/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jodd.http.HttpResponse;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.apache.ApacheHttpResponseProxy;
import me.chanjar.weixin.common.util.http.hc.HttpComponentsResponseProxy;
import me.chanjar.weixin.common.util.http.jodd.JoddHttpResponseProxy;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpResponseProxy;
import okhttp3.Response;
import org.apache.http.client.methods.CloseableHttpResponse;

public interface HttpResponseProxy {
    public static ApacheHttpResponseProxy from(CloseableHttpResponse response) {
        return new ApacheHttpResponseProxy(response);
    }

    public static HttpComponentsResponseProxy from(org.apache.hc.client5.http.impl.classic.CloseableHttpResponse response) {
        return new HttpComponentsResponseProxy(response);
    }

    public static JoddHttpResponseProxy from(HttpResponse response) {
        return new JoddHttpResponseProxy(response);
    }

    public static OkHttpResponseProxy from(Response response) {
        return new OkHttpResponseProxy(response);
    }

    public String getFileName() throws WxErrorException;

    public static String extractFileNameFromContentString(String content) throws WxErrorException {
        if (content == null || content.isEmpty()) {
            throw new WxErrorException("\u65e0\u6cd5\u83b7\u53d6\u5230\u6587\u4ef6\u540d\uff0ccontent\u4e3a\u7a7a");
        }
        Pattern pattern = Pattern.compile("filename\\*=utf-8''(.*?)($|;|\\s|,)");
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            String encodedFileName = matcher.group(1);
            try {
                return URLDecoder.decode(encodedFileName, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        pattern = Pattern.compile("filename=\"(.*?)\"");
        matcher = pattern.matcher(content);
        if (matcher.find()) {
            return new String(matcher.group(1).getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
        }
        throw new WxErrorException("\u65e0\u6cd5\u83b7\u53d6\u5230\u6587\u4ef6\u540d\uff0cheader\u4fe1\u606f\u6709\u95ee\u9898");
    }
}

