/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaCloudService;
import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.cloud.WxCloudBatchDeleteFileResult;
import cn.binarywang.wx.miniapp.bean.cloud.WxCloudBatchDownloadFileResult;
import cn.binarywang.wx.miniapp.bean.cloud.WxCloudCloudDatabaseMigrateQueryInfoResult;
import cn.binarywang.wx.miniapp.bean.cloud.WxCloudDatabaseCollectionGetResult;
import cn.binarywang.wx.miniapp.bean.cloud.WxCloudDatabaseCreateIndexRequest;
import cn.binarywang.wx.miniapp.bean.cloud.WxCloudDatabaseQueryResult;
import cn.binarywang.wx.miniapp.bean.cloud.WxCloudDatabaseUpdateResult;
import cn.binarywang.wx.miniapp.bean.cloud.WxCloudGetQcloudTokenResult;
import cn.binarywang.wx.miniapp.bean.cloud.WxCloudUploadFileResult;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMaCloudServiceImpl
implements WxMaCloudService {
    private static final Logger log = LoggerFactory.getLogger(WxMaCloudServiceImpl.class);
    private static final JsonParser JSON_PARSER = new JsonParser();
    private final WxMaService wxMaService;

    @Override
    public String invokeCloudFunction(String env, String name, String body) throws WxErrorException {
        String response = this.wxMaService.post(String.format("https://api.weixin.qq.com/tcb/invokecloudfunction?env=%s&name=%s", env, name), body);
        return JSON_PARSER.parse(response).getAsJsonObject().get("resp_data").getAsString();
    }

    @Override
    public JsonArray databaseAdd(String env, String query) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/tcb/databaseadd", ImmutableMap.of((Object)"env", (Object)env, (Object)"query", (Object)query));
        return JSON_PARSER.parse(response).getAsJsonObject().get("id_list").getAsJsonArray();
    }

    @Override
    public int databaseDelete(String env, String query) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/tcb/databasedelete", ImmutableMap.of((Object)"env", (Object)env, (Object)"query", (Object)query));
        return JSON_PARSER.parse(response).getAsJsonObject().get("deleted").getAsInt();
    }

    @Override
    public WxCloudDatabaseUpdateResult databaseUpdate(String env, String query) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/tcb/databaseupdate", ImmutableMap.of((Object)"env", (Object)env, (Object)"query", (Object)query));
        return (WxCloudDatabaseUpdateResult)WxGsonBuilder.create().fromJson(response, WxCloudDatabaseUpdateResult.class);
    }

    @Override
    public WxCloudDatabaseQueryResult databaseQuery(String env, String query) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/tcb/databasequery", ImmutableMap.of((Object)"env", (Object)env, (Object)"query", (Object)query));
        return (WxCloudDatabaseQueryResult)WxGsonBuilder.create().fromJson(response, WxCloudDatabaseQueryResult.class);
    }

    @Override
    public JsonArray databaseAggregate(String env, String query) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/tcb/databaseaggregate", ImmutableMap.of((Object)"env", (Object)env, (Object)"query", (Object)query));
        return JSON_PARSER.parse(response).getAsJsonObject().get("data").getAsJsonArray();
    }

    @Override
    public Long databaseCount(String env, String query) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/tcb/databasecount", ImmutableMap.of((Object)"env", (Object)env, (Object)"query", (Object)query));
        return JSON_PARSER.parse(response).getAsJsonObject().get("count").getAsLong();
    }

    @Override
    public void updateIndex(String env, String collectionName, List<WxCloudDatabaseCreateIndexRequest> createIndexes, List<String> dropIndexNames) throws WxErrorException {
        ArrayList dropIndexes = Lists.newArrayList();
        if (dropIndexNames != null) {
            for (String index : dropIndexNames) {
                dropIndexes.add(ImmutableMap.of((Object)"name", (Object)index));
            }
        }
        this.wxMaService.post("https://api.weixin.qq.com/tcb/updateindex", ImmutableMap.of((Object)"env", (Object)env, (Object)"collection_name", (Object)collectionName, (Object)"create_indexes", createIndexes, (Object)"drop_indexes", (Object)dropIndexes));
    }

    @Override
    public Long databaseMigrateImport(String env, String collectionName, String filePath, int fileType, boolean stopOnError, int conflictMode) throws WxErrorException {
        JsonObject params = new JsonObject();
        params.addProperty("env", env);
        params.addProperty("collection_name", collectionName);
        params.addProperty("file_path", filePath);
        params.addProperty("file_type", (Number)fileType);
        params.addProperty("stop_on_error", Boolean.valueOf(stopOnError));
        params.addProperty("conflict_mode", (Number)conflictMode);
        String response = this.wxMaService.post("https://api.weixin.qq.com/tcb/databasemigrateimport", params.toString());
        return JSON_PARSER.parse(response).getAsJsonObject().get("job_id").getAsLong();
    }

    @Override
    public Long databaseMigrateExport(String env, String filePath, int fileType, String query) throws WxErrorException {
        JsonObject params = new JsonObject();
        params.addProperty("env", env);
        params.addProperty("file_path", filePath);
        params.addProperty("file_type", (Number)fileType);
        params.addProperty("query", query);
        String response = this.wxMaService.post("https://api.weixin.qq.com/tcb/databasemigrateexport", params.toString());
        return JSON_PARSER.parse(response).getAsJsonObject().get("job_id").getAsLong();
    }

    @Override
    public WxCloudCloudDatabaseMigrateQueryInfoResult databaseMigrateQueryInfo(String env, Long jobId) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/tcb/databasemigratequeryinfo", ImmutableMap.of((Object)"env", (Object)env, (Object)"job_id", (Object)jobId));
        return (WxCloudCloudDatabaseMigrateQueryInfoResult)WxGsonBuilder.create().fromJson(response, WxCloudCloudDatabaseMigrateQueryInfoResult.class);
    }

    @Override
    public WxCloudUploadFileResult uploadFile(String env, String path) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/tcb/uploadfile", ImmutableMap.of((Object)"env", (Object)env, (Object)"path", (Object)path));
        return (WxCloudUploadFileResult)WxGsonBuilder.create().fromJson(response, WxCloudUploadFileResult.class);
    }

    @Override
    public WxCloudBatchDownloadFileResult batchDownloadFile(String env, String[] fileIds, long[] maxAges) throws WxErrorException {
        ArrayList fileList = Lists.newArrayList();
        int i = 0;
        for (String fileId : fileIds) {
            fileList.add(ImmutableMap.of((Object)"fileid", (Object)fileId, (Object)"max_age", (Object)maxAges[i++]));
        }
        String response = this.wxMaService.post("https://api.weixin.qq.com/tcb/getqcloudtoken", ImmutableMap.of((Object)"env", (Object)env, (Object)"file_list", (Object)fileList));
        return (WxCloudBatchDownloadFileResult)WxGsonBuilder.create().fromJson(response, WxCloudBatchDownloadFileResult.class);
    }

    @Override
    public WxCloudBatchDeleteFileResult batchDeleteFile(String env, String[] fileIds) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/tcb/batchdeletefile", ImmutableMap.of((Object)"env", (Object)env, (Object)"fileid_list", (Object)fileIds));
        return (WxCloudBatchDeleteFileResult)WxGsonBuilder.create().fromJson(response, WxCloudBatchDeleteFileResult.class);
    }

    @Override
    public WxCloudGetQcloudTokenResult getQcloudToken(long lifeSpan) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/tcb/getqcloudtoken", ImmutableMap.of((Object)"lifespan", (Object)lifeSpan));
        return (WxCloudGetQcloudTokenResult)WxGsonBuilder.create().fromJson(response, WxCloudGetQcloudTokenResult.class);
    }

    @Override
    public void databaseCollectionAdd(String env, String collectionName) throws WxErrorException {
        this.wxMaService.post("https://api.weixin.qq.com/tcb/databasecollectionadd", ImmutableMap.of((Object)"env", (Object)env, (Object)"collection_name", (Object)collectionName));
    }

    @Override
    public void databaseCollectionDelete(String env, String collectionName) throws WxErrorException {
        this.wxMaService.post("https://api.weixin.qq.com/tcb/databasecollectiondelete", ImmutableMap.of((Object)"env", (Object)env, (Object)"collection_name", (Object)collectionName));
    }

    @Override
    public WxCloudDatabaseCollectionGetResult databaseCollectionGet(String env, Long limit, Long offset) throws WxErrorException {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("env", env);
        if (limit != null) {
            params.put("limit", limit);
        }
        if (offset != null) {
            params.put("offset", offset);
        }
        String response = this.wxMaService.post("https://api.weixin.qq.com/tcb/databasecollectionget", params);
        return (WxCloudDatabaseCollectionGetResult)WxGsonBuilder.create().fromJson(response, WxCloudDatabaseCollectionGetResult.class);
    }

    public WxMaCloudServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }
}

