/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.executor;

import cn.binarywang.wx.miniapp.bean.AbstractWxMaQrcodeWrapper;
import cn.binarywang.wx.miniapp.executor.QrcodeRequestExecutor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.UUID;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import jodd.http.ProxyInfo;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.fs.FileUtils;
import me.chanjar.weixin.common.util.http.RequestHttp;
import org.apache.commons.lang3.StringUtils;

public class JoddHttpQrcodeFileRequestExecutor
extends QrcodeRequestExecutor<HttpConnectionProvider, ProxyInfo> {
    private final String filePath;

    public JoddHttpQrcodeFileRequestExecutor(RequestHttp<HttpConnectionProvider, ProxyInfo> requestHttp, String filePath) {
        super(requestHttp);
        this.filePath = filePath;
    }

    public File execute(String uri, AbstractWxMaQrcodeWrapper qrcodeWrapper, WxType wxType) throws WxErrorException, IOException {
        HttpRequest request = HttpRequest.get((String)uri);
        if (this.requestHttp.getRequestHttpProxy() != null) {
            ((HttpConnectionProvider)this.requestHttp.getRequestHttpClient()).useProxy((ProxyInfo)this.requestHttp.getRequestHttpProxy());
        }
        request.withConnectionProvider((HttpConnectionProvider)this.requestHttp.getRequestHttpClient());
        HttpResponse response = request.send();
        response.charset(StandardCharsets.UTF_8.name());
        String contentTypeHeader = response.header("Content-Type");
        if ("application/json".equals(contentTypeHeader)) {
            String responseContent = response.bodyText();
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)wxType));
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(response.bodyBytes());){
            if (StringUtils.isBlank((CharSequence)this.filePath)) {
                File file = FileUtils.createTmpFile((InputStream)inputStream, (String)UUID.randomUUID().toString(), (String)"jpg");
                return file;
            }
            File file = FileUtils.createTmpFile((InputStream)inputStream, (String)UUID.randomUUID().toString(), (String)"jpg", (File)Paths.get(this.filePath, new String[0]).toFile());
            return file;
        }
    }
}

