/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.util.requestexecuter.material;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.hc.Utf8ResponseHandler;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import me.chanjar.weixin.mp.bean.material.WxMpMaterialNews;
import me.chanjar.weixin.mp.util.json.WxMpGsonBuilder;
import me.chanjar.weixin.mp.util.requestexecuter.material.MaterialNewsInfoRequestExecutor;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterialNewsInfoHttpComponentsRequestExecutor
extends MaterialNewsInfoRequestExecutor<CloseableHttpClient, HttpHost> {
    private static final Logger log = LoggerFactory.getLogger(MaterialNewsInfoHttpComponentsRequestExecutor.class);

    public MaterialNewsInfoHttpComponentsRequestExecutor(RequestHttp<CloseableHttpClient, HttpHost> requestHttp) {
        super(requestHttp);
    }

    public WxMpMaterialNews execute(String uri, String materialId, WxType wxType) throws WxErrorException, IOException {
        HttpPost httpPost = new HttpPost(uri);
        if (this.requestHttp.getRequestHttpProxy() != null) {
            RequestConfig config = RequestConfig.custom().setProxy((HttpHost)this.requestHttp.getRequestHttpProxy()).build();
            httpPost.setConfig(config);
        }
        httpPost.setEntity((HttpEntity)new StringEntity(WxGsonBuilder.create().toJson((Object)ImmutableMap.of((Object)"media_id", (Object)materialId))));
        String responseContent = (String)((CloseableHttpClient)this.requestHttp.getRequestHttpClient()).execute((ClassicHttpRequest)httpPost, Utf8ResponseHandler.INSTANCE);
        log.debug("\u54cd\u5e94\u539f\u59cb\u6570\u636e\uff1a{}", (Object)responseContent);
        WxError error = WxError.fromJson((String)responseContent, (WxType)WxType.MP);
        if (error.getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        return (WxMpMaterialNews)WxMpGsonBuilder.create().fromJson(responseContent, WxMpMaterialNews.class);
    }
}

