/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.executor;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import me.chanjar.weixin.common.bean.CommonUploadData;
import me.chanjar.weixin.common.bean.CommonUploadParam;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.apache.Utf8ResponseHandler;
import me.chanjar.weixin.open.bean.CommonUploadMultiParam;
import me.chanjar.weixin.open.executor.CommonUploadMultiRequestExecutor;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.util.CollectionUtils;

public class CommonUploadMultiRequestExecutorApacheImpl
extends CommonUploadMultiRequestExecutor<CloseableHttpClient, HttpHost> {
    public CommonUploadMultiRequestExecutorApacheImpl(RequestHttp<CloseableHttpClient, HttpHost> requestHttp) {
        super(requestHttp);
    }

    public String execute(String uri, CommonUploadMultiParam param, WxType wxType) throws WxErrorException, IOException {
        String responseContent;
        HttpPost httpPost = new HttpPost(uri);
        if (this.requestHttp.getRequestHttpProxy() != null) {
            RequestConfig config = RequestConfig.custom().setProxy((HttpHost)this.requestHttp.getRequestHttpProxy()).build();
            httpPost.setConfig(config);
        }
        if (param != null) {
            CommonUploadParam uploadParam;
            MultipartEntityBuilder entity = MultipartEntityBuilder.create();
            List<CommonUploadMultiParam.NormalParam> normalParams = param.getNormalParams();
            if (!CollectionUtils.isEmpty(normalParams)) {
                for (CommonUploadMultiParam.NormalParam normalParam : normalParams) {
                    entity.addPart(normalParam.getName(), (ContentBody)new StringBody(normalParam.getValue(), ContentType.MULTIPART_FORM_DATA.withCharset(StandardCharsets.UTF_8)));
                }
            }
            if ((uploadParam = param.getUploadParam()) != null) {
                CommonUploadData data = uploadParam.getData();
                InnerStreamBody part = new InnerStreamBody(data.getInputStream(), ContentType.DEFAULT_BINARY, data.getFileName(), data.getLength());
                entity.addPart(uploadParam.getName(), (ContentBody)part).setMode(HttpMultipartMode.RFC6532);
            }
            httpPost.setEntity(entity.build());
        }
        if (StringUtils.isEmpty((CharSequence)(responseContent = (String)((CloseableHttpClient)this.requestHttp.getRequestHttpClient()).execute((HttpUriRequest)httpPost, Utf8ResponseHandler.INSTANCE)))) {
            throw new WxErrorException(String.format("\u4e0a\u4f20\u5931\u8d25\uff0c\u670d\u52a1\u5668\u54cd\u5e94\u7a7a url:%s param:%s", uri, param));
        }
        WxError error = WxError.fromJson((String)responseContent, (WxType)wxType);
        if (error.getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        return responseContent;
    }

    public static class InnerStreamBody
    extends InputStreamBody {
        private final long contentLength;

        public InnerStreamBody(InputStream in, ContentType contentType, String filename, long contentLength) {
            super(in, contentType, filename);
            this.contentLength = contentLength;
        }

        public long getContentLength() {
            return this.contentLength;
        }
    }
}

