/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.executor;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import me.chanjar.weixin.common.bean.CommonUploadData;
import me.chanjar.weixin.common.bean.CommonUploadParam;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.hc.Utf8ResponseHandler;
import me.chanjar.weixin.open.bean.CommonUploadMultiParam;
import me.chanjar.weixin.open.executor.CommonUploadMultiRequestExecutor;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.InputStreamBody;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.entity.mime.StringBody;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpHost;
import org.springframework.util.CollectionUtils;

public class CommonUploadMultiRequestExecutorHttpComponentsImpl
extends CommonUploadMultiRequestExecutor<CloseableHttpClient, HttpHost> {
    public CommonUploadMultiRequestExecutorHttpComponentsImpl(RequestHttp<CloseableHttpClient, HttpHost> requestHttp) {
        super(requestHttp);
    }

    public String execute(String uri, CommonUploadMultiParam param, WxType wxType) throws WxErrorException, IOException {
        String responseContent;
        HttpPost httpPost = new HttpPost(uri);
        if (this.requestHttp.getRequestHttpProxy() != null) {
            RequestConfig config = RequestConfig.custom().setProxy((HttpHost)this.requestHttp.getRequestHttpProxy()).build();
            httpPost.setConfig(config);
        }
        if (param != null) {
            CommonUploadParam uploadParam;
            MultipartEntityBuilder entity = MultipartEntityBuilder.create();
            List<CommonUploadMultiParam.NormalParam> normalParams = param.getNormalParams();
            if (!CollectionUtils.isEmpty(normalParams)) {
                for (CommonUploadMultiParam.NormalParam normalParam : normalParams) {
                    entity.addPart(normalParam.getName(), (ContentBody)new StringBody(normalParam.getValue(), ContentType.create((String)"multipart/form-data", (Charset)StandardCharsets.UTF_8)));
                }
            }
            if ((uploadParam = param.getUploadParam()) != null) {
                CommonUploadData data = uploadParam.getData();
                InnerStreamBody part = new InnerStreamBody(data.getInputStream(), ContentType.DEFAULT_BINARY, data.getFileName(), data.getLength());
                entity.addPart(uploadParam.getName(), (ContentBody)part).setMode(HttpMultipartMode.EXTENDED);
            }
            httpPost.setEntity(entity.build());
        }
        if (StringUtils.isEmpty((CharSequence)(responseContent = (String)((CloseableHttpClient)this.requestHttp.getRequestHttpClient()).execute((ClassicHttpRequest)httpPost, Utf8ResponseHandler.INSTANCE)))) {
            throw new WxErrorException(String.format("\u4e0a\u4f20\u5931\u8d25\uff0c\u670d\u52a1\u5668\u54cd\u5e94\u7a7a url:%s param:%s", uri, param));
        }
        WxError error = WxError.fromJson((String)responseContent, (WxType)wxType);
        if (error.getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        return responseContent;
    }

    public static class InnerStreamBody
    extends InputStreamBody {
        private final long contentLength;

        public InnerStreamBody(InputStream in, ContentType contentType, String filename, long contentLength) {
            super(in, contentType, filename);
            this.contentLength = contentLength;
        }

        public long getContentLength() {
            return this.contentLength;
        }
    }
}

