/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.patchca.custom;

import com.github.bingoohuang.patchca.custom.MathArithmeticFactory;
import com.github.bingoohuang.patchca.random.RandUtils;
import com.github.bingoohuang.patchca.word.WordBean;
import com.github.bingoohuang.patchca.word.WordFactory;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class MathExprFactory
implements WordFactory {
    private static String[] operations = new String[]{"\u52a0+", "\u51cf", "\u4e58X"};
    private static char[] exprOperations = new char[]{'+', '-', '*'};
    private static ScriptEngine engine;

    public char getOperation(int index) {
        String operation = operations[index];
        return operation.charAt(RandUtils.randInt(operation.length()));
    }

    private String evalExpr(String expr) {
        try {
            return "" + ((Double)engine.eval(expr)).intValue();
        }
        catch (ScriptException e) {
            return "error";
        }
    }

    @Override
    public WordBean getNextWord() {
        int a = RandUtils.randInt(9) + 1;
        int b = RandUtils.randInt(9) + 1;
        int c = RandUtils.randInt(9) + 1;
        int op1 = RandUtils.randInt(operations.length);
        int op2 = RandUtils.randInt(operations.length);
        StringBuilder answerExpr = new StringBuilder();
        answerExpr.append(a).append(exprOperations[op1]).append(b).append(exprOperations[op2]).append(c);
        String answer = this.evalExpr(answerExpr.toString());
        StringBuilder word = new StringBuilder();
        word.append(MathArithmeticFactory.rand(a)).append(this.getOperation(op1)).append(b).append(this.getOperation(op2)).append(c).append("=?");
        return new WordBean(word.toString(), answer, "\u8bf7\u8f93\u5165\u56fe\u7247\u4e2d?\u4ee3\u8868\u7684\u6570\u5b57");
    }

    @Override
    public String[] getSupportedFontFamilies() {
        return new String[]{"\u5b8b\u4f53"};
    }

    static {
        ScriptEngineManager mgr = new ScriptEngineManager();
        engine = mgr.getEngineByName("JavaScript");
    }
}

