/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.patchca.font;

import com.github.bingoohuang.patchca.font.FontFactory;
import com.github.bingoohuang.patchca.random.RandUtils;
import com.github.bingoohuang.patchca.word.WordFactory;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.List;

public class CustomRandomFontFactory
implements FontFactory {
    protected List<String> families = new ArrayList<String>();
    protected int minSize;
    protected int maxSize;
    private String word;
    private WordFactory wordFactory;

    public CustomRandomFontFactory() {
        String[] fontNames;
        for (String fontName : fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            if (!this.canDisplay(fontName, 'a')) continue;
            this.families.add(fontName);
        }
        this.minSize = 45;
        this.maxSize = 45;
    }

    public boolean canDisplay(String fontName, char ch) {
        Font f = new Font(fontName, 0, 12);
        return f.canDisplay(ch);
    }

    public void setMinSize(int minSize) {
        this.minSize = minSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public Font getFont(int index) {
        String family;
        String[] supportedFamilies;
        boolean bold = RandUtils.randBoolean();
        int size = this.minSize;
        if (this.maxSize - this.minSize > 0) {
            size += RandUtils.randInt(this.maxSize - this.minSize);
        }
        if (this.wordFactory != null && (supportedFamilies = this.wordFactory.getSupportedFontFamilies()) != null && supportedFamilies.length > 0) {
            String family2 = supportedFamilies[RandUtils.randInt(supportedFamilies.length)];
            System.out.println("family:" + family2);
            return new Font(family2, bold ? 1 : 0, size);
        }
        block0: while (true) {
            family = this.families.get(RandUtils.randInt(this.families.size()));
            for (char ch : this.word.toCharArray()) {
                if (!this.canDisplay(family, ch)) continue block0;
            }
            break;
        }
        System.out.println("family:" + family);
        return new Font(family, bold ? 1 : 0, size);
    }

    @Override
    public void setWord(String word) {
        this.word = word;
    }

    @Override
    public void setWordFactory(WordFactory wordFactory) {
        this.wordFactory = wordFactory;
    }
}

