/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.patchca.random;

import java.io.UnsupportedEncodingException;

public class ChineseUtils {
    private static int[] b_out = new int[]{201, 267, 279, 293, 484, 587, 625, 657, 734, 782, 827, 874, 901, 980, 5590};
    private static int[] e_out = new int[]{216, 268, 280, 294, 494, 594, 632, 694, 748, 794, 836, 894, 903, 994, 5594};
    private static String levelOneCharacters = ChineseUtils.generateCharacters(16, 55);

    public static boolean isChinese(char ch) {
        return ch >= '\u4e00' && ch <= '\u9fa5';
    }

    public static boolean containsChinese(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (!ChineseUtils.isChinese(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isChinese(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (ChineseUtils.isChinese(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String levelOne() {
        return levelOneCharacters;
    }

    public static String levelTwo() {
        return ChineseUtils.generateCharacters(56, 87);
    }

    public static String generateCharacters(int from, int to) {
        StringBuilder sb = new StringBuilder();
        for (int i = from; i <= to; ++i) {
            for (int j = 1; j <= 94; ++j) {
                byte hi = (byte)(160 + i);
                byte lo = (byte)(160 + j);
                if (!ChineseUtils.validGB(i, j)) continue;
                try {
                    sb.append(new String(new byte[]{hi, lo}, "GBK"));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
            }
        }
        return sb.toString();
    }

    private static boolean validGB(int i, int j) {
        for (int l = 0; l < b_out.length; ++l) {
            if (i * 100 + j < b_out[l] || i * 100 + j > e_out[l]) continue;
            return false;
        }
        return true;
    }
}

