/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.impl.bootstrap;

import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.function.Callback;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.ExceptionListener;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.impl.bootstrap.Worker;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.impl.io.HttpService;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.io.HttpConnectionFactory;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.io.HttpServerConnection;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.io.SocketConfig;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.io.Closer;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.io.SocketSupport;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

class RequestListener
implements Runnable {
    private final SocketConfig socketConfig;
    private final ServerSocket serverSocket;
    private final HttpService httpService;
    private final HttpConnectionFactory<? extends HttpServerConnection> connectionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final Callback<SSLParameters> sslSetupHandler;
    private final ExceptionListener exceptionListener;
    private final ExecutorService executorService;
    private final AtomicBoolean terminated;

    public RequestListener(SocketConfig socketConfig, ServerSocket serversocket, HttpService httpService, HttpConnectionFactory<? extends HttpServerConnection> connectionFactory, SSLSocketFactory sslSocketFactory, Callback<SSLParameters> sslSetupHandler, ExceptionListener exceptionListener, ExecutorService executorService) {
        this.socketConfig = socketConfig;
        this.serverSocket = serversocket;
        this.httpService = httpService;
        this.connectionFactory = connectionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.sslSetupHandler = sslSetupHandler;
        this.exceptionListener = exceptionListener;
        this.executorService = executorService;
        this.terminated = new AtomicBoolean();
    }

    private HttpServerConnection createConnection(Socket socket) throws IOException {
        socket.setSoTimeout(this.socketConfig.getSoTimeout().toMillisecondsIntBound());
        socket.setKeepAlive(this.socketConfig.isSoKeepAlive());
        socket.setTcpNoDelay(this.socketConfig.isTcpNoDelay());
        if (this.socketConfig.getRcvBufSize() > 0) {
            socket.setReceiveBufferSize(this.socketConfig.getRcvBufSize());
        }
        if (this.socketConfig.getSndBufSize() > 0) {
            socket.setSendBufferSize(this.socketConfig.getSndBufSize());
        }
        if (this.socketConfig.getSoLinger().toSeconds() >= 0L) {
            socket.setSoLinger(true, this.socketConfig.getSoLinger().toSecondsIntBound());
        }
        if (this.socketConfig.getTcpKeepIdle() > 0) {
            SocketSupport.setOption(this.serverSocket, "TCP_KEEPIDLE", this.socketConfig.getTcpKeepIdle());
        }
        if (this.socketConfig.getTcpKeepInterval() > 0) {
            SocketSupport.setOption(this.serverSocket, "TCP_KEEPINTERVAL", this.socketConfig.getTcpKeepInterval());
        }
        if (this.socketConfig.getTcpKeepCount() > 0) {
            SocketSupport.setOption(this.serverSocket, "TCP_KEEPCOUNT", this.socketConfig.getTcpKeepCount());
        }
        if (!(socket instanceof SSLSocket) && this.sslSocketFactory != null) {
            SSLSocket sslSocket = (SSLSocket)this.sslSocketFactory.createSocket(socket, null, -1, false);
            sslSocket.setUseClientMode(false);
            if (this.sslSetupHandler != null) {
                SSLParameters sslParameters = sslSocket.getSSLParameters();
                this.sslSetupHandler.execute(sslParameters);
                sslSocket.setSSLParameters(sslParameters);
            }
            try {
                sslSocket.startHandshake();
                SSLSession session = sslSocket.getSession();
                if (session == null) {
                    throw new SSLHandshakeException("SSL session not available");
                }
                return this.connectionFactory.createConnection(sslSocket, socket);
            }
            catch (IOException ex) {
                Closer.closeQuietly(sslSocket);
                throw ex;
            }
        }
        return this.connectionFactory.createConnection(socket);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            while (!this.isTerminated() && !Thread.interrupted()) {
                Socket socket = this.serverSocket.accept();
                try {
                    HttpServerConnection conn = this.createConnection(socket);
                    Worker worker = new Worker(this.httpService, conn, this.exceptionListener);
                    this.executorService.execute(worker);
                }
                catch (IOException | RuntimeException ex) {
                    Closer.closeQuietly(socket);
                    throw ex;
                    return;
                }
            }
        }
        catch (Exception ex) {
            this.exceptionListener.onError(ex);
        }
    }

    public boolean isTerminated() {
        return this.terminated.get();
    }

    public void terminate() throws IOException {
        if (this.terminated.compareAndSet(false, true)) {
            this.serverSocket.close();
        }
    }
}

