/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core;

import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.core.CssPrinter;
import com.github.sommeri.less4j.core.ExtendedStringBuilder;
import com.github.sommeri.less4j.core.ProblemsCollector;
import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.StyleSheet;
import com.github.sommeri.less4j.core.compiler.LessToCssCompiler;
import com.github.sommeri.less4j.core.parser.ANTLRParser;
import com.github.sommeri.less4j.core.parser.ANTLRPhaseErrors;
import com.github.sommeri.less4j.core.parser.ASTBuilder;
import java.util.List;

public class DefaultLessCompiler
implements LessCompiler {
    private ProblemsCollector problemsCollector = new ProblemsCollector();
    private ANTLRParser parser = new ANTLRParser();
    private ASTBuilder astBuilder = new ASTBuilder(this.problemsCollector);
    private LessToCssCompiler compiler = new LessToCssCompiler();

    @Override
    public String compile(String lessContent) {
        this.problemsCollector.clean();
        ExtendedStringBuilder stringBuilder = new ExtendedStringBuilder("");
        ANTLRParser.ParseResult result = this.parser.parseStyleSheet(lessContent);
        if (result.hasErrors()) {
            throw new ANTLRPhaseErrors(result.getErrors());
        }
        StyleSheet lessStyleSheet = this.astBuilder.parse(result.getTree());
        ASTCssNode cssStyleSheet = this.compiler.compileToCss(lessStyleSheet);
        CssPrinter builder = new CssPrinter(stringBuilder);
        builder.append(cssStyleSheet);
        return stringBuilder.toString();
    }

    @Override
    public List<LessCompiler.IProblem> getProblems() {
        return this.problemsCollector.getWarnings();
    }
}

