/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class Body<T extends ASTCssNode>
extends ASTCssNode {
    private List<T> body = new ArrayList<T>();

    public Body() {
        this(null);
    }

    public Body(HiddenTokenAwareTree underlyingStructure) {
        super(underlyingStructure);
    }

    public Body(HiddenTokenAwareTree underlyingStructure, List<T> declarations) {
        this(underlyingStructure);
        this.body.addAll(declarations);
    }

    public List<T> getChilds() {
        return this.body;
    }

    public boolean isEmpty() {
        return this.body.isEmpty() && this.getOrphanComments().isEmpty();
    }

    public void addMembers(List<? extends T> members) {
        this.body.addAll(members);
    }

    public void addMembersAfter(List<? extends T> nestedRulesets, ASTCssNode kid) {
        int index = this.body.indexOf(kid);
        index = index == -1 ? this.body.size() : ++index;
        this.body.addAll(index, nestedRulesets);
    }

    public void addMember(T member) {
        this.body.add(member);
    }

    public void replaceMember(T oldMember, List<T> newMembers) {
        this.body.addAll(this.body.indexOf(oldMember), newMembers);
        this.body.remove(oldMember);
    }

    public List<T> membersByType(ASTCssNodeType type) {
        ArrayList<ASTCssNode> result = new ArrayList<ASTCssNode>();
        List<T> body = this.getChilds();
        for (ASTCssNode node : body) {
            if (node.getType() != type) continue;
            result.add(node);
        }
        return result;
    }

    public boolean removeMember(T node) {
        return this.body.remove(node);
    }

    @Override
    public Body<T> clone() {
        Body result = (Body)super.clone();
        result.body = ArraysUtils.deeplyClonedList(this.body);
        result.configureParentToAllChilds();
        return result;
    }
}

