/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ComposedExpression;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.ExpressionOperator;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.compiler.CompileException;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;

public class ArithmeticOperator {
    public Expression evalute(ComposedExpression originalExpression, Expression firstNumber, Expression secondNumber) {
        this.validateParameters(firstNumber, secondNumber);
        NumberExpression first = (NumberExpression)firstNumber;
        NumberExpression second = (NumberExpression)secondNumber;
        ExpressionOperator operator = originalExpression.getOperator();
        switch (operator.getOperator()) {
            case SOLIDUS: {
                return this.divide(first, second, originalExpression);
            }
            case STAR: {
                return this.multiply(first, second, originalExpression);
            }
            case MINUS: {
                return this.subtract(first, second, originalExpression);
            }
            case PLUS: {
                return this.add(first, second, originalExpression);
            }
            case COMMA: 
            case EMPTY_OPERATOR: {
                throw new CompileException("Not an arithmetic operator.", (ASTCssNode)operator);
            }
        }
        throw new CompileException("Unknown operator.", (ASTCssNode)operator);
    }

    private Expression subtract(NumberExpression first, NumberExpression second, ComposedExpression originalExpression) {
        return this.subtractNumbers(first, second, originalExpression.getUnderlyingStructure());
    }

    private Expression subtractNumbers(NumberExpression first, NumberExpression second, HiddenTokenAwareTree parentToken) {
        Double firstVal = first.getValueAsDouble();
        Double secondVal = second.getValueAsDouble();
        Double resultVal = firstVal - secondVal;
        return this.createResultNumber(parentToken, resultVal, first, second);
    }

    private Expression multiply(NumberExpression first, NumberExpression second, ComposedExpression originalExpression) {
        return this.multiplyNumbers(first, second, originalExpression.getUnderlyingStructure());
    }

    private Expression multiplyNumbers(NumberExpression first, NumberExpression second, HiddenTokenAwareTree parentToken) {
        Double firstVal = first.getValueAsDouble();
        Double secondVal = second.getValueAsDouble();
        Double resultVal = firstVal * secondVal;
        return this.createResultNumber(parentToken, resultVal, first, second);
    }

    private Expression divide(NumberExpression first, NumberExpression second, ComposedExpression originalExpression) {
        return this.divideNumbers(first, second, originalExpression.getUnderlyingStructure());
    }

    private Expression divideNumbers(NumberExpression first, NumberExpression second, HiddenTokenAwareTree parentToken) {
        Double firstVal = first.getValueAsDouble();
        Double secondVal = second.getValueAsDouble();
        Double resultVal = firstVal / secondVal;
        return this.createResultNumber(parentToken, resultVal, first, second);
    }

    private Expression add(NumberExpression first, NumberExpression second, ComposedExpression originalExpression) {
        return this.addNumbers(first, second, originalExpression.getUnderlyingStructure());
    }

    private Expression addNumbers(NumberExpression first, NumberExpression second, HiddenTokenAwareTree parentToken) {
        Double firstVal = first.getValueAsDouble();
        Double secondVal = second.getValueAsDouble();
        Double resultVal = firstVal + secondVal;
        return this.createResultNumber(parentToken, resultVal, first, second);
    }

    public Expression createResultNumber(HiddenTokenAwareTree parentToken, Double resultVal, NumberExpression first, NumberExpression second) {
        NumberExpression.Dimension dimension = null;
        String suffix = null;
        if (first.getDimension() != NumberExpression.Dimension.NUMBER) {
            dimension = first.getDimension();
            suffix = first.getSuffix();
        } else {
            dimension = second.getDimension();
            suffix = second.getSuffix();
        }
        return new NumberExpression(parentToken, resultVal, suffix, null, dimension);
    }

    public boolean accepts(ExpressionOperator operator) {
        return operator.getOperator() != ExpressionOperator.Operator.COMMA && operator.getOperator() != ExpressionOperator.Operator.EMPTY_OPERATOR;
    }

    private void validateParameters(Expression first, Expression second) {
        if (first.getType() != ASTCssNodeType.NUMBER) {
            throw new CompileException("Only operations on numbers are supported.", (ASTCssNode)first);
        }
        if (second.getType() != ASTCssNodeType.NUMBER) {
            throw new CompileException("Only operations on numbers are supported.", (ASTCssNode)second);
        }
    }
}

