/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler;

import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ArgumentDeclaration;
import com.github.sommeri.less4j.core.ast.MixinReference;
import com.github.sommeri.less4j.core.ast.PureMixin;
import com.github.sommeri.less4j.core.ast.Variable;

public class CompileException
extends Less4jException {
    private ASTCssNode node;

    public CompileException(ASTCssNode node) {
        this.node = node;
    }

    public CompileException(String message, Throwable th, ASTCssNode node) {
        super(message, th);
        this.node = node;
    }

    public CompileException(Throwable th, ASTCssNode node) {
        super(th);
        this.node = node;
    }

    public CompileException(String message, ASTCssNode node) {
        super(message);
        this.node = node;
    }

    @Override
    public String getMessage() {
        return super.getMessage() + this.getPositionInformation();
    }

    @Override
    public boolean hasErrorPosition() {
        return this.node != null;
    }

    @Override
    public int getCharPositionInLine() {
        if (!this.hasErrorPosition()) {
            return -1;
        }
        return this.node.getCharPositionInSourceLine();
    }

    @Override
    public int getLine() {
        if (!this.hasErrorPosition()) {
            return -1;
        }
        return this.node.getSourceLine();
    }

    public static void throwUndefinedMixinParameterValue(PureMixin mixin, ArgumentDeclaration declaration, MixinReference reference) {
        throw CompileException.createUndefinedMixinParameterValue(mixin, declaration, reference);
    }

    private static CompileException createUndefinedMixinParameterValue(PureMixin mixin, ArgumentDeclaration declaration, MixinReference reference) {
        return new CompileException("Undefined parameter " + declaration.getVariable().getName() + " of mixin " + mixin.getName() + " defined on line " + mixin.getSourceLine(), (ASTCssNode)reference);
    }

    public static void throwUndeclaredVariable(Variable variable) {
        throw CompileException.createUndeclaredVariable(variable.getName(), variable);
    }

    public static void throwUndeclaredVariable(String name, ASTCssNode ifErrorNode) {
        throw CompileException.createUndeclaredVariable(name, ifErrorNode);
    }

    public static CompileException createUndeclaredVariable(String name, ASTCssNode variable) {
        return new CompileException("The variable \"" + name + "\" was not declared.", variable);
    }

    public static void throwUndeclaredMixin(Variable variable) {
        throw CompileException.createUndeclaredVariable(variable.getName(), variable);
    }

    public static void throwUndeclaredMixin(String name, ASTCssNode ifErrorNode) {
        throw CompileException.createUndeclaredVariable(name, ifErrorNode);
    }

    public static CompileException createUndeclaredMixin(MixinReference reference) {
        return CompileException.createUndeclaredMixin(reference.getName(), reference);
    }

    public static CompileException createUndeclaredMixin(String name, MixinReference variable) {
        return new CompileException("The mixin \"" + name + "\" was not declared.", (ASTCssNode)variable);
    }
}

