/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ArgumentDeclaration;
import com.github.sommeri.less4j.core.ast.Body;
import com.github.sommeri.less4j.core.ast.Declaration;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.IndirectVariable;
import com.github.sommeri.less4j.core.ast.Media;
import com.github.sommeri.less4j.core.ast.MediaExpression;
import com.github.sommeri.less4j.core.ast.MediaExpressionFeature;
import com.github.sommeri.less4j.core.ast.MixinReference;
import com.github.sommeri.less4j.core.ast.NestedRuleSet;
import com.github.sommeri.less4j.core.ast.PureMixin;
import com.github.sommeri.less4j.core.ast.RuleSet;
import com.github.sommeri.less4j.core.ast.RuleSetsBody;
import com.github.sommeri.less4j.core.ast.StyleSheet;
import com.github.sommeri.less4j.core.ast.Variable;
import com.github.sommeri.less4j.core.ast.VariableDeclaration;
import com.github.sommeri.less4j.core.compiler.ASTManipulator;
import com.github.sommeri.less4j.core.compiler.ActiveScope;
import com.github.sommeri.less4j.core.compiler.CompileException;
import com.github.sommeri.less4j.core.compiler.ExpressionEvaluator;
import com.github.sommeri.less4j.core.compiler.FullMixinDefinition;
import com.github.sommeri.less4j.core.compiler.MixinsReferenceMatcher;
import com.github.sommeri.less4j.core.compiler.NestedRulesCollector;
import com.github.sommeri.less4j.core.compiler.VariablesScope;
import java.util.ArrayList;
import java.util.List;

public class LessToCssCompiler {
    private static final String ALL_ARGUMENTS = "@arguments";
    private ASTManipulator manipulator = new ASTManipulator();
    private MixinsReferenceMatcher matcher;
    private ActiveScope activeScope;
    private ExpressionEvaluator expressionEvaluator;
    private NestedRulesCollector nestedRulesCollector;

    public ASTCssNode compileToCss(StyleSheet less) {
        this.activeScope = new ActiveScope();
        this.expressionEvaluator = new ExpressionEvaluator(this.activeScope);
        this.nestedRulesCollector = new NestedRulesCollector();
        this.matcher = new MixinsReferenceMatcher(this.activeScope);
        this.solveVariablesAndMixins(less);
        this.evaluateExpressions(less);
        this.freeNestedRuleSets(less);
        return less;
    }

    private void freeNestedRuleSets(Body<ASTCssNode> body) {
        ArrayList<ASTCssNode> childs = new ArrayList<ASTCssNode>(body.getChilds());
        for (ASTCssNode kid : childs) {
            if (kid.getType() == ASTCssNodeType.RULE_SET) {
                List<NestedRuleSet> nestedRulesets = this.nestedRulesCollector.collectNestedRuleSets((RuleSet)kid);
                body.addMembersAfter(this.convertToRulesSets(nestedRulesets), kid);
                for (RuleSet ruleSet : nestedRulesets) {
                    ruleSet.setParent(body);
                }
            }
            if (kid.getType() != ASTCssNodeType.MEDIA) continue;
            this.freeNestedRuleSets((Media)kid);
        }
    }

    private List<RuleSet> convertToRulesSets(List<NestedRuleSet> nestedRulesets) {
        ArrayList<RuleSet> result = new ArrayList<RuleSet>();
        for (NestedRuleSet nested : nestedRulesets) {
            result.add(nested.convertToRuleSet());
        }
        return result;
    }

    private void evaluateExpressions(ASTCssNode node) {
        if (node instanceof Expression) {
            Expression value = this.expressionEvaluator.evaluate((Expression)node);
            this.manipulator.replace(node, value);
        } else {
            List<? extends ASTCssNode> childs = node.getChilds();
            block4: for (ASTCssNode aSTCssNode : childs) {
                switch (aSTCssNode.getType()) {
                    case MEDIA_EXPRESSION: {
                        this.evaluateInMediaExpressions((MediaExpression)aSTCssNode);
                        continue block4;
                    }
                    case DECLARATION: {
                        this.evaluateInDeclaration((Declaration)aSTCssNode);
                        continue block4;
                    }
                }
                this.evaluateExpressions(aSTCssNode);
            }
        }
    }

    private void evaluateInDeclaration(Declaration node) {
        if (!node.isFontDeclaration()) {
            this.evaluateExpressions(node);
            return;
        }
    }

    private void evaluateInMediaExpressions(MediaExpression node) {
        MediaExpressionFeature feature = node.getFeature();
        if (!feature.isRatioFeature()) {
            this.evaluateExpressions(node);
            return;
        }
    }

    private void solveVariablesAndMixins(ASTCssNode node) {
        boolean hasOwnScope = this.hasOwnScope(node);
        if (hasOwnScope) {
            this.activeScope.increaseScope();
        }
        switch (node.getType()) {
            case VARIABLE_DECLARATION: {
                this.manipulator.removeFromBody(node);
                break;
            }
            case VARIABLE: {
                Expression replacement = this.expressionEvaluator.evaluate((Variable)node);
                this.manipulator.replace(node, replacement);
                break;
            }
            case INDIRECT_VARIABLE: {
                Expression replacement = this.expressionEvaluator.evaluate((IndirectVariable)node);
                this.manipulator.replace(node, replacement);
                break;
            }
            case MIXIN_REFERENCE: {
                MixinReference mixinReference = (MixinReference)node;
                RuleSetsBody replacement = this.resolveMixinReference(mixinReference);
                List<ASTCssNode> list = replacement.getChilds();
                if (!list.isEmpty()) {
                    ((ASTCssNode)list.get(0)).addOpeningComments(mixinReference.getOpeningComments());
                    list.get(list.size() - 1).addTrailingComments(mixinReference.getTrailingComments());
                }
                this.manipulator.replaceInBody(mixinReference, list);
                break;
            }
            case PURE_MIXIN: {
                this.manipulator.removeFromBody(node);
            }
        }
        if (node.getType() != ASTCssNodeType.PURE_MIXIN && node.getType() != ASTCssNodeType.VARIABLE_DECLARATION && node.getType() != ASTCssNodeType.ARGUMENT_DECLARATION) {
            ArrayList<? extends ASTCssNode> childs = new ArrayList<ASTCssNode>(node.getChilds());
            this.registerAllVariables(childs);
            this.registerAllMixins(childs);
            for (ASTCssNode aSTCssNode : childs) {
                this.solveVariablesAndMixins(aSTCssNode);
            }
        }
        if (hasOwnScope) {
            this.activeScope.decreaseScope();
        }
    }

    public void registerAllVariables(List<? extends ASTCssNode> childs) {
        for (ASTCssNode aSTCssNode : childs) {
            if (aSTCssNode.getType() != ASTCssNodeType.VARIABLE_DECLARATION) continue;
            this.activeScope.addDeclaration((VariableDeclaration)aSTCssNode);
        }
    }

    public void registerAllMixins(List<? extends ASTCssNode> childs) {
        for (ASTCssNode aSTCssNode : childs) {
            NestedRuleSet nested;
            RuleSet ruleSet;
            if (aSTCssNode.getType() == ASTCssNodeType.PURE_MIXIN) {
                this.activeScope.registerMixin((PureMixin)aSTCssNode);
            }
            if (aSTCssNode.getType() == ASTCssNodeType.RULE_SET && (ruleSet = (RuleSet)aSTCssNode).isMixin()) {
                this.activeScope.registerMixin(ruleSet.convertToMixin());
            }
            if (aSTCssNode.getType() != ASTCssNodeType.NESTED_RULESET || !(nested = (NestedRuleSet)aSTCssNode).isMixin()) continue;
            this.activeScope.registerMixin(nested.convertToMixin());
        }
    }

    private boolean hasOwnScope(ASTCssNode node) {
        return node instanceof Body;
    }

    private RuleSetsBody resolveMixinReference(MixinReference reference) {
        List<FullMixinDefinition> matchingMixins = this.activeScope.getAllMatchingMixins(this.matcher, reference);
        RuleSetsBody result = new RuleSetsBody(reference.getUnderlyingStructure());
        for (FullMixinDefinition fullMixin : matchingMixins) {
            if (!this.matcher.patternsMatch(reference, fullMixin)) continue;
            this.initializeMixinVariableScope(reference, fullMixin);
            PureMixin mixin = fullMixin.getMixin();
            if (this.expressionEvaluator.evaluate(mixin.getGuards())) {
                RuleSetsBody body = mixin.getBody().clone();
                this.solveVariablesAndMixins(body);
                result.addMembers(body.getChilds());
            }
            this.activeScope.leaveMixinVariableScope();
        }
        if (reference.isImportant()) {
            this.declarationsAreImportant(result);
        }
        return result;
    }

    public void declarationsAreImportant(RuleSetsBody result) {
        for (ASTCssNode kid : result.getChilds()) {
            if (!(kid instanceof Declaration)) continue;
            Declaration declaration = (Declaration)kid;
            declaration.setImportant(true);
        }
    }

    private void initializeMixinVariableScope(MixinReference reference, FullMixinDefinition mixin) {
        VariablesScope variableState = mixin.getVariablesUponDefinition();
        variableState.removeDeclaration(ALL_ARGUMENTS);
        ArrayList<Expression> allValues = new ArrayList<Expression>();
        int length = mixin.getMixin().getParameters().size();
        for (int i = 0; i < length; ++i) {
            ASTCssNode parameter = mixin.getMixin().getParameters().get(i);
            if (parameter.getType() != ASTCssNodeType.ARGUMENT_DECLARATION) continue;
            ArgumentDeclaration declaration = (ArgumentDeclaration)parameter;
            if (declaration.isCollector()) {
                List<Expression> allArgumentsFrom = this.expressionEvaluator.evaluateAll(reference.getAllArgumentsFrom(i));
                allValues.addAll(allArgumentsFrom);
                Expression value = this.expressionEvaluator.joinAll(allArgumentsFrom, reference);
                variableState.addDeclaration(declaration, value);
                continue;
            }
            if (reference.hasParameter(i)) {
                Expression value = this.expressionEvaluator.evaluate(reference.getParameter(i));
                allValues.add(value);
                variableState.addDeclaration(declaration, value);
                continue;
            }
            if (declaration.getValue() == null) {
                CompileException.throwUndefinedMixinParameterValue(mixin.getMixin(), declaration, reference);
            }
            allValues.add(declaration.getValue());
            variableState.addDeclaration(declaration);
        }
        Expression compoundedValues = this.expressionEvaluator.joinAll(allValues, reference);
        variableState.addDeclarationIfNotPresent(ALL_ARGUMENTS, compoundedValues);
        this.activeScope.enterMixinVariableScope(variableState);
    }
}

