/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.parser;

import com.github.sommeri.less4j.core.ProblemsCollector;
import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ArgumentDeclaration;
import com.github.sommeri.less4j.core.ast.CharsetDeclaration;
import com.github.sommeri.less4j.core.ast.ComparisonExpression;
import com.github.sommeri.less4j.core.ast.ComparisonExpressionOperator;
import com.github.sommeri.less4j.core.ast.ComposedExpression;
import com.github.sommeri.less4j.core.ast.CssClass;
import com.github.sommeri.less4j.core.ast.Declaration;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.ExpressionOperator;
import com.github.sommeri.less4j.core.ast.FontFace;
import com.github.sommeri.less4j.core.ast.Guard;
import com.github.sommeri.less4j.core.ast.GuardCondition;
import com.github.sommeri.less4j.core.ast.IdSelector;
import com.github.sommeri.less4j.core.ast.IdentifierExpression;
import com.github.sommeri.less4j.core.ast.IndirectVariable;
import com.github.sommeri.less4j.core.ast.Media;
import com.github.sommeri.less4j.core.ast.MediaExpression;
import com.github.sommeri.less4j.core.ast.MediaExpressionFeature;
import com.github.sommeri.less4j.core.ast.MediaQuery;
import com.github.sommeri.less4j.core.ast.Medium;
import com.github.sommeri.less4j.core.ast.MediumModifier;
import com.github.sommeri.less4j.core.ast.MediumType;
import com.github.sommeri.less4j.core.ast.MixinReference;
import com.github.sommeri.less4j.core.ast.NestedRuleSet;
import com.github.sommeri.less4j.core.ast.Nth;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.ast.Pseudo;
import com.github.sommeri.less4j.core.ast.PseudoClass;
import com.github.sommeri.less4j.core.ast.PseudoElement;
import com.github.sommeri.less4j.core.ast.PureMixin;
import com.github.sommeri.less4j.core.ast.RuleSet;
import com.github.sommeri.less4j.core.ast.RuleSetsBody;
import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.ast.SelectorAttribute;
import com.github.sommeri.less4j.core.ast.SelectorCombinator;
import com.github.sommeri.less4j.core.ast.SelectorOperator;
import com.github.sommeri.less4j.core.ast.SignedExpression;
import com.github.sommeri.less4j.core.ast.StyleSheet;
import com.github.sommeri.less4j.core.ast.Variable;
import com.github.sommeri.less4j.core.ast.VariableDeclaration;
import com.github.sommeri.less4j.core.parser.ConversionUtils;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.parser.SelectorBuilder;
import com.github.sommeri.less4j.core.parser.TermBuilder;
import com.github.sommeri.less4j.core.parser.TokenTypeSwitch;
import com.github.sommeri.less4j.core.parser.TreeBuildingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

class ASTBuilderSwitch
extends TokenTypeSwitch<ASTCssNode> {
    private final ProblemsCollector warningsCollector;
    private final TermBuilder termBuilder = new TermBuilder(this);
    private static Set<String> COLONLESS_PSEUDOELEMENTS = new HashSet<String>();

    public ASTBuilderSwitch(ProblemsCollector warningsCollector) {
        this.warningsCollector = warningsCollector;
    }

    @Override
    public StyleSheet handleStyleSheet(HiddenTokenAwareTree token) {
        StyleSheet result = new StyleSheet(token);
        if (token.getChildren() == null || token.getChildren().isEmpty()) {
            return result;
        }
        for (HiddenTokenAwareTree kid : token.getChildren()) {
            result.addMember((ASTCssNode)this.switchOn(kid));
        }
        return result;
    }

    @Override
    public Expression handleTerm(HiddenTokenAwareTree token) {
        return this.termBuilder.buildFromTerm(token);
    }

    @Override
    public Expression handleExpression(HiddenTokenAwareTree token) {
        LinkedList<HiddenTokenAwareTree> children = new LinkedList<HiddenTokenAwareTree>(token.getChildren());
        if (children.size() == 0) {
            throw new TreeBuildingException(token);
        }
        if (children.size() == 1) {
            Expression head = (Expression)this.switchOn(children.get(0));
            head.setUnderlyingStructure(token);
            return head;
        }
        return this.createExpression(token, children);
    }

    private Expression createExpression(HiddenTokenAwareTree parent, LinkedList<HiddenTokenAwareTree> members) {
        Expression head = (Expression)this.switchOn(members.removeFirst());
        while (!members.isEmpty()) {
            ExpressionOperator operator = this.readExpressionOperator(members);
            if (members.isEmpty()) {
                return new ComposedExpression(parent, head, operator, null);
            }
            Expression next = (Expression)this.switchOn(members.removeFirst());
            head = new ComposedExpression(parent, head, operator, next);
        }
        return head;
    }

    public ExpressionOperator readExpressionOperator(LinkedList<HiddenTokenAwareTree> members) {
        HiddenTokenAwareTree token = members.removeFirst();
        ExpressionOperator operator = new ExpressionOperator(token, this.toExpressionOperator(token));
        return operator;
    }

    private ExpressionOperator.Operator toExpressionOperator(HiddenTokenAwareTree token) {
        switch (token.getType()) {
            case 84: {
                return ExpressionOperator.Operator.SOLIDUS;
            }
            case 41: {
                return ExpressionOperator.Operator.COMMA;
            }
            case 72: {
                return ExpressionOperator.Operator.STAR;
            }
            case 57: {
                return ExpressionOperator.Operator.MINUS;
            }
            case 55: {
                return ExpressionOperator.Operator.PLUS;
            }
            case 15: {
                return ExpressionOperator.Operator.EMPTY_OPERATOR;
            }
        }
        throw new TreeBuildingException("Unknown operator type. ", token);
    }

    @Override
    public Variable handleVariable(HiddenTokenAwareTree token) {
        return this.termBuilder.buildFromVariable(token);
    }

    @Override
    public IndirectVariable handleIndirectVariable(HiddenTokenAwareTree token) {
        return this.termBuilder.buildFromIndirectVariable(token);
    }

    @Override
    public Declaration handleDeclaration(HiddenTokenAwareTree token) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        String name = children.get(0).getText();
        if (children.size() == 1) {
            return new Declaration(token, name);
        }
        HiddenTokenAwareTree expressionToken = children.get(1);
        if (expressionToken.getType() == 80) {
            return new Declaration(token, name, null, true);
        }
        Expression expression = (Expression)this.switchOn(expressionToken);
        if (children.size() == 2) {
            return new Declaration(token, name, expression);
        }
        if (children.get(2).getType() == 80) {
            return new Declaration(token, name, expression, true);
        }
        throw new TreeBuildingException(token);
    }

    @Override
    public FontFace handleFontFace(HiddenTokenAwareTree token) {
        FontFace result = new FontFace(token);
        List<HiddenTokenAwareTree> children = token.getChildren();
        ArrayList<Declaration> declarations = new ArrayList<Declaration>();
        for (HiddenTokenAwareTree kid : children) {
            if (kid.getType() != 8) continue;
            declarations.add(this.handleDeclaration(kid));
        }
        result.addMembers(declarations);
        return result;
    }

    @Override
    public CharsetDeclaration handleCharsetDeclaration(HiddenTokenAwareTree token) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        if (children.isEmpty()) {
            throw new TreeBuildingException(token);
        }
        return new CharsetDeclaration(token, children.get(0).getText());
    }

    @Override
    public RuleSet handleRuleSet(HiddenTokenAwareTree token) {
        RuleSet ruleSet = new RuleSet(token);
        ArrayList<Selector> selectors = new ArrayList<Selector>();
        List<HiddenTokenAwareTree> children = token.getChildren();
        ASTCssNode previousKid = null;
        for (HiddenTokenAwareTree kid : children) {
            if (kid.getType() == 12) {
                Selector selector = this.handleSelector(kid);
                if (selector != null) {
                    selectors.add(selector);
                }
                previousKid = selector;
            }
            if (kid.getType() == 30) {
                RuleSetsBody body = this.handleRuleSetsBody(kid);
                ruleSet.setBody(body);
                previousKid = body;
            }
            if (kid.getType() != 41 || previousKid == null) continue;
            previousKid.getUnderlyingStructure().addFollowing(kid.getPreceding());
        }
        ruleSet.addSelectors(selectors);
        this.warningsCollector.warnRuleSetWithoutSelector(ruleSet);
        return ruleSet;
    }

    @Override
    public PureMixin handlePureMixinDeclaration(HiddenTokenAwareTree token) {
        PureMixin result = new PureMixin(token);
        List<HiddenTokenAwareTree> children = token.getChildren();
        for (HiddenTokenAwareTree kid : children) {
            if (kid.getType() == 17) {
                result.setSelector(this.handleCssClass(kid));
                continue;
            }
            if (kid.getType() == 30) {
                result.setBody(this.handleRuleSetsBody(kid));
                continue;
            }
            if (kid.getType() == 35) {
                result.addGuard(this.handleGuard(kid));
                continue;
            }
            if (kid.getType() == 50) {
                result.addParameter(new ArgumentDeclaration(kid, new Variable(kid, "@"), null, true));
                continue;
            }
            result.addParameter((ASTCssNode)this.switchOn(kid));
        }
        return result;
    }

    @Override
    public MixinReference handleMixinReference(HiddenTokenAwareTree token) {
        MixinReference result = new MixinReference(token);
        List<HiddenTokenAwareTree> children = token.getChildren();
        for (HiddenTokenAwareTree kid : children) {
            if (kid.getType() == 17) {
                result.setSelector(this.handleCssClass(kid));
                continue;
            }
            if (kid.getType() == 80) {
                result.setImportant(true);
                continue;
            }
            result.addParameter((Expression)this.switchOn(kid));
        }
        return result;
    }

    @Override
    public Expression handleMixinPattern(HiddenTokenAwareTree token) {
        return this.termBuilder.buildFromTerm(token.getChild(0));
    }

    @Override
    public Guard handleGuard(HiddenTokenAwareTree token) {
        Guard result = new Guard(token);
        Iterator<HiddenTokenAwareTree> iterator = token.getChildren().iterator();
        result.addCondition(this.handleGuardCondition(iterator.next()));
        while (iterator.hasNext()) {
            this.validateGuardAnd(iterator.next());
            result.addCondition(this.handleGuardCondition(iterator.next()));
        }
        return result;
    }

    @Override
    public GuardCondition handleGuardCondition(HiddenTokenAwareTree token) {
        Iterator<HiddenTokenAwareTree> iterator = token.getChildren().iterator();
        HiddenTokenAwareTree kid = iterator.next();
        boolean isNegated = false;
        if (kid.getType() != 7) {
            this.validateGuardNegation(kid);
            isNegated = true;
            kid = iterator.next();
        }
        Expression condition = this.handleExpression(kid);
        if (iterator.hasNext()) {
            HiddenTokenAwareTree operatorToken = iterator.next();
            Expression followingExpression = this.handleExpression(iterator.next());
            condition = new ComparisonExpression(token, condition, this.toComparisonOperator(operatorToken), followingExpression);
        }
        return new GuardCondition(token, isNegated, condition);
    }

    private ComparisonExpressionOperator toComparisonOperator(HiddenTokenAwareTree token) {
        switch (token.getType()) {
            case 54: {
                return new ComparisonExpressionOperator(token, ComparisonExpressionOperator.Operator.GREATER);
            }
            case 81: {
                return new ComparisonExpressionOperator(token, ComparisonExpressionOperator.Operator.GREATER_OR_EQUAL);
            }
            case 73: {
                return new ComparisonExpressionOperator(token, ComparisonExpressionOperator.Operator.OPEQ);
            }
            case 82: {
                return new ComparisonExpressionOperator(token, ComparisonExpressionOperator.Operator.LOWER_OR_EQUAL);
            }
            case 83: {
                return new ComparisonExpressionOperator(token, ComparisonExpressionOperator.Operator.LOWER);
            }
        }
        throw new TreeBuildingException("Unknown operator type. ", token);
    }

    public void validateGuardNegation(HiddenTokenAwareTree token) {
        String operator = token.getText().trim();
        if (!"not".equals(operator)) {
            throw new TreeBuildingException("Unexpected guard operator ", token);
        }
    }

    public void validateGuardAnd(HiddenTokenAwareTree token) {
        String operator = token.getText().trim();
        if (!"and".equals(operator)) {
            throw new TreeBuildingException("Unexpected guard operator ", token);
        }
    }

    @Override
    public NestedRuleSet handleNestedRuleSet(HiddenTokenAwareTree token) {
        boolean hasAppender = false;
        SelectorCombinator combinator = null;
        RuleSet ruleSet = null;
        List<HiddenTokenAwareTree> children = token.getChildren();
        for (HiddenTokenAwareTree kid : children) {
            if (kid.getType() == 58) {
                token.addPreceding(kid.getPreceding());
                hasAppender = true;
                continue;
            }
            if (kid.getType() == 10) {
                ruleSet = (RuleSet)this.switchOn(kid);
                continue;
            }
            combinator = ConversionUtils.createSelectorCombinator(kid);
        }
        NestedRuleSet result = new NestedRuleSet(token, hasAppender, combinator, ruleSet);
        return result;
    }

    @Override
    public RuleSetsBody handleRuleSetsBody(HiddenTokenAwareTree token) {
        if (token.getChildren() == null) {
            return new RuleSetsBody(token);
        }
        ArrayList<ASTCssNode> members = new ArrayList<ASTCssNode>();
        for (HiddenTokenAwareTree kid : token.getChildren()) {
            members.add((ASTCssNode)this.switchOn(kid));
        }
        return new RuleSetsBody(token, (List<ASTCssNode>)members);
    }

    @Override
    public Selector handleSelector(HiddenTokenAwareTree token) {
        SelectorBuilder builder = new SelectorBuilder(token, this);
        return builder.buildSelector();
    }

    @Override
    public CssClass handleCssClass(HiddenTokenAwareTree token) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        HiddenTokenAwareTree nameToken = children.get(0);
        String name = nameToken.getText();
        if (nameToken.getType() != 45 && name.length() > 1) {
            name = name.substring(1, name.length());
        }
        CssClass result = new CssClass(token, name);
        return result;
    }

    @Override
    public SelectorAttribute handleSelectorAttribute(HiddenTokenAwareTree token) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        if (children.size() == 0) {
            throw new TreeBuildingException(token);
        }
        if (children.size() == 1) {
            return new SelectorAttribute(token, children.get(0).getText());
        }
        if (children.size() < 3) {
            throw new TreeBuildingException(token);
        }
        return new SelectorAttribute(token, children.get(0).getText(), this.handleSelectorOperator(children.get(1)), children.get(2).getText());
    }

    @Override
    public SelectorOperator handleSelectorOperator(HiddenTokenAwareTree token) {
        return new SelectorOperator(token, this.toSelectorOperator(token));
    }

    private SelectorOperator.Operator toSelectorOperator(HiddenTokenAwareTree token) {
        switch (token.getType()) {
            case 73: {
                return SelectorOperator.Operator.EQUALS;
            }
            case 74: {
                return SelectorOperator.Operator.INCLUDES;
            }
            case 75: {
                return SelectorOperator.Operator.SPECIAL_PREFIX;
            }
            case 76: {
                return SelectorOperator.Operator.PREFIXMATCH;
            }
            case 77: {
                return SelectorOperator.Operator.SUFFIXMATCH;
            }
            case 78: {
                return SelectorOperator.Operator.SUBSTRINGMATCH;
            }
        }
        throw new TreeBuildingException(token);
    }

    @Override
    public Pseudo handlePseudo(HiddenTokenAwareTree token) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        if (children.size() == 0 || children.size() == 1) {
            throw new TreeBuildingException(token);
        }
        HiddenTokenAwareTree t = children.get(1);
        if (t.getType() == 47) {
            return this.createPseudoElement(token, 2, false);
        }
        if (COLONLESS_PSEUDOELEMENTS.contains(t.getText().toLowerCase())) {
            return this.createPseudoElement(token, 1, true);
        }
        if (children.size() == 2) {
            return new PseudoClass(token, children.get(1).getText());
        }
        if (children.size() == 3) {
            HiddenTokenAwareTree parameter = children.get(2);
            if (parameter.getType() == 62) {
                return new PseudoClass(token, children.get(1).getText(), new NumberExpression(parameter, parameter.getText()));
            }
            if (parameter.getType() == 45) {
                return new PseudoClass(token, children.get(1).getText(), new IdentifierExpression(parameter, parameter.getText()));
            }
            return new PseudoClass(token, children.get(1).getText(), (ASTCssNode)this.switchOn(parameter));
        }
        throw new TreeBuildingException(token);
    }

    @Override
    public Nth handleNth(HiddenTokenAwareTree token) {
        Expression first = null;
        Expression second = null;
        if (this.hasChildren(token.getChild(0))) {
            first = this.termBuilder.buildFromTerm(token.getChild(0));
            String sign = "";
            if (first.getType() == ASTCssNodeType.SIGNED_EXPRESSION) {
                SignedExpression negated = (SignedExpression)first;
                first = negated.getExpression();
                sign = negated.getSign().toSymbol();
            }
            if (first.getType() == ASTCssNodeType.IDENTIFIER_EXPRESSION) {
                IdentifierExpression ident = (IdentifierExpression)first;
                String lowerCaseValue = ident.getValue().toLowerCase();
                lowerCaseValue = sign + lowerCaseValue;
                if ("even".equals(lowerCaseValue)) {
                    return new Nth(token, null, null, Nth.Form.EVEN);
                }
                if ("odd".equals(lowerCaseValue)) {
                    return new Nth(token, null, null, Nth.Form.ODD);
                }
                if ("n".equals(lowerCaseValue) || "-n".equals(lowerCaseValue) || "+n".equals(lowerCaseValue)) {
                    first = new NumberExpression(token.getChild(0), lowerCaseValue, NumberExpression.Dimension.REPEATER);
                } else {
                    throw new IllegalStateException("Unexpected identifier value for nth: " + ident.getValue());
                }
            }
        }
        if (token.getChild(1) != null && this.hasChildren(token.getChild(1))) {
            second = this.termBuilder.buildFromTerm(token.getChild(1));
        }
        return new Nth(token, (NumberExpression)first, (NumberExpression)second);
    }

    private boolean hasChildren(HiddenTokenAwareTree token) {
        return token.getChildren() != null && !token.getChildren().isEmpty();
    }

    private PseudoElement createPseudoElement(HiddenTokenAwareTree token, int startIndex, boolean level12Form) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        String name = children.get(startIndex).getText();
        return new PseudoElement(token, name, level12Form);
    }

    @Override
    public IdSelector handleIdSelector(HiddenTokenAwareTree token) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        if (children.size() != 1) {
            throw new TreeBuildingException(token);
        }
        String text = children.get(0).getText();
        if (text == null || text.length() < 1) {
            throw new TreeBuildingException(token);
        }
        return new IdSelector(token, text.substring(1));
    }

    @Override
    public Media handleMedia(HiddenTokenAwareTree token) {
        List<HiddenTokenAwareTree> originalChildren = token.getChildren();
        ArrayList<HiddenTokenAwareTree> children = new ArrayList<HiddenTokenAwareTree>(originalChildren);
        HiddenTokenAwareTree lbrace = (HiddenTokenAwareTree)((Object)children.remove(1));
        ((HiddenTokenAwareTree)((Object)children.get(0))).addFollowing(lbrace.getPreceding());
        ((HiddenTokenAwareTree)((Object)children.get(1))).addBeforePreceding(lbrace.getFollowing());
        HiddenTokenAwareTree rbrace = (HiddenTokenAwareTree)((Object)children.remove(children.size() - 1));
        ((HiddenTokenAwareTree)((Object)children.get(children.size() - 1))).addFollowing(rbrace.getPreceding());
        rbrace.getParent().addBeforeFollowing(rbrace.getFollowing());
        Media result = new Media(token);
        for (HiddenTokenAwareTree kid : children) {
            if (kid.getType() == 26) {
                kid.pushHiddenToKids();
                this.handleMediaDeclaration(result, kid);
                continue;
            }
            result.addChild((ASTCssNode)this.switchOn(kid));
        }
        return result;
    }

    private void handleMediaDeclaration(Media result, HiddenTokenAwareTree declaration) {
        List<HiddenTokenAwareTree> children = declaration.getChildren();
        ASTCssNode previousKid = null;
        for (HiddenTokenAwareTree kid : children) {
            if (kid.getType() == 41) {
                previousKid.getUnderlyingStructure().addFollowing(kid.getPreceding());
                continue;
            }
            previousKid = (ASTCssNode)this.switchOn(kid);
            result.addChild(previousKid);
        }
    }

    @Override
    public MediaQuery handleMediaQuery(HiddenTokenAwareTree token) {
        MediaQuery result = new MediaQuery(token);
        List<HiddenTokenAwareTree> originalChildren = token.getChildren();
        LinkedList<HiddenTokenAwareTree> children = new LinkedList<HiddenTokenAwareTree>();
        for (HiddenTokenAwareTree kid : originalChildren) {
            if (kid.getType() == 45) {
                HiddenTokenAwareTree lastKid = (HiddenTokenAwareTree)((Object)children.peekLast());
                if (lastKid == null) continue;
                lastKid.addFollowing(kid.getPreceding());
                continue;
            }
            children.add(kid);
        }
        for (HiddenTokenAwareTree kid : children) {
            if (kid.getType() == 45) continue;
            result.addMember((ASTCssNode)this.switchOn(kid));
        }
        return result;
    }

    @Override
    public Medium handleMedium(HiddenTokenAwareTree token) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        if (children.size() == 1) {
            HiddenTokenAwareTree type = children.get(0);
            return new Medium(token, new MediumModifier(type), new MediumType(type, type.getText()));
        }
        HiddenTokenAwareTree type = children.get(1);
        return new Medium(token, this.toMediumModifier(children.get(0)), new MediumType(type, type.getText()));
    }

    @Override
    public MediaExpression handleMediaExpression(HiddenTokenAwareTree token) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        HiddenTokenAwareTree featureNode = children.get(0);
        if (children.size() == 1) {
            return new MediaExpression(token, new MediaExpressionFeature(featureNode, featureNode.getText()), null);
        }
        if (children.size() == 2) {
            throw new TreeBuildingException(token);
        }
        HiddenTokenAwareTree colonNode = children.get(1);
        featureNode.addFollowing(colonNode.getPreceding());
        HiddenTokenAwareTree expressionNode = children.get(2);
        Expression expression = (Expression)this.switchOn(expressionNode);
        return new MediaExpression(token, new MediaExpressionFeature(featureNode, featureNode.getText()), expression);
    }

    private MediumModifier toMediumModifier(HiddenTokenAwareTree token) {
        String modifier = token.getText().toLowerCase();
        if ("not".equals(modifier)) {
            return new MediumModifier(token, MediumModifier.Modifier.NOT);
        }
        if ("only".equals(modifier)) {
            return new MediumModifier(token, MediumModifier.Modifier.ONLY);
        }
        throw new IllegalStateException("Unexpected medium modifier: " + modifier);
    }

    @Override
    public VariableDeclaration handleVariableDeclaration(HiddenTokenAwareTree token) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        HiddenTokenAwareTree name = children.get(0);
        HiddenTokenAwareTree colon = children.get(1);
        HiddenTokenAwareTree expression = children.get(2);
        HiddenTokenAwareTree semi = children.get(3);
        colon.giveHidden(name, expression);
        semi.giveHidden(expression, null);
        token.addBeforeFollowing(semi.getFollowing());
        return new VariableDeclaration(token, new Variable(name, name.getText()), (Expression)this.switchOn(expression));
    }

    @Override
    public ArgumentDeclaration handleArgumentDeclaration(HiddenTokenAwareTree token) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        HiddenTokenAwareTree name = children.get(0);
        if (children.size() == 1) {
            return new ArgumentDeclaration(token, new Variable(name, name.getText()), null);
        }
        HiddenTokenAwareTree separator = children.get(1);
        if (separator.getType() == 50) {
            return new ArgumentDeclaration(token, new Variable(name, name.getText()), null, true);
        }
        HiddenTokenAwareTree expression = children.get(2);
        separator.giveHidden(name, expression);
        return new ArgumentDeclaration(token, new Variable(name, name.getText()), (Expression)this.switchOn(expression));
    }

    static {
        COLONLESS_PSEUDOELEMENTS.add("first-line");
        COLONLESS_PSEUDOELEMENTS.add("first-letter");
        COLONLESS_PSEUDOELEMENTS.add("before");
        COLONLESS_PSEUDOELEMENTS.add("after");
    }
}

