/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.parser;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;

class CollectorTokenSource
implements TokenSource {
    private final TokenSource source;
    private final Set<Integer> collectTokenTypes = new HashSet<Integer>();
    private final LinkedList<Token> collectedTokens = new LinkedList();

    public CollectorTokenSource(TokenSource source, Collection<Integer> collectTokenTypes) {
        this.source = source;
        this.collectTokenTypes.addAll(collectTokenTypes);
    }

    public Token nextToken() {
        Token nextToken = this.source.nextToken();
        if (this.shouldCollect(nextToken)) {
            this.collectedTokens.add(nextToken);
        }
        return nextToken;
    }

    protected boolean shouldCollect(Token nextToken) {
        return this.collectTokenTypes.contains(nextToken.getType());
    }

    public LinkedList<Token> getCollectedTokens() {
        return this.collectedTokens;
    }

    public String getSourceName() {
        return "Collect hidden channel " + this.source.getSourceName();
    }
}

