/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.parser;

import java.util.HashSet;
import java.util.Set;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;

public class ParsersSemanticPredicates {
    private static Set<String> NTH_PSEUDOCLASSES = new HashSet<String>();

    public boolean isNthPseudoClass(Token a) {
        if (a == null) {
            return false;
        }
        String text = a.getText();
        if (text == null) {
            return false;
        }
        return NTH_PSEUDOCLASSES.contains(text.toLowerCase());
    }

    public boolean isFunctionStart(Token first, Token second) {
        if (first == null || second == null) {
            return false;
        }
        if (first.getType() != 45 || second.getType() != 46) {
            return false;
        }
        return this.directlyFollows(first, second);
    }

    public boolean isEmptySeparator(Token previousT, Token firstT, Token secondT) {
        if (previousT == null) {
            return false;
        }
        if (!(previousT instanceof CommonToken && firstT instanceof CommonToken && secondT instanceof CommonToken)) {
            return false;
        }
        CommonToken previous = (CommonToken)previousT;
        CommonToken first = (CommonToken)firstT;
        CommonToken second = (CommonToken)secondT;
        if (this.isArithmeticOperator(previous)) {
            return false;
        }
        if (this.directlyFollows(previous, first)) {
            return false;
        }
        if (this.isArithmeticOperator(first) && this.isArithmeticOperator(second)) {
            return false;
        }
        return !this.isArithmeticOperator(first) || this.isArithmeticOperator(second) || this.directlyFollows(first, second);
    }

    private boolean isArithmeticOperator(CommonToken previous) {
        return previous.getType() == 57 || previous.getType() == 55 || previous.getType() == 72 || previous.getType() == 84;
    }

    public boolean directlyFollows(Token first, Token second) {
        if (!(first instanceof CommonToken) || !(second instanceof CommonToken)) {
            return false;
        }
        CommonToken firstT = (CommonToken)first;
        CommonToken secondT = (CommonToken)second;
        return this.directlyFollows(firstT, secondT);
    }

    public boolean directlyFollows(CommonToken firstT, CommonToken secondT) {
        if (firstT.getStopIndex() + 1 != secondT.getStartIndex()) {
            return false;
        }
        String text = firstT.getText();
        if (text == null || text.isEmpty()) {
            return true;
        }
        String substring = text.substring(text.length() - 1);
        return substring.equals(substring.trim());
    }

    public boolean isWhenKeyword(Token token) {
        if (token == null || !(token instanceof CommonToken) || token.getType() != 45) {
            return false;
        }
        String word = token.getText().trim().toLowerCase();
        return "when".equals(word);
    }

    static {
        NTH_PSEUDOCLASSES.add("nth-child");
        NTH_PSEUDOCLASSES.add("nth-last-child");
        NTH_PSEUDOCLASSES.add("nth-of-type");
        NTH_PSEUDOCLASSES.add("nth-last-of-type");
    }
}

