/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.parser;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.ast.SelectorCombinator;
import com.github.sommeri.less4j.core.ast.SimpleSelector;
import com.github.sommeri.less4j.core.parser.ASTBuilderSwitch;
import com.github.sommeri.less4j.core.parser.ConversionUtils;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import java.util.List;

public class SelectorBuilder {
    private SimpleSelector currentSimpleSelector;
    private Selector result;
    private Selector currentSelector;
    private final HiddenTokenAwareTree token;
    private final ASTBuilderSwitch parentBuilder;
    private HiddenTokenAwareTree lastCombinator;

    public SelectorBuilder(HiddenTokenAwareTree token, ASTBuilderSwitch parentBuilder) {
        this.token = token;
        this.parentBuilder = parentBuilder;
    }

    public Selector buildSelector() {
        List<HiddenTokenAwareTree> members = this.token.getChildren();
        HiddenTokenAwareTree previousNonCombinator = null;
        block4: for (HiddenTokenAwareTree kid : members) {
            switch (kid.getType()) {
                case 16: {
                    this.addElementName(kid);
                    previousNonCombinator = kid;
                    continue block4;
                }
                case 22: {
                    this.addElementSubsequent(previousNonCombinator, kid);
                    previousNonCombinator = kid;
                    continue block4;
                }
            }
            this.lastCombinator = kid;
        }
        return this.result;
    }

    private void addElementSubsequent(HiddenTokenAwareTree previousNonCombinator, HiddenTokenAwareTree kid) {
        if (previousNonCombinator == null) {
            this.addWithImplicitStar(kid);
            return;
        }
        if (previousNonCombinator.getTokenStopIndex() + 1 < kid.getTokenStartIndex()) {
            this.addWithImplicitStar(kid);
            return;
        }
        this.addSubsequent(kid);
    }

    public void addSubsequent(HiddenTokenAwareTree kid) {
        this.currentSimpleSelector.addSubsequent((ASTCssNode)this.parentBuilder.switchOn(kid.getChild(0)));
    }

    private void addWithImplicitStar(HiddenTokenAwareTree kid) {
        this.currentSimpleSelector = new SimpleSelector(kid, null, true);
        this.currentSimpleSelector.setEmptyForm(true);
        this.addSubsequent(kid);
        this.startNewSelector();
        this.currentSelector.setHead(this.currentSimpleSelector);
    }

    private SelectorCombinator consumeLastCombinator() {
        if (this.lastCombinator == null) {
            return null;
        }
        SelectorCombinator result = ConversionUtils.createSelectorCombinator(this.lastCombinator);
        this.lastCombinator = null;
        return result;
    }

    private void addElementName(HiddenTokenAwareTree kid) {
        HiddenTokenAwareTree realName = kid.getChild(0);
        this.currentSimpleSelector = new SimpleSelector(kid, realName.getText(), realName.getType() == 72);
        this.startNewSelector();
        this.currentSelector.setHead(this.currentSimpleSelector);
    }

    private void startNewSelector() {
        Selector newSelector = new Selector(this.token);
        newSelector.setLeadingCombinator(this.consumeLastCombinator());
        if (this.currentSelector != null) {
            this.currentSelector.setRight(newSelector);
        }
        this.currentSelector = newSelector;
        if (this.result == null) {
            this.result = this.currentSelector;
        }
    }
}

