/*
 * Copyright 2013 ArcBees Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.gwtplatform.mvp.client;

/**
 * This class is used on class that can register handlers. Currently used by
 * {@link com.gwtplatform.mvp.client.proxy.ProxyImpl} to remove any registered handler when we unbind a proxy.
 */
public interface HasHandlerContainer {
    /**
     * @return the handler container of the implementer.
     */
    HandlerContainer getHandlerContainer();
}
