/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.file;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.functional.IPredicate;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.regex.RegExHelper;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@FunctionalInterface
public interface IFileFilter
extends FileFilter,
FilenameFilter,
IPredicate<File> {
    @Override
    default public boolean accept(@Nullable File file) {
        return this.test(file);
    }

    @Override
    default public boolean accept(@Nullable File file, @Nullable String string) {
        if (string == null) {
            return false;
        }
        File file2 = file != null ? new File(file, string) : new File(string);
        return this.test(file2);
    }

    @Nonnull
    public static IFileFilter directoryOnly() {
        return file -> FileHelper.existsDir(file);
    }

    @Nonnull
    public static IFileFilter directoryPublic() {
        return file -> FileHelper.existsDir(file) && !FilenameHelper.isHiddenFilename(file);
    }

    @Nonnull
    public static IFileFilter parentDirectoryPublic() {
        return file -> {
            File file2 = file != null ? file.getAbsoluteFile().getParentFile() : null;
            return file2 != null && !FilenameHelper.isHiddenFilename(file2);
        };
    }

    @Nonnull
    public static IFileFilter fileOnly() {
        return file -> FileHelper.existsFile(file);
    }

    @Nonnull
    public static IFileFilter filenameHidden() {
        return file -> FilenameHelper.isHiddenFilename(file);
    }

    @Nonnull
    public static IFileFilter filenameStartsWith(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Prefix");
        return file -> {
            String string2;
            if (file != null && (string2 = FilenameHelper.getSecureFilename(file.getName())) != null) {
                return string2.startsWith(string);
            }
            return false;
        };
    }

    @Nonnull
    public static IFileFilter filenameEndsWith(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Suffix");
        return file -> {
            String string2;
            if (file != null && (string2 = FilenameHelper.getSecureFilename(file.getName())) != null) {
                return string2.endsWith(string);
            }
            return false;
        };
    }

    @Nonnull
    public static IFileFilter filenameEquals(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Filename");
        return file -> file != null && string.equals(FilenameHelper.getSecureFilename(file.getName()));
    }

    @Nonnull
    public static IFileFilter filenameEqualsIgnoreCase(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Filename");
        return file -> file != null && string.equalsIgnoreCase(FilenameHelper.getSecureFilename(file.getName()));
    }

    @Nonnull
    public static IFileFilter filenameNotEquals(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Filename");
        return file -> file != null && !string.equals(FilenameHelper.getSecureFilename(file.getName()));
    }

    @Nonnull
    public static IFileFilter filenameNotEqualsIgnoreCase(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Filename");
        return file -> file != null && !string.equalsIgnoreCase(FilenameHelper.getSecureFilename(file.getName()));
    }

    @Nonnull
    public static IFileFilter filenameMatchAnyRegEx(String ... stringArray) {
        ValueEnforcer.notEmpty(stringArray, "RegularExpressions");
        return file -> {
            String string;
            if (file != null && (string = FilenameHelper.getSecureFilename(file.getName())) != null) {
                for (String string2 : stringArray) {
                    if (!RegExHelper.stringMatchesPattern(string2, string)) continue;
                    return true;
                }
            }
            return false;
        };
    }

    @Nonnull
    public static IFileFilter filenameMatchNoRegEx(String ... stringArray) {
        ValueEnforcer.notEmpty(stringArray, "RegularExpressions");
        return file -> {
            if (file == null) {
                return false;
            }
            String string = FilenameHelper.getSecureFilename(file.getName());
            if (string == null) {
                return false;
            }
            for (String string2 : stringArray) {
                if (!RegExHelper.stringMatchesPattern(string2, string)) continue;
                return false;
            }
            return true;
        };
    }

    @Nonnull
    public static IFileFilter filenameMatchAny(String ... stringArray) {
        ValueEnforcer.notEmpty(stringArray, "Filenames");
        return file -> {
            String string;
            if (file != null && (string = FilenameHelper.getSecureFilename(file.getName())) != null) {
                for (String string2 : stringArray) {
                    if (!string2.equals(string)) continue;
                    return true;
                }
            }
            return false;
        };
    }

    @Nonnull
    public static IFileFilter filenameMatchNone(String ... stringArray) {
        ValueEnforcer.notEmpty(stringArray, "Filenames");
        return file -> {
            if (file == null) {
                return false;
            }
            String string = FilenameHelper.getSecureFilename(file.getName());
            if (string == null) {
                return false;
            }
            for (String string2 : stringArray) {
                if (!string2.equals(string)) continue;
                return false;
            }
            return true;
        };
    }
}

