/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.stream;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.stream.WrappedInputStream;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class NonBlockingBufferedInputStream
extends WrappedInputStream {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    @SuppressFBWarnings(value={"VO_VOLATILE_REFERENCE_TO_ARRAY"})
    protected volatile byte[] m_aBuf;
    private static final AtomicReferenceFieldUpdater<NonBlockingBufferedInputStream, byte[]> s_aBufUpdater = AtomicReferenceFieldUpdater.newUpdater(NonBlockingBufferedInputStream.class, byte[].class, "m_aBuf");
    protected int m_nCount;
    protected int m_nPos;
    protected int m_nMarkPos = -1;
    protected int m_nMarkLimit;

    @Nonnull
    private InputStream _getInIfOpen() throws IOException {
        InputStream inputStream = this.in;
        if (inputStream == null) {
            throw new IOException("Stream closed");
        }
        return inputStream;
    }

    @Nonnull
    private byte[] _getBufIfOpen() throws IOException {
        byte[] byArray = this.m_aBuf;
        if (byArray == null) {
            throw new IOException("Stream closed");
        }
        return byArray;
    }

    public NonBlockingBufferedInputStream(@Nonnull InputStream inputStream) {
        this(inputStream, 8192);
    }

    public NonBlockingBufferedInputStream(@Nonnull InputStream inputStream, @Nonnegative int n) {
        super(inputStream);
        ValueEnforcer.isGT0(n, "Size");
        this.m_aBuf = new byte[n];
    }

    private void _fill() throws IOException {
        int n;
        byte[] byArray = this._getBufIfOpen();
        if (this.m_nMarkPos < 0) {
            this.m_nPos = 0;
        } else if (this.m_nPos >= byArray.length) {
            if (this.m_nMarkPos > 0) {
                n = this.m_nPos - this.m_nMarkPos;
                System.arraycopy(byArray, this.m_nMarkPos, byArray, 0, n);
                this.m_nPos = n;
                this.m_nMarkPos = 0;
            } else if (byArray.length >= this.m_nMarkLimit) {
                this.m_nMarkPos = -1;
                this.m_nPos = 0;
            } else {
                n = this.m_nPos * 2;
                if (n > this.m_nMarkLimit) {
                    n = this.m_nMarkLimit;
                }
                byte[] byArray2 = new byte[n];
                System.arraycopy(byArray, 0, byArray2, 0, this.m_nPos);
                if (!s_aBufUpdater.compareAndSet(this, byArray, byArray2)) {
                    throw new IOException("Stream closed");
                }
                byArray = byArray2;
            }
        }
        this.m_nCount = this.m_nPos;
        n = this._getInIfOpen().read(byArray, this.m_nPos, byArray.length - this.m_nPos);
        if (n > 0) {
            this.m_nCount = n + this.m_nPos;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.m_nPos >= this.m_nCount) {
            this._fill();
            if (this.m_nPos >= this.m_nCount) {
                return -1;
            }
        }
        return this._getBufIfOpen()[this.m_nPos++] & 0xFF;
    }

    private int _read1(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) throws IOException {
        int n3 = this.m_nCount - this.m_nPos;
        if (n3 <= 0) {
            if (n2 >= this._getBufIfOpen().length && this.m_nMarkPos < 0) {
                return this._getInIfOpen().read(byArray, n, n2);
            }
            this._fill();
            n3 = this.m_nCount - this.m_nPos;
            if (n3 <= 0) {
                return -1;
            }
        }
        int n4 = n3 < n2 ? n3 : n2;
        System.arraycopy(this._getBufIfOpen(), this.m_nPos, byArray, n, n4);
        this.m_nPos += n4;
        return n4;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        InputStream inputStream;
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        this._getBufIfOpen();
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        do {
            int n4;
            if ((n4 = this._read1(byArray, n + n3, n2 - n3)) <= 0) {
                return n3 == 0 ? n4 : n3;
            }
            if ((n3 += n4) < n2) continue;
            return n3;
        } while ((inputStream = this.in) == null || inputStream.available() > 0);
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        this._getBufIfOpen();
        if (l <= 0L) {
            return 0L;
        }
        long l2 = this.m_nCount - this.m_nPos;
        if (l2 <= 0L) {
            if (this.m_nMarkPos < 0) {
                return this._getInIfOpen().skip(l);
            }
            this._fill();
            l2 = this.m_nCount - this.m_nPos;
            if (l2 <= 0L) {
                return 0L;
            }
        }
        long l3 = l2 < l ? l2 : l;
        this.m_nPos = (int)((long)this.m_nPos + l3);
        return l3;
    }

    @Override
    public int available() throws IOException {
        return this._getInIfOpen().available() + (this.m_nCount - this.m_nPos);
    }

    @Override
    public void mark(int n) {
        this.m_nMarkLimit = n;
        this.m_nMarkPos = this.m_nPos;
    }

    @Override
    public void reset() throws IOException {
        this._getBufIfOpen();
        if (this.m_nMarkPos < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this.m_nPos = this.m_nMarkPos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void close() throws IOException {
        block2: {
            byte[] byArray;
            do {
                byArray = this.m_aBuf;
                if (this.m_aBuf == null) break block2;
            } while (!s_aBufUpdater.compareAndSet(this, byArray, null));
            InputStream inputStream = this.in;
            this.in = null;
            if (inputStream != null) {
                inputStream.close();
            }
            return;
        }
    }
}

