/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.mime;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.compare.IComparable;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.mime.EMimeContentType;
import com.helger.commons.mime.EMimeQuoting;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.mime.MimeTypeParameter;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.util.Collection;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MimeType
implements IMimeType,
IComparable<MimeType> {
    private final EMimeContentType m_eContentType;
    private final String m_sContentSubType;
    private final String m_sMainTypeAsString;
    private final ICommonsList<MimeTypeParameter> m_aParameters;

    public MimeType(@Nonnull IMimeType iMimeType) {
        this(iMimeType.getContentType(), iMimeType.getContentSubType(), iMimeType.getAllParameters());
    }

    public MimeType(@Nonnull EMimeContentType eMimeContentType, @Nonnull @Nonempty String string) {
        this(eMimeContentType, string, null);
    }

    public MimeType(@Nonnull EMimeContentType eMimeContentType, @Nonnull @Nonempty String string, @Nullable Collection<? extends MimeTypeParameter> collection) {
        ValueEnforcer.notNull(eMimeContentType, "ContentType");
        ValueEnforcer.notEmpty(string, "ContentSubType");
        this.m_eContentType = eMimeContentType;
        this.m_sContentSubType = string;
        this.m_sMainTypeAsString = this.m_eContentType.getText() + '/' + this.m_sContentSubType;
        this.m_aParameters = new CommonsArrayList<Collection<? extends MimeTypeParameter>>(collection);
    }

    @Override
    @Nonnull
    public EMimeContentType getContentType() {
        return this.m_eContentType;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getContentSubType() {
        return this.m_sContentSubType;
    }

    @Nonnull
    private String _getParametersAsString(@Nonnull EMimeQuoting eMimeQuoting) {
        StringBuilder stringBuilder = new StringBuilder();
        for (MimeTypeParameter mimeTypeParameter : this.m_aParameters) {
            stringBuilder.append(';').append(mimeTypeParameter.getAttribute()).append('=').append(mimeTypeParameter.getValueQuotedIfNecessary(eMimeQuoting));
        }
        return stringBuilder.toString();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsString(@Nonnull EMimeQuoting eMimeQuoting) {
        ValueEnforcer.notNull(eMimeQuoting, "QuotingAlgorithm");
        if (this.m_aParameters.isEmpty()) {
            return this.m_sMainTypeAsString;
        }
        return this.m_sMainTypeAsString + this._getParametersAsString(eMimeQuoting);
    }

    @Override
    @Nonnull
    public String getAsStringWithoutParameters() {
        return this.m_sMainTypeAsString;
    }

    @Override
    @Nonnull
    public String getParametersAsString(@Nonnull EMimeQuoting eMimeQuoting) {
        ValueEnforcer.notNull(eMimeQuoting, "QuotingAlgorithm");
        if (this.m_aParameters.isEmpty()) {
            return "";
        }
        return this._getParametersAsString(eMimeQuoting);
    }

    @Nonnull
    public MimeType addParameter(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        return this.addParameter(new MimeTypeParameter(string, string2));
    }

    @Nonnull
    public MimeType addParameter(@Nonnull MimeTypeParameter mimeTypeParameter) {
        ValueEnforcer.notNull(mimeTypeParameter, "Parameter");
        this.m_aParameters.add(mimeTypeParameter);
        return this;
    }

    @Nonnull
    public EChange removeParameter(@Nullable MimeTypeParameter mimeTypeParameter) {
        return this.m_aParameters.removeObject(mimeTypeParameter);
    }

    @Nonnull
    public EChange removeParameterAtIndex(int n) {
        return this.m_aParameters.removeAtIndex(n);
    }

    @Nonnull
    public EChange removeAllParameters() {
        return this.m_aParameters.removeAll();
    }

    @Nonnull
    public EChange removeParameterWithName(@Nullable String string) {
        if (StringHelper.hasText(string)) {
            int n = this.m_aParameters.size();
            for (int i = 0; i < n; ++i) {
                MimeTypeParameter mimeTypeParameter = (MimeTypeParameter)this.m_aParameters.get(i);
                if (!mimeTypeParameter.getAttribute().equals(string)) continue;
                this.m_aParameters.remove(i);
                return EChange.CHANGED;
            }
        }
        return EChange.UNCHANGED;
    }

    @Override
    public boolean hasAnyParameters() {
        return this.m_aParameters.isNotEmpty();
    }

    @Override
    @Nonnegative
    public int getParameterCount() {
        return this.m_aParameters.size();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<MimeTypeParameter> getAllParameters() {
        return (ICommonsList)this.m_aParameters.getClone();
    }

    @Override
    @Nullable
    public MimeTypeParameter getParameterAtIndex(@Nonnegative int n) {
        return (MimeTypeParameter)this.m_aParameters.getAtIndex(n);
    }

    @Override
    @Nullable
    public MimeTypeParameter getParameterWithName(@Nullable String string) {
        if (StringHelper.hasText(string)) {
            for (MimeTypeParameter mimeTypeParameter : this.m_aParameters) {
                if (!mimeTypeParameter.getAttribute().equals(string)) continue;
                return mimeTypeParameter;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public String getParameterValueWithName(@Nullable String string) {
        MimeTypeParameter mimeTypeParameter = this.getParameterWithName(string);
        return mimeTypeParameter == null ? null : mimeTypeParameter.getValue();
    }

    @Override
    @Nonnull
    public MimeType getClone() {
        return new MimeType(this.m_eContentType, this.m_sContentSubType, this.m_aParameters);
    }

    @Override
    @Nonnull
    public MimeType getCopyWithoutParameters() {
        return new MimeType(this.m_eContentType, this.m_sContentSubType);
    }

    @Override
    public int compareTo(MimeType mimeType) {
        return this.m_sMainTypeAsString.compareTo(mimeType.m_sMainTypeAsString);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MimeType mimeType = (MimeType)object;
        return this.m_eContentType.equals(mimeType.m_eContentType) && this.m_sContentSubType.equals(mimeType.m_sContentSubType) && EqualsHelper.equals(this.m_aParameters, mimeType.m_aParameters);
    }

    public int hashCode() {
        return ((HashCodeGenerator)((HashCodeGenerator)new HashCodeGenerator(this).append((Enum)this.m_eContentType)).append(this.m_sContentSubType).append(this.m_aParameters)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("contentType", this.m_eContentType).append("subType", this.m_sContentSubType).appendIfNotNull("parameters", this.m_aParameters).getToString();
    }
}

