/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.system;

import com.helger.commons.string.StringParser;
import com.helger.commons.system.SystemProperties;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class JavaVersionHelper {
    public static final double JAVA_CLASS_VERSION = StringParser.parseDouble(SystemProperties.getJavaClassVersion(), Double.NaN);
    public static final int JAVA_MAJOR_VERSION;
    public static final int JAVA_MINOR_VERSION;
    private static final Logger s_aLogger;
    private static final JavaVersionHelper s_aInstance;

    private JavaVersionHelper() {
    }

    public static boolean isAtLeast(int n, int n2) {
        if (JAVA_MAJOR_VERSION > n) {
            return true;
        }
        if (JAVA_MAJOR_VERSION == n) {
            return JAVA_MINOR_VERSION >= n2;
        }
        return false;
    }

    static {
        s_aLogger = LoggerFactory.getLogger(JavaVersionHelper.class);
        String string = SystemProperties.getJavaVersion();
        if (!string.startsWith("1.")) {
            throw new IllegalStateException("Java version does not start with '1.': '" + string + "'");
        }
        JAVA_MAJOR_VERSION = StringParser.parseInt((string = string.substring(2)).substring(0, string.indexOf(46)), -1);
        if (JAVA_MAJOR_VERSION < 0) {
            throw new IllegalStateException("Failed to determine Java major version from '" + string + "'");
        }
        JAVA_MINOR_VERSION = StringParser.parseInt(string.substring(string.indexOf(95) + 1), -1);
        if (JAVA_MINOR_VERSION < 0) {
            throw new IllegalStateException("Failed to determine Java minor version from '" + string + "'");
        }
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Java version '" + SystemProperties.getJavaVersion() + "' split into MAJOR=" + JAVA_MAJOR_VERSION + " and MINOR=" + JAVA_MINOR_VERSION);
        }
        s_aInstance = new JavaVersionHelper();
    }
}

