
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.MessageFormatType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ABIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Encryption Data. Details&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;Details of an encryption process&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;Encryption Data&lt;/ccts:ObjectClass&gt;&lt;/ccts:Component&gt;
 * </pre>
 * 
 * <p>Java class for EncryptionDataType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="EncryptionDataType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MessageFormat"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}EncryptionCertificateAttachment" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}EncryptionCertificatePathChain" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}EncryptionSymmetricAlgorithm" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "EncryptionDataType", propOrder = {
    "messageFormat",
    "encryptionCertificateAttachment",
    "encryptionCertificatePathChain",
    "encryptionSymmetricAlgorithm"
})
@CodingStyleguideUnaware
public class EncryptionDataType implements Serializable, IExplicitlyCloneable
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Encryption Data. Message Format. Text&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The format of the encrypted message.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Encryption Data&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Message Format&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Text&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Text. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "MessageFormat", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private MessageFormatType messageFormat;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Encryption Data. Encryption Certificate_ Attachment. Attachment&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A reference to the certificate used in the encryption process.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Encryption Data&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Encryption Certificate&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Attachment&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Attachment&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Attachment&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "EncryptionCertificateAttachment")
    private AttachmentType encryptionCertificateAttachment;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Encryption Data. Encryption Certificate Path Chain&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A reference to the path chain defined for the encryption process.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Encryption Data&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Encryption Certificate Path Chain&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Encryption Certificate Path Chain&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Encryption Certificate Path Chain&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "EncryptionCertificatePathChain")
    private List<EncryptionCertificatePathChainType> encryptionCertificatePathChain;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Encryption Data. Encryption Symmetric Algorithm&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A reference to the symmetric algorithm used for the encryption process.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Encryption Data&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Encryption Symmetric Algorithm&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Encryption Symmetric Algorithm&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Encryption Symmetric Algorithm&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "EncryptionSymmetricAlgorithm")
    private List<EncryptionSymmetricAlgorithmType> encryptionSymmetricAlgorithm;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public EncryptionDataType() {
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Encryption Data. Message Format. Text&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The format of the encrypted message.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Encryption Data&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Message Format&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Text&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Text. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link MessageFormatType }
     *     
     */
    @Nullable
    public MessageFormatType getMessageFormat() {
        return messageFormat;
    }

    /**
     * Sets the value of the messageFormat property.
     * 
     * @param value
     *     allowed object is
     *     {@link MessageFormatType }
     *     
     * @see #getMessageFormat()
     */
    public void setMessageFormat(
        @Nullable
        MessageFormatType value) {
        this.messageFormat = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Encryption Data. Encryption Certificate_ Attachment. Attachment&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A reference to the certificate used in the encryption process.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Encryption Data&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Encryption Certificate&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Attachment&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Attachment&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Attachment&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link AttachmentType }
     *     
     */
    @Nullable
    public AttachmentType getEncryptionCertificateAttachment() {
        return encryptionCertificateAttachment;
    }

    /**
     * Sets the value of the encryptionCertificateAttachment property.
     * 
     * @param value
     *     allowed object is
     *     {@link AttachmentType }
     *     
     * @see #getEncryptionCertificateAttachment()
     */
    public void setEncryptionCertificateAttachment(
        @Nullable
        AttachmentType value) {
        this.encryptionCertificateAttachment = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Encryption Data. Encryption Certificate Path Chain&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A reference to the path chain defined for the encryption process.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Encryption Data&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Encryption Certificate Path Chain&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Encryption Certificate Path Chain&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Encryption Certificate Path Chain&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * Gets the value of the encryptionCertificatePathChain property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the encryptionCertificatePathChain property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getEncryptionCertificatePathChain().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link EncryptionCertificatePathChainType }
     * </p>
     * 
     * 
     * @return
     *     The value of the encryptionCertificatePathChain property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<EncryptionCertificatePathChainType> getEncryptionCertificatePathChain() {
        if (encryptionCertificatePathChain == null) {
            encryptionCertificatePathChain = new ArrayList<>();
        }
        return this.encryptionCertificatePathChain;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Encryption Data. Encryption Symmetric Algorithm&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A reference to the symmetric algorithm used for the encryption process.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Encryption Data&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Encryption Symmetric Algorithm&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Encryption Symmetric Algorithm&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Encryption Symmetric Algorithm&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * Gets the value of the encryptionSymmetricAlgorithm property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the encryptionSymmetricAlgorithm property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getEncryptionSymmetricAlgorithm().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link EncryptionSymmetricAlgorithmType }
     * </p>
     * 
     * 
     * @return
     *     The value of the encryptionSymmetricAlgorithm property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<EncryptionSymmetricAlgorithmType> getEncryptionSymmetricAlgorithm() {
        if (encryptionSymmetricAlgorithm == null) {
            encryptionSymmetricAlgorithm = new ArrayList<>();
        }
        return this.encryptionSymmetricAlgorithm;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final EncryptionDataType rhs = ((EncryptionDataType) o);
        if (!EqualsHelper.equals(encryptionCertificateAttachment, rhs.encryptionCertificateAttachment)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(encryptionCertificatePathChain, rhs.encryptionCertificatePathChain)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(encryptionSymmetricAlgorithm, rhs.encryptionSymmetricAlgorithm)) {
            return false;
        }
        if (!EqualsHelper.equals(messageFormat, rhs.messageFormat)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(encryptionCertificateAttachment).append(encryptionCertificatePathChain).append(encryptionSymmetricAlgorithm).append(messageFormat).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("encryptionCertificateAttachment", encryptionCertificateAttachment).append("encryptionCertificatePathChain", encryptionCertificatePathChain).append("encryptionSymmetricAlgorithm", encryptionSymmetricAlgorithm).append("messageFormat", messageFormat).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setEncryptionCertificatePathChain(
        @Nullable
        final List<EncryptionCertificatePathChainType> aList) {
        encryptionCertificatePathChain = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setEncryptionSymmetricAlgorithm(
        @Nullable
        final List<EncryptionSymmetricAlgorithmType> aList) {
        encryptionSymmetricAlgorithm = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasEncryptionCertificatePathChainEntries() {
        return (!getEncryptionCertificatePathChain().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoEncryptionCertificatePathChainEntries() {
        return getEncryptionCertificatePathChain().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getEncryptionCertificatePathChainCount() {
        return getEncryptionCertificatePathChain().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public EncryptionCertificatePathChainType getEncryptionCertificatePathChainAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getEncryptionCertificatePathChain().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addEncryptionCertificatePathChain(
        @Nonnull
        final EncryptionCertificatePathChainType elem) {
        getEncryptionCertificatePathChain().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasEncryptionSymmetricAlgorithmEntries() {
        return (!getEncryptionSymmetricAlgorithm().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoEncryptionSymmetricAlgorithmEntries() {
        return getEncryptionSymmetricAlgorithm().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getEncryptionSymmetricAlgorithmCount() {
        return getEncryptionSymmetricAlgorithm().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public EncryptionSymmetricAlgorithmType getEncryptionSymmetricAlgorithmAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getEncryptionSymmetricAlgorithm().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addEncryptionSymmetricAlgorithm(
        @Nonnull
        final EncryptionSymmetricAlgorithmType elem) {
        getEncryptionSymmetricAlgorithm().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        EncryptionDataType ret) {
        ret.encryptionCertificateAttachment = ((encryptionCertificateAttachment == null)?null:encryptionCertificateAttachment.clone());
        if (encryptionCertificatePathChain == null) {
            ret.encryptionCertificatePathChain = null;
        } else {
            List<EncryptionCertificatePathChainType> retEncryptionCertificatePathChain = new ArrayList<>();
            for (EncryptionCertificatePathChainType aItem: getEncryptionCertificatePathChain()) {
                retEncryptionCertificatePathChain.add(((aItem == null)?null:aItem.clone()));
            }
            ret.encryptionCertificatePathChain = retEncryptionCertificatePathChain;
        }
        if (encryptionSymmetricAlgorithm == null) {
            ret.encryptionSymmetricAlgorithm = null;
        } else {
            List<EncryptionSymmetricAlgorithmType> retEncryptionSymmetricAlgorithm = new ArrayList<>();
            for (EncryptionSymmetricAlgorithmType aItem: getEncryptionSymmetricAlgorithm()) {
                retEncryptionSymmetricAlgorithm.add(((aItem == null)?null:aItem.clone()));
            }
            ret.encryptionSymmetricAlgorithm = retEncryptionSymmetricAlgorithm;
        }
        ret.messageFormat = ((messageFormat == null)?null:messageFormat.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public EncryptionDataType clone() {
        EncryptionDataType ret = new EncryptionDataType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MessageFormatType and never <code>null</code>
     */
    @Nonnull
    public MessageFormatType setMessageFormat(
        @Nullable
        final String valueParam) {
        MessageFormatType aObj = getMessageFormat();
        if (aObj == null) {
            aObj = new MessageFormatType(valueParam);
            setMessageFormat(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained MessageFormatType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MessageFormatType object or <code>null</code>
     */
    @Nullable
    public String getMessageFormatValue() {
        MessageFormatType aObj = getMessageFormat();
        return (aObj == null)?null:aObj.getValue();
    }

}
