
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.GroupingLotsType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.MaximumLotsAwardedNumericType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.MaximumLotsSubmittedNumericType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ABIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Lot Distribution. Details&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A class defining how to treat different lots in a single procurement.&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;Lot Distribution&lt;/ccts:ObjectClass&gt;&lt;/ccts:Component&gt;
 * </pre>
 * 
 * <p>Java class for LotDistributionType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="LotDistributionType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MaximumLotsAwardedNumeric" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MaximumLotsSubmittedNumeric" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}GroupingLots" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "LotDistributionType", propOrder = {
    "maximumLotsAwardedNumeric",
    "maximumLotsSubmittedNumeric",
    "groupingLots"
})
@CodingStyleguideUnaware
public class LotDistributionType implements Serializable, IExplicitlyCloneable
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Lot Distribution. Maximum Lots Awarded. Numeric&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The maximum number of lots that can be awarded to a single tenderer.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Lot Distribution&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Maximum Lots Awarded&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Numeric&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Numeric. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "MaximumLotsAwardedNumeric", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MaximumLotsAwardedNumericType maximumLotsAwardedNumeric;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Lot Distribution. Maximum Lots Submitted. Numeric&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The maximum number of lots to which a tenderer can submit an offer to.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Lot Distribution&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Maximum Lots Submitted&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Numeric&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Numeric. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "MaximumLotsSubmittedNumeric", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MaximumLotsSubmittedNumericType maximumLotsSubmittedNumeric;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Lot Distribution. Grouping Lots. Text&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;Description on how to combine lots when submitting a tender.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Lot Distribution&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Grouping Lots&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Text&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Text. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "GroupingLots", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<GroupingLotsType> groupingLots;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public LotDistributionType() {
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Lot Distribution. Maximum Lots Awarded. Numeric&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The maximum number of lots that can be awarded to a single tenderer.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Lot Distribution&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Maximum Lots Awarded&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Numeric&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Numeric. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link MaximumLotsAwardedNumericType }
     *     
     */
    @Nullable
    public MaximumLotsAwardedNumericType getMaximumLotsAwardedNumeric() {
        return maximumLotsAwardedNumeric;
    }

    /**
     * Sets the value of the maximumLotsAwardedNumeric property.
     * 
     * @param value
     *     allowed object is
     *     {@link MaximumLotsAwardedNumericType }
     *     
     * @see #getMaximumLotsAwardedNumeric()
     */
    public void setMaximumLotsAwardedNumeric(
        @Nullable
        MaximumLotsAwardedNumericType value) {
        this.maximumLotsAwardedNumeric = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Lot Distribution. Maximum Lots Submitted. Numeric&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The maximum number of lots to which a tenderer can submit an offer to.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Lot Distribution&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Maximum Lots Submitted&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Numeric&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Numeric. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link MaximumLotsSubmittedNumericType }
     *     
     */
    @Nullable
    public MaximumLotsSubmittedNumericType getMaximumLotsSubmittedNumeric() {
        return maximumLotsSubmittedNumeric;
    }

    /**
     * Sets the value of the maximumLotsSubmittedNumeric property.
     * 
     * @param value
     *     allowed object is
     *     {@link MaximumLotsSubmittedNumericType }
     *     
     * @see #getMaximumLotsSubmittedNumeric()
     */
    public void setMaximumLotsSubmittedNumeric(
        @Nullable
        MaximumLotsSubmittedNumericType value) {
        this.maximumLotsSubmittedNumeric = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Lot Distribution. Grouping Lots. Text&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;Description on how to combine lots when submitting a tender.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Lot Distribution&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Grouping Lots&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Text&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Text. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * Gets the value of the groupingLots property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the groupingLots property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getGroupingLots().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link GroupingLotsType }
     * </p>
     * 
     * 
     * @return
     *     The value of the groupingLots property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<GroupingLotsType> getGroupingLots() {
        if (groupingLots == null) {
            groupingLots = new ArrayList<>();
        }
        return this.groupingLots;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final LotDistributionType rhs = ((LotDistributionType) o);
        if (!EqualsHelper.equalsCollection(groupingLots, rhs.groupingLots)) {
            return false;
        }
        if (!EqualsHelper.equals(maximumLotsAwardedNumeric, rhs.maximumLotsAwardedNumeric)) {
            return false;
        }
        if (!EqualsHelper.equals(maximumLotsSubmittedNumeric, rhs.maximumLotsSubmittedNumeric)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(groupingLots).append(maximumLotsAwardedNumeric).append(maximumLotsSubmittedNumeric).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("groupingLots", groupingLots).append("maximumLotsAwardedNumeric", maximumLotsAwardedNumeric).append("maximumLotsSubmittedNumeric", maximumLotsSubmittedNumeric).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setGroupingLots(
        @Nullable
        final List<GroupingLotsType> aList) {
        groupingLots = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasGroupingLotsEntries() {
        return (!getGroupingLots().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoGroupingLotsEntries() {
        return getGroupingLots().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getGroupingLotsCount() {
        return getGroupingLots().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public GroupingLotsType getGroupingLotsAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getGroupingLots().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addGroupingLots(
        @Nonnull
        final GroupingLotsType elem) {
        getGroupingLots().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        LotDistributionType ret) {
        if (groupingLots == null) {
            ret.groupingLots = null;
        } else {
            List<GroupingLotsType> retGroupingLots = new ArrayList<>();
            for (GroupingLotsType aItem: getGroupingLots()) {
                retGroupingLots.add(((aItem == null)?null:aItem.clone()));
            }
            ret.groupingLots = retGroupingLots;
        }
        ret.maximumLotsAwardedNumeric = ((maximumLotsAwardedNumeric == null)?null:maximumLotsAwardedNumeric.clone());
        ret.maximumLotsSubmittedNumeric = ((maximumLotsSubmittedNumeric == null)?null:maximumLotsSubmittedNumeric.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public LotDistributionType clone() {
        LotDistributionType ret = new LotDistributionType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MaximumLotsAwardedNumericType and never <code>null</code>
     */
    @Nonnull
    public MaximumLotsAwardedNumericType setMaximumLotsAwardedNumeric(
        @Nullable
        final BigDecimal valueParam) {
        MaximumLotsAwardedNumericType aObj = getMaximumLotsAwardedNumeric();
        if (aObj == null) {
            aObj = new MaximumLotsAwardedNumericType(valueParam);
            setMaximumLotsAwardedNumeric(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MaximumLotsSubmittedNumericType and never <code>null</code>
     */
    @Nonnull
    public MaximumLotsSubmittedNumericType setMaximumLotsSubmittedNumeric(
        @Nullable
        final BigDecimal valueParam) {
        MaximumLotsSubmittedNumericType aObj = getMaximumLotsSubmittedNumeric();
        if (aObj == null) {
            aObj = new MaximumLotsSubmittedNumericType(valueParam);
            setMaximumLotsSubmittedNumeric(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained MaximumLotsAwardedNumericType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MaximumLotsAwardedNumericType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getMaximumLotsAwardedNumericValue() {
        MaximumLotsAwardedNumericType aObj = getMaximumLotsAwardedNumeric();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MaximumLotsSubmittedNumericType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MaximumLotsSubmittedNumericType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getMaximumLotsSubmittedNumericValue() {
        MaximumLotsSubmittedNumericType aObj = getMaximumLotsSubmittedNumeric();
        return (aObj == null)?null:aObj.getValue();
    }

}
