
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.InitiatingPartyIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.PrivatePartyIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.PublicPartyIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.ServiceProviderPartyIndicatorType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ABIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Participant Party. Details&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A class to describe a participant party.&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;Participant Party&lt;/ccts:ObjectClass&gt;&lt;/ccts:Component&gt;
 * </pre>
 * 
 * <p>Java class for ParticipantPartyType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ParticipantPartyType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}InitiatingPartyIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PrivatePartyIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PublicPartyIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ServiceProviderPartyIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Party"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}LegalContact" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}TechnicalContact" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}SupportContact" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}CommercialContact" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ParticipantPartyType", propOrder = {
    "initiatingPartyIndicator",
    "privatePartyIndicator",
    "publicPartyIndicator",
    "serviceProviderPartyIndicator",
    "party",
    "legalContact",
    "technicalContact",
    "supportContact",
    "commercialContact"
})
@CodingStyleguideUnaware
public class ParticipantPartyType implements Serializable, IExplicitlyCloneable
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Participant Party. Initiating Party_ Indicator. Indicator&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;An indicator that this party is playing the role of the initiator within a transaction (true) or not (false).&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Participant Party&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Initiating Party&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Indicator&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Indicator&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Indicator. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "InitiatingPartyIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private InitiatingPartyIndicatorType initiatingPartyIndicator;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Participant Party. Private Party_ Indicator. Indicator&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;An indicator that this party is a private entity (true) or not (false).&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Participant Party&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Private Party&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Indicator&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Indicator&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Indicator. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "PrivatePartyIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PrivatePartyIndicatorType privatePartyIndicator;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Participant Party. Public Party_ Indicator. Indicator&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;An indicator that this party is a public (governmental) entity (true) or not (false).&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Participant Party&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Public Party&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Indicator&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Indicator&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Indicator. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "PublicPartyIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PublicPartyIndicatorType publicPartyIndicator;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Participant Party. Service Provider Party_ Indicator. Indicator&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;An indicator that this party is a service provider (true) or not (false).&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Participant Party&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Service Provider Party&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Indicator&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Indicator&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Indicator. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "ServiceProviderPartyIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ServiceProviderPartyIndicatorType serviceProviderPartyIndicator;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Participant Party. Party&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The participant party itself.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Participant Party&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Party&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Party&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Party&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "Party", required = true)
    private PartyType party;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Participant Party. Legal_ Contact. Contact&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A legal contact associated to this participant for sending legal notices.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Participant Party&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Legal&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Contact&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Contact&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Contact&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "LegalContact")
    private ContactType legalContact;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Participant Party. Technical_ Contact. Contact&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A technical contact associated to this participant.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Participant Party&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Technical&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Contact&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Contact&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Contact&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "TechnicalContact")
    private ContactType technicalContact;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Participant Party. Support_ Contact. Contact&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A support contact associated to this participant.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Participant Party&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Support&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Contact&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Contact&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Contact&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "SupportContact")
    private ContactType supportContact;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Participant Party. Commercial_ Contact. Contact&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A commercial contact associated to this participant.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Participant Party&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Commercial&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Contact&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Contact&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Contact&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "CommercialContact")
    private ContactType commercialContact;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public ParticipantPartyType() {
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Participant Party. Initiating Party_ Indicator. Indicator&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;An indicator that this party is playing the role of the initiator within a transaction (true) or not (false).&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Participant Party&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Initiating Party&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Indicator&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Indicator&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Indicator. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link InitiatingPartyIndicatorType }
     *     
     */
    @Nullable
    public InitiatingPartyIndicatorType getInitiatingPartyIndicator() {
        return initiatingPartyIndicator;
    }

    /**
     * Sets the value of the initiatingPartyIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link InitiatingPartyIndicatorType }
     *     
     * @see #getInitiatingPartyIndicator()
     */
    public void setInitiatingPartyIndicator(
        @Nullable
        InitiatingPartyIndicatorType value) {
        this.initiatingPartyIndicator = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Participant Party. Private Party_ Indicator. Indicator&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;An indicator that this party is a private entity (true) or not (false).&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Participant Party&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Private Party&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Indicator&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Indicator&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Indicator. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link PrivatePartyIndicatorType }
     *     
     */
    @Nullable
    public PrivatePartyIndicatorType getPrivatePartyIndicator() {
        return privatePartyIndicator;
    }

    /**
     * Sets the value of the privatePartyIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link PrivatePartyIndicatorType }
     *     
     * @see #getPrivatePartyIndicator()
     */
    public void setPrivatePartyIndicator(
        @Nullable
        PrivatePartyIndicatorType value) {
        this.privatePartyIndicator = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Participant Party. Public Party_ Indicator. Indicator&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;An indicator that this party is a public (governmental) entity (true) or not (false).&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Participant Party&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Public Party&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Indicator&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Indicator&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Indicator. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link PublicPartyIndicatorType }
     *     
     */
    @Nullable
    public PublicPartyIndicatorType getPublicPartyIndicator() {
        return publicPartyIndicator;
    }

    /**
     * Sets the value of the publicPartyIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link PublicPartyIndicatorType }
     *     
     * @see #getPublicPartyIndicator()
     */
    public void setPublicPartyIndicator(
        @Nullable
        PublicPartyIndicatorType value) {
        this.publicPartyIndicator = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Participant Party. Service Provider Party_ Indicator. Indicator&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;An indicator that this party is a service provider (true) or not (false).&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Participant Party&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Service Provider Party&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Indicator&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Indicator&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Indicator. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link ServiceProviderPartyIndicatorType }
     *     
     */
    @Nullable
    public ServiceProviderPartyIndicatorType getServiceProviderPartyIndicator() {
        return serviceProviderPartyIndicator;
    }

    /**
     * Sets the value of the serviceProviderPartyIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link ServiceProviderPartyIndicatorType }
     *     
     * @see #getServiceProviderPartyIndicator()
     */
    public void setServiceProviderPartyIndicator(
        @Nullable
        ServiceProviderPartyIndicatorType value) {
        this.serviceProviderPartyIndicator = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Participant Party. Party&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The participant party itself.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Participant Party&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Party&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Party&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Party&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getParty() {
        return party;
    }

    /**
     * Sets the value of the party property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     * @see #getParty()
     */
    public void setParty(
        @Nullable
        PartyType value) {
        this.party = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Participant Party. Legal_ Contact. Contact&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A legal contact associated to this participant for sending legal notices.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Participant Party&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Legal&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Contact&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Contact&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Contact&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link ContactType }
     *     
     */
    @Nullable
    public ContactType getLegalContact() {
        return legalContact;
    }

    /**
     * Sets the value of the legalContact property.
     * 
     * @param value
     *     allowed object is
     *     {@link ContactType }
     *     
     * @see #getLegalContact()
     */
    public void setLegalContact(
        @Nullable
        ContactType value) {
        this.legalContact = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Participant Party. Technical_ Contact. Contact&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A technical contact associated to this participant.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Participant Party&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Technical&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Contact&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Contact&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Contact&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link ContactType }
     *     
     */
    @Nullable
    public ContactType getTechnicalContact() {
        return technicalContact;
    }

    /**
     * Sets the value of the technicalContact property.
     * 
     * @param value
     *     allowed object is
     *     {@link ContactType }
     *     
     * @see #getTechnicalContact()
     */
    public void setTechnicalContact(
        @Nullable
        ContactType value) {
        this.technicalContact = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Participant Party. Support_ Contact. Contact&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A support contact associated to this participant.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Participant Party&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Support&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Contact&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Contact&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Contact&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link ContactType }
     *     
     */
    @Nullable
    public ContactType getSupportContact() {
        return supportContact;
    }

    /**
     * Sets the value of the supportContact property.
     * 
     * @param value
     *     allowed object is
     *     {@link ContactType }
     *     
     * @see #getSupportContact()
     */
    public void setSupportContact(
        @Nullable
        ContactType value) {
        this.supportContact = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Participant Party. Commercial_ Contact. Contact&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A commercial contact associated to this participant.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Participant Party&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Commercial&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Contact&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Contact&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Contact&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link ContactType }
     *     
     */
    @Nullable
    public ContactType getCommercialContact() {
        return commercialContact;
    }

    /**
     * Sets the value of the commercialContact property.
     * 
     * @param value
     *     allowed object is
     *     {@link ContactType }
     *     
     * @see #getCommercialContact()
     */
    public void setCommercialContact(
        @Nullable
        ContactType value) {
        this.commercialContact = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final ParticipantPartyType rhs = ((ParticipantPartyType) o);
        if (!EqualsHelper.equals(commercialContact, rhs.commercialContact)) {
            return false;
        }
        if (!EqualsHelper.equals(initiatingPartyIndicator, rhs.initiatingPartyIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(legalContact, rhs.legalContact)) {
            return false;
        }
        if (!EqualsHelper.equals(party, rhs.party)) {
            return false;
        }
        if (!EqualsHelper.equals(privatePartyIndicator, rhs.privatePartyIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(publicPartyIndicator, rhs.publicPartyIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(serviceProviderPartyIndicator, rhs.serviceProviderPartyIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(supportContact, rhs.supportContact)) {
            return false;
        }
        if (!EqualsHelper.equals(technicalContact, rhs.technicalContact)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(commercialContact).append(initiatingPartyIndicator).append(legalContact).append(party).append(privatePartyIndicator).append(publicPartyIndicator).append(serviceProviderPartyIndicator).append(supportContact).append(technicalContact).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("commercialContact", commercialContact).append("initiatingPartyIndicator", initiatingPartyIndicator).append("legalContact", legalContact).append("party", party).append("privatePartyIndicator", privatePartyIndicator).append("publicPartyIndicator", publicPartyIndicator).append("serviceProviderPartyIndicator", serviceProviderPartyIndicator).append("supportContact", supportContact).append("technicalContact", technicalContact).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        ParticipantPartyType ret) {
        ret.commercialContact = ((commercialContact == null)?null:commercialContact.clone());
        ret.initiatingPartyIndicator = ((initiatingPartyIndicator == null)?null:initiatingPartyIndicator.clone());
        ret.legalContact = ((legalContact == null)?null:legalContact.clone());
        ret.party = ((party == null)?null:party.clone());
        ret.privatePartyIndicator = ((privatePartyIndicator == null)?null:privatePartyIndicator.clone());
        ret.publicPartyIndicator = ((publicPartyIndicator == null)?null:publicPartyIndicator.clone());
        ret.serviceProviderPartyIndicator = ((serviceProviderPartyIndicator == null)?null:serviceProviderPartyIndicator.clone());
        ret.supportContact = ((supportContact == null)?null:supportContact.clone());
        ret.technicalContact = ((technicalContact == null)?null:technicalContact.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ParticipantPartyType clone() {
        ParticipantPartyType ret = new ParticipantPartyType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type InitiatingPartyIndicatorType and never <code>null</code>
     */
    @Nonnull
    public InitiatingPartyIndicatorType setInitiatingPartyIndicator(final boolean valueParam) {
        InitiatingPartyIndicatorType aObj = getInitiatingPartyIndicator();
        if (aObj == null) {
            aObj = new InitiatingPartyIndicatorType(valueParam);
            setInitiatingPartyIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type PrivatePartyIndicatorType and never <code>null</code>
     */
    @Nonnull
    public PrivatePartyIndicatorType setPrivatePartyIndicator(final boolean valueParam) {
        PrivatePartyIndicatorType aObj = getPrivatePartyIndicator();
        if (aObj == null) {
            aObj = new PrivatePartyIndicatorType(valueParam);
            setPrivatePartyIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type PublicPartyIndicatorType and never <code>null</code>
     */
    @Nonnull
    public PublicPartyIndicatorType setPublicPartyIndicator(final boolean valueParam) {
        PublicPartyIndicatorType aObj = getPublicPartyIndicator();
        if (aObj == null) {
            aObj = new PublicPartyIndicatorType(valueParam);
            setPublicPartyIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type ServiceProviderPartyIndicatorType and never <code>null</code>
     */
    @Nonnull
    public ServiceProviderPartyIndicatorType setServiceProviderPartyIndicator(final boolean valueParam) {
        ServiceProviderPartyIndicatorType aObj = getServiceProviderPartyIndicator();
        if (aObj == null) {
            aObj = new ServiceProviderPartyIndicatorType(valueParam);
            setServiceProviderPartyIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained InitiatingPartyIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained InitiatingPartyIndicatorType object or the passed nullValue
     */
    public boolean isInitiatingPartyIndicatorValue(final boolean nullValue) {
        InitiatingPartyIndicatorType aObj = getInitiatingPartyIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained PrivatePartyIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained PrivatePartyIndicatorType object or the passed nullValue
     */
    public boolean isPrivatePartyIndicatorValue(final boolean nullValue) {
        PrivatePartyIndicatorType aObj = getPrivatePartyIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained PublicPartyIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained PublicPartyIndicatorType object or the passed nullValue
     */
    public boolean isPublicPartyIndicatorValue(final boolean nullValue) {
        PublicPartyIndicatorType aObj = getPublicPartyIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained ServiceProviderPartyIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained ServiceProviderPartyIndicatorType object or the passed nullValue
     */
    public boolean isServiceProviderPartyIndicatorValue(final boolean nullValue) {
        ServiceProviderPartyIndicatorType aObj = getServiceProviderPartyIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

}
