
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.ElectronicCatalogueUsageIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.ElectronicInvoiceAcceptedIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.ElectronicOrderUsageIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.ElectronicPaymentUsageIndicatorType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ABIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Post Award Process. Details&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A class to describe a post award process. These processes following the agreement on a contract for supply of goods or services ( for example, after the awarding of a tender).&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;Post Award Process&lt;/ccts:ObjectClass&gt;&lt;/ccts:Component&gt;
 * </pre>
 * 
 * <p>Java class for PostAwardProcessType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="PostAwardProcessType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ElectronicCatalogueUsageIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ElectronicInvoiceAcceptedIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ElectronicOrderUsageIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ElectronicPaymentUsageIndicator" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PostAwardProcessType", propOrder = {
    "electronicCatalogueUsageIndicator",
    "electronicInvoiceAcceptedIndicator",
    "electronicOrderUsageIndicator",
    "electronicPaymentUsageIndicator"
})
@CodingStyleguideUnaware
public class PostAwardProcessType implements Serializable, IExplicitlyCloneable
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Post Award Process. Electronic Catalogue Usage. Indicator&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;An indicator to specify whether an electronic catalogue will be used during the post award phase.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Post Award Process&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Electronic Catalogue Usage&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Indicator&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Indicator. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "ElectronicCatalogueUsageIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ElectronicCatalogueUsageIndicatorType electronicCatalogueUsageIndicator;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Post Award Process. Electronic Invoice Accepted. Indicator&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;An indicator on whether the electronic invoice is allowed for this process.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Post Award Process&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Electronic Invoice Accepted&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Indicator&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Indicator. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "ElectronicInvoiceAcceptedIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ElectronicInvoiceAcceptedIndicatorType electronicInvoiceAcceptedIndicator;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Post Award Process. Electronic Order Usage. Indicator&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;An indicator on whether electronic ordering shall be used in the post award process.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Post Award Process&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Electronic Order Usage&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Indicator&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Indicator. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "ElectronicOrderUsageIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ElectronicOrderUsageIndicatorType electronicOrderUsageIndicator;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Post Award Process. Electronic Payment Usage. Indicator&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;An indicator on whether electronic payment shall be used in the post award process.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Post Award Process&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Electronic Payment Usage&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Indicator&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Indicator. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "ElectronicPaymentUsageIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<ElectronicPaymentUsageIndicatorType> electronicPaymentUsageIndicator;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public PostAwardProcessType() {
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Post Award Process. Electronic Catalogue Usage. Indicator&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;An indicator to specify whether an electronic catalogue will be used during the post award phase.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Post Award Process&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Electronic Catalogue Usage&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Indicator&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Indicator. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link ElectronicCatalogueUsageIndicatorType }
     *     
     */
    @Nullable
    public ElectronicCatalogueUsageIndicatorType getElectronicCatalogueUsageIndicator() {
        return electronicCatalogueUsageIndicator;
    }

    /**
     * Sets the value of the electronicCatalogueUsageIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link ElectronicCatalogueUsageIndicatorType }
     *     
     * @see #getElectronicCatalogueUsageIndicator()
     */
    public void setElectronicCatalogueUsageIndicator(
        @Nullable
        ElectronicCatalogueUsageIndicatorType value) {
        this.electronicCatalogueUsageIndicator = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Post Award Process. Electronic Invoice Accepted. Indicator&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;An indicator on whether the electronic invoice is allowed for this process.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Post Award Process&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Electronic Invoice Accepted&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Indicator&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Indicator. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link ElectronicInvoiceAcceptedIndicatorType }
     *     
     */
    @Nullable
    public ElectronicInvoiceAcceptedIndicatorType getElectronicInvoiceAcceptedIndicator() {
        return electronicInvoiceAcceptedIndicator;
    }

    /**
     * Sets the value of the electronicInvoiceAcceptedIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link ElectronicInvoiceAcceptedIndicatorType }
     *     
     * @see #getElectronicInvoiceAcceptedIndicator()
     */
    public void setElectronicInvoiceAcceptedIndicator(
        @Nullable
        ElectronicInvoiceAcceptedIndicatorType value) {
        this.electronicInvoiceAcceptedIndicator = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Post Award Process. Electronic Order Usage. Indicator&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;An indicator on whether electronic ordering shall be used in the post award process.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Post Award Process&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Electronic Order Usage&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Indicator&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Indicator. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link ElectronicOrderUsageIndicatorType }
     *     
     */
    @Nullable
    public ElectronicOrderUsageIndicatorType getElectronicOrderUsageIndicator() {
        return electronicOrderUsageIndicator;
    }

    /**
     * Sets the value of the electronicOrderUsageIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link ElectronicOrderUsageIndicatorType }
     *     
     * @see #getElectronicOrderUsageIndicator()
     */
    public void setElectronicOrderUsageIndicator(
        @Nullable
        ElectronicOrderUsageIndicatorType value) {
        this.electronicOrderUsageIndicator = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Post Award Process. Electronic Payment Usage. Indicator&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;An indicator on whether electronic payment shall be used in the post award process.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Post Award Process&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Electronic Payment Usage&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Indicator&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Indicator. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * Gets the value of the electronicPaymentUsageIndicator property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the electronicPaymentUsageIndicator property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getElectronicPaymentUsageIndicator().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ElectronicPaymentUsageIndicatorType }
     * </p>
     * 
     * 
     * @return
     *     The value of the electronicPaymentUsageIndicator property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ElectronicPaymentUsageIndicatorType> getElectronicPaymentUsageIndicator() {
        if (electronicPaymentUsageIndicator == null) {
            electronicPaymentUsageIndicator = new ArrayList<>();
        }
        return this.electronicPaymentUsageIndicator;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final PostAwardProcessType rhs = ((PostAwardProcessType) o);
        if (!EqualsHelper.equals(electronicCatalogueUsageIndicator, rhs.electronicCatalogueUsageIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(electronicInvoiceAcceptedIndicator, rhs.electronicInvoiceAcceptedIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(electronicOrderUsageIndicator, rhs.electronicOrderUsageIndicator)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(electronicPaymentUsageIndicator, rhs.electronicPaymentUsageIndicator)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(electronicCatalogueUsageIndicator).append(electronicInvoiceAcceptedIndicator).append(electronicOrderUsageIndicator).append(electronicPaymentUsageIndicator).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("electronicCatalogueUsageIndicator", electronicCatalogueUsageIndicator).append("electronicInvoiceAcceptedIndicator", electronicInvoiceAcceptedIndicator).append("electronicOrderUsageIndicator", electronicOrderUsageIndicator).append("electronicPaymentUsageIndicator", electronicPaymentUsageIndicator).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setElectronicPaymentUsageIndicator(
        @Nullable
        final List<ElectronicPaymentUsageIndicatorType> aList) {
        electronicPaymentUsageIndicator = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasElectronicPaymentUsageIndicatorEntries() {
        return (!getElectronicPaymentUsageIndicator().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoElectronicPaymentUsageIndicatorEntries() {
        return getElectronicPaymentUsageIndicator().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getElectronicPaymentUsageIndicatorCount() {
        return getElectronicPaymentUsageIndicator().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ElectronicPaymentUsageIndicatorType getElectronicPaymentUsageIndicatorAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getElectronicPaymentUsageIndicator().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addElectronicPaymentUsageIndicator(
        @Nonnull
        final ElectronicPaymentUsageIndicatorType elem) {
        getElectronicPaymentUsageIndicator().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        PostAwardProcessType ret) {
        ret.electronicCatalogueUsageIndicator = ((electronicCatalogueUsageIndicator == null)?null:electronicCatalogueUsageIndicator.clone());
        ret.electronicInvoiceAcceptedIndicator = ((electronicInvoiceAcceptedIndicator == null)?null:electronicInvoiceAcceptedIndicator.clone());
        ret.electronicOrderUsageIndicator = ((electronicOrderUsageIndicator == null)?null:electronicOrderUsageIndicator.clone());
        if (electronicPaymentUsageIndicator == null) {
            ret.electronicPaymentUsageIndicator = null;
        } else {
            List<ElectronicPaymentUsageIndicatorType> retElectronicPaymentUsageIndicator = new ArrayList<>();
            for (ElectronicPaymentUsageIndicatorType aItem: getElectronicPaymentUsageIndicator()) {
                retElectronicPaymentUsageIndicator.add(((aItem == null)?null:aItem.clone()));
            }
            ret.electronicPaymentUsageIndicator = retElectronicPaymentUsageIndicator;
        }
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public PostAwardProcessType clone() {
        PostAwardProcessType ret = new PostAwardProcessType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type ElectronicCatalogueUsageIndicatorType and never <code>null</code>
     */
    @Nonnull
    public ElectronicCatalogueUsageIndicatorType setElectronicCatalogueUsageIndicator(final boolean valueParam) {
        ElectronicCatalogueUsageIndicatorType aObj = getElectronicCatalogueUsageIndicator();
        if (aObj == null) {
            aObj = new ElectronicCatalogueUsageIndicatorType(valueParam);
            setElectronicCatalogueUsageIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type ElectronicInvoiceAcceptedIndicatorType and never <code>null</code>
     */
    @Nonnull
    public ElectronicInvoiceAcceptedIndicatorType setElectronicInvoiceAcceptedIndicator(final boolean valueParam) {
        ElectronicInvoiceAcceptedIndicatorType aObj = getElectronicInvoiceAcceptedIndicator();
        if (aObj == null) {
            aObj = new ElectronicInvoiceAcceptedIndicatorType(valueParam);
            setElectronicInvoiceAcceptedIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type ElectronicOrderUsageIndicatorType and never <code>null</code>
     */
    @Nonnull
    public ElectronicOrderUsageIndicatorType setElectronicOrderUsageIndicator(final boolean valueParam) {
        ElectronicOrderUsageIndicatorType aObj = getElectronicOrderUsageIndicator();
        if (aObj == null) {
            aObj = new ElectronicOrderUsageIndicatorType(valueParam);
            setElectronicOrderUsageIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained ElectronicCatalogueUsageIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained ElectronicCatalogueUsageIndicatorType object or the passed nullValue
     */
    public boolean isElectronicCatalogueUsageIndicatorValue(final boolean nullValue) {
        ElectronicCatalogueUsageIndicatorType aObj = getElectronicCatalogueUsageIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained ElectronicInvoiceAcceptedIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained ElectronicInvoiceAcceptedIndicatorType object or the passed nullValue
     */
    public boolean isElectronicInvoiceAcceptedIndicatorValue(final boolean nullValue) {
        ElectronicInvoiceAcceptedIndicatorType aObj = getElectronicInvoiceAcceptedIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained ElectronicOrderUsageIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained ElectronicOrderUsageIndicatorType object or the passed nullValue
     */
    public boolean isElectronicOrderUsageIndicatorValue(final boolean nullValue) {
        ElectronicOrderUsageIndicatorType aObj = getElectronicOrderUsageIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

}
