
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_22;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.datetime.XMLOffsetTime;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.FreightRateClassCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.NameType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.NominationDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.NominationTimeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.PriorityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.SequenceNumericType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.TariffClassCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.TransportServiceCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.TransportationServiceDescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_22.TransportationServiceDetailsURIType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ABIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Details&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A class to describe a transportation service.&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;/ccts:Component&gt;
 * </pre>
 * 
 * <p>Java class for TransportationServiceType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="TransportationServiceType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TransportServiceCode"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TariffClassCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Priority" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}FreightRateClassCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TransportationServiceDescription" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TransportationServiceDetailsURI" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}NominationDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}NominationTime" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Name" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}SequenceNumeric" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}TransportEquipment" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}SupportedTransportEquipment" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}UnsupportedTransportEquipment" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}CommodityClassification" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}SupportedCommodityClassification" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}UnsupportedCommodityClassification" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}TotalCapacityDimension" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ShipmentStage" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}TransportEvent" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ResponsibleTransportServiceProviderParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}EnvironmentalEmission" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}EstimatedDurationPeriod" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ScheduledServiceFrequency" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TransportationServiceType", propOrder = {
    "transportServiceCode",
    "tariffClassCode",
    "priority",
    "freightRateClassCode",
    "transportationServiceDescription",
    "transportationServiceDetailsURI",
    "nominationDate",
    "nominationTime",
    "name",
    "sequenceNumeric",
    "transportEquipment",
    "supportedTransportEquipment",
    "unsupportedTransportEquipment",
    "commodityClassification",
    "supportedCommodityClassification",
    "unsupportedCommodityClassification",
    "totalCapacityDimension",
    "shipmentStage",
    "transportEvent",
    "responsibleTransportServiceProviderParty",
    "environmentalEmission",
    "estimatedDurationPeriod",
    "scheduledServiceFrequency"
})
@CodingStyleguideUnaware
public class TransportationServiceType implements Serializable, IExplicitlyCloneable
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Transport Service Code. Code&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A code signifying the extent of this transportation service (e.g., door-to-door, port-to-port).&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Transport Service Code&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Code. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "TransportServiceCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private TransportServiceCodeType transportServiceCode;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Tariff Class Code. Code&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A code signifying the tariff class applicable to this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Tariff Class Code&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Code. Type&lt;/ccts:DataType&gt;&lt;ccts:AlternativeBusinessTerms&gt;Tariff Class Specifier&lt;/ccts:AlternativeBusinessTerms&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "TariffClassCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TariffClassCodeType tariffClassCode;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Priority. Text&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The priority of this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Priority&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Text&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Text. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "Priority", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PriorityType priority;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Freight Rate Class Code. Code&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A code signifying the rate class for freight in this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Freight Rate Class Code&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Code. Type&lt;/ccts:DataType&gt;&lt;ccts:AlternativeBusinessTerms&gt;Charge Basis&lt;/ccts:AlternativeBusinessTerms&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "FreightRateClassCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private FreightRateClassCodeType freightRateClassCode;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Transportation Service Description. Text&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;Text describing this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Transportation Service Description&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Text&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Text. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "TransportationServiceDescription", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<TransportationServiceDescriptionType> transportationServiceDescription;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Transportation Service Details URI. Identifier&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The Uniform Resource Identifier (URI) of a document providing additional details regarding this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Transportation Service Details URI&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Identifier&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Identifier. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "TransportationServiceDetailsURI", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TransportationServiceDetailsURIType transportationServiceDetailsURI;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Nomination Date. Date&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;In a transport contract, the deadline date by which this transportation service has to be booked. For example, if this service is scheduled for Wednesday 16 February 2011 at 10 a.m. CET, the nomination date might be Tuesday15 February 2011.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Nomination Date&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Date&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Date. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "NominationDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private NominationDateType nominationDate;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Nomination Time. Time&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;In a transport contract, the deadline time by which this transportation service has to be booked. For example, if this service is scheduled for Wednesday 16 February 2011 at 10 a.m. CET, the nomination date might be Tuesday15 February 2011 and the nomination time 4 p.m. at the latest.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Nomination Time&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Time&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Time. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "NominationTime", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private NominationTimeType nominationTime;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Name&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The name of this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Name&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Name&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Name. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "Name", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private NameType name;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Sequence. Numeric&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A number indicating the order of this transportation service in a sequence of transportation services.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Sequence&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Numeric&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Numeric. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "SequenceNumeric", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private SequenceNumericType sequenceNumeric;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Transport Equipment&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A piece of transport equipment used in this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Transport Equipment&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Transport Equipment&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Transport Equipment&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "TransportEquipment")
    private List<TransportEquipmentType> transportEquipment;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Supported_ Transport Equipment. Transport Equipment&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A piece of transport equipment supported in this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Supported&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Transport Equipment&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Transport Equipment&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Transport Equipment&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "SupportedTransportEquipment")
    private List<TransportEquipmentType> supportedTransportEquipment;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Unsupported_ Transport Equipment. Transport Equipment&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A piece of transport equipment that is not supported in this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Unsupported&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Transport Equipment&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Transport Equipment&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Transport Equipment&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "UnsupportedTransportEquipment")
    private List<TransportEquipmentType> unsupportedTransportEquipment;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Commodity Classification&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A classification of this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Commodity Classification&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Commodity Classification&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Commodity Classification&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "CommodityClassification")
    private List<CommodityClassificationType> commodityClassification;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Supported_ Commodity Classification. Commodity Classification&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A classification (e.g., general cargo) for commodities that can be handled in this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Supported&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Commodity Classification&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Commodity Classification&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Commodity Classification&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "SupportedCommodityClassification")
    private List<CommodityClassificationType> supportedCommodityClassification;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Unsupported_ Commodity Classification. Commodity Classification&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A classification for commodities that cannot be handled in this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Unsupported&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Commodity Classification&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Commodity Classification&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Commodity Classification&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "UnsupportedCommodityClassification")
    private List<CommodityClassificationType> unsupportedCommodityClassification;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Total Capacity_ Dimension. Dimension&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The total capacity or volume available in this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Total Capacity&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Dimension&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Dimension&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Dimension&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "TotalCapacityDimension")
    private DimensionType totalCapacityDimension;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Shipment Stage&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;One of the stages of shipment in this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Shipment Stage&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Shipment Stage&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Shipment Stage&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "ShipmentStage")
    private List<ShipmentStageType> shipmentStage;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Transport Event&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;One of the transport events taking place in this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Transport Event&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Transport Event&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Transport Event&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "TransportEvent")
    private List<TransportEventType> transportEvent;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Responsible Transport Service Provider_ Party. Party&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The transport service provider responsible for this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Responsible Transport Service Provider&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Party&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Party&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Party&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "ResponsibleTransportServiceProviderParty")
    private PartyType responsibleTransportServiceProviderParty;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Environmental Emission&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;An environmental emission resulting from this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Environmental Emission&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Environmental Emission&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Environmental Emission&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "EnvironmentalEmission")
    private List<EnvironmentalEmissionType> environmentalEmission;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Estimated Duration_ Period. Period&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The estimated duration of this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Estimated Duration&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Period&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Period&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Period&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "EstimatedDurationPeriod")
    private PeriodType estimatedDurationPeriod;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Scheduled_ Service Frequency. Service Frequency&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A class to specify which day of the week a transport service is operational.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Scheduled&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Service Frequency&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Service Frequency&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Service Frequency&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     */
    @XmlElement(name = "ScheduledServiceFrequency")
    private List<ServiceFrequencyType> scheduledServiceFrequency;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public TransportationServiceType() {
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Transport Service Code. Code&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A code signifying the extent of this transportation service (e.g., door-to-door, port-to-port).&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Transport Service Code&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Code. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link TransportServiceCodeType }
     *     
     */
    @Nullable
    public TransportServiceCodeType getTransportServiceCode() {
        return transportServiceCode;
    }

    /**
     * Sets the value of the transportServiceCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportServiceCodeType }
     *     
     * @see #getTransportServiceCode()
     */
    public void setTransportServiceCode(
        @Nullable
        TransportServiceCodeType value) {
        this.transportServiceCode = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Tariff Class Code. Code&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A code signifying the tariff class applicable to this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Tariff Class Code&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Code. Type&lt;/ccts:DataType&gt;&lt;ccts:AlternativeBusinessTerms&gt;Tariff Class Specifier&lt;/ccts:AlternativeBusinessTerms&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link TariffClassCodeType }
     *     
     */
    @Nullable
    public TariffClassCodeType getTariffClassCode() {
        return tariffClassCode;
    }

    /**
     * Sets the value of the tariffClassCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link TariffClassCodeType }
     *     
     * @see #getTariffClassCode()
     */
    public void setTariffClassCode(
        @Nullable
        TariffClassCodeType value) {
        this.tariffClassCode = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Priority. Text&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The priority of this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Priority&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Text&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Text. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link PriorityType }
     *     
     */
    @Nullable
    public PriorityType getPriority() {
        return priority;
    }

    /**
     * Sets the value of the priority property.
     * 
     * @param value
     *     allowed object is
     *     {@link PriorityType }
     *     
     * @see #getPriority()
     */
    public void setPriority(
        @Nullable
        PriorityType value) {
        this.priority = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Freight Rate Class Code. Code&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A code signifying the rate class for freight in this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Freight Rate Class Code&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Code. Type&lt;/ccts:DataType&gt;&lt;ccts:AlternativeBusinessTerms&gt;Charge Basis&lt;/ccts:AlternativeBusinessTerms&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link FreightRateClassCodeType }
     *     
     */
    @Nullable
    public FreightRateClassCodeType getFreightRateClassCode() {
        return freightRateClassCode;
    }

    /**
     * Sets the value of the freightRateClassCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link FreightRateClassCodeType }
     *     
     * @see #getFreightRateClassCode()
     */
    public void setFreightRateClassCode(
        @Nullable
        FreightRateClassCodeType value) {
        this.freightRateClassCode = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Transportation Service Description. Text&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;Text describing this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Transportation Service Description&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Text&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Text. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * Gets the value of the transportationServiceDescription property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the transportationServiceDescription property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getTransportationServiceDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TransportationServiceDescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the transportationServiceDescription property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TransportationServiceDescriptionType> getTransportationServiceDescription() {
        if (transportationServiceDescription == null) {
            transportationServiceDescription = new ArrayList<>();
        }
        return this.transportationServiceDescription;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Transportation Service Details URI. Identifier&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The Uniform Resource Identifier (URI) of a document providing additional details regarding this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Transportation Service Details URI&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Identifier&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Identifier. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link TransportationServiceDetailsURIType }
     *     
     */
    @Nullable
    public TransportationServiceDetailsURIType getTransportationServiceDetailsURI() {
        return transportationServiceDetailsURI;
    }

    /**
     * Sets the value of the transportationServiceDetailsURI property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportationServiceDetailsURIType }
     *     
     * @see #getTransportationServiceDetailsURI()
     */
    public void setTransportationServiceDetailsURI(
        @Nullable
        TransportationServiceDetailsURIType value) {
        this.transportationServiceDetailsURI = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Nomination Date. Date&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;In a transport contract, the deadline date by which this transportation service has to be booked. For example, if this service is scheduled for Wednesday 16 February 2011 at 10 a.m. CET, the nomination date might be Tuesday15 February 2011.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Nomination Date&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Date&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Date. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link NominationDateType }
     *     
     */
    @Nullable
    public NominationDateType getNominationDate() {
        return nominationDate;
    }

    /**
     * Sets the value of the nominationDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link NominationDateType }
     *     
     * @see #getNominationDate()
     */
    public void setNominationDate(
        @Nullable
        NominationDateType value) {
        this.nominationDate = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Nomination Time. Time&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;In a transport contract, the deadline time by which this transportation service has to be booked. For example, if this service is scheduled for Wednesday 16 February 2011 at 10 a.m. CET, the nomination date might be Tuesday15 February 2011 and the nomination time 4 p.m. at the latest.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Nomination Time&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Time&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Time. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link NominationTimeType }
     *     
     */
    @Nullable
    public NominationTimeType getNominationTime() {
        return nominationTime;
    }

    /**
     * Sets the value of the nominationTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link NominationTimeType }
     *     
     * @see #getNominationTime()
     */
    public void setNominationTime(
        @Nullable
        NominationTimeType value) {
        this.nominationTime = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Name&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The name of this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Name&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Name&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Name. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link NameType }
     *     
     */
    @Nullable
    public NameType getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link NameType }
     *     
     * @see #getName()
     */
    public void setName(
        @Nullable
        NameType value) {
        this.name = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Sequence. Numeric&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A number indicating the order of this transportation service in a sequence of transportation services.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Sequence&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Numeric&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Numeric. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link SequenceNumericType }
     *     
     */
    @Nullable
    public SequenceNumericType getSequenceNumeric() {
        return sequenceNumeric;
    }

    /**
     * Sets the value of the sequenceNumeric property.
     * 
     * @param value
     *     allowed object is
     *     {@link SequenceNumericType }
     *     
     * @see #getSequenceNumeric()
     */
    public void setSequenceNumeric(
        @Nullable
        SequenceNumericType value) {
        this.sequenceNumeric = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Transport Equipment&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A piece of transport equipment used in this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Transport Equipment&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Transport Equipment&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Transport Equipment&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * Gets the value of the transportEquipment property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the transportEquipment property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getTransportEquipment().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TransportEquipmentType }
     * </p>
     * 
     * 
     * @return
     *     The value of the transportEquipment property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TransportEquipmentType> getTransportEquipment() {
        if (transportEquipment == null) {
            transportEquipment = new ArrayList<>();
        }
        return this.transportEquipment;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Supported_ Transport Equipment. Transport Equipment&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A piece of transport equipment supported in this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Supported&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Transport Equipment&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Transport Equipment&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Transport Equipment&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * Gets the value of the supportedTransportEquipment property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the supportedTransportEquipment property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getSupportedTransportEquipment().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TransportEquipmentType }
     * </p>
     * 
     * 
     * @return
     *     The value of the supportedTransportEquipment property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TransportEquipmentType> getSupportedTransportEquipment() {
        if (supportedTransportEquipment == null) {
            supportedTransportEquipment = new ArrayList<>();
        }
        return this.supportedTransportEquipment;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Unsupported_ Transport Equipment. Transport Equipment&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A piece of transport equipment that is not supported in this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Unsupported&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Transport Equipment&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Transport Equipment&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Transport Equipment&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * Gets the value of the unsupportedTransportEquipment property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the unsupportedTransportEquipment property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getUnsupportedTransportEquipment().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TransportEquipmentType }
     * </p>
     * 
     * 
     * @return
     *     The value of the unsupportedTransportEquipment property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TransportEquipmentType> getUnsupportedTransportEquipment() {
        if (unsupportedTransportEquipment == null) {
            unsupportedTransportEquipment = new ArrayList<>();
        }
        return this.unsupportedTransportEquipment;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Commodity Classification&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A classification of this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Commodity Classification&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Commodity Classification&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Commodity Classification&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * Gets the value of the commodityClassification property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the commodityClassification property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getCommodityClassification().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CommodityClassificationType }
     * </p>
     * 
     * 
     * @return
     *     The value of the commodityClassification property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CommodityClassificationType> getCommodityClassification() {
        if (commodityClassification == null) {
            commodityClassification = new ArrayList<>();
        }
        return this.commodityClassification;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Supported_ Commodity Classification. Commodity Classification&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A classification (e.g., general cargo) for commodities that can be handled in this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Supported&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Commodity Classification&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Commodity Classification&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Commodity Classification&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * Gets the value of the supportedCommodityClassification property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the supportedCommodityClassification property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getSupportedCommodityClassification().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CommodityClassificationType }
     * </p>
     * 
     * 
     * @return
     *     The value of the supportedCommodityClassification property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CommodityClassificationType> getSupportedCommodityClassification() {
        if (supportedCommodityClassification == null) {
            supportedCommodityClassification = new ArrayList<>();
        }
        return this.supportedCommodityClassification;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Unsupported_ Commodity Classification. Commodity Classification&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A classification for commodities that cannot be handled in this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Unsupported&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Commodity Classification&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Commodity Classification&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Commodity Classification&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * Gets the value of the unsupportedCommodityClassification property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the unsupportedCommodityClassification property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getUnsupportedCommodityClassification().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CommodityClassificationType }
     * </p>
     * 
     * 
     * @return
     *     The value of the unsupportedCommodityClassification property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CommodityClassificationType> getUnsupportedCommodityClassification() {
        if (unsupportedCommodityClassification == null) {
            unsupportedCommodityClassification = new ArrayList<>();
        }
        return this.unsupportedCommodityClassification;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Total Capacity_ Dimension. Dimension&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The total capacity or volume available in this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Total Capacity&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Dimension&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Dimension&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Dimension&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link DimensionType }
     *     
     */
    @Nullable
    public DimensionType getTotalCapacityDimension() {
        return totalCapacityDimension;
    }

    /**
     * Sets the value of the totalCapacityDimension property.
     * 
     * @param value
     *     allowed object is
     *     {@link DimensionType }
     *     
     * @see #getTotalCapacityDimension()
     */
    public void setTotalCapacityDimension(
        @Nullable
        DimensionType value) {
        this.totalCapacityDimension = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Shipment Stage&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;One of the stages of shipment in this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Shipment Stage&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Shipment Stage&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Shipment Stage&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * Gets the value of the shipmentStage property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the shipmentStage property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getShipmentStage().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ShipmentStageType }
     * </p>
     * 
     * 
     * @return
     *     The value of the shipmentStage property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ShipmentStageType> getShipmentStage() {
        if (shipmentStage == null) {
            shipmentStage = new ArrayList<>();
        }
        return this.shipmentStage;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Transport Event&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;One of the transport events taking place in this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Transport Event&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Transport Event&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Transport Event&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * Gets the value of the transportEvent property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the transportEvent property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getTransportEvent().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TransportEventType }
     * </p>
     * 
     * 
     * @return
     *     The value of the transportEvent property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TransportEventType> getTransportEvent() {
        if (transportEvent == null) {
            transportEvent = new ArrayList<>();
        }
        return this.transportEvent;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Responsible Transport Service Provider_ Party. Party&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The transport service provider responsible for this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Responsible Transport Service Provider&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Party&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Party&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Party&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getResponsibleTransportServiceProviderParty() {
        return responsibleTransportServiceProviderParty;
    }

    /**
     * Sets the value of the responsibleTransportServiceProviderParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     * @see #getResponsibleTransportServiceProviderParty()
     */
    public void setResponsibleTransportServiceProviderParty(
        @Nullable
        PartyType value) {
        this.responsibleTransportServiceProviderParty = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Environmental Emission&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;An environmental emission resulting from this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Environmental Emission&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Environmental Emission&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Environmental Emission&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * Gets the value of the environmentalEmission property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the environmentalEmission property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getEnvironmentalEmission().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link EnvironmentalEmissionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the environmentalEmission property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<EnvironmentalEmissionType> getEnvironmentalEmission() {
        if (environmentalEmission == null) {
            environmentalEmission = new ArrayList<>();
        }
        return this.environmentalEmission;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Estimated Duration_ Period. Period&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The estimated duration of this transportation service.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Estimated Duration&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Period&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Period&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Period&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link PeriodType }
     *     
     */
    @Nullable
    public PeriodType getEstimatedDurationPeriod() {
        return estimatedDurationPeriod;
    }

    /**
     * Sets the value of the estimatedDurationPeriod property.
     * 
     * @param value
     *     allowed object is
     *     {@link PeriodType }
     *     
     * @see #getEstimatedDurationPeriod()
     */
    public void setEstimatedDurationPeriod(
        @Nullable
        PeriodType value) {
        this.estimatedDurationPeriod = value;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p293553_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:p51722_="https://jakarta.ee/xml/ns/jaxb" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Transportation Service. Scheduled_ Service Frequency. Service Frequency&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A class to specify which day of the week a transport service is operational.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Transportation Service&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Scheduled&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Service Frequency&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Service Frequency&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Service Frequency&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * Gets the value of the scheduledServiceFrequency property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the scheduledServiceFrequency property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getScheduledServiceFrequency().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ServiceFrequencyType }
     * </p>
     * 
     * 
     * @return
     *     The value of the scheduledServiceFrequency property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ServiceFrequencyType> getScheduledServiceFrequency() {
        if (scheduledServiceFrequency == null) {
            scheduledServiceFrequency = new ArrayList<>();
        }
        return this.scheduledServiceFrequency;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final TransportationServiceType rhs = ((TransportationServiceType) o);
        if (!EqualsHelper.equalsCollection(commodityClassification, rhs.commodityClassification)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(environmentalEmission, rhs.environmentalEmission)) {
            return false;
        }
        if (!EqualsHelper.equals(estimatedDurationPeriod, rhs.estimatedDurationPeriod)) {
            return false;
        }
        if (!EqualsHelper.equals(freightRateClassCode, rhs.freightRateClassCode)) {
            return false;
        }
        if (!EqualsHelper.equals(name, rhs.name)) {
            return false;
        }
        if (!EqualsHelper.equals(nominationDate, rhs.nominationDate)) {
            return false;
        }
        if (!EqualsHelper.equals(nominationTime, rhs.nominationTime)) {
            return false;
        }
        if (!EqualsHelper.equals(priority, rhs.priority)) {
            return false;
        }
        if (!EqualsHelper.equals(responsibleTransportServiceProviderParty, rhs.responsibleTransportServiceProviderParty)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(scheduledServiceFrequency, rhs.scheduledServiceFrequency)) {
            return false;
        }
        if (!EqualsHelper.equals(sequenceNumeric, rhs.sequenceNumeric)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(shipmentStage, rhs.shipmentStage)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(supportedCommodityClassification, rhs.supportedCommodityClassification)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(supportedTransportEquipment, rhs.supportedTransportEquipment)) {
            return false;
        }
        if (!EqualsHelper.equals(tariffClassCode, rhs.tariffClassCode)) {
            return false;
        }
        if (!EqualsHelper.equals(totalCapacityDimension, rhs.totalCapacityDimension)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(transportEquipment, rhs.transportEquipment)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(transportEvent, rhs.transportEvent)) {
            return false;
        }
        if (!EqualsHelper.equals(transportServiceCode, rhs.transportServiceCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(transportationServiceDescription, rhs.transportationServiceDescription)) {
            return false;
        }
        if (!EqualsHelper.equals(transportationServiceDetailsURI, rhs.transportationServiceDetailsURI)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(unsupportedCommodityClassification, rhs.unsupportedCommodityClassification)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(unsupportedTransportEquipment, rhs.unsupportedTransportEquipment)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(commodityClassification).append(environmentalEmission).append(estimatedDurationPeriod).append(freightRateClassCode).append(name).append(nominationDate).append(nominationTime).append(priority).append(responsibleTransportServiceProviderParty).append(scheduledServiceFrequency).append(sequenceNumeric).append(shipmentStage).append(supportedCommodityClassification).append(supportedTransportEquipment).append(tariffClassCode).append(totalCapacityDimension).append(transportEquipment).append(transportEvent).append(transportServiceCode).append(transportationServiceDescription).append(transportationServiceDetailsURI).append(unsupportedCommodityClassification).append(unsupportedTransportEquipment).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("commodityClassification", commodityClassification).append("environmentalEmission", environmentalEmission).append("estimatedDurationPeriod", estimatedDurationPeriod).append("freightRateClassCode", freightRateClassCode).append("name", name).append("nominationDate", nominationDate).append("nominationTime", nominationTime).append("priority", priority).append("responsibleTransportServiceProviderParty", responsibleTransportServiceProviderParty).append("scheduledServiceFrequency", scheduledServiceFrequency).append("sequenceNumeric", sequenceNumeric).append("shipmentStage", shipmentStage).append("supportedCommodityClassification", supportedCommodityClassification).append("supportedTransportEquipment", supportedTransportEquipment).append("tariffClassCode", tariffClassCode).append("totalCapacityDimension", totalCapacityDimension).append("transportEquipment", transportEquipment).append("transportEvent", transportEvent).append("transportServiceCode", transportServiceCode).append("transportationServiceDescription", transportationServiceDescription).append("transportationServiceDetailsURI", transportationServiceDetailsURI).append("unsupportedCommodityClassification", unsupportedCommodityClassification).append("unsupportedTransportEquipment", unsupportedTransportEquipment).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTransportationServiceDescription(
        @Nullable
        final List<TransportationServiceDescriptionType> aList) {
        transportationServiceDescription = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTransportEquipment(
        @Nullable
        final List<TransportEquipmentType> aList) {
        transportEquipment = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSupportedTransportEquipment(
        @Nullable
        final List<TransportEquipmentType> aList) {
        supportedTransportEquipment = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setUnsupportedTransportEquipment(
        @Nullable
        final List<TransportEquipmentType> aList) {
        unsupportedTransportEquipment = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCommodityClassification(
        @Nullable
        final List<CommodityClassificationType> aList) {
        commodityClassification = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSupportedCommodityClassification(
        @Nullable
        final List<CommodityClassificationType> aList) {
        supportedCommodityClassification = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setUnsupportedCommodityClassification(
        @Nullable
        final List<CommodityClassificationType> aList) {
        unsupportedCommodityClassification = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setShipmentStage(
        @Nullable
        final List<ShipmentStageType> aList) {
        shipmentStage = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTransportEvent(
        @Nullable
        final List<TransportEventType> aList) {
        transportEvent = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setEnvironmentalEmission(
        @Nullable
        final List<EnvironmentalEmissionType> aList) {
        environmentalEmission = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setScheduledServiceFrequency(
        @Nullable
        final List<ServiceFrequencyType> aList) {
        scheduledServiceFrequency = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTransportationServiceDescriptionEntries() {
        return (!getTransportationServiceDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTransportationServiceDescriptionEntries() {
        return getTransportationServiceDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTransportationServiceDescriptionCount() {
        return getTransportationServiceDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TransportationServiceDescriptionType getTransportationServiceDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTransportationServiceDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTransportationServiceDescription(
        @Nonnull
        final TransportationServiceDescriptionType elem) {
        getTransportationServiceDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTransportEquipmentEntries() {
        return (!getTransportEquipment().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTransportEquipmentEntries() {
        return getTransportEquipment().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTransportEquipmentCount() {
        return getTransportEquipment().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TransportEquipmentType getTransportEquipmentAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTransportEquipment().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTransportEquipment(
        @Nonnull
        final TransportEquipmentType elem) {
        getTransportEquipment().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSupportedTransportEquipmentEntries() {
        return (!getSupportedTransportEquipment().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSupportedTransportEquipmentEntries() {
        return getSupportedTransportEquipment().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSupportedTransportEquipmentCount() {
        return getSupportedTransportEquipment().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TransportEquipmentType getSupportedTransportEquipmentAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSupportedTransportEquipment().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSupportedTransportEquipment(
        @Nonnull
        final TransportEquipmentType elem) {
        getSupportedTransportEquipment().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasUnsupportedTransportEquipmentEntries() {
        return (!getUnsupportedTransportEquipment().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoUnsupportedTransportEquipmentEntries() {
        return getUnsupportedTransportEquipment().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getUnsupportedTransportEquipmentCount() {
        return getUnsupportedTransportEquipment().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TransportEquipmentType getUnsupportedTransportEquipmentAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getUnsupportedTransportEquipment().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addUnsupportedTransportEquipment(
        @Nonnull
        final TransportEquipmentType elem) {
        getUnsupportedTransportEquipment().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCommodityClassificationEntries() {
        return (!getCommodityClassification().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCommodityClassificationEntries() {
        return getCommodityClassification().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCommodityClassificationCount() {
        return getCommodityClassification().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CommodityClassificationType getCommodityClassificationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCommodityClassification().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCommodityClassification(
        @Nonnull
        final CommodityClassificationType elem) {
        getCommodityClassification().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSupportedCommodityClassificationEntries() {
        return (!getSupportedCommodityClassification().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSupportedCommodityClassificationEntries() {
        return getSupportedCommodityClassification().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSupportedCommodityClassificationCount() {
        return getSupportedCommodityClassification().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CommodityClassificationType getSupportedCommodityClassificationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSupportedCommodityClassification().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSupportedCommodityClassification(
        @Nonnull
        final CommodityClassificationType elem) {
        getSupportedCommodityClassification().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasUnsupportedCommodityClassificationEntries() {
        return (!getUnsupportedCommodityClassification().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoUnsupportedCommodityClassificationEntries() {
        return getUnsupportedCommodityClassification().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getUnsupportedCommodityClassificationCount() {
        return getUnsupportedCommodityClassification().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CommodityClassificationType getUnsupportedCommodityClassificationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getUnsupportedCommodityClassification().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addUnsupportedCommodityClassification(
        @Nonnull
        final CommodityClassificationType elem) {
        getUnsupportedCommodityClassification().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasShipmentStageEntries() {
        return (!getShipmentStage().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoShipmentStageEntries() {
        return getShipmentStage().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getShipmentStageCount() {
        return getShipmentStage().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ShipmentStageType getShipmentStageAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getShipmentStage().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addShipmentStage(
        @Nonnull
        final ShipmentStageType elem) {
        getShipmentStage().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTransportEventEntries() {
        return (!getTransportEvent().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTransportEventEntries() {
        return getTransportEvent().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTransportEventCount() {
        return getTransportEvent().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TransportEventType getTransportEventAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTransportEvent().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTransportEvent(
        @Nonnull
        final TransportEventType elem) {
        getTransportEvent().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasEnvironmentalEmissionEntries() {
        return (!getEnvironmentalEmission().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoEnvironmentalEmissionEntries() {
        return getEnvironmentalEmission().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getEnvironmentalEmissionCount() {
        return getEnvironmentalEmission().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public EnvironmentalEmissionType getEnvironmentalEmissionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getEnvironmentalEmission().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addEnvironmentalEmission(
        @Nonnull
        final EnvironmentalEmissionType elem) {
        getEnvironmentalEmission().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasScheduledServiceFrequencyEntries() {
        return (!getScheduledServiceFrequency().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoScheduledServiceFrequencyEntries() {
        return getScheduledServiceFrequency().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getScheduledServiceFrequencyCount() {
        return getScheduledServiceFrequency().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ServiceFrequencyType getScheduledServiceFrequencyAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getScheduledServiceFrequency().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addScheduledServiceFrequency(
        @Nonnull
        final ServiceFrequencyType elem) {
        getScheduledServiceFrequency().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        TransportationServiceType ret) {
        if (commodityClassification == null) {
            ret.commodityClassification = null;
        } else {
            List<CommodityClassificationType> retCommodityClassification = new ArrayList<>();
            for (CommodityClassificationType aItem: getCommodityClassification()) {
                retCommodityClassification.add(((aItem == null)?null:aItem.clone()));
            }
            ret.commodityClassification = retCommodityClassification;
        }
        if (environmentalEmission == null) {
            ret.environmentalEmission = null;
        } else {
            List<EnvironmentalEmissionType> retEnvironmentalEmission = new ArrayList<>();
            for (EnvironmentalEmissionType aItem: getEnvironmentalEmission()) {
                retEnvironmentalEmission.add(((aItem == null)?null:aItem.clone()));
            }
            ret.environmentalEmission = retEnvironmentalEmission;
        }
        ret.estimatedDurationPeriod = ((estimatedDurationPeriod == null)?null:estimatedDurationPeriod.clone());
        ret.freightRateClassCode = ((freightRateClassCode == null)?null:freightRateClassCode.clone());
        ret.name = ((name == null)?null:name.clone());
        ret.nominationDate = ((nominationDate == null)?null:nominationDate.clone());
        ret.nominationTime = ((nominationTime == null)?null:nominationTime.clone());
        ret.priority = ((priority == null)?null:priority.clone());
        ret.responsibleTransportServiceProviderParty = ((responsibleTransportServiceProviderParty == null)?null:responsibleTransportServiceProviderParty.clone());
        if (scheduledServiceFrequency == null) {
            ret.scheduledServiceFrequency = null;
        } else {
            List<ServiceFrequencyType> retScheduledServiceFrequency = new ArrayList<>();
            for (ServiceFrequencyType aItem: getScheduledServiceFrequency()) {
                retScheduledServiceFrequency.add(((aItem == null)?null:aItem.clone()));
            }
            ret.scheduledServiceFrequency = retScheduledServiceFrequency;
        }
        ret.sequenceNumeric = ((sequenceNumeric == null)?null:sequenceNumeric.clone());
        if (shipmentStage == null) {
            ret.shipmentStage = null;
        } else {
            List<ShipmentStageType> retShipmentStage = new ArrayList<>();
            for (ShipmentStageType aItem: getShipmentStage()) {
                retShipmentStage.add(((aItem == null)?null:aItem.clone()));
            }
            ret.shipmentStage = retShipmentStage;
        }
        if (supportedCommodityClassification == null) {
            ret.supportedCommodityClassification = null;
        } else {
            List<CommodityClassificationType> retSupportedCommodityClassification = new ArrayList<>();
            for (CommodityClassificationType aItem: getSupportedCommodityClassification()) {
                retSupportedCommodityClassification.add(((aItem == null)?null:aItem.clone()));
            }
            ret.supportedCommodityClassification = retSupportedCommodityClassification;
        }
        if (supportedTransportEquipment == null) {
            ret.supportedTransportEquipment = null;
        } else {
            List<TransportEquipmentType> retSupportedTransportEquipment = new ArrayList<>();
            for (TransportEquipmentType aItem: getSupportedTransportEquipment()) {
                retSupportedTransportEquipment.add(((aItem == null)?null:aItem.clone()));
            }
            ret.supportedTransportEquipment = retSupportedTransportEquipment;
        }
        ret.tariffClassCode = ((tariffClassCode == null)?null:tariffClassCode.clone());
        ret.totalCapacityDimension = ((totalCapacityDimension == null)?null:totalCapacityDimension.clone());
        if (transportEquipment == null) {
            ret.transportEquipment = null;
        } else {
            List<TransportEquipmentType> retTransportEquipment = new ArrayList<>();
            for (TransportEquipmentType aItem: getTransportEquipment()) {
                retTransportEquipment.add(((aItem == null)?null:aItem.clone()));
            }
            ret.transportEquipment = retTransportEquipment;
        }
        if (transportEvent == null) {
            ret.transportEvent = null;
        } else {
            List<TransportEventType> retTransportEvent = new ArrayList<>();
            for (TransportEventType aItem: getTransportEvent()) {
                retTransportEvent.add(((aItem == null)?null:aItem.clone()));
            }
            ret.transportEvent = retTransportEvent;
        }
        ret.transportServiceCode = ((transportServiceCode == null)?null:transportServiceCode.clone());
        if (transportationServiceDescription == null) {
            ret.transportationServiceDescription = null;
        } else {
            List<TransportationServiceDescriptionType> retTransportationServiceDescription = new ArrayList<>();
            for (TransportationServiceDescriptionType aItem: getTransportationServiceDescription()) {
                retTransportationServiceDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.transportationServiceDescription = retTransportationServiceDescription;
        }
        ret.transportationServiceDetailsURI = ((transportationServiceDetailsURI == null)?null:transportationServiceDetailsURI.clone());
        if (unsupportedCommodityClassification == null) {
            ret.unsupportedCommodityClassification = null;
        } else {
            List<CommodityClassificationType> retUnsupportedCommodityClassification = new ArrayList<>();
            for (CommodityClassificationType aItem: getUnsupportedCommodityClassification()) {
                retUnsupportedCommodityClassification.add(((aItem == null)?null:aItem.clone()));
            }
            ret.unsupportedCommodityClassification = retUnsupportedCommodityClassification;
        }
        if (unsupportedTransportEquipment == null) {
            ret.unsupportedTransportEquipment = null;
        } else {
            List<TransportEquipmentType> retUnsupportedTransportEquipment = new ArrayList<>();
            for (TransportEquipmentType aItem: getUnsupportedTransportEquipment()) {
                retUnsupportedTransportEquipment.add(((aItem == null)?null:aItem.clone()));
            }
            ret.unsupportedTransportEquipment = retUnsupportedTransportEquipment;
        }
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public TransportationServiceType clone() {
        TransportationServiceType ret = new TransportationServiceType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TransportServiceCodeType and never <code>null</code>
     */
    @Nonnull
    public TransportServiceCodeType setTransportServiceCode(
        @Nullable
        final String valueParam) {
        TransportServiceCodeType aObj = getTransportServiceCode();
        if (aObj == null) {
            aObj = new TransportServiceCodeType(valueParam);
            setTransportServiceCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TariffClassCodeType and never <code>null</code>
     */
    @Nonnull
    public TariffClassCodeType setTariffClassCode(
        @Nullable
        final String valueParam) {
        TariffClassCodeType aObj = getTariffClassCode();
        if (aObj == null) {
            aObj = new TariffClassCodeType(valueParam);
            setTariffClassCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PriorityType and never <code>null</code>
     */
    @Nonnull
    public PriorityType setPriority(
        @Nullable
        final String valueParam) {
        PriorityType aObj = getPriority();
        if (aObj == null) {
            aObj = new PriorityType(valueParam);
            setPriority(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type FreightRateClassCodeType and never <code>null</code>
     */
    @Nonnull
    public FreightRateClassCodeType setFreightRateClassCode(
        @Nullable
        final String valueParam) {
        FreightRateClassCodeType aObj = getFreightRateClassCode();
        if (aObj == null) {
            aObj = new FreightRateClassCodeType(valueParam);
            setFreightRateClassCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TransportationServiceDetailsURIType and never <code>null</code>
     */
    @Nonnull
    public TransportationServiceDetailsURIType setTransportationServiceDetailsURI(
        @Nullable
        final String valueParam) {
        TransportationServiceDetailsURIType aObj = getTransportationServiceDetailsURI();
        if (aObj == null) {
            aObj = new TransportationServiceDetailsURIType(valueParam);
            setTransportationServiceDetailsURI(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NominationDateType and never <code>null</code>
     */
    @Nonnull
    public NominationDateType setNominationDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        NominationDateType aObj = getNominationDate();
        if (aObj == null) {
            aObj = new NominationDateType(valueParam);
            setNominationDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NominationDateType and never <code>null</code>
     */
    @Nonnull
    public NominationDateType setNominationDate(
        @Nullable
        final LocalDate valueParam) {
        NominationDateType aObj = getNominationDate();
        if (aObj == null) {
            aObj = new NominationDateType(valueParam);
            setNominationDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NominationTimeType and never <code>null</code>
     */
    @Nonnull
    public NominationTimeType setNominationTime(
        @Nullable
        final XMLOffsetTime valueParam) {
        NominationTimeType aObj = getNominationTime();
        if (aObj == null) {
            aObj = new NominationTimeType(valueParam);
            setNominationTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NominationTimeType and never <code>null</code>
     */
    @Nonnull
    public NominationTimeType setNominationTime(
        @Nullable
        final LocalTime valueParam) {
        NominationTimeType aObj = getNominationTime();
        if (aObj == null) {
            aObj = new NominationTimeType(valueParam);
            setNominationTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NameType and never <code>null</code>
     */
    @Nonnull
    public NameType setName(
        @Nullable
        final String valueParam) {
        NameType aObj = getName();
        if (aObj == null) {
            aObj = new NameType(valueParam);
            setName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SequenceNumericType and never <code>null</code>
     */
    @Nonnull
    public SequenceNumericType setSequenceNumeric(
        @Nullable
        final BigDecimal valueParam) {
        SequenceNumericType aObj = getSequenceNumeric();
        if (aObj == null) {
            aObj = new SequenceNumericType(valueParam);
            setSequenceNumeric(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained TransportServiceCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TransportServiceCodeType object or <code>null</code>
     */
    @Nullable
    public String getTransportServiceCodeValue() {
        TransportServiceCodeType aObj = getTransportServiceCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TariffClassCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TariffClassCodeType object or <code>null</code>
     */
    @Nullable
    public String getTariffClassCodeValue() {
        TariffClassCodeType aObj = getTariffClassCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PriorityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PriorityType object or <code>null</code>
     */
    @Nullable
    public String getPriorityValue() {
        PriorityType aObj = getPriority();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained FreightRateClassCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained FreightRateClassCodeType object or <code>null</code>
     */
    @Nullable
    public String getFreightRateClassCodeValue() {
        FreightRateClassCodeType aObj = getFreightRateClassCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TransportationServiceDetailsURIType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TransportationServiceDetailsURIType object or <code>null</code>
     */
    @Nullable
    public String getTransportationServiceDetailsURIValue() {
        TransportationServiceDetailsURIType aObj = getTransportationServiceDetailsURI();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained NominationDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NominationDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getNominationDateValue() {
        NominationDateType aObj = getNominationDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained NominationDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NominationDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getNominationDateValueLocal() {
        NominationDateType aObj = getNominationDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained NominationTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NominationTimeType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetTime getNominationTimeValue() {
        NominationTimeType aObj = getNominationTime();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained NominationTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NominationTimeType object or <code>null</code>
     */
    @Nullable
    public LocalTime getNominationTimeValueLocal() {
        NominationTimeType aObj = getNominationTime();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained NameType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NameType object or <code>null</code>
     */
    @Nullable
    public String getNameValue() {
        NameType aObj = getName();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained SequenceNumericType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SequenceNumericType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getSequenceNumericValue() {
        SequenceNumericType aObj = getSequenceNumeric();
        return (aObj == null)?null:aObj.getValue();
    }

}
