
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.BindingOnBuyerIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.FollowupContractIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.LowTendersDescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.NoFurtherNegotiationIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.PaymentDescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.PrizeDescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.PrizeIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TechnicalCommitteeDescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.WeightingAlgorithmCodeType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for AwardingTermsType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="AwardingTermsType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}WeightingAlgorithmCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Description" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TechnicalCommitteeDescription" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}LowTendersDescription" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PrizeIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PrizeDescription" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PaymentDescription" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}FollowupContractIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}BindingOnBuyerIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}NoFurtherNegotiationIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}AwardingCriterion" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}TechnicalCommitteePerson" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Prize" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "AwardingTermsType", propOrder = {
    "ublExtensions",
    "weightingAlgorithmCode",
    "description",
    "technicalCommitteeDescription",
    "lowTendersDescription",
    "prizeIndicator",
    "prizeDescription",
    "paymentDescription",
    "followupContractIndicator",
    "bindingOnBuyerIndicator",
    "noFurtherNegotiationIndicator",
    "awardingCriterion",
    "technicalCommitteePerson",
    "prize"
})
@CodingStyleguideUnaware
public class AwardingTermsType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "WeightingAlgorithmCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private WeightingAlgorithmCodeType weightingAlgorithmCode;
    @XmlElement(name = "Description", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<DescriptionType> description;
    @XmlElement(name = "TechnicalCommitteeDescription", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<TechnicalCommitteeDescriptionType> technicalCommitteeDescription;
    @XmlElement(name = "LowTendersDescription", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<LowTendersDescriptionType> lowTendersDescription;
    @XmlElement(name = "PrizeIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PrizeIndicatorType prizeIndicator;
    @XmlElement(name = "PrizeDescription", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<PrizeDescriptionType> prizeDescription;
    @XmlElement(name = "PaymentDescription", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<PaymentDescriptionType> paymentDescription;
    @XmlElement(name = "FollowupContractIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private FollowupContractIndicatorType followupContractIndicator;
    @XmlElement(name = "BindingOnBuyerIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private BindingOnBuyerIndicatorType bindingOnBuyerIndicator;
    @XmlElement(name = "NoFurtherNegotiationIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private NoFurtherNegotiationIndicatorType noFurtherNegotiationIndicator;
    @XmlElement(name = "AwardingCriterion")
    private List<AwardingCriterionType> awardingCriterion;
    @XmlElement(name = "TechnicalCommitteePerson")
    private List<PersonType> technicalCommitteePerson;
    @XmlElement(name = "Prize")
    private List<PrizeType> prize;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public AwardingTermsType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the weightingAlgorithmCode property.
     * 
     * @return
     *     possible object is
     *     {@link WeightingAlgorithmCodeType }
     *     
     */
    @Nullable
    public WeightingAlgorithmCodeType getWeightingAlgorithmCode() {
        return weightingAlgorithmCode;
    }

    /**
     * Sets the value of the weightingAlgorithmCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link WeightingAlgorithmCodeType }
     *     
     */
    public void setWeightingAlgorithmCode(
        @Nullable
        WeightingAlgorithmCodeType value) {
        this.weightingAlgorithmCode = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the description property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the description property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DescriptionType> getDescription() {
        if (description == null) {
            description = new ArrayList<>();
        }
        return this.description;
    }

    /**
     * Gets the value of the technicalCommitteeDescription property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the technicalCommitteeDescription property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getTechnicalCommitteeDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TechnicalCommitteeDescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the technicalCommitteeDescription property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TechnicalCommitteeDescriptionType> getTechnicalCommitteeDescription() {
        if (technicalCommitteeDescription == null) {
            technicalCommitteeDescription = new ArrayList<>();
        }
        return this.technicalCommitteeDescription;
    }

    /**
     * Gets the value of the lowTendersDescription property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the lowTendersDescription property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getLowTendersDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LowTendersDescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the lowTendersDescription property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<LowTendersDescriptionType> getLowTendersDescription() {
        if (lowTendersDescription == null) {
            lowTendersDescription = new ArrayList<>();
        }
        return this.lowTendersDescription;
    }

    /**
     * Gets the value of the prizeIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link PrizeIndicatorType }
     *     
     */
    @Nullable
    public PrizeIndicatorType getPrizeIndicator() {
        return prizeIndicator;
    }

    /**
     * Sets the value of the prizeIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link PrizeIndicatorType }
     *     
     */
    public void setPrizeIndicator(
        @Nullable
        PrizeIndicatorType value) {
        this.prizeIndicator = value;
    }

    /**
     * Gets the value of the prizeDescription property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the prizeDescription property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPrizeDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PrizeDescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the prizeDescription property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PrizeDescriptionType> getPrizeDescription() {
        if (prizeDescription == null) {
            prizeDescription = new ArrayList<>();
        }
        return this.prizeDescription;
    }

    /**
     * Gets the value of the paymentDescription property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the paymentDescription property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPaymentDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PaymentDescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the paymentDescription property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PaymentDescriptionType> getPaymentDescription() {
        if (paymentDescription == null) {
            paymentDescription = new ArrayList<>();
        }
        return this.paymentDescription;
    }

    /**
     * Gets the value of the followupContractIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link FollowupContractIndicatorType }
     *     
     */
    @Nullable
    public FollowupContractIndicatorType getFollowupContractIndicator() {
        return followupContractIndicator;
    }

    /**
     * Sets the value of the followupContractIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link FollowupContractIndicatorType }
     *     
     */
    public void setFollowupContractIndicator(
        @Nullable
        FollowupContractIndicatorType value) {
        this.followupContractIndicator = value;
    }

    /**
     * Gets the value of the bindingOnBuyerIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link BindingOnBuyerIndicatorType }
     *     
     */
    @Nullable
    public BindingOnBuyerIndicatorType getBindingOnBuyerIndicator() {
        return bindingOnBuyerIndicator;
    }

    /**
     * Sets the value of the bindingOnBuyerIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link BindingOnBuyerIndicatorType }
     *     
     */
    public void setBindingOnBuyerIndicator(
        @Nullable
        BindingOnBuyerIndicatorType value) {
        this.bindingOnBuyerIndicator = value;
    }

    /**
     * Gets the value of the noFurtherNegotiationIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link NoFurtherNegotiationIndicatorType }
     *     
     */
    @Nullable
    public NoFurtherNegotiationIndicatorType getNoFurtherNegotiationIndicator() {
        return noFurtherNegotiationIndicator;
    }

    /**
     * Sets the value of the noFurtherNegotiationIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link NoFurtherNegotiationIndicatorType }
     *     
     */
    public void setNoFurtherNegotiationIndicator(
        @Nullable
        NoFurtherNegotiationIndicatorType value) {
        this.noFurtherNegotiationIndicator = value;
    }

    /**
     * Gets the value of the awardingCriterion property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the awardingCriterion property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getAwardingCriterion().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AwardingCriterionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the awardingCriterion property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AwardingCriterionType> getAwardingCriterion() {
        if (awardingCriterion == null) {
            awardingCriterion = new ArrayList<>();
        }
        return this.awardingCriterion;
    }

    /**
     * Gets the value of the technicalCommitteePerson property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the technicalCommitteePerson property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getTechnicalCommitteePerson().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PersonType }
     * </p>
     * 
     * 
     * @return
     *     The value of the technicalCommitteePerson property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PersonType> getTechnicalCommitteePerson() {
        if (technicalCommitteePerson == null) {
            technicalCommitteePerson = new ArrayList<>();
        }
        return this.technicalCommitteePerson;
    }

    /**
     * Gets the value of the prize property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the prize property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPrize().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PrizeType }
     * </p>
     * 
     * 
     * @return
     *     The value of the prize property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PrizeType> getPrize() {
        if (prize == null) {
            prize = new ArrayList<>();
        }
        return this.prize;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final AwardingTermsType rhs = ((AwardingTermsType) o);
        if (!EqualsHelper.equalsCollection(awardingCriterion, rhs.awardingCriterion)) {
            return false;
        }
        if (!EqualsHelper.equals(bindingOnBuyerIndicator, rhs.bindingOnBuyerIndicator)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equals(followupContractIndicator, rhs.followupContractIndicator)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(lowTendersDescription, rhs.lowTendersDescription)) {
            return false;
        }
        if (!EqualsHelper.equals(noFurtherNegotiationIndicator, rhs.noFurtherNegotiationIndicator)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(paymentDescription, rhs.paymentDescription)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(prize, rhs.prize)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(prizeDescription, rhs.prizeDescription)) {
            return false;
        }
        if (!EqualsHelper.equals(prizeIndicator, rhs.prizeIndicator)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(technicalCommitteeDescription, rhs.technicalCommitteeDescription)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(technicalCommitteePerson, rhs.technicalCommitteePerson)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        if (!EqualsHelper.equals(weightingAlgorithmCode, rhs.weightingAlgorithmCode)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(awardingCriterion).append(bindingOnBuyerIndicator).append(description).append(followupContractIndicator).append(lowTendersDescription).append(noFurtherNegotiationIndicator).append(paymentDescription).append(prize).append(prizeDescription).append(prizeIndicator).append(technicalCommitteeDescription).append(technicalCommitteePerson).append(ublExtensions).append(weightingAlgorithmCode).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("awardingCriterion", awardingCriterion).append("bindingOnBuyerIndicator", bindingOnBuyerIndicator).append("description", description).append("followupContractIndicator", followupContractIndicator).append("lowTendersDescription", lowTendersDescription).append("noFurtherNegotiationIndicator", noFurtherNegotiationIndicator).append("paymentDescription", paymentDescription).append("prize", prize).append("prizeDescription", prizeDescription).append("prizeIndicator", prizeIndicator).append("technicalCommitteeDescription", technicalCommitteeDescription).append("technicalCommitteePerson", technicalCommitteePerson).append("ublExtensions", ublExtensions).append("weightingAlgorithmCode", weightingAlgorithmCode).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDescription(
        @Nullable
        final List<DescriptionType> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTechnicalCommitteeDescription(
        @Nullable
        final List<TechnicalCommitteeDescriptionType> aList) {
        technicalCommitteeDescription = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setLowTendersDescription(
        @Nullable
        final List<LowTendersDescriptionType> aList) {
        lowTendersDescription = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPrizeDescription(
        @Nullable
        final List<PrizeDescriptionType> aList) {
        prizeDescription = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPaymentDescription(
        @Nullable
        final List<PaymentDescriptionType> aList) {
        paymentDescription = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAwardingCriterion(
        @Nullable
        final List<AwardingCriterionType> aList) {
        awardingCriterion = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTechnicalCommitteePerson(
        @Nullable
        final List<PersonType> aList) {
        technicalCommitteePerson = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPrize(
        @Nullable
        final List<PrizeType> aList) {
        prize = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DescriptionType getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDescription(
        @Nonnull
        final DescriptionType elem) {
        getDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTechnicalCommitteeDescriptionEntries() {
        return (!getTechnicalCommitteeDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTechnicalCommitteeDescriptionEntries() {
        return getTechnicalCommitteeDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTechnicalCommitteeDescriptionCount() {
        return getTechnicalCommitteeDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TechnicalCommitteeDescriptionType getTechnicalCommitteeDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTechnicalCommitteeDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTechnicalCommitteeDescription(
        @Nonnull
        final TechnicalCommitteeDescriptionType elem) {
        getTechnicalCommitteeDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasLowTendersDescriptionEntries() {
        return (!getLowTendersDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoLowTendersDescriptionEntries() {
        return getLowTendersDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getLowTendersDescriptionCount() {
        return getLowTendersDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public LowTendersDescriptionType getLowTendersDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getLowTendersDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addLowTendersDescription(
        @Nonnull
        final LowTendersDescriptionType elem) {
        getLowTendersDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPrizeDescriptionEntries() {
        return (!getPrizeDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPrizeDescriptionEntries() {
        return getPrizeDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPrizeDescriptionCount() {
        return getPrizeDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PrizeDescriptionType getPrizeDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPrizeDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPrizeDescription(
        @Nonnull
        final PrizeDescriptionType elem) {
        getPrizeDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPaymentDescriptionEntries() {
        return (!getPaymentDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPaymentDescriptionEntries() {
        return getPaymentDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPaymentDescriptionCount() {
        return getPaymentDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PaymentDescriptionType getPaymentDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPaymentDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPaymentDescription(
        @Nonnull
        final PaymentDescriptionType elem) {
        getPaymentDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAwardingCriterionEntries() {
        return (!getAwardingCriterion().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAwardingCriterionEntries() {
        return getAwardingCriterion().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAwardingCriterionCount() {
        return getAwardingCriterion().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AwardingCriterionType getAwardingCriterionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAwardingCriterion().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAwardingCriterion(
        @Nonnull
        final AwardingCriterionType elem) {
        getAwardingCriterion().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTechnicalCommitteePersonEntries() {
        return (!getTechnicalCommitteePerson().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTechnicalCommitteePersonEntries() {
        return getTechnicalCommitteePerson().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTechnicalCommitteePersonCount() {
        return getTechnicalCommitteePerson().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PersonType getTechnicalCommitteePersonAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTechnicalCommitteePerson().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTechnicalCommitteePerson(
        @Nonnull
        final PersonType elem) {
        getTechnicalCommitteePerson().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPrizeEntries() {
        return (!getPrize().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPrizeEntries() {
        return getPrize().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPrizeCount() {
        return getPrize().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PrizeType getPrizeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPrize().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPrize(
        @Nonnull
        final PrizeType elem) {
        getPrize().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        AwardingTermsType ret) {
        if (awardingCriterion == null) {
            ret.awardingCriterion = null;
        } else {
            List<AwardingCriterionType> retAwardingCriterion = new ArrayList<>();
            for (AwardingCriterionType aItem: getAwardingCriterion()) {
                retAwardingCriterion.add(((aItem == null)?null:aItem.clone()));
            }
            ret.awardingCriterion = retAwardingCriterion;
        }
        ret.bindingOnBuyerIndicator = ((bindingOnBuyerIndicator == null)?null:bindingOnBuyerIndicator.clone());
        if (description == null) {
            ret.description = null;
        } else {
            List<DescriptionType> retDescription = new ArrayList<>();
            for (DescriptionType aItem: getDescription()) {
                retDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.description = retDescription;
        }
        ret.followupContractIndicator = ((followupContractIndicator == null)?null:followupContractIndicator.clone());
        if (lowTendersDescription == null) {
            ret.lowTendersDescription = null;
        } else {
            List<LowTendersDescriptionType> retLowTendersDescription = new ArrayList<>();
            for (LowTendersDescriptionType aItem: getLowTendersDescription()) {
                retLowTendersDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.lowTendersDescription = retLowTendersDescription;
        }
        ret.noFurtherNegotiationIndicator = ((noFurtherNegotiationIndicator == null)?null:noFurtherNegotiationIndicator.clone());
        if (paymentDescription == null) {
            ret.paymentDescription = null;
        } else {
            List<PaymentDescriptionType> retPaymentDescription = new ArrayList<>();
            for (PaymentDescriptionType aItem: getPaymentDescription()) {
                retPaymentDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.paymentDescription = retPaymentDescription;
        }
        if (prize == null) {
            ret.prize = null;
        } else {
            List<PrizeType> retPrize = new ArrayList<>();
            for (PrizeType aItem: getPrize()) {
                retPrize.add(((aItem == null)?null:aItem.clone()));
            }
            ret.prize = retPrize;
        }
        if (prizeDescription == null) {
            ret.prizeDescription = null;
        } else {
            List<PrizeDescriptionType> retPrizeDescription = new ArrayList<>();
            for (PrizeDescriptionType aItem: getPrizeDescription()) {
                retPrizeDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.prizeDescription = retPrizeDescription;
        }
        ret.prizeIndicator = ((prizeIndicator == null)?null:prizeIndicator.clone());
        if (technicalCommitteeDescription == null) {
            ret.technicalCommitteeDescription = null;
        } else {
            List<TechnicalCommitteeDescriptionType> retTechnicalCommitteeDescription = new ArrayList<>();
            for (TechnicalCommitteeDescriptionType aItem: getTechnicalCommitteeDescription()) {
                retTechnicalCommitteeDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.technicalCommitteeDescription = retTechnicalCommitteeDescription;
        }
        if (technicalCommitteePerson == null) {
            ret.technicalCommitteePerson = null;
        } else {
            List<PersonType> retTechnicalCommitteePerson = new ArrayList<>();
            for (PersonType aItem: getTechnicalCommitteePerson()) {
                retTechnicalCommitteePerson.add(((aItem == null)?null:aItem.clone()));
            }
            ret.technicalCommitteePerson = retTechnicalCommitteePerson;
        }
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
        ret.weightingAlgorithmCode = ((weightingAlgorithmCode == null)?null:weightingAlgorithmCode.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public AwardingTermsType clone() {
        AwardingTermsType ret = new AwardingTermsType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type WeightingAlgorithmCodeType and never <code>null</code>
     */
    @Nonnull
    public WeightingAlgorithmCodeType setWeightingAlgorithmCode(
        @Nullable
        final String valueParam) {
        WeightingAlgorithmCodeType aObj = getWeightingAlgorithmCode();
        if (aObj == null) {
            aObj = new WeightingAlgorithmCodeType(valueParam);
            setWeightingAlgorithmCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type PrizeIndicatorType and never <code>null</code>
     */
    @Nonnull
    public PrizeIndicatorType setPrizeIndicator(final boolean valueParam) {
        PrizeIndicatorType aObj = getPrizeIndicator();
        if (aObj == null) {
            aObj = new PrizeIndicatorType(valueParam);
            setPrizeIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type FollowupContractIndicatorType and never <code>null</code>
     */
    @Nonnull
    public FollowupContractIndicatorType setFollowupContractIndicator(final boolean valueParam) {
        FollowupContractIndicatorType aObj = getFollowupContractIndicator();
        if (aObj == null) {
            aObj = new FollowupContractIndicatorType(valueParam);
            setFollowupContractIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type BindingOnBuyerIndicatorType and never <code>null</code>
     */
    @Nonnull
    public BindingOnBuyerIndicatorType setBindingOnBuyerIndicator(final boolean valueParam) {
        BindingOnBuyerIndicatorType aObj = getBindingOnBuyerIndicator();
        if (aObj == null) {
            aObj = new BindingOnBuyerIndicatorType(valueParam);
            setBindingOnBuyerIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type NoFurtherNegotiationIndicatorType and never <code>null</code>
     */
    @Nonnull
    public NoFurtherNegotiationIndicatorType setNoFurtherNegotiationIndicator(final boolean valueParam) {
        NoFurtherNegotiationIndicatorType aObj = getNoFurtherNegotiationIndicator();
        if (aObj == null) {
            aObj = new NoFurtherNegotiationIndicatorType(valueParam);
            setNoFurtherNegotiationIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained WeightingAlgorithmCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained WeightingAlgorithmCodeType object or <code>null</code>
     */
    @Nullable
    public String getWeightingAlgorithmCodeValue() {
        WeightingAlgorithmCodeType aObj = getWeightingAlgorithmCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PrizeIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained PrizeIndicatorType object or the passed nullValue
     */
    public boolean isPrizeIndicatorValue(final boolean nullValue) {
        PrizeIndicatorType aObj = getPrizeIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained FollowupContractIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained FollowupContractIndicatorType object or the passed nullValue
     */
    public boolean isFollowupContractIndicatorValue(final boolean nullValue) {
        FollowupContractIndicatorType aObj = getFollowupContractIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained BindingOnBuyerIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained BindingOnBuyerIndicatorType object or the passed nullValue
     */
    public boolean isBindingOnBuyerIndicatorValue(final boolean nullValue) {
        BindingOnBuyerIndicatorType aObj = getBindingOnBuyerIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained NoFurtherNegotiationIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained NoFurtherNegotiationIndicatorType object or the passed nullValue
     */
    public boolean isNoFurtherNegotiationIndicatorValue(final boolean nullValue) {
        NoFurtherNegotiationIndicatorType aObj = getNoFurtherNegotiationIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

}
