
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.IMOGuidelinesOnBoardIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ManagementPlanImplementedIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ManagementPlanOnBoardIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.NoControlActionsReasonType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.OtherControlActionsType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TanksExchangedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TanksInBallastQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TanksNotExchangedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TotalBallastTanksOnBoardQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TotalBallastWaterCapacityMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TotalBallastWaterOnBoardMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for BallastWaterSummaryType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="BallastWaterSummaryType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ManagementPlanOnBoardIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ManagementPlanImplementedIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}IMOGuidelinesOnBoardIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TotalBallastTanksOnBoardQuantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TanksInBallastQuantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TanksExchangedQuantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TanksNotExchangedQuantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TotalBallastWaterOnBoardMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TotalBallastWaterCapacityMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}OtherControlActions" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}NoControlActionsReason" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}UptakeBallastWaterTransaction" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ExchangeBallastWaterTransaction" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}DischargeBallastWaterTransaction" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ResponsibleOfficerPerson" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "BallastWaterSummaryType", propOrder = {
    "ublExtensions",
    "id",
    "managementPlanOnBoardIndicator",
    "managementPlanImplementedIndicator",
    "imoGuidelinesOnBoardIndicator",
    "totalBallastTanksOnBoardQuantity",
    "tanksInBallastQuantity",
    "tanksExchangedQuantity",
    "tanksNotExchangedQuantity",
    "totalBallastWaterOnBoardMeasure",
    "totalBallastWaterCapacityMeasure",
    "otherControlActions",
    "noControlActionsReason",
    "uptakeBallastWaterTransaction",
    "exchangeBallastWaterTransaction",
    "dischargeBallastWaterTransaction",
    "responsibleOfficerPerson"
})
@CodingStyleguideUnaware
public class BallastWaterSummaryType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IDType id;
    @XmlElement(name = "ManagementPlanOnBoardIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ManagementPlanOnBoardIndicatorType managementPlanOnBoardIndicator;
    @XmlElement(name = "ManagementPlanImplementedIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ManagementPlanImplementedIndicatorType managementPlanImplementedIndicator;
    @XmlElement(name = "IMOGuidelinesOnBoardIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IMOGuidelinesOnBoardIndicatorType imoGuidelinesOnBoardIndicator;
    @XmlElement(name = "TotalBallastTanksOnBoardQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TotalBallastTanksOnBoardQuantityType totalBallastTanksOnBoardQuantity;
    @XmlElement(name = "TanksInBallastQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TanksInBallastQuantityType tanksInBallastQuantity;
    @XmlElement(name = "TanksExchangedQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TanksExchangedQuantityType tanksExchangedQuantity;
    @XmlElement(name = "TanksNotExchangedQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TanksNotExchangedQuantityType tanksNotExchangedQuantity;
    @XmlElement(name = "TotalBallastWaterOnBoardMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TotalBallastWaterOnBoardMeasureType totalBallastWaterOnBoardMeasure;
    @XmlElement(name = "TotalBallastWaterCapacityMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TotalBallastWaterCapacityMeasureType totalBallastWaterCapacityMeasure;
    @XmlElement(name = "OtherControlActions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<OtherControlActionsType> otherControlActions;
    @XmlElement(name = "NoControlActionsReason", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<NoControlActionsReasonType> noControlActionsReason;
    @XmlElement(name = "UptakeBallastWaterTransaction")
    private List<BallastWaterTransactionType> uptakeBallastWaterTransaction;
    @XmlElement(name = "ExchangeBallastWaterTransaction")
    private List<BallastWaterTransactionType> exchangeBallastWaterTransaction;
    @XmlElement(name = "DischargeBallastWaterTransaction")
    private List<BallastWaterTransactionType> dischargeBallastWaterTransaction;
    @XmlElement(name = "ResponsibleOfficerPerson")
    private PersonType responsibleOfficerPerson;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public BallastWaterSummaryType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the managementPlanOnBoardIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link ManagementPlanOnBoardIndicatorType }
     *     
     */
    @Nullable
    public ManagementPlanOnBoardIndicatorType getManagementPlanOnBoardIndicator() {
        return managementPlanOnBoardIndicator;
    }

    /**
     * Sets the value of the managementPlanOnBoardIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link ManagementPlanOnBoardIndicatorType }
     *     
     */
    public void setManagementPlanOnBoardIndicator(
        @Nullable
        ManagementPlanOnBoardIndicatorType value) {
        this.managementPlanOnBoardIndicator = value;
    }

    /**
     * Gets the value of the managementPlanImplementedIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link ManagementPlanImplementedIndicatorType }
     *     
     */
    @Nullable
    public ManagementPlanImplementedIndicatorType getManagementPlanImplementedIndicator() {
        return managementPlanImplementedIndicator;
    }

    /**
     * Sets the value of the managementPlanImplementedIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link ManagementPlanImplementedIndicatorType }
     *     
     */
    public void setManagementPlanImplementedIndicator(
        @Nullable
        ManagementPlanImplementedIndicatorType value) {
        this.managementPlanImplementedIndicator = value;
    }

    /**
     * Gets the value of the imoGuidelinesOnBoardIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link IMOGuidelinesOnBoardIndicatorType }
     *     
     */
    @Nullable
    public IMOGuidelinesOnBoardIndicatorType getIMOGuidelinesOnBoardIndicator() {
        return imoGuidelinesOnBoardIndicator;
    }

    /**
     * Sets the value of the imoGuidelinesOnBoardIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link IMOGuidelinesOnBoardIndicatorType }
     *     
     */
    public void setIMOGuidelinesOnBoardIndicator(
        @Nullable
        IMOGuidelinesOnBoardIndicatorType value) {
        this.imoGuidelinesOnBoardIndicator = value;
    }

    /**
     * Gets the value of the totalBallastTanksOnBoardQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link TotalBallastTanksOnBoardQuantityType }
     *     
     */
    @Nullable
    public TotalBallastTanksOnBoardQuantityType getTotalBallastTanksOnBoardQuantity() {
        return totalBallastTanksOnBoardQuantity;
    }

    /**
     * Sets the value of the totalBallastTanksOnBoardQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link TotalBallastTanksOnBoardQuantityType }
     *     
     */
    public void setTotalBallastTanksOnBoardQuantity(
        @Nullable
        TotalBallastTanksOnBoardQuantityType value) {
        this.totalBallastTanksOnBoardQuantity = value;
    }

    /**
     * Gets the value of the tanksInBallastQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link TanksInBallastQuantityType }
     *     
     */
    @Nullable
    public TanksInBallastQuantityType getTanksInBallastQuantity() {
        return tanksInBallastQuantity;
    }

    /**
     * Sets the value of the tanksInBallastQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link TanksInBallastQuantityType }
     *     
     */
    public void setTanksInBallastQuantity(
        @Nullable
        TanksInBallastQuantityType value) {
        this.tanksInBallastQuantity = value;
    }

    /**
     * Gets the value of the tanksExchangedQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link TanksExchangedQuantityType }
     *     
     */
    @Nullable
    public TanksExchangedQuantityType getTanksExchangedQuantity() {
        return tanksExchangedQuantity;
    }

    /**
     * Sets the value of the tanksExchangedQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link TanksExchangedQuantityType }
     *     
     */
    public void setTanksExchangedQuantity(
        @Nullable
        TanksExchangedQuantityType value) {
        this.tanksExchangedQuantity = value;
    }

    /**
     * Gets the value of the tanksNotExchangedQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link TanksNotExchangedQuantityType }
     *     
     */
    @Nullable
    public TanksNotExchangedQuantityType getTanksNotExchangedQuantity() {
        return tanksNotExchangedQuantity;
    }

    /**
     * Sets the value of the tanksNotExchangedQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link TanksNotExchangedQuantityType }
     *     
     */
    public void setTanksNotExchangedQuantity(
        @Nullable
        TanksNotExchangedQuantityType value) {
        this.tanksNotExchangedQuantity = value;
    }

    /**
     * Gets the value of the totalBallastWaterOnBoardMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link TotalBallastWaterOnBoardMeasureType }
     *     
     */
    @Nullable
    public TotalBallastWaterOnBoardMeasureType getTotalBallastWaterOnBoardMeasure() {
        return totalBallastWaterOnBoardMeasure;
    }

    /**
     * Sets the value of the totalBallastWaterOnBoardMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link TotalBallastWaterOnBoardMeasureType }
     *     
     */
    public void setTotalBallastWaterOnBoardMeasure(
        @Nullable
        TotalBallastWaterOnBoardMeasureType value) {
        this.totalBallastWaterOnBoardMeasure = value;
    }

    /**
     * Gets the value of the totalBallastWaterCapacityMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link TotalBallastWaterCapacityMeasureType }
     *     
     */
    @Nullable
    public TotalBallastWaterCapacityMeasureType getTotalBallastWaterCapacityMeasure() {
        return totalBallastWaterCapacityMeasure;
    }

    /**
     * Sets the value of the totalBallastWaterCapacityMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link TotalBallastWaterCapacityMeasureType }
     *     
     */
    public void setTotalBallastWaterCapacityMeasure(
        @Nullable
        TotalBallastWaterCapacityMeasureType value) {
        this.totalBallastWaterCapacityMeasure = value;
    }

    /**
     * Gets the value of the otherControlActions property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the otherControlActions property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getOtherControlActions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link OtherControlActionsType }
     * </p>
     * 
     * 
     * @return
     *     The value of the otherControlActions property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<OtherControlActionsType> getOtherControlActions() {
        if (otherControlActions == null) {
            otherControlActions = new ArrayList<>();
        }
        return this.otherControlActions;
    }

    /**
     * Gets the value of the noControlActionsReason property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the noControlActionsReason property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getNoControlActionsReason().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NoControlActionsReasonType }
     * </p>
     * 
     * 
     * @return
     *     The value of the noControlActionsReason property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NoControlActionsReasonType> getNoControlActionsReason() {
        if (noControlActionsReason == null) {
            noControlActionsReason = new ArrayList<>();
        }
        return this.noControlActionsReason;
    }

    /**
     * Gets the value of the uptakeBallastWaterTransaction property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the uptakeBallastWaterTransaction property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getUptakeBallastWaterTransaction().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link BallastWaterTransactionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the uptakeBallastWaterTransaction property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<BallastWaterTransactionType> getUptakeBallastWaterTransaction() {
        if (uptakeBallastWaterTransaction == null) {
            uptakeBallastWaterTransaction = new ArrayList<>();
        }
        return this.uptakeBallastWaterTransaction;
    }

    /**
     * Gets the value of the exchangeBallastWaterTransaction property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the exchangeBallastWaterTransaction property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getExchangeBallastWaterTransaction().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link BallastWaterTransactionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the exchangeBallastWaterTransaction property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<BallastWaterTransactionType> getExchangeBallastWaterTransaction() {
        if (exchangeBallastWaterTransaction == null) {
            exchangeBallastWaterTransaction = new ArrayList<>();
        }
        return this.exchangeBallastWaterTransaction;
    }

    /**
     * Gets the value of the dischargeBallastWaterTransaction property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the dischargeBallastWaterTransaction property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDischargeBallastWaterTransaction().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link BallastWaterTransactionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the dischargeBallastWaterTransaction property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<BallastWaterTransactionType> getDischargeBallastWaterTransaction() {
        if (dischargeBallastWaterTransaction == null) {
            dischargeBallastWaterTransaction = new ArrayList<>();
        }
        return this.dischargeBallastWaterTransaction;
    }

    /**
     * Gets the value of the responsibleOfficerPerson property.
     * 
     * @return
     *     possible object is
     *     {@link PersonType }
     *     
     */
    @Nullable
    public PersonType getResponsibleOfficerPerson() {
        return responsibleOfficerPerson;
    }

    /**
     * Sets the value of the responsibleOfficerPerson property.
     * 
     * @param value
     *     allowed object is
     *     {@link PersonType }
     *     
     */
    public void setResponsibleOfficerPerson(
        @Nullable
        PersonType value) {
        this.responsibleOfficerPerson = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final BallastWaterSummaryType rhs = ((BallastWaterSummaryType) o);
        if (!EqualsHelper.equalsCollection(dischargeBallastWaterTransaction, rhs.dischargeBallastWaterTransaction)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(exchangeBallastWaterTransaction, rhs.exchangeBallastWaterTransaction)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(imoGuidelinesOnBoardIndicator, rhs.imoGuidelinesOnBoardIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(managementPlanImplementedIndicator, rhs.managementPlanImplementedIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(managementPlanOnBoardIndicator, rhs.managementPlanOnBoardIndicator)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(noControlActionsReason, rhs.noControlActionsReason)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(otherControlActions, rhs.otherControlActions)) {
            return false;
        }
        if (!EqualsHelper.equals(responsibleOfficerPerson, rhs.responsibleOfficerPerson)) {
            return false;
        }
        if (!EqualsHelper.equals(tanksExchangedQuantity, rhs.tanksExchangedQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(tanksInBallastQuantity, rhs.tanksInBallastQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(tanksNotExchangedQuantity, rhs.tanksNotExchangedQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(totalBallastTanksOnBoardQuantity, rhs.totalBallastTanksOnBoardQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(totalBallastWaterCapacityMeasure, rhs.totalBallastWaterCapacityMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(totalBallastWaterOnBoardMeasure, rhs.totalBallastWaterOnBoardMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(uptakeBallastWaterTransaction, rhs.uptakeBallastWaterTransaction)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(dischargeBallastWaterTransaction).append(exchangeBallastWaterTransaction).append(id).append(imoGuidelinesOnBoardIndicator).append(managementPlanImplementedIndicator).append(managementPlanOnBoardIndicator).append(noControlActionsReason).append(otherControlActions).append(responsibleOfficerPerson).append(tanksExchangedQuantity).append(tanksInBallastQuantity).append(tanksNotExchangedQuantity).append(totalBallastTanksOnBoardQuantity).append(totalBallastWaterCapacityMeasure).append(totalBallastWaterOnBoardMeasure).append(ublExtensions).append(uptakeBallastWaterTransaction).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("dischargeBallastWaterTransaction", dischargeBallastWaterTransaction).append("exchangeBallastWaterTransaction", exchangeBallastWaterTransaction).append("id", id).append("imoGuidelinesOnBoardIndicator", imoGuidelinesOnBoardIndicator).append("managementPlanImplementedIndicator", managementPlanImplementedIndicator).append("managementPlanOnBoardIndicator", managementPlanOnBoardIndicator).append("noControlActionsReason", noControlActionsReason).append("otherControlActions", otherControlActions).append("responsibleOfficerPerson", responsibleOfficerPerson).append("tanksExchangedQuantity", tanksExchangedQuantity).append("tanksInBallastQuantity", tanksInBallastQuantity).append("tanksNotExchangedQuantity", tanksNotExchangedQuantity).append("totalBallastTanksOnBoardQuantity", totalBallastTanksOnBoardQuantity).append("totalBallastWaterCapacityMeasure", totalBallastWaterCapacityMeasure).append("totalBallastWaterOnBoardMeasure", totalBallastWaterOnBoardMeasure).append("ublExtensions", ublExtensions).append("uptakeBallastWaterTransaction", uptakeBallastWaterTransaction).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setOtherControlActions(
        @Nullable
        final List<OtherControlActionsType> aList) {
        otherControlActions = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setNoControlActionsReason(
        @Nullable
        final List<NoControlActionsReasonType> aList) {
        noControlActionsReason = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setUptakeBallastWaterTransaction(
        @Nullable
        final List<BallastWaterTransactionType> aList) {
        uptakeBallastWaterTransaction = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setExchangeBallastWaterTransaction(
        @Nullable
        final List<BallastWaterTransactionType> aList) {
        exchangeBallastWaterTransaction = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDischargeBallastWaterTransaction(
        @Nullable
        final List<BallastWaterTransactionType> aList) {
        dischargeBallastWaterTransaction = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasOtherControlActionsEntries() {
        return (!getOtherControlActions().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoOtherControlActionsEntries() {
        return getOtherControlActions().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getOtherControlActionsCount() {
        return getOtherControlActions().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public OtherControlActionsType getOtherControlActionsAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getOtherControlActions().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addOtherControlActions(
        @Nonnull
        final OtherControlActionsType elem) {
        getOtherControlActions().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoControlActionsReasonEntries() {
        return (!getNoControlActionsReason().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoNoControlActionsReasonEntries() {
        return getNoControlActionsReason().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getNoControlActionsReasonCount() {
        return getNoControlActionsReason().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NoControlActionsReasonType getNoControlActionsReasonAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getNoControlActionsReason().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addNoControlActionsReason(
        @Nonnull
        final NoControlActionsReasonType elem) {
        getNoControlActionsReason().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasUptakeBallastWaterTransactionEntries() {
        return (!getUptakeBallastWaterTransaction().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoUptakeBallastWaterTransactionEntries() {
        return getUptakeBallastWaterTransaction().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getUptakeBallastWaterTransactionCount() {
        return getUptakeBallastWaterTransaction().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public BallastWaterTransactionType getUptakeBallastWaterTransactionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getUptakeBallastWaterTransaction().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addUptakeBallastWaterTransaction(
        @Nonnull
        final BallastWaterTransactionType elem) {
        getUptakeBallastWaterTransaction().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasExchangeBallastWaterTransactionEntries() {
        return (!getExchangeBallastWaterTransaction().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoExchangeBallastWaterTransactionEntries() {
        return getExchangeBallastWaterTransaction().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getExchangeBallastWaterTransactionCount() {
        return getExchangeBallastWaterTransaction().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public BallastWaterTransactionType getExchangeBallastWaterTransactionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getExchangeBallastWaterTransaction().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addExchangeBallastWaterTransaction(
        @Nonnull
        final BallastWaterTransactionType elem) {
        getExchangeBallastWaterTransaction().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDischargeBallastWaterTransactionEntries() {
        return (!getDischargeBallastWaterTransaction().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDischargeBallastWaterTransactionEntries() {
        return getDischargeBallastWaterTransaction().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDischargeBallastWaterTransactionCount() {
        return getDischargeBallastWaterTransaction().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public BallastWaterTransactionType getDischargeBallastWaterTransactionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDischargeBallastWaterTransaction().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDischargeBallastWaterTransaction(
        @Nonnull
        final BallastWaterTransactionType elem) {
        getDischargeBallastWaterTransaction().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        BallastWaterSummaryType ret) {
        if (dischargeBallastWaterTransaction == null) {
            ret.dischargeBallastWaterTransaction = null;
        } else {
            List<BallastWaterTransactionType> retDischargeBallastWaterTransaction = new ArrayList<>();
            for (BallastWaterTransactionType aItem: getDischargeBallastWaterTransaction()) {
                retDischargeBallastWaterTransaction.add(((aItem == null)?null:aItem.clone()));
            }
            ret.dischargeBallastWaterTransaction = retDischargeBallastWaterTransaction;
        }
        if (exchangeBallastWaterTransaction == null) {
            ret.exchangeBallastWaterTransaction = null;
        } else {
            List<BallastWaterTransactionType> retExchangeBallastWaterTransaction = new ArrayList<>();
            for (BallastWaterTransactionType aItem: getExchangeBallastWaterTransaction()) {
                retExchangeBallastWaterTransaction.add(((aItem == null)?null:aItem.clone()));
            }
            ret.exchangeBallastWaterTransaction = retExchangeBallastWaterTransaction;
        }
        ret.id = ((id == null)?null:id.clone());
        ret.imoGuidelinesOnBoardIndicator = ((imoGuidelinesOnBoardIndicator == null)?null:imoGuidelinesOnBoardIndicator.clone());
        ret.managementPlanImplementedIndicator = ((managementPlanImplementedIndicator == null)?null:managementPlanImplementedIndicator.clone());
        ret.managementPlanOnBoardIndicator = ((managementPlanOnBoardIndicator == null)?null:managementPlanOnBoardIndicator.clone());
        if (noControlActionsReason == null) {
            ret.noControlActionsReason = null;
        } else {
            List<NoControlActionsReasonType> retNoControlActionsReason = new ArrayList<>();
            for (NoControlActionsReasonType aItem: getNoControlActionsReason()) {
                retNoControlActionsReason.add(((aItem == null)?null:aItem.clone()));
            }
            ret.noControlActionsReason = retNoControlActionsReason;
        }
        if (otherControlActions == null) {
            ret.otherControlActions = null;
        } else {
            List<OtherControlActionsType> retOtherControlActions = new ArrayList<>();
            for (OtherControlActionsType aItem: getOtherControlActions()) {
                retOtherControlActions.add(((aItem == null)?null:aItem.clone()));
            }
            ret.otherControlActions = retOtherControlActions;
        }
        ret.responsibleOfficerPerson = ((responsibleOfficerPerson == null)?null:responsibleOfficerPerson.clone());
        ret.tanksExchangedQuantity = ((tanksExchangedQuantity == null)?null:tanksExchangedQuantity.clone());
        ret.tanksInBallastQuantity = ((tanksInBallastQuantity == null)?null:tanksInBallastQuantity.clone());
        ret.tanksNotExchangedQuantity = ((tanksNotExchangedQuantity == null)?null:tanksNotExchangedQuantity.clone());
        ret.totalBallastTanksOnBoardQuantity = ((totalBallastTanksOnBoardQuantity == null)?null:totalBallastTanksOnBoardQuantity.clone());
        ret.totalBallastWaterCapacityMeasure = ((totalBallastWaterCapacityMeasure == null)?null:totalBallastWaterCapacityMeasure.clone());
        ret.totalBallastWaterOnBoardMeasure = ((totalBallastWaterOnBoardMeasure == null)?null:totalBallastWaterOnBoardMeasure.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
        if (uptakeBallastWaterTransaction == null) {
            ret.uptakeBallastWaterTransaction = null;
        } else {
            List<BallastWaterTransactionType> retUptakeBallastWaterTransaction = new ArrayList<>();
            for (BallastWaterTransactionType aItem: getUptakeBallastWaterTransaction()) {
                retUptakeBallastWaterTransaction.add(((aItem == null)?null:aItem.clone()));
            }
            ret.uptakeBallastWaterTransaction = retUptakeBallastWaterTransaction;
        }
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public BallastWaterSummaryType clone() {
        BallastWaterSummaryType ret = new BallastWaterSummaryType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type ManagementPlanOnBoardIndicatorType and never <code>null</code>
     */
    @Nonnull
    public ManagementPlanOnBoardIndicatorType setManagementPlanOnBoardIndicator(final boolean valueParam) {
        ManagementPlanOnBoardIndicatorType aObj = getManagementPlanOnBoardIndicator();
        if (aObj == null) {
            aObj = new ManagementPlanOnBoardIndicatorType(valueParam);
            setManagementPlanOnBoardIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type ManagementPlanImplementedIndicatorType and never <code>null</code>
     */
    @Nonnull
    public ManagementPlanImplementedIndicatorType setManagementPlanImplementedIndicator(final boolean valueParam) {
        ManagementPlanImplementedIndicatorType aObj = getManagementPlanImplementedIndicator();
        if (aObj == null) {
            aObj = new ManagementPlanImplementedIndicatorType(valueParam);
            setManagementPlanImplementedIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type IMOGuidelinesOnBoardIndicatorType and never <code>null</code>
     */
    @Nonnull
    public IMOGuidelinesOnBoardIndicatorType setIMOGuidelinesOnBoardIndicator(final boolean valueParam) {
        IMOGuidelinesOnBoardIndicatorType aObj = getIMOGuidelinesOnBoardIndicator();
        if (aObj == null) {
            aObj = new IMOGuidelinesOnBoardIndicatorType(valueParam);
            setIMOGuidelinesOnBoardIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TotalBallastTanksOnBoardQuantityType and never <code>null</code>
     */
    @Nonnull
    public TotalBallastTanksOnBoardQuantityType setTotalBallastTanksOnBoardQuantity(
        @Nullable
        final BigDecimal valueParam) {
        TotalBallastTanksOnBoardQuantityType aObj = getTotalBallastTanksOnBoardQuantity();
        if (aObj == null) {
            aObj = new TotalBallastTanksOnBoardQuantityType(valueParam);
            setTotalBallastTanksOnBoardQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TanksInBallastQuantityType and never <code>null</code>
     */
    @Nonnull
    public TanksInBallastQuantityType setTanksInBallastQuantity(
        @Nullable
        final BigDecimal valueParam) {
        TanksInBallastQuantityType aObj = getTanksInBallastQuantity();
        if (aObj == null) {
            aObj = new TanksInBallastQuantityType(valueParam);
            setTanksInBallastQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TanksExchangedQuantityType and never <code>null</code>
     */
    @Nonnull
    public TanksExchangedQuantityType setTanksExchangedQuantity(
        @Nullable
        final BigDecimal valueParam) {
        TanksExchangedQuantityType aObj = getTanksExchangedQuantity();
        if (aObj == null) {
            aObj = new TanksExchangedQuantityType(valueParam);
            setTanksExchangedQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TanksNotExchangedQuantityType and never <code>null</code>
     */
    @Nonnull
    public TanksNotExchangedQuantityType setTanksNotExchangedQuantity(
        @Nullable
        final BigDecimal valueParam) {
        TanksNotExchangedQuantityType aObj = getTanksNotExchangedQuantity();
        if (aObj == null) {
            aObj = new TanksNotExchangedQuantityType(valueParam);
            setTanksNotExchangedQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TotalBallastWaterOnBoardMeasureType and never <code>null</code>
     */
    @Nonnull
    public TotalBallastWaterOnBoardMeasureType setTotalBallastWaterOnBoardMeasure(
        @Nullable
        final BigDecimal valueParam) {
        TotalBallastWaterOnBoardMeasureType aObj = getTotalBallastWaterOnBoardMeasure();
        if (aObj == null) {
            aObj = new TotalBallastWaterOnBoardMeasureType(valueParam);
            setTotalBallastWaterOnBoardMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TotalBallastWaterCapacityMeasureType and never <code>null</code>
     */
    @Nonnull
    public TotalBallastWaterCapacityMeasureType setTotalBallastWaterCapacityMeasure(
        @Nullable
        final BigDecimal valueParam) {
        TotalBallastWaterCapacityMeasureType aObj = getTotalBallastWaterCapacityMeasure();
        if (aObj == null) {
            aObj = new TotalBallastWaterCapacityMeasureType(valueParam);
            setTotalBallastWaterCapacityMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ManagementPlanOnBoardIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained ManagementPlanOnBoardIndicatorType object or the passed nullValue
     */
    public boolean isManagementPlanOnBoardIndicatorValue(final boolean nullValue) {
        ManagementPlanOnBoardIndicatorType aObj = getManagementPlanOnBoardIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained ManagementPlanImplementedIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained ManagementPlanImplementedIndicatorType object or the passed nullValue
     */
    public boolean isManagementPlanImplementedIndicatorValue(final boolean nullValue) {
        ManagementPlanImplementedIndicatorType aObj = getManagementPlanImplementedIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained IMOGuidelinesOnBoardIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained IMOGuidelinesOnBoardIndicatorType object or the passed nullValue
     */
    public boolean isIMOGuidelinesOnBoardIndicatorValue(final boolean nullValue) {
        IMOGuidelinesOnBoardIndicatorType aObj = getIMOGuidelinesOnBoardIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained TotalBallastTanksOnBoardQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TotalBallastTanksOnBoardQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getTotalBallastTanksOnBoardQuantityValue() {
        TotalBallastTanksOnBoardQuantityType aObj = getTotalBallastTanksOnBoardQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TanksInBallastQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TanksInBallastQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getTanksInBallastQuantityValue() {
        TanksInBallastQuantityType aObj = getTanksInBallastQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TanksExchangedQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TanksExchangedQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getTanksExchangedQuantityValue() {
        TanksExchangedQuantityType aObj = getTanksExchangedQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TanksNotExchangedQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TanksNotExchangedQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getTanksNotExchangedQuantityValue() {
        TanksNotExchangedQuantityType aObj = getTanksNotExchangedQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TotalBallastWaterOnBoardMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TotalBallastWaterOnBoardMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getTotalBallastWaterOnBoardMeasureValue() {
        TotalBallastWaterOnBoardMeasureType aObj = getTotalBallastWaterOnBoardMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TotalBallastWaterCapacityMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TotalBallastWaterCapacityMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getTotalBallastWaterCapacityMeasureValue() {
        TotalBallastWaterCapacityMeasureType aObj = getTotalBallastWaterCapacityMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

}
