
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ExchangeMethodCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ExchangedPercentType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.SalinityMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.SeaHeightMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TankIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TankTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TransactionDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.VolumeMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for BallastWaterTransactionType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="BallastWaterTransactionType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TankID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TankTypeCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ExchangeMethodCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ExchangedPercent" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}VolumeMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}SeaHeightMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}SalinityMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TransactionDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Location" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}BallastWaterTemperature" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "BallastWaterTransactionType", propOrder = {
    "ublExtensions",
    "tankID",
    "tankTypeCode",
    "exchangeMethodCode",
    "exchangedPercent",
    "volumeMeasure",
    "seaHeightMeasure",
    "salinityMeasure",
    "transactionDate",
    "location",
    "ballastWaterTemperature"
})
@CodingStyleguideUnaware
public class BallastWaterTransactionType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "TankID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TankIDType tankID;
    @XmlElement(name = "TankTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TankTypeCodeType tankTypeCode;
    @XmlElement(name = "ExchangeMethodCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ExchangeMethodCodeType exchangeMethodCode;
    @XmlElement(name = "ExchangedPercent", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ExchangedPercentType exchangedPercent;
    @XmlElement(name = "VolumeMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private VolumeMeasureType volumeMeasure;
    @XmlElement(name = "SeaHeightMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private SeaHeightMeasureType seaHeightMeasure;
    @XmlElement(name = "SalinityMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private SalinityMeasureType salinityMeasure;
    @XmlElement(name = "TransactionDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TransactionDateType transactionDate;
    @XmlElement(name = "Location")
    private LocationType location;
    @XmlElement(name = "BallastWaterTemperature")
    private TemperatureType ballastWaterTemperature;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public BallastWaterTransactionType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the tankID property.
     * 
     * @return
     *     possible object is
     *     {@link TankIDType }
     *     
     */
    @Nullable
    public TankIDType getTankID() {
        return tankID;
    }

    /**
     * Sets the value of the tankID property.
     * 
     * @param value
     *     allowed object is
     *     {@link TankIDType }
     *     
     */
    public void setTankID(
        @Nullable
        TankIDType value) {
        this.tankID = value;
    }

    /**
     * Gets the value of the tankTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link TankTypeCodeType }
     *     
     */
    @Nullable
    public TankTypeCodeType getTankTypeCode() {
        return tankTypeCode;
    }

    /**
     * Sets the value of the tankTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link TankTypeCodeType }
     *     
     */
    public void setTankTypeCode(
        @Nullable
        TankTypeCodeType value) {
        this.tankTypeCode = value;
    }

    /**
     * Gets the value of the exchangeMethodCode property.
     * 
     * @return
     *     possible object is
     *     {@link ExchangeMethodCodeType }
     *     
     */
    @Nullable
    public ExchangeMethodCodeType getExchangeMethodCode() {
        return exchangeMethodCode;
    }

    /**
     * Sets the value of the exchangeMethodCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExchangeMethodCodeType }
     *     
     */
    public void setExchangeMethodCode(
        @Nullable
        ExchangeMethodCodeType value) {
        this.exchangeMethodCode = value;
    }

    /**
     * Gets the value of the exchangedPercent property.
     * 
     * @return
     *     possible object is
     *     {@link ExchangedPercentType }
     *     
     */
    @Nullable
    public ExchangedPercentType getExchangedPercent() {
        return exchangedPercent;
    }

    /**
     * Sets the value of the exchangedPercent property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExchangedPercentType }
     *     
     */
    public void setExchangedPercent(
        @Nullable
        ExchangedPercentType value) {
        this.exchangedPercent = value;
    }

    /**
     * Gets the value of the volumeMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link VolumeMeasureType }
     *     
     */
    @Nullable
    public VolumeMeasureType getVolumeMeasure() {
        return volumeMeasure;
    }

    /**
     * Sets the value of the volumeMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link VolumeMeasureType }
     *     
     */
    public void setVolumeMeasure(
        @Nullable
        VolumeMeasureType value) {
        this.volumeMeasure = value;
    }

    /**
     * Gets the value of the seaHeightMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link SeaHeightMeasureType }
     *     
     */
    @Nullable
    public SeaHeightMeasureType getSeaHeightMeasure() {
        return seaHeightMeasure;
    }

    /**
     * Sets the value of the seaHeightMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link SeaHeightMeasureType }
     *     
     */
    public void setSeaHeightMeasure(
        @Nullable
        SeaHeightMeasureType value) {
        this.seaHeightMeasure = value;
    }

    /**
     * Gets the value of the salinityMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link SalinityMeasureType }
     *     
     */
    @Nullable
    public SalinityMeasureType getSalinityMeasure() {
        return salinityMeasure;
    }

    /**
     * Sets the value of the salinityMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link SalinityMeasureType }
     *     
     */
    public void setSalinityMeasure(
        @Nullable
        SalinityMeasureType value) {
        this.salinityMeasure = value;
    }

    /**
     * Gets the value of the transactionDate property.
     * 
     * @return
     *     possible object is
     *     {@link TransactionDateType }
     *     
     */
    @Nullable
    public TransactionDateType getTransactionDate() {
        return transactionDate;
    }

    /**
     * Sets the value of the transactionDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransactionDateType }
     *     
     */
    public void setTransactionDate(
        @Nullable
        TransactionDateType value) {
        this.transactionDate = value;
    }

    /**
     * Gets the value of the location property.
     * 
     * @return
     *     possible object is
     *     {@link LocationType }
     *     
     */
    @Nullable
    public LocationType getLocation() {
        return location;
    }

    /**
     * Sets the value of the location property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocationType }
     *     
     */
    public void setLocation(
        @Nullable
        LocationType value) {
        this.location = value;
    }

    /**
     * Gets the value of the ballastWaterTemperature property.
     * 
     * @return
     *     possible object is
     *     {@link TemperatureType }
     *     
     */
    @Nullable
    public TemperatureType getBallastWaterTemperature() {
        return ballastWaterTemperature;
    }

    /**
     * Sets the value of the ballastWaterTemperature property.
     * 
     * @param value
     *     allowed object is
     *     {@link TemperatureType }
     *     
     */
    public void setBallastWaterTemperature(
        @Nullable
        TemperatureType value) {
        this.ballastWaterTemperature = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final BallastWaterTransactionType rhs = ((BallastWaterTransactionType) o);
        if (!EqualsHelper.equals(ballastWaterTemperature, rhs.ballastWaterTemperature)) {
            return false;
        }
        if (!EqualsHelper.equals(exchangeMethodCode, rhs.exchangeMethodCode)) {
            return false;
        }
        if (!EqualsHelper.equals(exchangedPercent, rhs.exchangedPercent)) {
            return false;
        }
        if (!EqualsHelper.equals(location, rhs.location)) {
            return false;
        }
        if (!EqualsHelper.equals(salinityMeasure, rhs.salinityMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(seaHeightMeasure, rhs.seaHeightMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(tankID, rhs.tankID)) {
            return false;
        }
        if (!EqualsHelper.equals(tankTypeCode, rhs.tankTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(transactionDate, rhs.transactionDate)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        if (!EqualsHelper.equals(volumeMeasure, rhs.volumeMeasure)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(ballastWaterTemperature).append(exchangeMethodCode).append(exchangedPercent).append(location).append(salinityMeasure).append(seaHeightMeasure).append(tankID).append(tankTypeCode).append(transactionDate).append(ublExtensions).append(volumeMeasure).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("ballastWaterTemperature", ballastWaterTemperature).append("exchangeMethodCode", exchangeMethodCode).append("exchangedPercent", exchangedPercent).append("location", location).append("salinityMeasure", salinityMeasure).append("seaHeightMeasure", seaHeightMeasure).append("tankID", tankID).append("tankTypeCode", tankTypeCode).append("transactionDate", transactionDate).append("ublExtensions", ublExtensions).append("volumeMeasure", volumeMeasure).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        BallastWaterTransactionType ret) {
        ret.ballastWaterTemperature = ((ballastWaterTemperature == null)?null:ballastWaterTemperature.clone());
        ret.exchangeMethodCode = ((exchangeMethodCode == null)?null:exchangeMethodCode.clone());
        ret.exchangedPercent = ((exchangedPercent == null)?null:exchangedPercent.clone());
        ret.location = ((location == null)?null:location.clone());
        ret.salinityMeasure = ((salinityMeasure == null)?null:salinityMeasure.clone());
        ret.seaHeightMeasure = ((seaHeightMeasure == null)?null:seaHeightMeasure.clone());
        ret.tankID = ((tankID == null)?null:tankID.clone());
        ret.tankTypeCode = ((tankTypeCode == null)?null:tankTypeCode.clone());
        ret.transactionDate = ((transactionDate == null)?null:transactionDate.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
        ret.volumeMeasure = ((volumeMeasure == null)?null:volumeMeasure.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public BallastWaterTransactionType clone() {
        BallastWaterTransactionType ret = new BallastWaterTransactionType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TankIDType and never <code>null</code>
     */
    @Nonnull
    public TankIDType setTankID(
        @Nullable
        final String valueParam) {
        TankIDType aObj = getTankID();
        if (aObj == null) {
            aObj = new TankIDType(valueParam);
            setTankID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TankTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public TankTypeCodeType setTankTypeCode(
        @Nullable
        final String valueParam) {
        TankTypeCodeType aObj = getTankTypeCode();
        if (aObj == null) {
            aObj = new TankTypeCodeType(valueParam);
            setTankTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ExchangeMethodCodeType and never <code>null</code>
     */
    @Nonnull
    public ExchangeMethodCodeType setExchangeMethodCode(
        @Nullable
        final String valueParam) {
        ExchangeMethodCodeType aObj = getExchangeMethodCode();
        if (aObj == null) {
            aObj = new ExchangeMethodCodeType(valueParam);
            setExchangeMethodCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ExchangedPercentType and never <code>null</code>
     */
    @Nonnull
    public ExchangedPercentType setExchangedPercent(
        @Nullable
        final BigDecimal valueParam) {
        ExchangedPercentType aObj = getExchangedPercent();
        if (aObj == null) {
            aObj = new ExchangedPercentType(valueParam);
            setExchangedPercent(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type VolumeMeasureType and never <code>null</code>
     */
    @Nonnull
    public VolumeMeasureType setVolumeMeasure(
        @Nullable
        final BigDecimal valueParam) {
        VolumeMeasureType aObj = getVolumeMeasure();
        if (aObj == null) {
            aObj = new VolumeMeasureType(valueParam);
            setVolumeMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SeaHeightMeasureType and never <code>null</code>
     */
    @Nonnull
    public SeaHeightMeasureType setSeaHeightMeasure(
        @Nullable
        final BigDecimal valueParam) {
        SeaHeightMeasureType aObj = getSeaHeightMeasure();
        if (aObj == null) {
            aObj = new SeaHeightMeasureType(valueParam);
            setSeaHeightMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SalinityMeasureType and never <code>null</code>
     */
    @Nonnull
    public SalinityMeasureType setSalinityMeasure(
        @Nullable
        final BigDecimal valueParam) {
        SalinityMeasureType aObj = getSalinityMeasure();
        if (aObj == null) {
            aObj = new SalinityMeasureType(valueParam);
            setSalinityMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TransactionDateType and never <code>null</code>
     */
    @Nonnull
    public TransactionDateType setTransactionDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        TransactionDateType aObj = getTransactionDate();
        if (aObj == null) {
            aObj = new TransactionDateType(valueParam);
            setTransactionDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TransactionDateType and never <code>null</code>
     */
    @Nonnull
    public TransactionDateType setTransactionDate(
        @Nullable
        final LocalDate valueParam) {
        TransactionDateType aObj = getTransactionDate();
        if (aObj == null) {
            aObj = new TransactionDateType(valueParam);
            setTransactionDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained TankIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TankIDType object or <code>null</code>
     */
    @Nullable
    public String getTankIDValue() {
        TankIDType aObj = getTankID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TankTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TankTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getTankTypeCodeValue() {
        TankTypeCodeType aObj = getTankTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ExchangeMethodCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ExchangeMethodCodeType object or <code>null</code>
     */
    @Nullable
    public String getExchangeMethodCodeValue() {
        ExchangeMethodCodeType aObj = getExchangeMethodCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ExchangedPercentType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ExchangedPercentType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getExchangedPercentValue() {
        ExchangedPercentType aObj = getExchangedPercent();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained VolumeMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained VolumeMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getVolumeMeasureValue() {
        VolumeMeasureType aObj = getVolumeMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained SeaHeightMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SeaHeightMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getSeaHeightMeasureValue() {
        SeaHeightMeasureType aObj = getSeaHeightMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained SalinityMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SalinityMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getSalinityMeasureValue() {
        SalinityMeasureType aObj = getSalinityMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TransactionDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TransactionDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getTransactionDateValue() {
        TransactionDateType aObj = getTransactionDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TransactionDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TransactionDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getTransactionDateValueLocal() {
        TransactionDateType aObj = getTransactionDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

}
