
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.AnnualAverageAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.PartyCapacityAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TotalTaskAmountType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for CompletedTaskType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="CompletedTaskType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}AnnualAverageAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TotalTaskAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PartyCapacityAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Description" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}EvidenceSupplied" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Period" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}RecipientCustomerParty" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CompletedTaskType", propOrder = {
    "ublExtensions",
    "annualAverageAmount",
    "totalTaskAmount",
    "partyCapacityAmount",
    "description",
    "evidenceSupplied",
    "period",
    "recipientCustomerParty"
})
@CodingStyleguideUnaware
public class CompletedTaskType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "AnnualAverageAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private AnnualAverageAmountType annualAverageAmount;
    @XmlElement(name = "TotalTaskAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TotalTaskAmountType totalTaskAmount;
    @XmlElement(name = "PartyCapacityAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PartyCapacityAmountType partyCapacityAmount;
    @XmlElement(name = "Description", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<DescriptionType> description;
    @XmlElement(name = "EvidenceSupplied")
    private List<EvidenceSuppliedType> evidenceSupplied;
    @XmlElement(name = "Period")
    private PeriodType period;
    @XmlElement(name = "RecipientCustomerParty")
    private CustomerPartyType recipientCustomerParty;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public CompletedTaskType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the annualAverageAmount property.
     * 
     * @return
     *     possible object is
     *     {@link AnnualAverageAmountType }
     *     
     */
    @Nullable
    public AnnualAverageAmountType getAnnualAverageAmount() {
        return annualAverageAmount;
    }

    /**
     * Sets the value of the annualAverageAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link AnnualAverageAmountType }
     *     
     */
    public void setAnnualAverageAmount(
        @Nullable
        AnnualAverageAmountType value) {
        this.annualAverageAmount = value;
    }

    /**
     * Gets the value of the totalTaskAmount property.
     * 
     * @return
     *     possible object is
     *     {@link TotalTaskAmountType }
     *     
     */
    @Nullable
    public TotalTaskAmountType getTotalTaskAmount() {
        return totalTaskAmount;
    }

    /**
     * Sets the value of the totalTaskAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link TotalTaskAmountType }
     *     
     */
    public void setTotalTaskAmount(
        @Nullable
        TotalTaskAmountType value) {
        this.totalTaskAmount = value;
    }

    /**
     * Gets the value of the partyCapacityAmount property.
     * 
     * @return
     *     possible object is
     *     {@link PartyCapacityAmountType }
     *     
     */
    @Nullable
    public PartyCapacityAmountType getPartyCapacityAmount() {
        return partyCapacityAmount;
    }

    /**
     * Sets the value of the partyCapacityAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyCapacityAmountType }
     *     
     */
    public void setPartyCapacityAmount(
        @Nullable
        PartyCapacityAmountType value) {
        this.partyCapacityAmount = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the description property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the description property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DescriptionType> getDescription() {
        if (description == null) {
            description = new ArrayList<>();
        }
        return this.description;
    }

    /**
     * Gets the value of the evidenceSupplied property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the evidenceSupplied property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getEvidenceSupplied().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link EvidenceSuppliedType }
     * </p>
     * 
     * 
     * @return
     *     The value of the evidenceSupplied property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<EvidenceSuppliedType> getEvidenceSupplied() {
        if (evidenceSupplied == null) {
            evidenceSupplied = new ArrayList<>();
        }
        return this.evidenceSupplied;
    }

    /**
     * Gets the value of the period property.
     * 
     * @return
     *     possible object is
     *     {@link PeriodType }
     *     
     */
    @Nullable
    public PeriodType getPeriod() {
        return period;
    }

    /**
     * Sets the value of the period property.
     * 
     * @param value
     *     allowed object is
     *     {@link PeriodType }
     *     
     */
    public void setPeriod(
        @Nullable
        PeriodType value) {
        this.period = value;
    }

    /**
     * Gets the value of the recipientCustomerParty property.
     * 
     * @return
     *     possible object is
     *     {@link CustomerPartyType }
     *     
     */
    @Nullable
    public CustomerPartyType getRecipientCustomerParty() {
        return recipientCustomerParty;
    }

    /**
     * Sets the value of the recipientCustomerParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link CustomerPartyType }
     *     
     */
    public void setRecipientCustomerParty(
        @Nullable
        CustomerPartyType value) {
        this.recipientCustomerParty = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final CompletedTaskType rhs = ((CompletedTaskType) o);
        if (!EqualsHelper.equals(annualAverageAmount, rhs.annualAverageAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(evidenceSupplied, rhs.evidenceSupplied)) {
            return false;
        }
        if (!EqualsHelper.equals(partyCapacityAmount, rhs.partyCapacityAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(period, rhs.period)) {
            return false;
        }
        if (!EqualsHelper.equals(recipientCustomerParty, rhs.recipientCustomerParty)) {
            return false;
        }
        if (!EqualsHelper.equals(totalTaskAmount, rhs.totalTaskAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(annualAverageAmount).append(description).append(evidenceSupplied).append(partyCapacityAmount).append(period).append(recipientCustomerParty).append(totalTaskAmount).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("annualAverageAmount", annualAverageAmount).append("description", description).append("evidenceSupplied", evidenceSupplied).append("partyCapacityAmount", partyCapacityAmount).append("period", period).append("recipientCustomerParty", recipientCustomerParty).append("totalTaskAmount", totalTaskAmount).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDescription(
        @Nullable
        final List<DescriptionType> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setEvidenceSupplied(
        @Nullable
        final List<EvidenceSuppliedType> aList) {
        evidenceSupplied = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DescriptionType getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDescription(
        @Nonnull
        final DescriptionType elem) {
        getDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasEvidenceSuppliedEntries() {
        return (!getEvidenceSupplied().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoEvidenceSuppliedEntries() {
        return getEvidenceSupplied().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getEvidenceSuppliedCount() {
        return getEvidenceSupplied().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public EvidenceSuppliedType getEvidenceSuppliedAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getEvidenceSupplied().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addEvidenceSupplied(
        @Nonnull
        final EvidenceSuppliedType elem) {
        getEvidenceSupplied().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        CompletedTaskType ret) {
        ret.annualAverageAmount = ((annualAverageAmount == null)?null:annualAverageAmount.clone());
        if (description == null) {
            ret.description = null;
        } else {
            List<DescriptionType> retDescription = new ArrayList<>();
            for (DescriptionType aItem: getDescription()) {
                retDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.description = retDescription;
        }
        if (evidenceSupplied == null) {
            ret.evidenceSupplied = null;
        } else {
            List<EvidenceSuppliedType> retEvidenceSupplied = new ArrayList<>();
            for (EvidenceSuppliedType aItem: getEvidenceSupplied()) {
                retEvidenceSupplied.add(((aItem == null)?null:aItem.clone()));
            }
            ret.evidenceSupplied = retEvidenceSupplied;
        }
        ret.partyCapacityAmount = ((partyCapacityAmount == null)?null:partyCapacityAmount.clone());
        ret.period = ((period == null)?null:period.clone());
        ret.recipientCustomerParty = ((recipientCustomerParty == null)?null:recipientCustomerParty.clone());
        ret.totalTaskAmount = ((totalTaskAmount == null)?null:totalTaskAmount.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public CompletedTaskType clone() {
        CompletedTaskType ret = new CompletedTaskType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type AnnualAverageAmountType and never <code>null</code>
     */
    @Nonnull
    public AnnualAverageAmountType setAnnualAverageAmount(
        @Nullable
        final BigDecimal valueParam) {
        AnnualAverageAmountType aObj = getAnnualAverageAmount();
        if (aObj == null) {
            aObj = new AnnualAverageAmountType(valueParam);
            setAnnualAverageAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TotalTaskAmountType and never <code>null</code>
     */
    @Nonnull
    public TotalTaskAmountType setTotalTaskAmount(
        @Nullable
        final BigDecimal valueParam) {
        TotalTaskAmountType aObj = getTotalTaskAmount();
        if (aObj == null) {
            aObj = new TotalTaskAmountType(valueParam);
            setTotalTaskAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PartyCapacityAmountType and never <code>null</code>
     */
    @Nonnull
    public PartyCapacityAmountType setPartyCapacityAmount(
        @Nullable
        final BigDecimal valueParam) {
        PartyCapacityAmountType aObj = getPartyCapacityAmount();
        if (aObj == null) {
            aObj = new PartyCapacityAmountType(valueParam);
            setPartyCapacityAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained AnnualAverageAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained AnnualAverageAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getAnnualAverageAmountValue() {
        AnnualAverageAmountType aObj = getAnnualAverageAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TotalTaskAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TotalTaskAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getTotalTaskAmountValue() {
        TotalTaskAmountType aObj = getTotalTaskAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PartyCapacityAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PartyCapacityAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getPartyCapacityAmountValue() {
        PartyCapacityAmountType aObj = getPartyCapacityAmount();
        return (aObj == null)?null:aObj.getValue();
    }

}
