
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.NetworkIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ParticipantIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TestIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for DeliveryChannelType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="DeliveryChannelType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}NetworkID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ParticipantID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TestIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}DigitalCertificate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}DigitalMessageDelivery" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "DeliveryChannelType", propOrder = {
    "ublExtensions",
    "networkID",
    "participantID",
    "testIndicator",
    "digitalCertificate",
    "digitalMessageDelivery"
})
@CodingStyleguideUnaware
public class DeliveryChannelType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "NetworkID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private NetworkIDType networkID;
    @XmlElement(name = "ParticipantID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ParticipantIDType participantID;
    @XmlElement(name = "TestIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TestIndicatorType testIndicator;
    @XmlElement(name = "DigitalCertificate")
    private CertificateType digitalCertificate;
    @XmlElement(name = "DigitalMessageDelivery")
    private MessageDeliveryType digitalMessageDelivery;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public DeliveryChannelType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the networkID property.
     * 
     * @return
     *     possible object is
     *     {@link NetworkIDType }
     *     
     */
    @Nullable
    public NetworkIDType getNetworkID() {
        return networkID;
    }

    /**
     * Sets the value of the networkID property.
     * 
     * @param value
     *     allowed object is
     *     {@link NetworkIDType }
     *     
     */
    public void setNetworkID(
        @Nullable
        NetworkIDType value) {
        this.networkID = value;
    }

    /**
     * Gets the value of the participantID property.
     * 
     * @return
     *     possible object is
     *     {@link ParticipantIDType }
     *     
     */
    @Nullable
    public ParticipantIDType getParticipantID() {
        return participantID;
    }

    /**
     * Sets the value of the participantID property.
     * 
     * @param value
     *     allowed object is
     *     {@link ParticipantIDType }
     *     
     */
    public void setParticipantID(
        @Nullable
        ParticipantIDType value) {
        this.participantID = value;
    }

    /**
     * Gets the value of the testIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link TestIndicatorType }
     *     
     */
    @Nullable
    public TestIndicatorType getTestIndicator() {
        return testIndicator;
    }

    /**
     * Sets the value of the testIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link TestIndicatorType }
     *     
     */
    public void setTestIndicator(
        @Nullable
        TestIndicatorType value) {
        this.testIndicator = value;
    }

    /**
     * Gets the value of the digitalCertificate property.
     * 
     * @return
     *     possible object is
     *     {@link CertificateType }
     *     
     */
    @Nullable
    public CertificateType getDigitalCertificate() {
        return digitalCertificate;
    }

    /**
     * Sets the value of the digitalCertificate property.
     * 
     * @param value
     *     allowed object is
     *     {@link CertificateType }
     *     
     */
    public void setDigitalCertificate(
        @Nullable
        CertificateType value) {
        this.digitalCertificate = value;
    }

    /**
     * Gets the value of the digitalMessageDelivery property.
     * 
     * @return
     *     possible object is
     *     {@link MessageDeliveryType }
     *     
     */
    @Nullable
    public MessageDeliveryType getDigitalMessageDelivery() {
        return digitalMessageDelivery;
    }

    /**
     * Sets the value of the digitalMessageDelivery property.
     * 
     * @param value
     *     allowed object is
     *     {@link MessageDeliveryType }
     *     
     */
    public void setDigitalMessageDelivery(
        @Nullable
        MessageDeliveryType value) {
        this.digitalMessageDelivery = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final DeliveryChannelType rhs = ((DeliveryChannelType) o);
        if (!EqualsHelper.equals(digitalCertificate, rhs.digitalCertificate)) {
            return false;
        }
        if (!EqualsHelper.equals(digitalMessageDelivery, rhs.digitalMessageDelivery)) {
            return false;
        }
        if (!EqualsHelper.equals(networkID, rhs.networkID)) {
            return false;
        }
        if (!EqualsHelper.equals(participantID, rhs.participantID)) {
            return false;
        }
        if (!EqualsHelper.equals(testIndicator, rhs.testIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(digitalCertificate).append(digitalMessageDelivery).append(networkID).append(participantID).append(testIndicator).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("digitalCertificate", digitalCertificate).append("digitalMessageDelivery", digitalMessageDelivery).append("networkID", networkID).append("participantID", participantID).append("testIndicator", testIndicator).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        DeliveryChannelType ret) {
        ret.digitalCertificate = ((digitalCertificate == null)?null:digitalCertificate.clone());
        ret.digitalMessageDelivery = ((digitalMessageDelivery == null)?null:digitalMessageDelivery.clone());
        ret.networkID = ((networkID == null)?null:networkID.clone());
        ret.participantID = ((participantID == null)?null:participantID.clone());
        ret.testIndicator = ((testIndicator == null)?null:testIndicator.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public DeliveryChannelType clone() {
        DeliveryChannelType ret = new DeliveryChannelType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NetworkIDType and never <code>null</code>
     */
    @Nonnull
    public NetworkIDType setNetworkID(
        @Nullable
        final String valueParam) {
        NetworkIDType aObj = getNetworkID();
        if (aObj == null) {
            aObj = new NetworkIDType(valueParam);
            setNetworkID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ParticipantIDType and never <code>null</code>
     */
    @Nonnull
    public ParticipantIDType setParticipantID(
        @Nullable
        final String valueParam) {
        ParticipantIDType aObj = getParticipantID();
        if (aObj == null) {
            aObj = new ParticipantIDType(valueParam);
            setParticipantID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type TestIndicatorType and never <code>null</code>
     */
    @Nonnull
    public TestIndicatorType setTestIndicator(final boolean valueParam) {
        TestIndicatorType aObj = getTestIndicator();
        if (aObj == null) {
            aObj = new TestIndicatorType(valueParam);
            setTestIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained NetworkIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NetworkIDType object or <code>null</code>
     */
    @Nullable
    public String getNetworkIDValue() {
        NetworkIDType aObj = getNetworkID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ParticipantIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ParticipantIDType object or <code>null</code>
     */
    @Nullable
    public String getParticipantIDValue() {
        ParticipantIDType aObj = getParticipantID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TestIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained TestIndicatorType object or the passed nullValue
     */
    public boolean isTestIndicatorValue(final boolean nullValue) {
        TestIndicatorType aObj = getTestIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

}
