
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.CopyIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.DistributionTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.DistributionTypeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.DocumentTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.MaximumCopiesNumericType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.MaximumOriginalsNumericType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.PrintQualifierType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ValueType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for DocumentDistributionType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="DocumentDistributionType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}DocumentTypeCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}DistributionTypeCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}DistributionType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PrintQualifier" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CopyIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MaximumCopiesNumeric" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MaximumOriginalsNumeric" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Communication" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Party"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "DocumentDistributionType", propOrder = {
    "ublExtensions",
    "id",
    "documentTypeCode",
    "distributionTypeCode",
    "distributionType",
    "printQualifier",
    "copyIndicator",
    "maximumCopiesNumeric",
    "maximumOriginalsNumeric",
    "communication",
    "party"
})
@CodingStyleguideUnaware
public class DocumentDistributionType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IDType id;
    @XmlElement(name = "DocumentTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private DocumentTypeCodeType documentTypeCode;
    @XmlElement(name = "DistributionTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private DistributionTypeCodeType distributionTypeCode;
    @XmlElement(name = "DistributionType", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<DistributionTypeType> distributionType;
    @XmlElement(name = "PrintQualifier", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PrintQualifierType printQualifier;
    @XmlElement(name = "CopyIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private CopyIndicatorType copyIndicator;
    @XmlElement(name = "MaximumCopiesNumeric", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MaximumCopiesNumericType maximumCopiesNumeric;
    @XmlElement(name = "MaximumOriginalsNumeric", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MaximumOriginalsNumericType maximumOriginalsNumeric;
    @XmlElement(name = "Communication")
    private CommunicationType communication;
    @XmlElement(name = "Party", required = true)
    private PartyType party;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public DocumentDistributionType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the documentTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link DocumentTypeCodeType }
     *     
     */
    @Nullable
    public DocumentTypeCodeType getDocumentTypeCode() {
        return documentTypeCode;
    }

    /**
     * Sets the value of the documentTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link DocumentTypeCodeType }
     *     
     */
    public void setDocumentTypeCode(
        @Nullable
        DocumentTypeCodeType value) {
        this.documentTypeCode = value;
    }

    /**
     * Gets the value of the distributionTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link DistributionTypeCodeType }
     *     
     */
    @Nullable
    public DistributionTypeCodeType getDistributionTypeCode() {
        return distributionTypeCode;
    }

    /**
     * Sets the value of the distributionTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link DistributionTypeCodeType }
     *     
     */
    public void setDistributionTypeCode(
        @Nullable
        DistributionTypeCodeType value) {
        this.distributionTypeCode = value;
    }

    /**
     * Gets the value of the distributionType property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the distributionType property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDistributionType().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DistributionTypeType }
     * </p>
     * 
     * 
     * @return
     *     The value of the distributionType property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DistributionTypeType> getDistributionType() {
        if (distributionType == null) {
            distributionType = new ArrayList<>();
        }
        return this.distributionType;
    }

    /**
     * Gets the value of the printQualifier property.
     * 
     * @return
     *     possible object is
     *     {@link PrintQualifierType }
     *     
     */
    @Nullable
    public PrintQualifierType getPrintQualifier() {
        return printQualifier;
    }

    /**
     * Sets the value of the printQualifier property.
     * 
     * @param value
     *     allowed object is
     *     {@link PrintQualifierType }
     *     
     */
    public void setPrintQualifier(
        @Nullable
        PrintQualifierType value) {
        this.printQualifier = value;
    }

    /**
     * Gets the value of the copyIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link CopyIndicatorType }
     *     
     */
    @Nullable
    public CopyIndicatorType getCopyIndicator() {
        return copyIndicator;
    }

    /**
     * Sets the value of the copyIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link CopyIndicatorType }
     *     
     */
    public void setCopyIndicator(
        @Nullable
        CopyIndicatorType value) {
        this.copyIndicator = value;
    }

    /**
     * Gets the value of the maximumCopiesNumeric property.
     * 
     * @return
     *     possible object is
     *     {@link MaximumCopiesNumericType }
     *     
     */
    @Nullable
    public MaximumCopiesNumericType getMaximumCopiesNumeric() {
        return maximumCopiesNumeric;
    }

    /**
     * Sets the value of the maximumCopiesNumeric property.
     * 
     * @param value
     *     allowed object is
     *     {@link MaximumCopiesNumericType }
     *     
     */
    public void setMaximumCopiesNumeric(
        @Nullable
        MaximumCopiesNumericType value) {
        this.maximumCopiesNumeric = value;
    }

    /**
     * Gets the value of the maximumOriginalsNumeric property.
     * 
     * @return
     *     possible object is
     *     {@link MaximumOriginalsNumericType }
     *     
     */
    @Nullable
    public MaximumOriginalsNumericType getMaximumOriginalsNumeric() {
        return maximumOriginalsNumeric;
    }

    /**
     * Sets the value of the maximumOriginalsNumeric property.
     * 
     * @param value
     *     allowed object is
     *     {@link MaximumOriginalsNumericType }
     *     
     */
    public void setMaximumOriginalsNumeric(
        @Nullable
        MaximumOriginalsNumericType value) {
        this.maximumOriginalsNumeric = value;
    }

    /**
     * Gets the value of the communication property.
     * 
     * @return
     *     possible object is
     *     {@link CommunicationType }
     *     
     */
    @Nullable
    public CommunicationType getCommunication() {
        return communication;
    }

    /**
     * Sets the value of the communication property.
     * 
     * @param value
     *     allowed object is
     *     {@link CommunicationType }
     *     
     */
    public void setCommunication(
        @Nullable
        CommunicationType value) {
        this.communication = value;
    }

    /**
     * Gets the value of the party property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getParty() {
        return party;
    }

    /**
     * Sets the value of the party property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setParty(
        @Nullable
        PartyType value) {
        this.party = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final DocumentDistributionType rhs = ((DocumentDistributionType) o);
        if (!EqualsHelper.equals(communication, rhs.communication)) {
            return false;
        }
        if (!EqualsHelper.equals(copyIndicator, rhs.copyIndicator)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(distributionType, rhs.distributionType)) {
            return false;
        }
        if (!EqualsHelper.equals(distributionTypeCode, rhs.distributionTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(documentTypeCode, rhs.documentTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(maximumCopiesNumeric, rhs.maximumCopiesNumeric)) {
            return false;
        }
        if (!EqualsHelper.equals(maximumOriginalsNumeric, rhs.maximumOriginalsNumeric)) {
            return false;
        }
        if (!EqualsHelper.equals(party, rhs.party)) {
            return false;
        }
        if (!EqualsHelper.equals(printQualifier, rhs.printQualifier)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(communication).append(copyIndicator).append(distributionType).append(distributionTypeCode).append(documentTypeCode).append(id).append(maximumCopiesNumeric).append(maximumOriginalsNumeric).append(party).append(printQualifier).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("communication", communication).append("copyIndicator", copyIndicator).append("distributionType", distributionType).append("distributionTypeCode", distributionTypeCode).append("documentTypeCode", documentTypeCode).append("id", id).append("maximumCopiesNumeric", maximumCopiesNumeric).append("maximumOriginalsNumeric", maximumOriginalsNumeric).append("party", party).append("printQualifier", printQualifier).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDistributionType(
        @Nullable
        final List<DistributionTypeType> aList) {
        distributionType = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDistributionTypeEntries() {
        return (!getDistributionType().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDistributionTypeEntries() {
        return getDistributionType().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDistributionTypeCount() {
        return getDistributionType().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DistributionTypeType getDistributionTypeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDistributionType().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDistributionType(
        @Nonnull
        final DistributionTypeType elem) {
        getDistributionType().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        DocumentDistributionType ret) {
        ret.communication = ((communication == null)?null:communication.clone());
        ret.copyIndicator = ((copyIndicator == null)?null:copyIndicator.clone());
        if (distributionType == null) {
            ret.distributionType = null;
        } else {
            List<DistributionTypeType> retDistributionType = new ArrayList<>();
            for (DistributionTypeType aItem: getDistributionType()) {
                retDistributionType.add(((aItem == null)?null:aItem.clone()));
            }
            ret.distributionType = retDistributionType;
        }
        ret.distributionTypeCode = ((distributionTypeCode == null)?null:distributionTypeCode.clone());
        ret.documentTypeCode = ((documentTypeCode == null)?null:documentTypeCode.clone());
        ret.id = ((id == null)?null:id.clone());
        ret.maximumCopiesNumeric = ((maximumCopiesNumeric == null)?null:maximumCopiesNumeric.clone());
        ret.maximumOriginalsNumeric = ((maximumOriginalsNumeric == null)?null:maximumOriginalsNumeric.clone());
        ret.party = ((party == null)?null:party.clone());
        ret.printQualifier = ((printQualifier == null)?null:printQualifier.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public DocumentDistributionType clone() {
        DocumentDistributionType ret = new DocumentDistributionType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type DocumentTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public DocumentTypeCodeType setDocumentTypeCode(
        @Nullable
        final String valueParam) {
        DocumentTypeCodeType aObj = getDocumentTypeCode();
        if (aObj == null) {
            aObj = new DocumentTypeCodeType(valueParam);
            setDocumentTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type DistributionTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public DistributionTypeCodeType setDistributionTypeCode(
        @Nullable
        final String valueParam) {
        DistributionTypeCodeType aObj = getDistributionTypeCode();
        if (aObj == null) {
            aObj = new DistributionTypeCodeType(valueParam);
            setDistributionTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PrintQualifierType and never <code>null</code>
     */
    @Nonnull
    public PrintQualifierType setPrintQualifier(
        @Nullable
        final String valueParam) {
        PrintQualifierType aObj = getPrintQualifier();
        if (aObj == null) {
            aObj = new PrintQualifierType(valueParam);
            setPrintQualifier(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type CopyIndicatorType and never <code>null</code>
     */
    @Nonnull
    public CopyIndicatorType setCopyIndicator(final boolean valueParam) {
        CopyIndicatorType aObj = getCopyIndicator();
        if (aObj == null) {
            aObj = new CopyIndicatorType(valueParam);
            setCopyIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MaximumCopiesNumericType and never <code>null</code>
     */
    @Nonnull
    public MaximumCopiesNumericType setMaximumCopiesNumeric(
        @Nullable
        final BigDecimal valueParam) {
        MaximumCopiesNumericType aObj = getMaximumCopiesNumeric();
        if (aObj == null) {
            aObj = new MaximumCopiesNumericType(valueParam);
            setMaximumCopiesNumeric(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MaximumOriginalsNumericType and never <code>null</code>
     */
    @Nonnull
    public MaximumOriginalsNumericType setMaximumOriginalsNumeric(
        @Nullable
        final BigDecimal valueParam) {
        MaximumOriginalsNumericType aObj = getMaximumOriginalsNumeric();
        if (aObj == null) {
            aObj = new MaximumOriginalsNumericType(valueParam);
            setMaximumOriginalsNumeric(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type ValueType<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CommunicationType and never <code>null</code>
     */
    @Nonnull
    public CommunicationType setCommunication(
        @Nullable
        final ValueType valueParam) {
        CommunicationType aObj = getCommunication();
        if (aObj == null) {
            aObj = new CommunicationType(valueParam);
            setCommunication(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained DocumentTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained DocumentTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getDocumentTypeCodeValue() {
        DocumentTypeCodeType aObj = getDocumentTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained DistributionTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained DistributionTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getDistributionTypeCodeValue() {
        DistributionTypeCodeType aObj = getDistributionTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PrintQualifierType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PrintQualifierType object or <code>null</code>
     */
    @Nullable
    public String getPrintQualifierValue() {
        PrintQualifierType aObj = getPrintQualifier();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CopyIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained CopyIndicatorType object or the passed nullValue
     */
    public boolean isCopyIndicatorValue(final boolean nullValue) {
        CopyIndicatorType aObj = getCopyIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained MaximumCopiesNumericType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MaximumCopiesNumericType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getMaximumCopiesNumericValue() {
        MaximumCopiesNumericType aObj = getMaximumCopiesNumeric();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MaximumOriginalsNumericType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MaximumOriginalsNumericType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getMaximumOriginalsNumericValue() {
        MaximumOriginalsNumericType aObj = getMaximumOriginalsNumeric();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CommunicationType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CommunicationType object or <code>null</code>
     */
    @Nullable
    public ValueType getCommunicationValue() {
        CommunicationType aObj = getCommunication();
        return (aObj == null)?null:aObj.getValue();
    }

}
