
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.DocumentTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.FormatIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.SchemaURIType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.VersionIDType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for DocumentMetadataType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="DocumentMetadataType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}FormatID"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}VersionID"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}SchemaURI" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}DocumentTypeCode" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "DocumentMetadataType", propOrder = {
    "ublExtensions",
    "id",
    "formatID",
    "versionID",
    "schemaURI",
    "documentTypeCode"
})
@CodingStyleguideUnaware
public class DocumentMetadataType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IDType id;
    @XmlElement(name = "FormatID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private FormatIDType formatID;
    @XmlElement(name = "VersionID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private VersionIDType versionID;
    @XmlElement(name = "SchemaURI", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private SchemaURIType schemaURI;
    @XmlElement(name = "DocumentTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private DocumentTypeCodeType documentTypeCode;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public DocumentMetadataType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the formatID property.
     * 
     * @return
     *     possible object is
     *     {@link FormatIDType }
     *     
     */
    @Nullable
    public FormatIDType getFormatID() {
        return formatID;
    }

    /**
     * Sets the value of the formatID property.
     * 
     * @param value
     *     allowed object is
     *     {@link FormatIDType }
     *     
     */
    public void setFormatID(
        @Nullable
        FormatIDType value) {
        this.formatID = value;
    }

    /**
     * Gets the value of the versionID property.
     * 
     * @return
     *     possible object is
     *     {@link VersionIDType }
     *     
     */
    @Nullable
    public VersionIDType getVersionID() {
        return versionID;
    }

    /**
     * Sets the value of the versionID property.
     * 
     * @param value
     *     allowed object is
     *     {@link VersionIDType }
     *     
     */
    public void setVersionID(
        @Nullable
        VersionIDType value) {
        this.versionID = value;
    }

    /**
     * Gets the value of the schemaURI property.
     * 
     * @return
     *     possible object is
     *     {@link SchemaURIType }
     *     
     */
    @Nullable
    public SchemaURIType getSchemaURI() {
        return schemaURI;
    }

    /**
     * Sets the value of the schemaURI property.
     * 
     * @param value
     *     allowed object is
     *     {@link SchemaURIType }
     *     
     */
    public void setSchemaURI(
        @Nullable
        SchemaURIType value) {
        this.schemaURI = value;
    }

    /**
     * Gets the value of the documentTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link DocumentTypeCodeType }
     *     
     */
    @Nullable
    public DocumentTypeCodeType getDocumentTypeCode() {
        return documentTypeCode;
    }

    /**
     * Sets the value of the documentTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link DocumentTypeCodeType }
     *     
     */
    public void setDocumentTypeCode(
        @Nullable
        DocumentTypeCodeType value) {
        this.documentTypeCode = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final DocumentMetadataType rhs = ((DocumentMetadataType) o);
        if (!EqualsHelper.equals(documentTypeCode, rhs.documentTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(formatID, rhs.formatID)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(schemaURI, rhs.schemaURI)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        if (!EqualsHelper.equals(versionID, rhs.versionID)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(documentTypeCode).append(formatID).append(id).append(schemaURI).append(ublExtensions).append(versionID).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("documentTypeCode", documentTypeCode).append("formatID", formatID).append("id", id).append("schemaURI", schemaURI).append("ublExtensions", ublExtensions).append("versionID", versionID).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        DocumentMetadataType ret) {
        ret.documentTypeCode = ((documentTypeCode == null)?null:documentTypeCode.clone());
        ret.formatID = ((formatID == null)?null:formatID.clone());
        ret.id = ((id == null)?null:id.clone());
        ret.schemaURI = ((schemaURI == null)?null:schemaURI.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
        ret.versionID = ((versionID == null)?null:versionID.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public DocumentMetadataType clone() {
        DocumentMetadataType ret = new DocumentMetadataType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type FormatIDType and never <code>null</code>
     */
    @Nonnull
    public FormatIDType setFormatID(
        @Nullable
        final String valueParam) {
        FormatIDType aObj = getFormatID();
        if (aObj == null) {
            aObj = new FormatIDType(valueParam);
            setFormatID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type VersionIDType and never <code>null</code>
     */
    @Nonnull
    public VersionIDType setVersionID(
        @Nullable
        final String valueParam) {
        VersionIDType aObj = getVersionID();
        if (aObj == null) {
            aObj = new VersionIDType(valueParam);
            setVersionID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SchemaURIType and never <code>null</code>
     */
    @Nonnull
    public SchemaURIType setSchemaURI(
        @Nullable
        final String valueParam) {
        SchemaURIType aObj = getSchemaURI();
        if (aObj == null) {
            aObj = new SchemaURIType(valueParam);
            setSchemaURI(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type DocumentTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public DocumentTypeCodeType setDocumentTypeCode(
        @Nullable
        final String valueParam) {
        DocumentTypeCodeType aObj = getDocumentTypeCode();
        if (aObj == null) {
            aObj = new DocumentTypeCodeType(valueParam);
            setDocumentTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained FormatIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained FormatIDType object or <code>null</code>
     */
    @Nullable
    public String getFormatIDValue() {
        FormatIDType aObj = getFormatID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained VersionIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained VersionIDType object or <code>null</code>
     */
    @Nullable
    public String getVersionIDValue() {
        VersionIDType aObj = getVersionID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained SchemaURIType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SchemaURIType object or <code>null</code>
     */
    @Nullable
    public String getSchemaURIValue() {
        SchemaURIType aObj = getSchemaURI();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained DocumentTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained DocumentTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getDocumentTypeCodeValue() {
        DocumentTypeCodeType aObj = getDocumentTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

}
