
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.EstimatedMaximumValueAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ExpectedOperatorQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.FrequencyType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.JustificationType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.MaximumOperatorQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.MaximumValueAmountType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for FrameworkAgreementType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="FrameworkAgreementType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ExpectedOperatorQuantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MaximumOperatorQuantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Justification" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Frequency" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}EstimatedMaximumValueAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MaximumValueAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}DurationPeriod" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}SubsequentProcessTenderRequirement" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "FrameworkAgreementType", propOrder = {
    "ublExtensions",
    "expectedOperatorQuantity",
    "maximumOperatorQuantity",
    "justification",
    "frequency",
    "estimatedMaximumValueAmount",
    "maximumValueAmount",
    "durationPeriod",
    "subsequentProcessTenderRequirement"
})
@CodingStyleguideUnaware
public class FrameworkAgreementType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ExpectedOperatorQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ExpectedOperatorQuantityType expectedOperatorQuantity;
    @XmlElement(name = "MaximumOperatorQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MaximumOperatorQuantityType maximumOperatorQuantity;
    @XmlElement(name = "Justification", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<JustificationType> justification;
    @XmlElement(name = "Frequency", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<FrequencyType> frequency;
    @XmlElement(name = "EstimatedMaximumValueAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private EstimatedMaximumValueAmountType estimatedMaximumValueAmount;
    @XmlElement(name = "MaximumValueAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MaximumValueAmountType maximumValueAmount;
    @XmlElement(name = "DurationPeriod")
    private PeriodType durationPeriod;
    @XmlElement(name = "SubsequentProcessTenderRequirement")
    private List<TenderRequirementType> subsequentProcessTenderRequirement;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public FrameworkAgreementType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the expectedOperatorQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link ExpectedOperatorQuantityType }
     *     
     */
    @Nullable
    public ExpectedOperatorQuantityType getExpectedOperatorQuantity() {
        return expectedOperatorQuantity;
    }

    /**
     * Sets the value of the expectedOperatorQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExpectedOperatorQuantityType }
     *     
     */
    public void setExpectedOperatorQuantity(
        @Nullable
        ExpectedOperatorQuantityType value) {
        this.expectedOperatorQuantity = value;
    }

    /**
     * Gets the value of the maximumOperatorQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link MaximumOperatorQuantityType }
     *     
     */
    @Nullable
    public MaximumOperatorQuantityType getMaximumOperatorQuantity() {
        return maximumOperatorQuantity;
    }

    /**
     * Sets the value of the maximumOperatorQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link MaximumOperatorQuantityType }
     *     
     */
    public void setMaximumOperatorQuantity(
        @Nullable
        MaximumOperatorQuantityType value) {
        this.maximumOperatorQuantity = value;
    }

    /**
     * Gets the value of the justification property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the justification property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getJustification().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JustificationType }
     * </p>
     * 
     * 
     * @return
     *     The value of the justification property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<JustificationType> getJustification() {
        if (justification == null) {
            justification = new ArrayList<>();
        }
        return this.justification;
    }

    /**
     * Gets the value of the frequency property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the frequency property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getFrequency().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FrequencyType }
     * </p>
     * 
     * 
     * @return
     *     The value of the frequency property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<FrequencyType> getFrequency() {
        if (frequency == null) {
            frequency = new ArrayList<>();
        }
        return this.frequency;
    }

    /**
     * Gets the value of the estimatedMaximumValueAmount property.
     * 
     * @return
     *     possible object is
     *     {@link EstimatedMaximumValueAmountType }
     *     
     */
    @Nullable
    public EstimatedMaximumValueAmountType getEstimatedMaximumValueAmount() {
        return estimatedMaximumValueAmount;
    }

    /**
     * Sets the value of the estimatedMaximumValueAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link EstimatedMaximumValueAmountType }
     *     
     */
    public void setEstimatedMaximumValueAmount(
        @Nullable
        EstimatedMaximumValueAmountType value) {
        this.estimatedMaximumValueAmount = value;
    }

    /**
     * Gets the value of the maximumValueAmount property.
     * 
     * @return
     *     possible object is
     *     {@link MaximumValueAmountType }
     *     
     */
    @Nullable
    public MaximumValueAmountType getMaximumValueAmount() {
        return maximumValueAmount;
    }

    /**
     * Sets the value of the maximumValueAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link MaximumValueAmountType }
     *     
     */
    public void setMaximumValueAmount(
        @Nullable
        MaximumValueAmountType value) {
        this.maximumValueAmount = value;
    }

    /**
     * Gets the value of the durationPeriod property.
     * 
     * @return
     *     possible object is
     *     {@link PeriodType }
     *     
     */
    @Nullable
    public PeriodType getDurationPeriod() {
        return durationPeriod;
    }

    /**
     * Sets the value of the durationPeriod property.
     * 
     * @param value
     *     allowed object is
     *     {@link PeriodType }
     *     
     */
    public void setDurationPeriod(
        @Nullable
        PeriodType value) {
        this.durationPeriod = value;
    }

    /**
     * Gets the value of the subsequentProcessTenderRequirement property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the subsequentProcessTenderRequirement property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getSubsequentProcessTenderRequirement().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TenderRequirementType }
     * </p>
     * 
     * 
     * @return
     *     The value of the subsequentProcessTenderRequirement property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TenderRequirementType> getSubsequentProcessTenderRequirement() {
        if (subsequentProcessTenderRequirement == null) {
            subsequentProcessTenderRequirement = new ArrayList<>();
        }
        return this.subsequentProcessTenderRequirement;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final FrameworkAgreementType rhs = ((FrameworkAgreementType) o);
        if (!EqualsHelper.equals(durationPeriod, rhs.durationPeriod)) {
            return false;
        }
        if (!EqualsHelper.equals(estimatedMaximumValueAmount, rhs.estimatedMaximumValueAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(expectedOperatorQuantity, rhs.expectedOperatorQuantity)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(frequency, rhs.frequency)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(justification, rhs.justification)) {
            return false;
        }
        if (!EqualsHelper.equals(maximumOperatorQuantity, rhs.maximumOperatorQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(maximumValueAmount, rhs.maximumValueAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(subsequentProcessTenderRequirement, rhs.subsequentProcessTenderRequirement)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(durationPeriod).append(estimatedMaximumValueAmount).append(expectedOperatorQuantity).append(frequency).append(justification).append(maximumOperatorQuantity).append(maximumValueAmount).append(subsequentProcessTenderRequirement).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("durationPeriod", durationPeriod).append("estimatedMaximumValueAmount", estimatedMaximumValueAmount).append("expectedOperatorQuantity", expectedOperatorQuantity).append("frequency", frequency).append("justification", justification).append("maximumOperatorQuantity", maximumOperatorQuantity).append("maximumValueAmount", maximumValueAmount).append("subsequentProcessTenderRequirement", subsequentProcessTenderRequirement).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setJustification(
        @Nullable
        final List<JustificationType> aList) {
        justification = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setFrequency(
        @Nullable
        final List<FrequencyType> aList) {
        frequency = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSubsequentProcessTenderRequirement(
        @Nullable
        final List<TenderRequirementType> aList) {
        subsequentProcessTenderRequirement = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasJustificationEntries() {
        return (!getJustification().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoJustificationEntries() {
        return getJustification().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getJustificationCount() {
        return getJustification().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public JustificationType getJustificationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getJustification().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addJustification(
        @Nonnull
        final JustificationType elem) {
        getJustification().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasFrequencyEntries() {
        return (!getFrequency().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoFrequencyEntries() {
        return getFrequency().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getFrequencyCount() {
        return getFrequency().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public FrequencyType getFrequencyAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getFrequency().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addFrequency(
        @Nonnull
        final FrequencyType elem) {
        getFrequency().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSubsequentProcessTenderRequirementEntries() {
        return (!getSubsequentProcessTenderRequirement().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSubsequentProcessTenderRequirementEntries() {
        return getSubsequentProcessTenderRequirement().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSubsequentProcessTenderRequirementCount() {
        return getSubsequentProcessTenderRequirement().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TenderRequirementType getSubsequentProcessTenderRequirementAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSubsequentProcessTenderRequirement().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSubsequentProcessTenderRequirement(
        @Nonnull
        final TenderRequirementType elem) {
        getSubsequentProcessTenderRequirement().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        FrameworkAgreementType ret) {
        ret.durationPeriod = ((durationPeriod == null)?null:durationPeriod.clone());
        ret.estimatedMaximumValueAmount = ((estimatedMaximumValueAmount == null)?null:estimatedMaximumValueAmount.clone());
        ret.expectedOperatorQuantity = ((expectedOperatorQuantity == null)?null:expectedOperatorQuantity.clone());
        if (frequency == null) {
            ret.frequency = null;
        } else {
            List<FrequencyType> retFrequency = new ArrayList<>();
            for (FrequencyType aItem: getFrequency()) {
                retFrequency.add(((aItem == null)?null:aItem.clone()));
            }
            ret.frequency = retFrequency;
        }
        if (justification == null) {
            ret.justification = null;
        } else {
            List<JustificationType> retJustification = new ArrayList<>();
            for (JustificationType aItem: getJustification()) {
                retJustification.add(((aItem == null)?null:aItem.clone()));
            }
            ret.justification = retJustification;
        }
        ret.maximumOperatorQuantity = ((maximumOperatorQuantity == null)?null:maximumOperatorQuantity.clone());
        ret.maximumValueAmount = ((maximumValueAmount == null)?null:maximumValueAmount.clone());
        if (subsequentProcessTenderRequirement == null) {
            ret.subsequentProcessTenderRequirement = null;
        } else {
            List<TenderRequirementType> retSubsequentProcessTenderRequirement = new ArrayList<>();
            for (TenderRequirementType aItem: getSubsequentProcessTenderRequirement()) {
                retSubsequentProcessTenderRequirement.add(((aItem == null)?null:aItem.clone()));
            }
            ret.subsequentProcessTenderRequirement = retSubsequentProcessTenderRequirement;
        }
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public FrameworkAgreementType clone() {
        FrameworkAgreementType ret = new FrameworkAgreementType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ExpectedOperatorQuantityType and never <code>null</code>
     */
    @Nonnull
    public ExpectedOperatorQuantityType setExpectedOperatorQuantity(
        @Nullable
        final BigDecimal valueParam) {
        ExpectedOperatorQuantityType aObj = getExpectedOperatorQuantity();
        if (aObj == null) {
            aObj = new ExpectedOperatorQuantityType(valueParam);
            setExpectedOperatorQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MaximumOperatorQuantityType and never <code>null</code>
     */
    @Nonnull
    public MaximumOperatorQuantityType setMaximumOperatorQuantity(
        @Nullable
        final BigDecimal valueParam) {
        MaximumOperatorQuantityType aObj = getMaximumOperatorQuantity();
        if (aObj == null) {
            aObj = new MaximumOperatorQuantityType(valueParam);
            setMaximumOperatorQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type EstimatedMaximumValueAmountType and never <code>null</code>
     */
    @Nonnull
    public EstimatedMaximumValueAmountType setEstimatedMaximumValueAmount(
        @Nullable
        final BigDecimal valueParam) {
        EstimatedMaximumValueAmountType aObj = getEstimatedMaximumValueAmount();
        if (aObj == null) {
            aObj = new EstimatedMaximumValueAmountType(valueParam);
            setEstimatedMaximumValueAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MaximumValueAmountType and never <code>null</code>
     */
    @Nonnull
    public MaximumValueAmountType setMaximumValueAmount(
        @Nullable
        final BigDecimal valueParam) {
        MaximumValueAmountType aObj = getMaximumValueAmount();
        if (aObj == null) {
            aObj = new MaximumValueAmountType(valueParam);
            setMaximumValueAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained ExpectedOperatorQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ExpectedOperatorQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getExpectedOperatorQuantityValue() {
        ExpectedOperatorQuantityType aObj = getExpectedOperatorQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MaximumOperatorQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MaximumOperatorQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getMaximumOperatorQuantityValue() {
        MaximumOperatorQuantityType aObj = getMaximumOperatorQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained EstimatedMaximumValueAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained EstimatedMaximumValueAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getEstimatedMaximumValueAmountValue() {
        EstimatedMaximumValueAmountType aObj = getEstimatedMaximumValueAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MaximumValueAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MaximumValueAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getMaximumValueAmountValue() {
        MaximumValueAmountType aObj = getMaximumValueAmount();
        return (aObj == null)?null:aObj.getValue();
    }

}
