
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.FuelConsumptionMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.FuelTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.FuelTypeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.IDType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for FuelConsumptionType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="FuelConsumptionType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}FuelTypeCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}FuelType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}FuelConsumptionMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}AdditionalFuelProperty" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}FuelMetering" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}EnvironmentalEmission" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}FuelProviderParty" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "FuelConsumptionType", propOrder = {
    "ublExtensions",
    "id",
    "fuelTypeCode",
    "fuelType",
    "fuelConsumptionMeasure",
    "additionalFuelProperty",
    "fuelMetering",
    "environmentalEmission",
    "fuelProviderParty"
})
@CodingStyleguideUnaware
public class FuelConsumptionType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IDType id;
    @XmlElement(name = "FuelTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private FuelTypeCodeType fuelTypeCode;
    @XmlElement(name = "FuelType", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<FuelTypeType> fuelType;
    @XmlElement(name = "FuelConsumptionMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private FuelConsumptionMeasureType fuelConsumptionMeasure;
    @XmlElement(name = "AdditionalFuelProperty")
    private List<FuelPropertyType> additionalFuelProperty;
    @XmlElement(name = "FuelMetering")
    private List<FuelMeteringType> fuelMetering;
    @XmlElement(name = "EnvironmentalEmission")
    private List<EnvironmentalEmissionType> environmentalEmission;
    @XmlElement(name = "FuelProviderParty")
    private PartyType fuelProviderParty;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public FuelConsumptionType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the fuelTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link FuelTypeCodeType }
     *     
     */
    @Nullable
    public FuelTypeCodeType getFuelTypeCode() {
        return fuelTypeCode;
    }

    /**
     * Sets the value of the fuelTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link FuelTypeCodeType }
     *     
     */
    public void setFuelTypeCode(
        @Nullable
        FuelTypeCodeType value) {
        this.fuelTypeCode = value;
    }

    /**
     * Gets the value of the fuelType property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the fuelType property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getFuelType().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FuelTypeType }
     * </p>
     * 
     * 
     * @return
     *     The value of the fuelType property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<FuelTypeType> getFuelType() {
        if (fuelType == null) {
            fuelType = new ArrayList<>();
        }
        return this.fuelType;
    }

    /**
     * Gets the value of the fuelConsumptionMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link FuelConsumptionMeasureType }
     *     
     */
    @Nullable
    public FuelConsumptionMeasureType getFuelConsumptionMeasure() {
        return fuelConsumptionMeasure;
    }

    /**
     * Sets the value of the fuelConsumptionMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link FuelConsumptionMeasureType }
     *     
     */
    public void setFuelConsumptionMeasure(
        @Nullable
        FuelConsumptionMeasureType value) {
        this.fuelConsumptionMeasure = value;
    }

    /**
     * Gets the value of the additionalFuelProperty property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the additionalFuelProperty property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getAdditionalFuelProperty().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FuelPropertyType }
     * </p>
     * 
     * 
     * @return
     *     The value of the additionalFuelProperty property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<FuelPropertyType> getAdditionalFuelProperty() {
        if (additionalFuelProperty == null) {
            additionalFuelProperty = new ArrayList<>();
        }
        return this.additionalFuelProperty;
    }

    /**
     * Gets the value of the fuelMetering property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the fuelMetering property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getFuelMetering().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FuelMeteringType }
     * </p>
     * 
     * 
     * @return
     *     The value of the fuelMetering property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<FuelMeteringType> getFuelMetering() {
        if (fuelMetering == null) {
            fuelMetering = new ArrayList<>();
        }
        return this.fuelMetering;
    }

    /**
     * Gets the value of the environmentalEmission property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the environmentalEmission property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getEnvironmentalEmission().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link EnvironmentalEmissionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the environmentalEmission property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<EnvironmentalEmissionType> getEnvironmentalEmission() {
        if (environmentalEmission == null) {
            environmentalEmission = new ArrayList<>();
        }
        return this.environmentalEmission;
    }

    /**
     * Gets the value of the fuelProviderParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getFuelProviderParty() {
        return fuelProviderParty;
    }

    /**
     * Sets the value of the fuelProviderParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setFuelProviderParty(
        @Nullable
        PartyType value) {
        this.fuelProviderParty = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final FuelConsumptionType rhs = ((FuelConsumptionType) o);
        if (!EqualsHelper.equalsCollection(additionalFuelProperty, rhs.additionalFuelProperty)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(environmentalEmission, rhs.environmentalEmission)) {
            return false;
        }
        if (!EqualsHelper.equals(fuelConsumptionMeasure, rhs.fuelConsumptionMeasure)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(fuelMetering, rhs.fuelMetering)) {
            return false;
        }
        if (!EqualsHelper.equals(fuelProviderParty, rhs.fuelProviderParty)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(fuelType, rhs.fuelType)) {
            return false;
        }
        if (!EqualsHelper.equals(fuelTypeCode, rhs.fuelTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(additionalFuelProperty).append(environmentalEmission).append(fuelConsumptionMeasure).append(fuelMetering).append(fuelProviderParty).append(fuelType).append(fuelTypeCode).append(id).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("additionalFuelProperty", additionalFuelProperty).append("environmentalEmission", environmentalEmission).append("fuelConsumptionMeasure", fuelConsumptionMeasure).append("fuelMetering", fuelMetering).append("fuelProviderParty", fuelProviderParty).append("fuelType", fuelType).append("fuelTypeCode", fuelTypeCode).append("id", id).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setFuelType(
        @Nullable
        final List<FuelTypeType> aList) {
        fuelType = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAdditionalFuelProperty(
        @Nullable
        final List<FuelPropertyType> aList) {
        additionalFuelProperty = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setFuelMetering(
        @Nullable
        final List<FuelMeteringType> aList) {
        fuelMetering = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setEnvironmentalEmission(
        @Nullable
        final List<EnvironmentalEmissionType> aList) {
        environmentalEmission = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasFuelTypeEntries() {
        return (!getFuelType().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoFuelTypeEntries() {
        return getFuelType().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getFuelTypeCount() {
        return getFuelType().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public FuelTypeType getFuelTypeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getFuelType().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addFuelType(
        @Nonnull
        final FuelTypeType elem) {
        getFuelType().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAdditionalFuelPropertyEntries() {
        return (!getAdditionalFuelProperty().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAdditionalFuelPropertyEntries() {
        return getAdditionalFuelProperty().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAdditionalFuelPropertyCount() {
        return getAdditionalFuelProperty().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public FuelPropertyType getAdditionalFuelPropertyAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAdditionalFuelProperty().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAdditionalFuelProperty(
        @Nonnull
        final FuelPropertyType elem) {
        getAdditionalFuelProperty().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasFuelMeteringEntries() {
        return (!getFuelMetering().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoFuelMeteringEntries() {
        return getFuelMetering().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getFuelMeteringCount() {
        return getFuelMetering().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public FuelMeteringType getFuelMeteringAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getFuelMetering().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addFuelMetering(
        @Nonnull
        final FuelMeteringType elem) {
        getFuelMetering().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasEnvironmentalEmissionEntries() {
        return (!getEnvironmentalEmission().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoEnvironmentalEmissionEntries() {
        return getEnvironmentalEmission().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getEnvironmentalEmissionCount() {
        return getEnvironmentalEmission().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public EnvironmentalEmissionType getEnvironmentalEmissionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getEnvironmentalEmission().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addEnvironmentalEmission(
        @Nonnull
        final EnvironmentalEmissionType elem) {
        getEnvironmentalEmission().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        FuelConsumptionType ret) {
        if (additionalFuelProperty == null) {
            ret.additionalFuelProperty = null;
        } else {
            List<FuelPropertyType> retAdditionalFuelProperty = new ArrayList<>();
            for (FuelPropertyType aItem: getAdditionalFuelProperty()) {
                retAdditionalFuelProperty.add(((aItem == null)?null:aItem.clone()));
            }
            ret.additionalFuelProperty = retAdditionalFuelProperty;
        }
        if (environmentalEmission == null) {
            ret.environmentalEmission = null;
        } else {
            List<EnvironmentalEmissionType> retEnvironmentalEmission = new ArrayList<>();
            for (EnvironmentalEmissionType aItem: getEnvironmentalEmission()) {
                retEnvironmentalEmission.add(((aItem == null)?null:aItem.clone()));
            }
            ret.environmentalEmission = retEnvironmentalEmission;
        }
        ret.fuelConsumptionMeasure = ((fuelConsumptionMeasure == null)?null:fuelConsumptionMeasure.clone());
        if (fuelMetering == null) {
            ret.fuelMetering = null;
        } else {
            List<FuelMeteringType> retFuelMetering = new ArrayList<>();
            for (FuelMeteringType aItem: getFuelMetering()) {
                retFuelMetering.add(((aItem == null)?null:aItem.clone()));
            }
            ret.fuelMetering = retFuelMetering;
        }
        ret.fuelProviderParty = ((fuelProviderParty == null)?null:fuelProviderParty.clone());
        if (fuelType == null) {
            ret.fuelType = null;
        } else {
            List<FuelTypeType> retFuelType = new ArrayList<>();
            for (FuelTypeType aItem: getFuelType()) {
                retFuelType.add(((aItem == null)?null:aItem.clone()));
            }
            ret.fuelType = retFuelType;
        }
        ret.fuelTypeCode = ((fuelTypeCode == null)?null:fuelTypeCode.clone());
        ret.id = ((id == null)?null:id.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public FuelConsumptionType clone() {
        FuelConsumptionType ret = new FuelConsumptionType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type FuelTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public FuelTypeCodeType setFuelTypeCode(
        @Nullable
        final String valueParam) {
        FuelTypeCodeType aObj = getFuelTypeCode();
        if (aObj == null) {
            aObj = new FuelTypeCodeType(valueParam);
            setFuelTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type FuelConsumptionMeasureType and never <code>null</code>
     */
    @Nonnull
    public FuelConsumptionMeasureType setFuelConsumptionMeasure(
        @Nullable
        final BigDecimal valueParam) {
        FuelConsumptionMeasureType aObj = getFuelConsumptionMeasure();
        if (aObj == null) {
            aObj = new FuelConsumptionMeasureType(valueParam);
            setFuelConsumptionMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained FuelTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained FuelTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getFuelTypeCodeValue() {
        FuelTypeCodeType aObj = getFuelTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained FuelConsumptionMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained FuelConsumptionMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getFuelConsumptionMeasureValue() {
        FuelConsumptionMeasureType aObj = getFuelConsumptionMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

}
