
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.FinalReexportationDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.GoodsItemPassportIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.NoteType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for GoodsItemPassportCounterfoilType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="GoodsItemPassportCounterfoilType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}GoodsItemPassportID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}FinalReexportationDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Note" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}CustomsOfficeLocation" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}GoodsItem" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ExportationDocumentReference" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ImportationDocumentReference" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ReexportationDocumentReference" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ReimportationDocumentReference" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}VoucherDocumentReference" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "GoodsItemPassportCounterfoilType", propOrder = {
    "ublExtensions",
    "id",
    "goodsItemPassportID",
    "finalReexportationDate",
    "note",
    "customsOfficeLocation",
    "goodsItem",
    "exportationDocumentReference",
    "importationDocumentReference",
    "reexportationDocumentReference",
    "reimportationDocumentReference",
    "voucherDocumentReference"
})
@CodingStyleguideUnaware
public class GoodsItemPassportCounterfoilType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private IDType id;
    @XmlElement(name = "GoodsItemPassportID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private GoodsItemPassportIDType goodsItemPassportID;
    @XmlElement(name = "FinalReexportationDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private FinalReexportationDateType finalReexportationDate;
    @XmlElement(name = "Note", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<NoteType> note;
    @XmlElement(name = "CustomsOfficeLocation")
    private LocationType customsOfficeLocation;
    @XmlElement(name = "GoodsItem")
    private GoodsItemType goodsItem;
    @XmlElement(name = "ExportationDocumentReference")
    private List<DocumentReferenceType> exportationDocumentReference;
    @XmlElement(name = "ImportationDocumentReference")
    private List<DocumentReferenceType> importationDocumentReference;
    @XmlElement(name = "ReexportationDocumentReference")
    private List<DocumentReferenceType> reexportationDocumentReference;
    @XmlElement(name = "ReimportationDocumentReference")
    private List<DocumentReferenceType> reimportationDocumentReference;
    @XmlElement(name = "VoucherDocumentReference")
    private List<DocumentReferenceType> voucherDocumentReference;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public GoodsItemPassportCounterfoilType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the goodsItemPassportID property.
     * 
     * @return
     *     possible object is
     *     {@link GoodsItemPassportIDType }
     *     
     */
    @Nullable
    public GoodsItemPassportIDType getGoodsItemPassportID() {
        return goodsItemPassportID;
    }

    /**
     * Sets the value of the goodsItemPassportID property.
     * 
     * @param value
     *     allowed object is
     *     {@link GoodsItemPassportIDType }
     *     
     */
    public void setGoodsItemPassportID(
        @Nullable
        GoodsItemPassportIDType value) {
        this.goodsItemPassportID = value;
    }

    /**
     * Gets the value of the finalReexportationDate property.
     * 
     * @return
     *     possible object is
     *     {@link FinalReexportationDateType }
     *     
     */
    @Nullable
    public FinalReexportationDateType getFinalReexportationDate() {
        return finalReexportationDate;
    }

    /**
     * Sets the value of the finalReexportationDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link FinalReexportationDateType }
     *     
     */
    public void setFinalReexportationDate(
        @Nullable
        FinalReexportationDateType value) {
        this.finalReexportationDate = value;
    }

    /**
     * Gets the value of the note property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the note property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getNote().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NoteType }
     * </p>
     * 
     * 
     * @return
     *     The value of the note property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NoteType> getNote() {
        if (note == null) {
            note = new ArrayList<>();
        }
        return this.note;
    }

    /**
     * Gets the value of the customsOfficeLocation property.
     * 
     * @return
     *     possible object is
     *     {@link LocationType }
     *     
     */
    @Nullable
    public LocationType getCustomsOfficeLocation() {
        return customsOfficeLocation;
    }

    /**
     * Sets the value of the customsOfficeLocation property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocationType }
     *     
     */
    public void setCustomsOfficeLocation(
        @Nullable
        LocationType value) {
        this.customsOfficeLocation = value;
    }

    /**
     * Gets the value of the goodsItem property.
     * 
     * @return
     *     possible object is
     *     {@link GoodsItemType }
     *     
     */
    @Nullable
    public GoodsItemType getGoodsItem() {
        return goodsItem;
    }

    /**
     * Sets the value of the goodsItem property.
     * 
     * @param value
     *     allowed object is
     *     {@link GoodsItemType }
     *     
     */
    public void setGoodsItem(
        @Nullable
        GoodsItemType value) {
        this.goodsItem = value;
    }

    /**
     * Gets the value of the exportationDocumentReference property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the exportationDocumentReference property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getExportationDocumentReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentReferenceType }
     * </p>
     * 
     * 
     * @return
     *     The value of the exportationDocumentReference property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentReferenceType> getExportationDocumentReference() {
        if (exportationDocumentReference == null) {
            exportationDocumentReference = new ArrayList<>();
        }
        return this.exportationDocumentReference;
    }

    /**
     * Gets the value of the importationDocumentReference property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the importationDocumentReference property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getImportationDocumentReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentReferenceType }
     * </p>
     * 
     * 
     * @return
     *     The value of the importationDocumentReference property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentReferenceType> getImportationDocumentReference() {
        if (importationDocumentReference == null) {
            importationDocumentReference = new ArrayList<>();
        }
        return this.importationDocumentReference;
    }

    /**
     * Gets the value of the reexportationDocumentReference property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the reexportationDocumentReference property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getReexportationDocumentReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentReferenceType }
     * </p>
     * 
     * 
     * @return
     *     The value of the reexportationDocumentReference property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentReferenceType> getReexportationDocumentReference() {
        if (reexportationDocumentReference == null) {
            reexportationDocumentReference = new ArrayList<>();
        }
        return this.reexportationDocumentReference;
    }

    /**
     * Gets the value of the reimportationDocumentReference property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the reimportationDocumentReference property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getReimportationDocumentReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentReferenceType }
     * </p>
     * 
     * 
     * @return
     *     The value of the reimportationDocumentReference property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentReferenceType> getReimportationDocumentReference() {
        if (reimportationDocumentReference == null) {
            reimportationDocumentReference = new ArrayList<>();
        }
        return this.reimportationDocumentReference;
    }

    /**
     * Gets the value of the voucherDocumentReference property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the voucherDocumentReference property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getVoucherDocumentReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentReferenceType }
     * </p>
     * 
     * 
     * @return
     *     The value of the voucherDocumentReference property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentReferenceType> getVoucherDocumentReference() {
        if (voucherDocumentReference == null) {
            voucherDocumentReference = new ArrayList<>();
        }
        return this.voucherDocumentReference;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final GoodsItemPassportCounterfoilType rhs = ((GoodsItemPassportCounterfoilType) o);
        if (!EqualsHelper.equals(customsOfficeLocation, rhs.customsOfficeLocation)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(exportationDocumentReference, rhs.exportationDocumentReference)) {
            return false;
        }
        if (!EqualsHelper.equals(finalReexportationDate, rhs.finalReexportationDate)) {
            return false;
        }
        if (!EqualsHelper.equals(goodsItem, rhs.goodsItem)) {
            return false;
        }
        if (!EqualsHelper.equals(goodsItemPassportID, rhs.goodsItemPassportID)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(importationDocumentReference, rhs.importationDocumentReference)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(note, rhs.note)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(reexportationDocumentReference, rhs.reexportationDocumentReference)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(reimportationDocumentReference, rhs.reimportationDocumentReference)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(voucherDocumentReference, rhs.voucherDocumentReference)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(customsOfficeLocation).append(exportationDocumentReference).append(finalReexportationDate).append(goodsItem).append(goodsItemPassportID).append(id).append(importationDocumentReference).append(note).append(reexportationDocumentReference).append(reimportationDocumentReference).append(ublExtensions).append(voucherDocumentReference).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("customsOfficeLocation", customsOfficeLocation).append("exportationDocumentReference", exportationDocumentReference).append("finalReexportationDate", finalReexportationDate).append("goodsItem", goodsItem).append("goodsItemPassportID", goodsItemPassportID).append("id", id).append("importationDocumentReference", importationDocumentReference).append("note", note).append("reexportationDocumentReference", reexportationDocumentReference).append("reimportationDocumentReference", reimportationDocumentReference).append("ublExtensions", ublExtensions).append("voucherDocumentReference", voucherDocumentReference).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setNote(
        @Nullable
        final List<NoteType> aList) {
        note = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setExportationDocumentReference(
        @Nullable
        final List<DocumentReferenceType> aList) {
        exportationDocumentReference = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setImportationDocumentReference(
        @Nullable
        final List<DocumentReferenceType> aList) {
        importationDocumentReference = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setReexportationDocumentReference(
        @Nullable
        final List<DocumentReferenceType> aList) {
        reexportationDocumentReference = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setReimportationDocumentReference(
        @Nullable
        final List<DocumentReferenceType> aList) {
        reimportationDocumentReference = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setVoucherDocumentReference(
        @Nullable
        final List<DocumentReferenceType> aList) {
        voucherDocumentReference = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoteEntries() {
        return (!getNote().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoNoteEntries() {
        return getNote().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getNoteCount() {
        return getNote().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NoteType getNoteAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getNote().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addNote(
        @Nonnull
        final NoteType elem) {
        getNote().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasExportationDocumentReferenceEntries() {
        return (!getExportationDocumentReference().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoExportationDocumentReferenceEntries() {
        return getExportationDocumentReference().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getExportationDocumentReferenceCount() {
        return getExportationDocumentReference().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentReferenceType getExportationDocumentReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getExportationDocumentReference().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addExportationDocumentReference(
        @Nonnull
        final DocumentReferenceType elem) {
        getExportationDocumentReference().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasImportationDocumentReferenceEntries() {
        return (!getImportationDocumentReference().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoImportationDocumentReferenceEntries() {
        return getImportationDocumentReference().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getImportationDocumentReferenceCount() {
        return getImportationDocumentReference().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentReferenceType getImportationDocumentReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getImportationDocumentReference().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addImportationDocumentReference(
        @Nonnull
        final DocumentReferenceType elem) {
        getImportationDocumentReference().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasReexportationDocumentReferenceEntries() {
        return (!getReexportationDocumentReference().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoReexportationDocumentReferenceEntries() {
        return getReexportationDocumentReference().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getReexportationDocumentReferenceCount() {
        return getReexportationDocumentReference().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentReferenceType getReexportationDocumentReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getReexportationDocumentReference().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addReexportationDocumentReference(
        @Nonnull
        final DocumentReferenceType elem) {
        getReexportationDocumentReference().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasReimportationDocumentReferenceEntries() {
        return (!getReimportationDocumentReference().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoReimportationDocumentReferenceEntries() {
        return getReimportationDocumentReference().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getReimportationDocumentReferenceCount() {
        return getReimportationDocumentReference().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentReferenceType getReimportationDocumentReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getReimportationDocumentReference().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addReimportationDocumentReference(
        @Nonnull
        final DocumentReferenceType elem) {
        getReimportationDocumentReference().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasVoucherDocumentReferenceEntries() {
        return (!getVoucherDocumentReference().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoVoucherDocumentReferenceEntries() {
        return getVoucherDocumentReference().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getVoucherDocumentReferenceCount() {
        return getVoucherDocumentReference().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentReferenceType getVoucherDocumentReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getVoucherDocumentReference().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addVoucherDocumentReference(
        @Nonnull
        final DocumentReferenceType elem) {
        getVoucherDocumentReference().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        GoodsItemPassportCounterfoilType ret) {
        ret.customsOfficeLocation = ((customsOfficeLocation == null)?null:customsOfficeLocation.clone());
        if (exportationDocumentReference == null) {
            ret.exportationDocumentReference = null;
        } else {
            List<DocumentReferenceType> retExportationDocumentReference = new ArrayList<>();
            for (DocumentReferenceType aItem: getExportationDocumentReference()) {
                retExportationDocumentReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.exportationDocumentReference = retExportationDocumentReference;
        }
        ret.finalReexportationDate = ((finalReexportationDate == null)?null:finalReexportationDate.clone());
        ret.goodsItem = ((goodsItem == null)?null:goodsItem.clone());
        ret.goodsItemPassportID = ((goodsItemPassportID == null)?null:goodsItemPassportID.clone());
        ret.id = ((id == null)?null:id.clone());
        if (importationDocumentReference == null) {
            ret.importationDocumentReference = null;
        } else {
            List<DocumentReferenceType> retImportationDocumentReference = new ArrayList<>();
            for (DocumentReferenceType aItem: getImportationDocumentReference()) {
                retImportationDocumentReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.importationDocumentReference = retImportationDocumentReference;
        }
        if (note == null) {
            ret.note = null;
        } else {
            List<NoteType> retNote = new ArrayList<>();
            for (NoteType aItem: getNote()) {
                retNote.add(((aItem == null)?null:aItem.clone()));
            }
            ret.note = retNote;
        }
        if (reexportationDocumentReference == null) {
            ret.reexportationDocumentReference = null;
        } else {
            List<DocumentReferenceType> retReexportationDocumentReference = new ArrayList<>();
            for (DocumentReferenceType aItem: getReexportationDocumentReference()) {
                retReexportationDocumentReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.reexportationDocumentReference = retReexportationDocumentReference;
        }
        if (reimportationDocumentReference == null) {
            ret.reimportationDocumentReference = null;
        } else {
            List<DocumentReferenceType> retReimportationDocumentReference = new ArrayList<>();
            for (DocumentReferenceType aItem: getReimportationDocumentReference()) {
                retReimportationDocumentReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.reimportationDocumentReference = retReimportationDocumentReference;
        }
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
        if (voucherDocumentReference == null) {
            ret.voucherDocumentReference = null;
        } else {
            List<DocumentReferenceType> retVoucherDocumentReference = new ArrayList<>();
            for (DocumentReferenceType aItem: getVoucherDocumentReference()) {
                retVoucherDocumentReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.voucherDocumentReference = retVoucherDocumentReference;
        }
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public GoodsItemPassportCounterfoilType clone() {
        GoodsItemPassportCounterfoilType ret = new GoodsItemPassportCounterfoilType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type GoodsItemPassportIDType and never <code>null</code>
     */
    @Nonnull
    public GoodsItemPassportIDType setGoodsItemPassportID(
        @Nullable
        final String valueParam) {
        GoodsItemPassportIDType aObj = getGoodsItemPassportID();
        if (aObj == null) {
            aObj = new GoodsItemPassportIDType(valueParam);
            setGoodsItemPassportID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type FinalReexportationDateType and never <code>null</code>
     */
    @Nonnull
    public FinalReexportationDateType setFinalReexportationDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        FinalReexportationDateType aObj = getFinalReexportationDate();
        if (aObj == null) {
            aObj = new FinalReexportationDateType(valueParam);
            setFinalReexportationDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type FinalReexportationDateType and never <code>null</code>
     */
    @Nonnull
    public FinalReexportationDateType setFinalReexportationDate(
        @Nullable
        final LocalDate valueParam) {
        FinalReexportationDateType aObj = getFinalReexportationDate();
        if (aObj == null) {
            aObj = new FinalReexportationDateType(valueParam);
            setFinalReexportationDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained GoodsItemPassportIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained GoodsItemPassportIDType object or <code>null</code>
     */
    @Nullable
    public String getGoodsItemPassportIDValue() {
        GoodsItemPassportIDType aObj = getGoodsItemPassportID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained FinalReexportationDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained FinalReexportationDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getFinalReexportationDateValue() {
        FinalReexportationDateType aObj = getFinalReexportationDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained FinalReexportationDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained FinalReexportationDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getFinalReexportationDateValueLocal() {
        FinalReexportationDateType aObj = getFinalReexportationDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

}
