
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ChargeableQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ChargeableWeightMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.CustomsImportClassifiedIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.CustomsProcedureCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.CustomsStatusCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.CustomsTariffQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.DeclaredCustomsValueAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.DeclaredForCarriageValueAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.DeclaredStatisticsValueAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.FreeOnBoardValueAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.GrossVolumeMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.GrossWeightMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.HazardousRiskIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.InsuranceValueAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.NetNetWeightMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.NetVolumeMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.NetWeightMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.PreferenceCriterionCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.QuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.RequiredCustomsIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ReturnableQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.SequenceNumberIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TraceIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ValueAmountType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for GoodsItemType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="GoodsItemType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}SequenceNumberID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Description" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}HazardousRiskIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}DeclaredCustomsValueAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}DeclaredForCarriageValueAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}DeclaredStatisticsValueAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}FreeOnBoardValueAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}InsuranceValueAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ValueAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}GrossWeightMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}NetWeightMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}NetNetWeightMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ChargeableWeightMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}GrossVolumeMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}NetVolumeMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Quantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PreferenceCriterionCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}RequiredCustomsID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CustomsStatusCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CustomsProcedureCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CustomsTariffQuantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CustomsImportClassifiedIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ChargeableQuantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ReturnableQuantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TraceID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Item" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}GoodsItemContainer" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}FreightAllowanceCharge" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}InvoiceLine" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}OrderLineReference" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}DespatchLineReference" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ReceiptLineReference" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Temperature" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ContainedGoodsItem" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}OriginAddress" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Delivery" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Pickup" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Despatch" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}BondedWarehouseLocation" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}MeasurementDimension" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ContainingPackage" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ShipmentDocumentReference" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}AdditionalDocumentReference" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}MinimumTemperature" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}MaximumTemperature" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "GoodsItemType", propOrder = {
    "ublExtensions",
    "id",
    "sequenceNumberID",
    "description",
    "hazardousRiskIndicator",
    "declaredCustomsValueAmount",
    "declaredForCarriageValueAmount",
    "declaredStatisticsValueAmount",
    "freeOnBoardValueAmount",
    "insuranceValueAmount",
    "valueAmount",
    "grossWeightMeasure",
    "netWeightMeasure",
    "netNetWeightMeasure",
    "chargeableWeightMeasure",
    "grossVolumeMeasure",
    "netVolumeMeasure",
    "quantity",
    "preferenceCriterionCode",
    "requiredCustomsID",
    "customsStatusCode",
    "customsProcedureCode",
    "customsTariffQuantity",
    "customsImportClassifiedIndicator",
    "chargeableQuantity",
    "returnableQuantity",
    "traceID",
    "item",
    "goodsItemContainer",
    "freightAllowanceCharge",
    "invoiceLine",
    "orderLineReference",
    "despatchLineReference",
    "receiptLineReference",
    "temperature",
    "containedGoodsItem",
    "originAddress",
    "delivery",
    "pickup",
    "despatch",
    "bondedWarehouseLocation",
    "measurementDimension",
    "containingPackage",
    "shipmentDocumentReference",
    "additionalDocumentReference",
    "minimumTemperature",
    "maximumTemperature"
})
@CodingStyleguideUnaware
public class GoodsItemType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IDType id;
    @XmlElement(name = "SequenceNumberID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private SequenceNumberIDType sequenceNumberID;
    @XmlElement(name = "Description", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<DescriptionType> description;
    @XmlElement(name = "HazardousRiskIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private HazardousRiskIndicatorType hazardousRiskIndicator;
    @XmlElement(name = "DeclaredCustomsValueAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private DeclaredCustomsValueAmountType declaredCustomsValueAmount;
    @XmlElement(name = "DeclaredForCarriageValueAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private DeclaredForCarriageValueAmountType declaredForCarriageValueAmount;
    @XmlElement(name = "DeclaredStatisticsValueAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private DeclaredStatisticsValueAmountType declaredStatisticsValueAmount;
    @XmlElement(name = "FreeOnBoardValueAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private FreeOnBoardValueAmountType freeOnBoardValueAmount;
    @XmlElement(name = "InsuranceValueAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private InsuranceValueAmountType insuranceValueAmount;
    @XmlElement(name = "ValueAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ValueAmountType valueAmount;
    @XmlElement(name = "GrossWeightMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private GrossWeightMeasureType grossWeightMeasure;
    @XmlElement(name = "NetWeightMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private NetWeightMeasureType netWeightMeasure;
    @XmlElement(name = "NetNetWeightMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private NetNetWeightMeasureType netNetWeightMeasure;
    @XmlElement(name = "ChargeableWeightMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ChargeableWeightMeasureType chargeableWeightMeasure;
    @XmlElement(name = "GrossVolumeMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private GrossVolumeMeasureType grossVolumeMeasure;
    @XmlElement(name = "NetVolumeMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private NetVolumeMeasureType netVolumeMeasure;
    @XmlElement(name = "Quantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private QuantityType quantity;
    @XmlElement(name = "PreferenceCriterionCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PreferenceCriterionCodeType preferenceCriterionCode;
    @XmlElement(name = "RequiredCustomsID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private RequiredCustomsIDType requiredCustomsID;
    @XmlElement(name = "CustomsStatusCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private CustomsStatusCodeType customsStatusCode;
    @XmlElement(name = "CustomsProcedureCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private CustomsProcedureCodeType customsProcedureCode;
    @XmlElement(name = "CustomsTariffQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private CustomsTariffQuantityType customsTariffQuantity;
    @XmlElement(name = "CustomsImportClassifiedIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private CustomsImportClassifiedIndicatorType customsImportClassifiedIndicator;
    @XmlElement(name = "ChargeableQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ChargeableQuantityType chargeableQuantity;
    @XmlElement(name = "ReturnableQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ReturnableQuantityType returnableQuantity;
    @XmlElement(name = "TraceID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TraceIDType traceID;
    @XmlElement(name = "Item")
    private List<ItemType> item;
    @XmlElement(name = "GoodsItemContainer")
    private List<GoodsItemContainerType> goodsItemContainer;
    @XmlElement(name = "FreightAllowanceCharge")
    private List<AllowanceChargeType> freightAllowanceCharge;
    @XmlElement(name = "InvoiceLine")
    private List<InvoiceLineType> invoiceLine;
    @XmlElement(name = "OrderLineReference")
    private List<OrderLineReferenceType> orderLineReference;
    @XmlElement(name = "DespatchLineReference")
    private LineReferenceType despatchLineReference;
    @XmlElement(name = "ReceiptLineReference")
    private LineReferenceType receiptLineReference;
    @XmlElement(name = "Temperature")
    private List<TemperatureType> temperature;
    @XmlElement(name = "ContainedGoodsItem")
    private List<GoodsItemType> containedGoodsItem;
    @XmlElement(name = "OriginAddress")
    private AddressType originAddress;
    @XmlElement(name = "Delivery")
    private DeliveryType delivery;
    @XmlElement(name = "Pickup")
    private PickupType pickup;
    @XmlElement(name = "Despatch")
    private DespatchType despatch;
    @XmlElement(name = "BondedWarehouseLocation")
    private LocationType bondedWarehouseLocation;
    @XmlElement(name = "MeasurementDimension")
    private List<DimensionType> measurementDimension;
    @XmlElement(name = "ContainingPackage")
    private List<PackageType> containingPackage;
    @XmlElement(name = "ShipmentDocumentReference")
    private DocumentReferenceType shipmentDocumentReference;
    @XmlElement(name = "AdditionalDocumentReference")
    private List<DocumentReferenceType> additionalDocumentReference;
    @XmlElement(name = "MinimumTemperature")
    private TemperatureType minimumTemperature;
    @XmlElement(name = "MaximumTemperature")
    private TemperatureType maximumTemperature;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public GoodsItemType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the sequenceNumberID property.
     * 
     * @return
     *     possible object is
     *     {@link SequenceNumberIDType }
     *     
     */
    @Nullable
    public SequenceNumberIDType getSequenceNumberID() {
        return sequenceNumberID;
    }

    /**
     * Sets the value of the sequenceNumberID property.
     * 
     * @param value
     *     allowed object is
     *     {@link SequenceNumberIDType }
     *     
     */
    public void setSequenceNumberID(
        @Nullable
        SequenceNumberIDType value) {
        this.sequenceNumberID = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the description property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the description property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DescriptionType> getDescription() {
        if (description == null) {
            description = new ArrayList<>();
        }
        return this.description;
    }

    /**
     * Gets the value of the hazardousRiskIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link HazardousRiskIndicatorType }
     *     
     */
    @Nullable
    public HazardousRiskIndicatorType getHazardousRiskIndicator() {
        return hazardousRiskIndicator;
    }

    /**
     * Sets the value of the hazardousRiskIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link HazardousRiskIndicatorType }
     *     
     */
    public void setHazardousRiskIndicator(
        @Nullable
        HazardousRiskIndicatorType value) {
        this.hazardousRiskIndicator = value;
    }

    /**
     * Gets the value of the declaredCustomsValueAmount property.
     * 
     * @return
     *     possible object is
     *     {@link DeclaredCustomsValueAmountType }
     *     
     */
    @Nullable
    public DeclaredCustomsValueAmountType getDeclaredCustomsValueAmount() {
        return declaredCustomsValueAmount;
    }

    /**
     * Sets the value of the declaredCustomsValueAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link DeclaredCustomsValueAmountType }
     *     
     */
    public void setDeclaredCustomsValueAmount(
        @Nullable
        DeclaredCustomsValueAmountType value) {
        this.declaredCustomsValueAmount = value;
    }

    /**
     * Gets the value of the declaredForCarriageValueAmount property.
     * 
     * @return
     *     possible object is
     *     {@link DeclaredForCarriageValueAmountType }
     *     
     */
    @Nullable
    public DeclaredForCarriageValueAmountType getDeclaredForCarriageValueAmount() {
        return declaredForCarriageValueAmount;
    }

    /**
     * Sets the value of the declaredForCarriageValueAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link DeclaredForCarriageValueAmountType }
     *     
     */
    public void setDeclaredForCarriageValueAmount(
        @Nullable
        DeclaredForCarriageValueAmountType value) {
        this.declaredForCarriageValueAmount = value;
    }

    /**
     * Gets the value of the declaredStatisticsValueAmount property.
     * 
     * @return
     *     possible object is
     *     {@link DeclaredStatisticsValueAmountType }
     *     
     */
    @Nullable
    public DeclaredStatisticsValueAmountType getDeclaredStatisticsValueAmount() {
        return declaredStatisticsValueAmount;
    }

    /**
     * Sets the value of the declaredStatisticsValueAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link DeclaredStatisticsValueAmountType }
     *     
     */
    public void setDeclaredStatisticsValueAmount(
        @Nullable
        DeclaredStatisticsValueAmountType value) {
        this.declaredStatisticsValueAmount = value;
    }

    /**
     * Gets the value of the freeOnBoardValueAmount property.
     * 
     * @return
     *     possible object is
     *     {@link FreeOnBoardValueAmountType }
     *     
     */
    @Nullable
    public FreeOnBoardValueAmountType getFreeOnBoardValueAmount() {
        return freeOnBoardValueAmount;
    }

    /**
     * Sets the value of the freeOnBoardValueAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link FreeOnBoardValueAmountType }
     *     
     */
    public void setFreeOnBoardValueAmount(
        @Nullable
        FreeOnBoardValueAmountType value) {
        this.freeOnBoardValueAmount = value;
    }

    /**
     * Gets the value of the insuranceValueAmount property.
     * 
     * @return
     *     possible object is
     *     {@link InsuranceValueAmountType }
     *     
     */
    @Nullable
    public InsuranceValueAmountType getInsuranceValueAmount() {
        return insuranceValueAmount;
    }

    /**
     * Sets the value of the insuranceValueAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link InsuranceValueAmountType }
     *     
     */
    public void setInsuranceValueAmount(
        @Nullable
        InsuranceValueAmountType value) {
        this.insuranceValueAmount = value;
    }

    /**
     * Gets the value of the valueAmount property.
     * 
     * @return
     *     possible object is
     *     {@link ValueAmountType }
     *     
     */
    @Nullable
    public ValueAmountType getValueAmount() {
        return valueAmount;
    }

    /**
     * Sets the value of the valueAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link ValueAmountType }
     *     
     */
    public void setValueAmount(
        @Nullable
        ValueAmountType value) {
        this.valueAmount = value;
    }

    /**
     * Gets the value of the grossWeightMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link GrossWeightMeasureType }
     *     
     */
    @Nullable
    public GrossWeightMeasureType getGrossWeightMeasure() {
        return grossWeightMeasure;
    }

    /**
     * Sets the value of the grossWeightMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link GrossWeightMeasureType }
     *     
     */
    public void setGrossWeightMeasure(
        @Nullable
        GrossWeightMeasureType value) {
        this.grossWeightMeasure = value;
    }

    /**
     * Gets the value of the netWeightMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link NetWeightMeasureType }
     *     
     */
    @Nullable
    public NetWeightMeasureType getNetWeightMeasure() {
        return netWeightMeasure;
    }

    /**
     * Sets the value of the netWeightMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link NetWeightMeasureType }
     *     
     */
    public void setNetWeightMeasure(
        @Nullable
        NetWeightMeasureType value) {
        this.netWeightMeasure = value;
    }

    /**
     * Gets the value of the netNetWeightMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link NetNetWeightMeasureType }
     *     
     */
    @Nullable
    public NetNetWeightMeasureType getNetNetWeightMeasure() {
        return netNetWeightMeasure;
    }

    /**
     * Sets the value of the netNetWeightMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link NetNetWeightMeasureType }
     *     
     */
    public void setNetNetWeightMeasure(
        @Nullable
        NetNetWeightMeasureType value) {
        this.netNetWeightMeasure = value;
    }

    /**
     * Gets the value of the chargeableWeightMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link ChargeableWeightMeasureType }
     *     
     */
    @Nullable
    public ChargeableWeightMeasureType getChargeableWeightMeasure() {
        return chargeableWeightMeasure;
    }

    /**
     * Sets the value of the chargeableWeightMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link ChargeableWeightMeasureType }
     *     
     */
    public void setChargeableWeightMeasure(
        @Nullable
        ChargeableWeightMeasureType value) {
        this.chargeableWeightMeasure = value;
    }

    /**
     * Gets the value of the grossVolumeMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link GrossVolumeMeasureType }
     *     
     */
    @Nullable
    public GrossVolumeMeasureType getGrossVolumeMeasure() {
        return grossVolumeMeasure;
    }

    /**
     * Sets the value of the grossVolumeMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link GrossVolumeMeasureType }
     *     
     */
    public void setGrossVolumeMeasure(
        @Nullable
        GrossVolumeMeasureType value) {
        this.grossVolumeMeasure = value;
    }

    /**
     * Gets the value of the netVolumeMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link NetVolumeMeasureType }
     *     
     */
    @Nullable
    public NetVolumeMeasureType getNetVolumeMeasure() {
        return netVolumeMeasure;
    }

    /**
     * Sets the value of the netVolumeMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link NetVolumeMeasureType }
     *     
     */
    public void setNetVolumeMeasure(
        @Nullable
        NetVolumeMeasureType value) {
        this.netVolumeMeasure = value;
    }

    /**
     * Gets the value of the quantity property.
     * 
     * @return
     *     possible object is
     *     {@link QuantityType }
     *     
     */
    @Nullable
    public QuantityType getQuantity() {
        return quantity;
    }

    /**
     * Sets the value of the quantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityType }
     *     
     */
    public void setQuantity(
        @Nullable
        QuantityType value) {
        this.quantity = value;
    }

    /**
     * Gets the value of the preferenceCriterionCode property.
     * 
     * @return
     *     possible object is
     *     {@link PreferenceCriterionCodeType }
     *     
     */
    @Nullable
    public PreferenceCriterionCodeType getPreferenceCriterionCode() {
        return preferenceCriterionCode;
    }

    /**
     * Sets the value of the preferenceCriterionCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link PreferenceCriterionCodeType }
     *     
     */
    public void setPreferenceCriterionCode(
        @Nullable
        PreferenceCriterionCodeType value) {
        this.preferenceCriterionCode = value;
    }

    /**
     * Gets the value of the requiredCustomsID property.
     * 
     * @return
     *     possible object is
     *     {@link RequiredCustomsIDType }
     *     
     */
    @Nullable
    public RequiredCustomsIDType getRequiredCustomsID() {
        return requiredCustomsID;
    }

    /**
     * Sets the value of the requiredCustomsID property.
     * 
     * @param value
     *     allowed object is
     *     {@link RequiredCustomsIDType }
     *     
     */
    public void setRequiredCustomsID(
        @Nullable
        RequiredCustomsIDType value) {
        this.requiredCustomsID = value;
    }

    /**
     * Gets the value of the customsStatusCode property.
     * 
     * @return
     *     possible object is
     *     {@link CustomsStatusCodeType }
     *     
     */
    @Nullable
    public CustomsStatusCodeType getCustomsStatusCode() {
        return customsStatusCode;
    }

    /**
     * Sets the value of the customsStatusCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CustomsStatusCodeType }
     *     
     */
    public void setCustomsStatusCode(
        @Nullable
        CustomsStatusCodeType value) {
        this.customsStatusCode = value;
    }

    /**
     * Gets the value of the customsProcedureCode property.
     * 
     * @return
     *     possible object is
     *     {@link CustomsProcedureCodeType }
     *     
     */
    @Nullable
    public CustomsProcedureCodeType getCustomsProcedureCode() {
        return customsProcedureCode;
    }

    /**
     * Sets the value of the customsProcedureCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CustomsProcedureCodeType }
     *     
     */
    public void setCustomsProcedureCode(
        @Nullable
        CustomsProcedureCodeType value) {
        this.customsProcedureCode = value;
    }

    /**
     * Gets the value of the customsTariffQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link CustomsTariffQuantityType }
     *     
     */
    @Nullable
    public CustomsTariffQuantityType getCustomsTariffQuantity() {
        return customsTariffQuantity;
    }

    /**
     * Sets the value of the customsTariffQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link CustomsTariffQuantityType }
     *     
     */
    public void setCustomsTariffQuantity(
        @Nullable
        CustomsTariffQuantityType value) {
        this.customsTariffQuantity = value;
    }

    /**
     * Gets the value of the customsImportClassifiedIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link CustomsImportClassifiedIndicatorType }
     *     
     */
    @Nullable
    public CustomsImportClassifiedIndicatorType getCustomsImportClassifiedIndicator() {
        return customsImportClassifiedIndicator;
    }

    /**
     * Sets the value of the customsImportClassifiedIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link CustomsImportClassifiedIndicatorType }
     *     
     */
    public void setCustomsImportClassifiedIndicator(
        @Nullable
        CustomsImportClassifiedIndicatorType value) {
        this.customsImportClassifiedIndicator = value;
    }

    /**
     * Gets the value of the chargeableQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link ChargeableQuantityType }
     *     
     */
    @Nullable
    public ChargeableQuantityType getChargeableQuantity() {
        return chargeableQuantity;
    }

    /**
     * Sets the value of the chargeableQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link ChargeableQuantityType }
     *     
     */
    public void setChargeableQuantity(
        @Nullable
        ChargeableQuantityType value) {
        this.chargeableQuantity = value;
    }

    /**
     * Gets the value of the returnableQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link ReturnableQuantityType }
     *     
     */
    @Nullable
    public ReturnableQuantityType getReturnableQuantity() {
        return returnableQuantity;
    }

    /**
     * Sets the value of the returnableQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReturnableQuantityType }
     *     
     */
    public void setReturnableQuantity(
        @Nullable
        ReturnableQuantityType value) {
        this.returnableQuantity = value;
    }

    /**
     * Gets the value of the traceID property.
     * 
     * @return
     *     possible object is
     *     {@link TraceIDType }
     *     
     */
    @Nullable
    public TraceIDType getTraceID() {
        return traceID;
    }

    /**
     * Sets the value of the traceID property.
     * 
     * @param value
     *     allowed object is
     *     {@link TraceIDType }
     *     
     */
    public void setTraceID(
        @Nullable
        TraceIDType value) {
        this.traceID = value;
    }

    /**
     * Gets the value of the item property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the item property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getItem().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ItemType }
     * </p>
     * 
     * 
     * @return
     *     The value of the item property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ItemType> getItem() {
        if (item == null) {
            item = new ArrayList<>();
        }
        return this.item;
    }

    /**
     * Gets the value of the goodsItemContainer property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the goodsItemContainer property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getGoodsItemContainer().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link GoodsItemContainerType }
     * </p>
     * 
     * 
     * @return
     *     The value of the goodsItemContainer property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<GoodsItemContainerType> getGoodsItemContainer() {
        if (goodsItemContainer == null) {
            goodsItemContainer = new ArrayList<>();
        }
        return this.goodsItemContainer;
    }

    /**
     * Gets the value of the freightAllowanceCharge property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the freightAllowanceCharge property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getFreightAllowanceCharge().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AllowanceChargeType }
     * </p>
     * 
     * 
     * @return
     *     The value of the freightAllowanceCharge property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AllowanceChargeType> getFreightAllowanceCharge() {
        if (freightAllowanceCharge == null) {
            freightAllowanceCharge = new ArrayList<>();
        }
        return this.freightAllowanceCharge;
    }

    /**
     * Gets the value of the invoiceLine property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the invoiceLine property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getInvoiceLine().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link InvoiceLineType }
     * </p>
     * 
     * 
     * @return
     *     The value of the invoiceLine property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<InvoiceLineType> getInvoiceLine() {
        if (invoiceLine == null) {
            invoiceLine = new ArrayList<>();
        }
        return this.invoiceLine;
    }

    /**
     * Gets the value of the orderLineReference property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the orderLineReference property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getOrderLineReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link OrderLineReferenceType }
     * </p>
     * 
     * 
     * @return
     *     The value of the orderLineReference property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<OrderLineReferenceType> getOrderLineReference() {
        if (orderLineReference == null) {
            orderLineReference = new ArrayList<>();
        }
        return this.orderLineReference;
    }

    /**
     * Gets the value of the despatchLineReference property.
     * 
     * @return
     *     possible object is
     *     {@link LineReferenceType }
     *     
     */
    @Nullable
    public LineReferenceType getDespatchLineReference() {
        return despatchLineReference;
    }

    /**
     * Sets the value of the despatchLineReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link LineReferenceType }
     *     
     */
    public void setDespatchLineReference(
        @Nullable
        LineReferenceType value) {
        this.despatchLineReference = value;
    }

    /**
     * Gets the value of the receiptLineReference property.
     * 
     * @return
     *     possible object is
     *     {@link LineReferenceType }
     *     
     */
    @Nullable
    public LineReferenceType getReceiptLineReference() {
        return receiptLineReference;
    }

    /**
     * Sets the value of the receiptLineReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link LineReferenceType }
     *     
     */
    public void setReceiptLineReference(
        @Nullable
        LineReferenceType value) {
        this.receiptLineReference = value;
    }

    /**
     * Gets the value of the temperature property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the temperature property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getTemperature().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TemperatureType }
     * </p>
     * 
     * 
     * @return
     *     The value of the temperature property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TemperatureType> getTemperature() {
        if (temperature == null) {
            temperature = new ArrayList<>();
        }
        return this.temperature;
    }

    /**
     * Gets the value of the containedGoodsItem property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the containedGoodsItem property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getContainedGoodsItem().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link GoodsItemType }
     * </p>
     * 
     * 
     * @return
     *     The value of the containedGoodsItem property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<GoodsItemType> getContainedGoodsItem() {
        if (containedGoodsItem == null) {
            containedGoodsItem = new ArrayList<>();
        }
        return this.containedGoodsItem;
    }

    /**
     * Gets the value of the originAddress property.
     * 
     * @return
     *     possible object is
     *     {@link AddressType }
     *     
     */
    @Nullable
    public AddressType getOriginAddress() {
        return originAddress;
    }

    /**
     * Sets the value of the originAddress property.
     * 
     * @param value
     *     allowed object is
     *     {@link AddressType }
     *     
     */
    public void setOriginAddress(
        @Nullable
        AddressType value) {
        this.originAddress = value;
    }

    /**
     * Gets the value of the delivery property.
     * 
     * @return
     *     possible object is
     *     {@link DeliveryType }
     *     
     */
    @Nullable
    public DeliveryType getDelivery() {
        return delivery;
    }

    /**
     * Sets the value of the delivery property.
     * 
     * @param value
     *     allowed object is
     *     {@link DeliveryType }
     *     
     */
    public void setDelivery(
        @Nullable
        DeliveryType value) {
        this.delivery = value;
    }

    /**
     * Gets the value of the pickup property.
     * 
     * @return
     *     possible object is
     *     {@link PickupType }
     *     
     */
    @Nullable
    public PickupType getPickup() {
        return pickup;
    }

    /**
     * Sets the value of the pickup property.
     * 
     * @param value
     *     allowed object is
     *     {@link PickupType }
     *     
     */
    public void setPickup(
        @Nullable
        PickupType value) {
        this.pickup = value;
    }

    /**
     * Gets the value of the despatch property.
     * 
     * @return
     *     possible object is
     *     {@link DespatchType }
     *     
     */
    @Nullable
    public DespatchType getDespatch() {
        return despatch;
    }

    /**
     * Sets the value of the despatch property.
     * 
     * @param value
     *     allowed object is
     *     {@link DespatchType }
     *     
     */
    public void setDespatch(
        @Nullable
        DespatchType value) {
        this.despatch = value;
    }

    /**
     * Gets the value of the bondedWarehouseLocation property.
     * 
     * @return
     *     possible object is
     *     {@link LocationType }
     *     
     */
    @Nullable
    public LocationType getBondedWarehouseLocation() {
        return bondedWarehouseLocation;
    }

    /**
     * Sets the value of the bondedWarehouseLocation property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocationType }
     *     
     */
    public void setBondedWarehouseLocation(
        @Nullable
        LocationType value) {
        this.bondedWarehouseLocation = value;
    }

    /**
     * Gets the value of the measurementDimension property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the measurementDimension property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getMeasurementDimension().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DimensionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the measurementDimension property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DimensionType> getMeasurementDimension() {
        if (measurementDimension == null) {
            measurementDimension = new ArrayList<>();
        }
        return this.measurementDimension;
    }

    /**
     * Gets the value of the containingPackage property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the containingPackage property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getContainingPackage().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PackageType }
     * </p>
     * 
     * 
     * @return
     *     The value of the containingPackage property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PackageType> getContainingPackage() {
        if (containingPackage == null) {
            containingPackage = new ArrayList<>();
        }
        return this.containingPackage;
    }

    /**
     * Gets the value of the shipmentDocumentReference property.
     * 
     * @return
     *     possible object is
     *     {@link DocumentReferenceType }
     *     
     */
    @Nullable
    public DocumentReferenceType getShipmentDocumentReference() {
        return shipmentDocumentReference;
    }

    /**
     * Sets the value of the shipmentDocumentReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link DocumentReferenceType }
     *     
     */
    public void setShipmentDocumentReference(
        @Nullable
        DocumentReferenceType value) {
        this.shipmentDocumentReference = value;
    }

    /**
     * Gets the value of the additionalDocumentReference property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the additionalDocumentReference property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getAdditionalDocumentReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentReferenceType }
     * </p>
     * 
     * 
     * @return
     *     The value of the additionalDocumentReference property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentReferenceType> getAdditionalDocumentReference() {
        if (additionalDocumentReference == null) {
            additionalDocumentReference = new ArrayList<>();
        }
        return this.additionalDocumentReference;
    }

    /**
     * Gets the value of the minimumTemperature property.
     * 
     * @return
     *     possible object is
     *     {@link TemperatureType }
     *     
     */
    @Nullable
    public TemperatureType getMinimumTemperature() {
        return minimumTemperature;
    }

    /**
     * Sets the value of the minimumTemperature property.
     * 
     * @param value
     *     allowed object is
     *     {@link TemperatureType }
     *     
     */
    public void setMinimumTemperature(
        @Nullable
        TemperatureType value) {
        this.minimumTemperature = value;
    }

    /**
     * Gets the value of the maximumTemperature property.
     * 
     * @return
     *     possible object is
     *     {@link TemperatureType }
     *     
     */
    @Nullable
    public TemperatureType getMaximumTemperature() {
        return maximumTemperature;
    }

    /**
     * Sets the value of the maximumTemperature property.
     * 
     * @param value
     *     allowed object is
     *     {@link TemperatureType }
     *     
     */
    public void setMaximumTemperature(
        @Nullable
        TemperatureType value) {
        this.maximumTemperature = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final GoodsItemType rhs = ((GoodsItemType) o);
        if (!EqualsHelper.equalsCollection(additionalDocumentReference, rhs.additionalDocumentReference)) {
            return false;
        }
        if (!EqualsHelper.equals(bondedWarehouseLocation, rhs.bondedWarehouseLocation)) {
            return false;
        }
        if (!EqualsHelper.equals(chargeableQuantity, rhs.chargeableQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(chargeableWeightMeasure, rhs.chargeableWeightMeasure)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(containedGoodsItem, rhs.containedGoodsItem)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(containingPackage, rhs.containingPackage)) {
            return false;
        }
        if (!EqualsHelper.equals(customsImportClassifiedIndicator, rhs.customsImportClassifiedIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(customsProcedureCode, rhs.customsProcedureCode)) {
            return false;
        }
        if (!EqualsHelper.equals(customsStatusCode, rhs.customsStatusCode)) {
            return false;
        }
        if (!EqualsHelper.equals(customsTariffQuantity, rhs.customsTariffQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(declaredCustomsValueAmount, rhs.declaredCustomsValueAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(declaredForCarriageValueAmount, rhs.declaredForCarriageValueAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(declaredStatisticsValueAmount, rhs.declaredStatisticsValueAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(delivery, rhs.delivery)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equals(despatch, rhs.despatch)) {
            return false;
        }
        if (!EqualsHelper.equals(despatchLineReference, rhs.despatchLineReference)) {
            return false;
        }
        if (!EqualsHelper.equals(freeOnBoardValueAmount, rhs.freeOnBoardValueAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(freightAllowanceCharge, rhs.freightAllowanceCharge)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(goodsItemContainer, rhs.goodsItemContainer)) {
            return false;
        }
        if (!EqualsHelper.equals(grossVolumeMeasure, rhs.grossVolumeMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(grossWeightMeasure, rhs.grossWeightMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(hazardousRiskIndicator, rhs.hazardousRiskIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(insuranceValueAmount, rhs.insuranceValueAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(invoiceLine, rhs.invoiceLine)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(item, rhs.item)) {
            return false;
        }
        if (!EqualsHelper.equals(maximumTemperature, rhs.maximumTemperature)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(measurementDimension, rhs.measurementDimension)) {
            return false;
        }
        if (!EqualsHelper.equals(minimumTemperature, rhs.minimumTemperature)) {
            return false;
        }
        if (!EqualsHelper.equals(netNetWeightMeasure, rhs.netNetWeightMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(netVolumeMeasure, rhs.netVolumeMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(netWeightMeasure, rhs.netWeightMeasure)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(orderLineReference, rhs.orderLineReference)) {
            return false;
        }
        if (!EqualsHelper.equals(originAddress, rhs.originAddress)) {
            return false;
        }
        if (!EqualsHelper.equals(pickup, rhs.pickup)) {
            return false;
        }
        if (!EqualsHelper.equals(preferenceCriterionCode, rhs.preferenceCriterionCode)) {
            return false;
        }
        if (!EqualsHelper.equals(quantity, rhs.quantity)) {
            return false;
        }
        if (!EqualsHelper.equals(receiptLineReference, rhs.receiptLineReference)) {
            return false;
        }
        if (!EqualsHelper.equals(requiredCustomsID, rhs.requiredCustomsID)) {
            return false;
        }
        if (!EqualsHelper.equals(returnableQuantity, rhs.returnableQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(sequenceNumberID, rhs.sequenceNumberID)) {
            return false;
        }
        if (!EqualsHelper.equals(shipmentDocumentReference, rhs.shipmentDocumentReference)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(temperature, rhs.temperature)) {
            return false;
        }
        if (!EqualsHelper.equals(traceID, rhs.traceID)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        if (!EqualsHelper.equals(valueAmount, rhs.valueAmount)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(additionalDocumentReference).append(bondedWarehouseLocation).append(chargeableQuantity).append(chargeableWeightMeasure).append(containedGoodsItem).append(containingPackage).append(customsImportClassifiedIndicator).append(customsProcedureCode).append(customsStatusCode).append(customsTariffQuantity).append(declaredCustomsValueAmount).append(declaredForCarriageValueAmount).append(declaredStatisticsValueAmount).append(delivery).append(description).append(despatch).append(despatchLineReference).append(freeOnBoardValueAmount).append(freightAllowanceCharge).append(goodsItemContainer).append(grossVolumeMeasure).append(grossWeightMeasure).append(hazardousRiskIndicator).append(id).append(insuranceValueAmount).append(invoiceLine).append(item).append(maximumTemperature).append(measurementDimension).append(minimumTemperature).append(netNetWeightMeasure).append(netVolumeMeasure).append(netWeightMeasure).append(orderLineReference).append(originAddress).append(pickup).append(preferenceCriterionCode).append(quantity).append(receiptLineReference).append(requiredCustomsID).append(returnableQuantity).append(sequenceNumberID).append(shipmentDocumentReference).append(temperature).append(traceID).append(ublExtensions).append(valueAmount).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("additionalDocumentReference", additionalDocumentReference).append("bondedWarehouseLocation", bondedWarehouseLocation).append("chargeableQuantity", chargeableQuantity).append("chargeableWeightMeasure", chargeableWeightMeasure).append("containedGoodsItem", containedGoodsItem).append("containingPackage", containingPackage).append("customsImportClassifiedIndicator", customsImportClassifiedIndicator).append("customsProcedureCode", customsProcedureCode).append("customsStatusCode", customsStatusCode).append("customsTariffQuantity", customsTariffQuantity).append("declaredCustomsValueAmount", declaredCustomsValueAmount).append("declaredForCarriageValueAmount", declaredForCarriageValueAmount).append("declaredStatisticsValueAmount", declaredStatisticsValueAmount).append("delivery", delivery).append("description", description).append("despatch", despatch).append("despatchLineReference", despatchLineReference).append("freeOnBoardValueAmount", freeOnBoardValueAmount).append("freightAllowanceCharge", freightAllowanceCharge).append("goodsItemContainer", goodsItemContainer).append("grossVolumeMeasure", grossVolumeMeasure).append("grossWeightMeasure", grossWeightMeasure).append("hazardousRiskIndicator", hazardousRiskIndicator).append("id", id).append("insuranceValueAmount", insuranceValueAmount).append("invoiceLine", invoiceLine).append("item", item).append("maximumTemperature", maximumTemperature).append("measurementDimension", measurementDimension).append("minimumTemperature", minimumTemperature).append("netNetWeightMeasure", netNetWeightMeasure).append("netVolumeMeasure", netVolumeMeasure).append("netWeightMeasure", netWeightMeasure).append("orderLineReference", orderLineReference).append("originAddress", originAddress).append("pickup", pickup).append("preferenceCriterionCode", preferenceCriterionCode).append("quantity", quantity).append("receiptLineReference", receiptLineReference).append("requiredCustomsID", requiredCustomsID).append("returnableQuantity", returnableQuantity).append("sequenceNumberID", sequenceNumberID).append("shipmentDocumentReference", shipmentDocumentReference).append("temperature", temperature).append("traceID", traceID).append("ublExtensions", ublExtensions).append("valueAmount", valueAmount).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDescription(
        @Nullable
        final List<DescriptionType> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setItem(
        @Nullable
        final List<ItemType> aList) {
        item = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setGoodsItemContainer(
        @Nullable
        final List<GoodsItemContainerType> aList) {
        goodsItemContainer = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setFreightAllowanceCharge(
        @Nullable
        final List<AllowanceChargeType> aList) {
        freightAllowanceCharge = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setInvoiceLine(
        @Nullable
        final List<InvoiceLineType> aList) {
        invoiceLine = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setOrderLineReference(
        @Nullable
        final List<OrderLineReferenceType> aList) {
        orderLineReference = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTemperature(
        @Nullable
        final List<TemperatureType> aList) {
        temperature = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setContainedGoodsItem(
        @Nullable
        final List<GoodsItemType> aList) {
        containedGoodsItem = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setMeasurementDimension(
        @Nullable
        final List<DimensionType> aList) {
        measurementDimension = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setContainingPackage(
        @Nullable
        final List<PackageType> aList) {
        containingPackage = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAdditionalDocumentReference(
        @Nullable
        final List<DocumentReferenceType> aList) {
        additionalDocumentReference = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DescriptionType getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDescription(
        @Nonnull
        final DescriptionType elem) {
        getDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasItemEntries() {
        return (!getItem().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoItemEntries() {
        return getItem().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getItemCount() {
        return getItem().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ItemType getItemAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getItem().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addItem(
        @Nonnull
        final ItemType elem) {
        getItem().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasGoodsItemContainerEntries() {
        return (!getGoodsItemContainer().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoGoodsItemContainerEntries() {
        return getGoodsItemContainer().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getGoodsItemContainerCount() {
        return getGoodsItemContainer().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public GoodsItemContainerType getGoodsItemContainerAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getGoodsItemContainer().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addGoodsItemContainer(
        @Nonnull
        final GoodsItemContainerType elem) {
        getGoodsItemContainer().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasFreightAllowanceChargeEntries() {
        return (!getFreightAllowanceCharge().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoFreightAllowanceChargeEntries() {
        return getFreightAllowanceCharge().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getFreightAllowanceChargeCount() {
        return getFreightAllowanceCharge().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AllowanceChargeType getFreightAllowanceChargeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getFreightAllowanceCharge().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addFreightAllowanceCharge(
        @Nonnull
        final AllowanceChargeType elem) {
        getFreightAllowanceCharge().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasInvoiceLineEntries() {
        return (!getInvoiceLine().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoInvoiceLineEntries() {
        return getInvoiceLine().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getInvoiceLineCount() {
        return getInvoiceLine().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public InvoiceLineType getInvoiceLineAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getInvoiceLine().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addInvoiceLine(
        @Nonnull
        final InvoiceLineType elem) {
        getInvoiceLine().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasOrderLineReferenceEntries() {
        return (!getOrderLineReference().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoOrderLineReferenceEntries() {
        return getOrderLineReference().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getOrderLineReferenceCount() {
        return getOrderLineReference().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public OrderLineReferenceType getOrderLineReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getOrderLineReference().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addOrderLineReference(
        @Nonnull
        final OrderLineReferenceType elem) {
        getOrderLineReference().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTemperatureEntries() {
        return (!getTemperature().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTemperatureEntries() {
        return getTemperature().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTemperatureCount() {
        return getTemperature().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TemperatureType getTemperatureAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTemperature().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTemperature(
        @Nonnull
        final TemperatureType elem) {
        getTemperature().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasContainedGoodsItemEntries() {
        return (!getContainedGoodsItem().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoContainedGoodsItemEntries() {
        return getContainedGoodsItem().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getContainedGoodsItemCount() {
        return getContainedGoodsItem().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public GoodsItemType getContainedGoodsItemAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getContainedGoodsItem().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addContainedGoodsItem(
        @Nonnull
        final GoodsItemType elem) {
        getContainedGoodsItem().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasMeasurementDimensionEntries() {
        return (!getMeasurementDimension().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoMeasurementDimensionEntries() {
        return getMeasurementDimension().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getMeasurementDimensionCount() {
        return getMeasurementDimension().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DimensionType getMeasurementDimensionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getMeasurementDimension().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addMeasurementDimension(
        @Nonnull
        final DimensionType elem) {
        getMeasurementDimension().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasContainingPackageEntries() {
        return (!getContainingPackage().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoContainingPackageEntries() {
        return getContainingPackage().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getContainingPackageCount() {
        return getContainingPackage().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PackageType getContainingPackageAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getContainingPackage().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addContainingPackage(
        @Nonnull
        final PackageType elem) {
        getContainingPackage().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAdditionalDocumentReferenceEntries() {
        return (!getAdditionalDocumentReference().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAdditionalDocumentReferenceEntries() {
        return getAdditionalDocumentReference().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAdditionalDocumentReferenceCount() {
        return getAdditionalDocumentReference().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentReferenceType getAdditionalDocumentReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAdditionalDocumentReference().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAdditionalDocumentReference(
        @Nonnull
        final DocumentReferenceType elem) {
        getAdditionalDocumentReference().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        GoodsItemType ret) {
        if (additionalDocumentReference == null) {
            ret.additionalDocumentReference = null;
        } else {
            List<DocumentReferenceType> retAdditionalDocumentReference = new ArrayList<>();
            for (DocumentReferenceType aItem: getAdditionalDocumentReference()) {
                retAdditionalDocumentReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.additionalDocumentReference = retAdditionalDocumentReference;
        }
        ret.bondedWarehouseLocation = ((bondedWarehouseLocation == null)?null:bondedWarehouseLocation.clone());
        ret.chargeableQuantity = ((chargeableQuantity == null)?null:chargeableQuantity.clone());
        ret.chargeableWeightMeasure = ((chargeableWeightMeasure == null)?null:chargeableWeightMeasure.clone());
        if (containedGoodsItem == null) {
            ret.containedGoodsItem = null;
        } else {
            List<GoodsItemType> retContainedGoodsItem = new ArrayList<>();
            for (GoodsItemType aItem: getContainedGoodsItem()) {
                retContainedGoodsItem.add(((aItem == null)?null:aItem.clone()));
            }
            ret.containedGoodsItem = retContainedGoodsItem;
        }
        if (containingPackage == null) {
            ret.containingPackage = null;
        } else {
            List<PackageType> retContainingPackage = new ArrayList<>();
            for (PackageType aItem: getContainingPackage()) {
                retContainingPackage.add(((aItem == null)?null:aItem.clone()));
            }
            ret.containingPackage = retContainingPackage;
        }
        ret.customsImportClassifiedIndicator = ((customsImportClassifiedIndicator == null)?null:customsImportClassifiedIndicator.clone());
        ret.customsProcedureCode = ((customsProcedureCode == null)?null:customsProcedureCode.clone());
        ret.customsStatusCode = ((customsStatusCode == null)?null:customsStatusCode.clone());
        ret.customsTariffQuantity = ((customsTariffQuantity == null)?null:customsTariffQuantity.clone());
        ret.declaredCustomsValueAmount = ((declaredCustomsValueAmount == null)?null:declaredCustomsValueAmount.clone());
        ret.declaredForCarriageValueAmount = ((declaredForCarriageValueAmount == null)?null:declaredForCarriageValueAmount.clone());
        ret.declaredStatisticsValueAmount = ((declaredStatisticsValueAmount == null)?null:declaredStatisticsValueAmount.clone());
        ret.delivery = ((delivery == null)?null:delivery.clone());
        if (description == null) {
            ret.description = null;
        } else {
            List<DescriptionType> retDescription = new ArrayList<>();
            for (DescriptionType aItem: getDescription()) {
                retDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.description = retDescription;
        }
        ret.despatch = ((despatch == null)?null:despatch.clone());
        ret.despatchLineReference = ((despatchLineReference == null)?null:despatchLineReference.clone());
        ret.freeOnBoardValueAmount = ((freeOnBoardValueAmount == null)?null:freeOnBoardValueAmount.clone());
        if (freightAllowanceCharge == null) {
            ret.freightAllowanceCharge = null;
        } else {
            List<AllowanceChargeType> retFreightAllowanceCharge = new ArrayList<>();
            for (AllowanceChargeType aItem: getFreightAllowanceCharge()) {
                retFreightAllowanceCharge.add(((aItem == null)?null:aItem.clone()));
            }
            ret.freightAllowanceCharge = retFreightAllowanceCharge;
        }
        if (goodsItemContainer == null) {
            ret.goodsItemContainer = null;
        } else {
            List<GoodsItemContainerType> retGoodsItemContainer = new ArrayList<>();
            for (GoodsItemContainerType aItem: getGoodsItemContainer()) {
                retGoodsItemContainer.add(((aItem == null)?null:aItem.clone()));
            }
            ret.goodsItemContainer = retGoodsItemContainer;
        }
        ret.grossVolumeMeasure = ((grossVolumeMeasure == null)?null:grossVolumeMeasure.clone());
        ret.grossWeightMeasure = ((grossWeightMeasure == null)?null:grossWeightMeasure.clone());
        ret.hazardousRiskIndicator = ((hazardousRiskIndicator == null)?null:hazardousRiskIndicator.clone());
        ret.id = ((id == null)?null:id.clone());
        ret.insuranceValueAmount = ((insuranceValueAmount == null)?null:insuranceValueAmount.clone());
        if (invoiceLine == null) {
            ret.invoiceLine = null;
        } else {
            List<InvoiceLineType> retInvoiceLine = new ArrayList<>();
            for (InvoiceLineType aItem: getInvoiceLine()) {
                retInvoiceLine.add(((aItem == null)?null:aItem.clone()));
            }
            ret.invoiceLine = retInvoiceLine;
        }
        if (item == null) {
            ret.item = null;
        } else {
            List<ItemType> retItem = new ArrayList<>();
            for (ItemType aItem: getItem()) {
                retItem.add(((aItem == null)?null:aItem.clone()));
            }
            ret.item = retItem;
        }
        ret.maximumTemperature = ((maximumTemperature == null)?null:maximumTemperature.clone());
        if (measurementDimension == null) {
            ret.measurementDimension = null;
        } else {
            List<DimensionType> retMeasurementDimension = new ArrayList<>();
            for (DimensionType aItem: getMeasurementDimension()) {
                retMeasurementDimension.add(((aItem == null)?null:aItem.clone()));
            }
            ret.measurementDimension = retMeasurementDimension;
        }
        ret.minimumTemperature = ((minimumTemperature == null)?null:minimumTemperature.clone());
        ret.netNetWeightMeasure = ((netNetWeightMeasure == null)?null:netNetWeightMeasure.clone());
        ret.netVolumeMeasure = ((netVolumeMeasure == null)?null:netVolumeMeasure.clone());
        ret.netWeightMeasure = ((netWeightMeasure == null)?null:netWeightMeasure.clone());
        if (orderLineReference == null) {
            ret.orderLineReference = null;
        } else {
            List<OrderLineReferenceType> retOrderLineReference = new ArrayList<>();
            for (OrderLineReferenceType aItem: getOrderLineReference()) {
                retOrderLineReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.orderLineReference = retOrderLineReference;
        }
        ret.originAddress = ((originAddress == null)?null:originAddress.clone());
        ret.pickup = ((pickup == null)?null:pickup.clone());
        ret.preferenceCriterionCode = ((preferenceCriterionCode == null)?null:preferenceCriterionCode.clone());
        ret.quantity = ((quantity == null)?null:quantity.clone());
        ret.receiptLineReference = ((receiptLineReference == null)?null:receiptLineReference.clone());
        ret.requiredCustomsID = ((requiredCustomsID == null)?null:requiredCustomsID.clone());
        ret.returnableQuantity = ((returnableQuantity == null)?null:returnableQuantity.clone());
        ret.sequenceNumberID = ((sequenceNumberID == null)?null:sequenceNumberID.clone());
        ret.shipmentDocumentReference = ((shipmentDocumentReference == null)?null:shipmentDocumentReference.clone());
        if (temperature == null) {
            ret.temperature = null;
        } else {
            List<TemperatureType> retTemperature = new ArrayList<>();
            for (TemperatureType aItem: getTemperature()) {
                retTemperature.add(((aItem == null)?null:aItem.clone()));
            }
            ret.temperature = retTemperature;
        }
        ret.traceID = ((traceID == null)?null:traceID.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
        ret.valueAmount = ((valueAmount == null)?null:valueAmount.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public GoodsItemType clone() {
        GoodsItemType ret = new GoodsItemType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SequenceNumberIDType and never <code>null</code>
     */
    @Nonnull
    public SequenceNumberIDType setSequenceNumberID(
        @Nullable
        final String valueParam) {
        SequenceNumberIDType aObj = getSequenceNumberID();
        if (aObj == null) {
            aObj = new SequenceNumberIDType(valueParam);
            setSequenceNumberID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type HazardousRiskIndicatorType and never <code>null</code>
     */
    @Nonnull
    public HazardousRiskIndicatorType setHazardousRiskIndicator(final boolean valueParam) {
        HazardousRiskIndicatorType aObj = getHazardousRiskIndicator();
        if (aObj == null) {
            aObj = new HazardousRiskIndicatorType(valueParam);
            setHazardousRiskIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type DeclaredCustomsValueAmountType and never <code>null</code>
     */
    @Nonnull
    public DeclaredCustomsValueAmountType setDeclaredCustomsValueAmount(
        @Nullable
        final BigDecimal valueParam) {
        DeclaredCustomsValueAmountType aObj = getDeclaredCustomsValueAmount();
        if (aObj == null) {
            aObj = new DeclaredCustomsValueAmountType(valueParam);
            setDeclaredCustomsValueAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type DeclaredForCarriageValueAmountType and never <code>null</code>
     */
    @Nonnull
    public DeclaredForCarriageValueAmountType setDeclaredForCarriageValueAmount(
        @Nullable
        final BigDecimal valueParam) {
        DeclaredForCarriageValueAmountType aObj = getDeclaredForCarriageValueAmount();
        if (aObj == null) {
            aObj = new DeclaredForCarriageValueAmountType(valueParam);
            setDeclaredForCarriageValueAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type DeclaredStatisticsValueAmountType and never <code>null</code>
     */
    @Nonnull
    public DeclaredStatisticsValueAmountType setDeclaredStatisticsValueAmount(
        @Nullable
        final BigDecimal valueParam) {
        DeclaredStatisticsValueAmountType aObj = getDeclaredStatisticsValueAmount();
        if (aObj == null) {
            aObj = new DeclaredStatisticsValueAmountType(valueParam);
            setDeclaredStatisticsValueAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type FreeOnBoardValueAmountType and never <code>null</code>
     */
    @Nonnull
    public FreeOnBoardValueAmountType setFreeOnBoardValueAmount(
        @Nullable
        final BigDecimal valueParam) {
        FreeOnBoardValueAmountType aObj = getFreeOnBoardValueAmount();
        if (aObj == null) {
            aObj = new FreeOnBoardValueAmountType(valueParam);
            setFreeOnBoardValueAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type InsuranceValueAmountType and never <code>null</code>
     */
    @Nonnull
    public InsuranceValueAmountType setInsuranceValueAmount(
        @Nullable
        final BigDecimal valueParam) {
        InsuranceValueAmountType aObj = getInsuranceValueAmount();
        if (aObj == null) {
            aObj = new InsuranceValueAmountType(valueParam);
            setInsuranceValueAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ValueAmountType and never <code>null</code>
     */
    @Nonnull
    public ValueAmountType setValueAmount(
        @Nullable
        final BigDecimal valueParam) {
        ValueAmountType aObj = getValueAmount();
        if (aObj == null) {
            aObj = new ValueAmountType(valueParam);
            setValueAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type GrossWeightMeasureType and never <code>null</code>
     */
    @Nonnull
    public GrossWeightMeasureType setGrossWeightMeasure(
        @Nullable
        final BigDecimal valueParam) {
        GrossWeightMeasureType aObj = getGrossWeightMeasure();
        if (aObj == null) {
            aObj = new GrossWeightMeasureType(valueParam);
            setGrossWeightMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NetWeightMeasureType and never <code>null</code>
     */
    @Nonnull
    public NetWeightMeasureType setNetWeightMeasure(
        @Nullable
        final BigDecimal valueParam) {
        NetWeightMeasureType aObj = getNetWeightMeasure();
        if (aObj == null) {
            aObj = new NetWeightMeasureType(valueParam);
            setNetWeightMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NetNetWeightMeasureType and never <code>null</code>
     */
    @Nonnull
    public NetNetWeightMeasureType setNetNetWeightMeasure(
        @Nullable
        final BigDecimal valueParam) {
        NetNetWeightMeasureType aObj = getNetNetWeightMeasure();
        if (aObj == null) {
            aObj = new NetNetWeightMeasureType(valueParam);
            setNetNetWeightMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ChargeableWeightMeasureType and never <code>null</code>
     */
    @Nonnull
    public ChargeableWeightMeasureType setChargeableWeightMeasure(
        @Nullable
        final BigDecimal valueParam) {
        ChargeableWeightMeasureType aObj = getChargeableWeightMeasure();
        if (aObj == null) {
            aObj = new ChargeableWeightMeasureType(valueParam);
            setChargeableWeightMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type GrossVolumeMeasureType and never <code>null</code>
     */
    @Nonnull
    public GrossVolumeMeasureType setGrossVolumeMeasure(
        @Nullable
        final BigDecimal valueParam) {
        GrossVolumeMeasureType aObj = getGrossVolumeMeasure();
        if (aObj == null) {
            aObj = new GrossVolumeMeasureType(valueParam);
            setGrossVolumeMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NetVolumeMeasureType and never <code>null</code>
     */
    @Nonnull
    public NetVolumeMeasureType setNetVolumeMeasure(
        @Nullable
        final BigDecimal valueParam) {
        NetVolumeMeasureType aObj = getNetVolumeMeasure();
        if (aObj == null) {
            aObj = new NetVolumeMeasureType(valueParam);
            setNetVolumeMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityType and never <code>null</code>
     */
    @Nonnull
    public QuantityType setQuantity(
        @Nullable
        final BigDecimal valueParam) {
        QuantityType aObj = getQuantity();
        if (aObj == null) {
            aObj = new QuantityType(valueParam);
            setQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PreferenceCriterionCodeType and never <code>null</code>
     */
    @Nonnull
    public PreferenceCriterionCodeType setPreferenceCriterionCode(
        @Nullable
        final String valueParam) {
        PreferenceCriterionCodeType aObj = getPreferenceCriterionCode();
        if (aObj == null) {
            aObj = new PreferenceCriterionCodeType(valueParam);
            setPreferenceCriterionCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type RequiredCustomsIDType and never <code>null</code>
     */
    @Nonnull
    public RequiredCustomsIDType setRequiredCustomsID(
        @Nullable
        final String valueParam) {
        RequiredCustomsIDType aObj = getRequiredCustomsID();
        if (aObj == null) {
            aObj = new RequiredCustomsIDType(valueParam);
            setRequiredCustomsID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CustomsStatusCodeType and never <code>null</code>
     */
    @Nonnull
    public CustomsStatusCodeType setCustomsStatusCode(
        @Nullable
        final String valueParam) {
        CustomsStatusCodeType aObj = getCustomsStatusCode();
        if (aObj == null) {
            aObj = new CustomsStatusCodeType(valueParam);
            setCustomsStatusCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CustomsProcedureCodeType and never <code>null</code>
     */
    @Nonnull
    public CustomsProcedureCodeType setCustomsProcedureCode(
        @Nullable
        final String valueParam) {
        CustomsProcedureCodeType aObj = getCustomsProcedureCode();
        if (aObj == null) {
            aObj = new CustomsProcedureCodeType(valueParam);
            setCustomsProcedureCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CustomsTariffQuantityType and never <code>null</code>
     */
    @Nonnull
    public CustomsTariffQuantityType setCustomsTariffQuantity(
        @Nullable
        final BigDecimal valueParam) {
        CustomsTariffQuantityType aObj = getCustomsTariffQuantity();
        if (aObj == null) {
            aObj = new CustomsTariffQuantityType(valueParam);
            setCustomsTariffQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type CustomsImportClassifiedIndicatorType and never <code>null</code>
     */
    @Nonnull
    public CustomsImportClassifiedIndicatorType setCustomsImportClassifiedIndicator(final boolean valueParam) {
        CustomsImportClassifiedIndicatorType aObj = getCustomsImportClassifiedIndicator();
        if (aObj == null) {
            aObj = new CustomsImportClassifiedIndicatorType(valueParam);
            setCustomsImportClassifiedIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ChargeableQuantityType and never <code>null</code>
     */
    @Nonnull
    public ChargeableQuantityType setChargeableQuantity(
        @Nullable
        final BigDecimal valueParam) {
        ChargeableQuantityType aObj = getChargeableQuantity();
        if (aObj == null) {
            aObj = new ChargeableQuantityType(valueParam);
            setChargeableQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ReturnableQuantityType and never <code>null</code>
     */
    @Nonnull
    public ReturnableQuantityType setReturnableQuantity(
        @Nullable
        final BigDecimal valueParam) {
        ReturnableQuantityType aObj = getReturnableQuantity();
        if (aObj == null) {
            aObj = new ReturnableQuantityType(valueParam);
            setReturnableQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TraceIDType and never <code>null</code>
     */
    @Nonnull
    public TraceIDType setTraceID(
        @Nullable
        final String valueParam) {
        TraceIDType aObj = getTraceID();
        if (aObj == null) {
            aObj = new TraceIDType(valueParam);
            setTraceID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained SequenceNumberIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SequenceNumberIDType object or <code>null</code>
     */
    @Nullable
    public String getSequenceNumberIDValue() {
        SequenceNumberIDType aObj = getSequenceNumberID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained HazardousRiskIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained HazardousRiskIndicatorType object or the passed nullValue
     */
    public boolean isHazardousRiskIndicatorValue(final boolean nullValue) {
        HazardousRiskIndicatorType aObj = getHazardousRiskIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained DeclaredCustomsValueAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained DeclaredCustomsValueAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getDeclaredCustomsValueAmountValue() {
        DeclaredCustomsValueAmountType aObj = getDeclaredCustomsValueAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained DeclaredForCarriageValueAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained DeclaredForCarriageValueAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getDeclaredForCarriageValueAmountValue() {
        DeclaredForCarriageValueAmountType aObj = getDeclaredForCarriageValueAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained DeclaredStatisticsValueAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained DeclaredStatisticsValueAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getDeclaredStatisticsValueAmountValue() {
        DeclaredStatisticsValueAmountType aObj = getDeclaredStatisticsValueAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained FreeOnBoardValueAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained FreeOnBoardValueAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getFreeOnBoardValueAmountValue() {
        FreeOnBoardValueAmountType aObj = getFreeOnBoardValueAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained InsuranceValueAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained InsuranceValueAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getInsuranceValueAmountValue() {
        InsuranceValueAmountType aObj = getInsuranceValueAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ValueAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ValueAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getValueAmountValue() {
        ValueAmountType aObj = getValueAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained GrossWeightMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained GrossWeightMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getGrossWeightMeasureValue() {
        GrossWeightMeasureType aObj = getGrossWeightMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained NetWeightMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NetWeightMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getNetWeightMeasureValue() {
        NetWeightMeasureType aObj = getNetWeightMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained NetNetWeightMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NetNetWeightMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getNetNetWeightMeasureValue() {
        NetNetWeightMeasureType aObj = getNetNetWeightMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ChargeableWeightMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ChargeableWeightMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getChargeableWeightMeasureValue() {
        ChargeableWeightMeasureType aObj = getChargeableWeightMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained GrossVolumeMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained GrossVolumeMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getGrossVolumeMeasureValue() {
        GrossVolumeMeasureType aObj = getGrossVolumeMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained NetVolumeMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NetVolumeMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getNetVolumeMeasureValue() {
        NetVolumeMeasureType aObj = getNetVolumeMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained QuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getQuantityValue() {
        QuantityType aObj = getQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PreferenceCriterionCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PreferenceCriterionCodeType object or <code>null</code>
     */
    @Nullable
    public String getPreferenceCriterionCodeValue() {
        PreferenceCriterionCodeType aObj = getPreferenceCriterionCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained RequiredCustomsIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained RequiredCustomsIDType object or <code>null</code>
     */
    @Nullable
    public String getRequiredCustomsIDValue() {
        RequiredCustomsIDType aObj = getRequiredCustomsID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CustomsStatusCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CustomsStatusCodeType object or <code>null</code>
     */
    @Nullable
    public String getCustomsStatusCodeValue() {
        CustomsStatusCodeType aObj = getCustomsStatusCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CustomsProcedureCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CustomsProcedureCodeType object or <code>null</code>
     */
    @Nullable
    public String getCustomsProcedureCodeValue() {
        CustomsProcedureCodeType aObj = getCustomsProcedureCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CustomsTariffQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CustomsTariffQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getCustomsTariffQuantityValue() {
        CustomsTariffQuantityType aObj = getCustomsTariffQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CustomsImportClassifiedIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained CustomsImportClassifiedIndicatorType object or the passed nullValue
     */
    public boolean isCustomsImportClassifiedIndicatorValue(final boolean nullValue) {
        CustomsImportClassifiedIndicatorType aObj = getCustomsImportClassifiedIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained ChargeableQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ChargeableQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getChargeableQuantityValue() {
        ChargeableQuantityType aObj = getChargeableQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ReturnableQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ReturnableQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getReturnableQuantityValue() {
        ReturnableQuantityType aObj = getReturnableQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TraceIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TraceIDType object or <code>null</code>
     */
    @Nullable
    public String getTraceIDValue() {
        TraceIDType aObj = getTraceID();
        return (aObj == null)?null:aObj.getValue();
    }

}
