
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.HazardousRegulationCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.InhalationToxicityZoneCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.PackingCriteriaCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TransitDescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TransportAuthorizationCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TransportEmergencyCardCodeType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for HazardousGoodsTransitType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="HazardousGoodsTransitType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TransportEmergencyCardCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PackingCriteriaCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}HazardousRegulationCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}InhalationToxicityZoneCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TransportAuthorizationCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TransitDescription" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}MaximumTemperature" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}MinimumTemperature" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "HazardousGoodsTransitType", propOrder = {
    "ublExtensions",
    "transportEmergencyCardCode",
    "packingCriteriaCode",
    "hazardousRegulationCode",
    "inhalationToxicityZoneCode",
    "transportAuthorizationCode",
    "transitDescription",
    "maximumTemperature",
    "minimumTemperature"
})
@CodingStyleguideUnaware
public class HazardousGoodsTransitType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "TransportEmergencyCardCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TransportEmergencyCardCodeType transportEmergencyCardCode;
    @XmlElement(name = "PackingCriteriaCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PackingCriteriaCodeType packingCriteriaCode;
    @XmlElement(name = "HazardousRegulationCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private HazardousRegulationCodeType hazardousRegulationCode;
    @XmlElement(name = "InhalationToxicityZoneCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private InhalationToxicityZoneCodeType inhalationToxicityZoneCode;
    @XmlElement(name = "TransportAuthorizationCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TransportAuthorizationCodeType transportAuthorizationCode;
    @XmlElement(name = "TransitDescription", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<TransitDescriptionType> transitDescription;
    @XmlElement(name = "MaximumTemperature")
    private TemperatureType maximumTemperature;
    @XmlElement(name = "MinimumTemperature")
    private TemperatureType minimumTemperature;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public HazardousGoodsTransitType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the transportEmergencyCardCode property.
     * 
     * @return
     *     possible object is
     *     {@link TransportEmergencyCardCodeType }
     *     
     */
    @Nullable
    public TransportEmergencyCardCodeType getTransportEmergencyCardCode() {
        return transportEmergencyCardCode;
    }

    /**
     * Sets the value of the transportEmergencyCardCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportEmergencyCardCodeType }
     *     
     */
    public void setTransportEmergencyCardCode(
        @Nullable
        TransportEmergencyCardCodeType value) {
        this.transportEmergencyCardCode = value;
    }

    /**
     * Gets the value of the packingCriteriaCode property.
     * 
     * @return
     *     possible object is
     *     {@link PackingCriteriaCodeType }
     *     
     */
    @Nullable
    public PackingCriteriaCodeType getPackingCriteriaCode() {
        return packingCriteriaCode;
    }

    /**
     * Sets the value of the packingCriteriaCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link PackingCriteriaCodeType }
     *     
     */
    public void setPackingCriteriaCode(
        @Nullable
        PackingCriteriaCodeType value) {
        this.packingCriteriaCode = value;
    }

    /**
     * Gets the value of the hazardousRegulationCode property.
     * 
     * @return
     *     possible object is
     *     {@link HazardousRegulationCodeType }
     *     
     */
    @Nullable
    public HazardousRegulationCodeType getHazardousRegulationCode() {
        return hazardousRegulationCode;
    }

    /**
     * Sets the value of the hazardousRegulationCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link HazardousRegulationCodeType }
     *     
     */
    public void setHazardousRegulationCode(
        @Nullable
        HazardousRegulationCodeType value) {
        this.hazardousRegulationCode = value;
    }

    /**
     * Gets the value of the inhalationToxicityZoneCode property.
     * 
     * @return
     *     possible object is
     *     {@link InhalationToxicityZoneCodeType }
     *     
     */
    @Nullable
    public InhalationToxicityZoneCodeType getInhalationToxicityZoneCode() {
        return inhalationToxicityZoneCode;
    }

    /**
     * Sets the value of the inhalationToxicityZoneCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link InhalationToxicityZoneCodeType }
     *     
     */
    public void setInhalationToxicityZoneCode(
        @Nullable
        InhalationToxicityZoneCodeType value) {
        this.inhalationToxicityZoneCode = value;
    }

    /**
     * Gets the value of the transportAuthorizationCode property.
     * 
     * @return
     *     possible object is
     *     {@link TransportAuthorizationCodeType }
     *     
     */
    @Nullable
    public TransportAuthorizationCodeType getTransportAuthorizationCode() {
        return transportAuthorizationCode;
    }

    /**
     * Sets the value of the transportAuthorizationCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportAuthorizationCodeType }
     *     
     */
    public void setTransportAuthorizationCode(
        @Nullable
        TransportAuthorizationCodeType value) {
        this.transportAuthorizationCode = value;
    }

    /**
     * Gets the value of the transitDescription property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the transitDescription property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getTransitDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TransitDescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the transitDescription property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TransitDescriptionType> getTransitDescription() {
        if (transitDescription == null) {
            transitDescription = new ArrayList<>();
        }
        return this.transitDescription;
    }

    /**
     * Gets the value of the maximumTemperature property.
     * 
     * @return
     *     possible object is
     *     {@link TemperatureType }
     *     
     */
    @Nullable
    public TemperatureType getMaximumTemperature() {
        return maximumTemperature;
    }

    /**
     * Sets the value of the maximumTemperature property.
     * 
     * @param value
     *     allowed object is
     *     {@link TemperatureType }
     *     
     */
    public void setMaximumTemperature(
        @Nullable
        TemperatureType value) {
        this.maximumTemperature = value;
    }

    /**
     * Gets the value of the minimumTemperature property.
     * 
     * @return
     *     possible object is
     *     {@link TemperatureType }
     *     
     */
    @Nullable
    public TemperatureType getMinimumTemperature() {
        return minimumTemperature;
    }

    /**
     * Sets the value of the minimumTemperature property.
     * 
     * @param value
     *     allowed object is
     *     {@link TemperatureType }
     *     
     */
    public void setMinimumTemperature(
        @Nullable
        TemperatureType value) {
        this.minimumTemperature = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final HazardousGoodsTransitType rhs = ((HazardousGoodsTransitType) o);
        if (!EqualsHelper.equals(hazardousRegulationCode, rhs.hazardousRegulationCode)) {
            return false;
        }
        if (!EqualsHelper.equals(inhalationToxicityZoneCode, rhs.inhalationToxicityZoneCode)) {
            return false;
        }
        if (!EqualsHelper.equals(maximumTemperature, rhs.maximumTemperature)) {
            return false;
        }
        if (!EqualsHelper.equals(minimumTemperature, rhs.minimumTemperature)) {
            return false;
        }
        if (!EqualsHelper.equals(packingCriteriaCode, rhs.packingCriteriaCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(transitDescription, rhs.transitDescription)) {
            return false;
        }
        if (!EqualsHelper.equals(transportAuthorizationCode, rhs.transportAuthorizationCode)) {
            return false;
        }
        if (!EqualsHelper.equals(transportEmergencyCardCode, rhs.transportEmergencyCardCode)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(hazardousRegulationCode).append(inhalationToxicityZoneCode).append(maximumTemperature).append(minimumTemperature).append(packingCriteriaCode).append(transitDescription).append(transportAuthorizationCode).append(transportEmergencyCardCode).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("hazardousRegulationCode", hazardousRegulationCode).append("inhalationToxicityZoneCode", inhalationToxicityZoneCode).append("maximumTemperature", maximumTemperature).append("minimumTemperature", minimumTemperature).append("packingCriteriaCode", packingCriteriaCode).append("transitDescription", transitDescription).append("transportAuthorizationCode", transportAuthorizationCode).append("transportEmergencyCardCode", transportEmergencyCardCode).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTransitDescription(
        @Nullable
        final List<TransitDescriptionType> aList) {
        transitDescription = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTransitDescriptionEntries() {
        return (!getTransitDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTransitDescriptionEntries() {
        return getTransitDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTransitDescriptionCount() {
        return getTransitDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TransitDescriptionType getTransitDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTransitDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTransitDescription(
        @Nonnull
        final TransitDescriptionType elem) {
        getTransitDescription().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        HazardousGoodsTransitType ret) {
        ret.hazardousRegulationCode = ((hazardousRegulationCode == null)?null:hazardousRegulationCode.clone());
        ret.inhalationToxicityZoneCode = ((inhalationToxicityZoneCode == null)?null:inhalationToxicityZoneCode.clone());
        ret.maximumTemperature = ((maximumTemperature == null)?null:maximumTemperature.clone());
        ret.minimumTemperature = ((minimumTemperature == null)?null:minimumTemperature.clone());
        ret.packingCriteriaCode = ((packingCriteriaCode == null)?null:packingCriteriaCode.clone());
        if (transitDescription == null) {
            ret.transitDescription = null;
        } else {
            List<TransitDescriptionType> retTransitDescription = new ArrayList<>();
            for (TransitDescriptionType aItem: getTransitDescription()) {
                retTransitDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.transitDescription = retTransitDescription;
        }
        ret.transportAuthorizationCode = ((transportAuthorizationCode == null)?null:transportAuthorizationCode.clone());
        ret.transportEmergencyCardCode = ((transportEmergencyCardCode == null)?null:transportEmergencyCardCode.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public HazardousGoodsTransitType clone() {
        HazardousGoodsTransitType ret = new HazardousGoodsTransitType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TransportEmergencyCardCodeType and never <code>null</code>
     */
    @Nonnull
    public TransportEmergencyCardCodeType setTransportEmergencyCardCode(
        @Nullable
        final String valueParam) {
        TransportEmergencyCardCodeType aObj = getTransportEmergencyCardCode();
        if (aObj == null) {
            aObj = new TransportEmergencyCardCodeType(valueParam);
            setTransportEmergencyCardCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PackingCriteriaCodeType and never <code>null</code>
     */
    @Nonnull
    public PackingCriteriaCodeType setPackingCriteriaCode(
        @Nullable
        final String valueParam) {
        PackingCriteriaCodeType aObj = getPackingCriteriaCode();
        if (aObj == null) {
            aObj = new PackingCriteriaCodeType(valueParam);
            setPackingCriteriaCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type HazardousRegulationCodeType and never <code>null</code>
     */
    @Nonnull
    public HazardousRegulationCodeType setHazardousRegulationCode(
        @Nullable
        final String valueParam) {
        HazardousRegulationCodeType aObj = getHazardousRegulationCode();
        if (aObj == null) {
            aObj = new HazardousRegulationCodeType(valueParam);
            setHazardousRegulationCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type InhalationToxicityZoneCodeType and never <code>null</code>
     */
    @Nonnull
    public InhalationToxicityZoneCodeType setInhalationToxicityZoneCode(
        @Nullable
        final String valueParam) {
        InhalationToxicityZoneCodeType aObj = getInhalationToxicityZoneCode();
        if (aObj == null) {
            aObj = new InhalationToxicityZoneCodeType(valueParam);
            setInhalationToxicityZoneCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TransportAuthorizationCodeType and never <code>null</code>
     */
    @Nonnull
    public TransportAuthorizationCodeType setTransportAuthorizationCode(
        @Nullable
        final String valueParam) {
        TransportAuthorizationCodeType aObj = getTransportAuthorizationCode();
        if (aObj == null) {
            aObj = new TransportAuthorizationCodeType(valueParam);
            setTransportAuthorizationCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained TransportEmergencyCardCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TransportEmergencyCardCodeType object or <code>null</code>
     */
    @Nullable
    public String getTransportEmergencyCardCodeValue() {
        TransportEmergencyCardCodeType aObj = getTransportEmergencyCardCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PackingCriteriaCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PackingCriteriaCodeType object or <code>null</code>
     */
    @Nullable
    public String getPackingCriteriaCodeValue() {
        PackingCriteriaCodeType aObj = getPackingCriteriaCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained HazardousRegulationCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained HazardousRegulationCodeType object or <code>null</code>
     */
    @Nullable
    public String getHazardousRegulationCodeValue() {
        HazardousRegulationCodeType aObj = getHazardousRegulationCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained InhalationToxicityZoneCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained InhalationToxicityZoneCodeType object or <code>null</code>
     */
    @Nullable
    public String getInhalationToxicityZoneCodeValue() {
        InhalationToxicityZoneCodeType aObj = getInhalationToxicityZoneCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TransportAuthorizationCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TransportAuthorizationCodeType object or <code>null</code>
     */
    @Nullable
    public String getTransportAuthorizationCodeValue() {
        TransportAuthorizationCodeType aObj = getTransportAuthorizationCode();
        return (aObj == null)?null:aObj.getValue();
    }

}
