
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.datetime.XMLOffsetTime;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.BestBeforeDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ManufactureDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ManufactureTimeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ProductTraceIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.RegistrationIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.SerialIDType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for ItemInstanceType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ItemInstanceType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ProductTraceID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ManufactureDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ManufactureTime" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}BestBeforeDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}RegistrationID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}SerialID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}AdditionalItemProperty" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}LotIdentification" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ItemInstanceType", propOrder = {
    "ublExtensions",
    "productTraceID",
    "manufactureDate",
    "manufactureTime",
    "bestBeforeDate",
    "registrationID",
    "serialID",
    "additionalItemProperty",
    "lotIdentification"
})
@CodingStyleguideUnaware
public class ItemInstanceType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ProductTraceID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ProductTraceIDType productTraceID;
    @XmlElement(name = "ManufactureDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ManufactureDateType manufactureDate;
    @XmlElement(name = "ManufactureTime", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ManufactureTimeType manufactureTime;
    @XmlElement(name = "BestBeforeDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private BestBeforeDateType bestBeforeDate;
    @XmlElement(name = "RegistrationID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private RegistrationIDType registrationID;
    @XmlElement(name = "SerialID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private SerialIDType serialID;
    @XmlElement(name = "AdditionalItemProperty")
    private List<ItemPropertyType> additionalItemProperty;
    @XmlElement(name = "LotIdentification")
    private LotIdentificationType lotIdentification;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public ItemInstanceType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the productTraceID property.
     * 
     * @return
     *     possible object is
     *     {@link ProductTraceIDType }
     *     
     */
    @Nullable
    public ProductTraceIDType getProductTraceID() {
        return productTraceID;
    }

    /**
     * Sets the value of the productTraceID property.
     * 
     * @param value
     *     allowed object is
     *     {@link ProductTraceIDType }
     *     
     */
    public void setProductTraceID(
        @Nullable
        ProductTraceIDType value) {
        this.productTraceID = value;
    }

    /**
     * Gets the value of the manufactureDate property.
     * 
     * @return
     *     possible object is
     *     {@link ManufactureDateType }
     *     
     */
    @Nullable
    public ManufactureDateType getManufactureDate() {
        return manufactureDate;
    }

    /**
     * Sets the value of the manufactureDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link ManufactureDateType }
     *     
     */
    public void setManufactureDate(
        @Nullable
        ManufactureDateType value) {
        this.manufactureDate = value;
    }

    /**
     * Gets the value of the manufactureTime property.
     * 
     * @return
     *     possible object is
     *     {@link ManufactureTimeType }
     *     
     */
    @Nullable
    public ManufactureTimeType getManufactureTime() {
        return manufactureTime;
    }

    /**
     * Sets the value of the manufactureTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link ManufactureTimeType }
     *     
     */
    public void setManufactureTime(
        @Nullable
        ManufactureTimeType value) {
        this.manufactureTime = value;
    }

    /**
     * Gets the value of the bestBeforeDate property.
     * 
     * @return
     *     possible object is
     *     {@link BestBeforeDateType }
     *     
     */
    @Nullable
    public BestBeforeDateType getBestBeforeDate() {
        return bestBeforeDate;
    }

    /**
     * Sets the value of the bestBeforeDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link BestBeforeDateType }
     *     
     */
    public void setBestBeforeDate(
        @Nullable
        BestBeforeDateType value) {
        this.bestBeforeDate = value;
    }

    /**
     * Gets the value of the registrationID property.
     * 
     * @return
     *     possible object is
     *     {@link RegistrationIDType }
     *     
     */
    @Nullable
    public RegistrationIDType getRegistrationID() {
        return registrationID;
    }

    /**
     * Sets the value of the registrationID property.
     * 
     * @param value
     *     allowed object is
     *     {@link RegistrationIDType }
     *     
     */
    public void setRegistrationID(
        @Nullable
        RegistrationIDType value) {
        this.registrationID = value;
    }

    /**
     * Gets the value of the serialID property.
     * 
     * @return
     *     possible object is
     *     {@link SerialIDType }
     *     
     */
    @Nullable
    public SerialIDType getSerialID() {
        return serialID;
    }

    /**
     * Sets the value of the serialID property.
     * 
     * @param value
     *     allowed object is
     *     {@link SerialIDType }
     *     
     */
    public void setSerialID(
        @Nullable
        SerialIDType value) {
        this.serialID = value;
    }

    /**
     * Gets the value of the additionalItemProperty property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the additionalItemProperty property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getAdditionalItemProperty().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ItemPropertyType }
     * </p>
     * 
     * 
     * @return
     *     The value of the additionalItemProperty property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ItemPropertyType> getAdditionalItemProperty() {
        if (additionalItemProperty == null) {
            additionalItemProperty = new ArrayList<>();
        }
        return this.additionalItemProperty;
    }

    /**
     * Gets the value of the lotIdentification property.
     * 
     * @return
     *     possible object is
     *     {@link LotIdentificationType }
     *     
     */
    @Nullable
    public LotIdentificationType getLotIdentification() {
        return lotIdentification;
    }

    /**
     * Sets the value of the lotIdentification property.
     * 
     * @param value
     *     allowed object is
     *     {@link LotIdentificationType }
     *     
     */
    public void setLotIdentification(
        @Nullable
        LotIdentificationType value) {
        this.lotIdentification = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final ItemInstanceType rhs = ((ItemInstanceType) o);
        if (!EqualsHelper.equalsCollection(additionalItemProperty, rhs.additionalItemProperty)) {
            return false;
        }
        if (!EqualsHelper.equals(bestBeforeDate, rhs.bestBeforeDate)) {
            return false;
        }
        if (!EqualsHelper.equals(lotIdentification, rhs.lotIdentification)) {
            return false;
        }
        if (!EqualsHelper.equals(manufactureDate, rhs.manufactureDate)) {
            return false;
        }
        if (!EqualsHelper.equals(manufactureTime, rhs.manufactureTime)) {
            return false;
        }
        if (!EqualsHelper.equals(productTraceID, rhs.productTraceID)) {
            return false;
        }
        if (!EqualsHelper.equals(registrationID, rhs.registrationID)) {
            return false;
        }
        if (!EqualsHelper.equals(serialID, rhs.serialID)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(additionalItemProperty).append(bestBeforeDate).append(lotIdentification).append(manufactureDate).append(manufactureTime).append(productTraceID).append(registrationID).append(serialID).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("additionalItemProperty", additionalItemProperty).append("bestBeforeDate", bestBeforeDate).append("lotIdentification", lotIdentification).append("manufactureDate", manufactureDate).append("manufactureTime", manufactureTime).append("productTraceID", productTraceID).append("registrationID", registrationID).append("serialID", serialID).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAdditionalItemProperty(
        @Nullable
        final List<ItemPropertyType> aList) {
        additionalItemProperty = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAdditionalItemPropertyEntries() {
        return (!getAdditionalItemProperty().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAdditionalItemPropertyEntries() {
        return getAdditionalItemProperty().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAdditionalItemPropertyCount() {
        return getAdditionalItemProperty().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ItemPropertyType getAdditionalItemPropertyAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAdditionalItemProperty().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAdditionalItemProperty(
        @Nonnull
        final ItemPropertyType elem) {
        getAdditionalItemProperty().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        ItemInstanceType ret) {
        if (additionalItemProperty == null) {
            ret.additionalItemProperty = null;
        } else {
            List<ItemPropertyType> retAdditionalItemProperty = new ArrayList<>();
            for (ItemPropertyType aItem: getAdditionalItemProperty()) {
                retAdditionalItemProperty.add(((aItem == null)?null:aItem.clone()));
            }
            ret.additionalItemProperty = retAdditionalItemProperty;
        }
        ret.bestBeforeDate = ((bestBeforeDate == null)?null:bestBeforeDate.clone());
        ret.lotIdentification = ((lotIdentification == null)?null:lotIdentification.clone());
        ret.manufactureDate = ((manufactureDate == null)?null:manufactureDate.clone());
        ret.manufactureTime = ((manufactureTime == null)?null:manufactureTime.clone());
        ret.productTraceID = ((productTraceID == null)?null:productTraceID.clone());
        ret.registrationID = ((registrationID == null)?null:registrationID.clone());
        ret.serialID = ((serialID == null)?null:serialID.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ItemInstanceType clone() {
        ItemInstanceType ret = new ItemInstanceType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ProductTraceIDType and never <code>null</code>
     */
    @Nonnull
    public ProductTraceIDType setProductTraceID(
        @Nullable
        final String valueParam) {
        ProductTraceIDType aObj = getProductTraceID();
        if (aObj == null) {
            aObj = new ProductTraceIDType(valueParam);
            setProductTraceID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ManufactureDateType and never <code>null</code>
     */
    @Nonnull
    public ManufactureDateType setManufactureDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        ManufactureDateType aObj = getManufactureDate();
        if (aObj == null) {
            aObj = new ManufactureDateType(valueParam);
            setManufactureDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ManufactureDateType and never <code>null</code>
     */
    @Nonnull
    public ManufactureDateType setManufactureDate(
        @Nullable
        final LocalDate valueParam) {
        ManufactureDateType aObj = getManufactureDate();
        if (aObj == null) {
            aObj = new ManufactureDateType(valueParam);
            setManufactureDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ManufactureTimeType and never <code>null</code>
     */
    @Nonnull
    public ManufactureTimeType setManufactureTime(
        @Nullable
        final XMLOffsetTime valueParam) {
        ManufactureTimeType aObj = getManufactureTime();
        if (aObj == null) {
            aObj = new ManufactureTimeType(valueParam);
            setManufactureTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ManufactureTimeType and never <code>null</code>
     */
    @Nonnull
    public ManufactureTimeType setManufactureTime(
        @Nullable
        final LocalTime valueParam) {
        ManufactureTimeType aObj = getManufactureTime();
        if (aObj == null) {
            aObj = new ManufactureTimeType(valueParam);
            setManufactureTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type BestBeforeDateType and never <code>null</code>
     */
    @Nonnull
    public BestBeforeDateType setBestBeforeDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        BestBeforeDateType aObj = getBestBeforeDate();
        if (aObj == null) {
            aObj = new BestBeforeDateType(valueParam);
            setBestBeforeDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type BestBeforeDateType and never <code>null</code>
     */
    @Nonnull
    public BestBeforeDateType setBestBeforeDate(
        @Nullable
        final LocalDate valueParam) {
        BestBeforeDateType aObj = getBestBeforeDate();
        if (aObj == null) {
            aObj = new BestBeforeDateType(valueParam);
            setBestBeforeDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type RegistrationIDType and never <code>null</code>
     */
    @Nonnull
    public RegistrationIDType setRegistrationID(
        @Nullable
        final String valueParam) {
        RegistrationIDType aObj = getRegistrationID();
        if (aObj == null) {
            aObj = new RegistrationIDType(valueParam);
            setRegistrationID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SerialIDType and never <code>null</code>
     */
    @Nonnull
    public SerialIDType setSerialID(
        @Nullable
        final String valueParam) {
        SerialIDType aObj = getSerialID();
        if (aObj == null) {
            aObj = new SerialIDType(valueParam);
            setSerialID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained ProductTraceIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ProductTraceIDType object or <code>null</code>
     */
    @Nullable
    public String getProductTraceIDValue() {
        ProductTraceIDType aObj = getProductTraceID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ManufactureDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ManufactureDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getManufactureDateValue() {
        ManufactureDateType aObj = getManufactureDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ManufactureDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ManufactureDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getManufactureDateValueLocal() {
        ManufactureDateType aObj = getManufactureDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained ManufactureTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ManufactureTimeType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetTime getManufactureTimeValue() {
        ManufactureTimeType aObj = getManufactureTime();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ManufactureTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ManufactureTimeType object or <code>null</code>
     */
    @Nullable
    public LocalTime getManufactureTimeValueLocal() {
        ManufactureTimeType aObj = getManufactureTime();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained BestBeforeDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained BestBeforeDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getBestBeforeDateValue() {
        BestBeforeDateType aObj = getBestBeforeDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained BestBeforeDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained BestBeforeDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getBestBeforeDateValueLocal() {
        BestBeforeDateType aObj = getBestBeforeDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained RegistrationIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained RegistrationIDType object or <code>null</code>
     */
    @Nullable
    public String getRegistrationIDValue() {
        RegistrationIDType aObj = getRegistrationID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained SerialIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SerialIDType object or <code>null</code>
     */
    @Nullable
    public String getSerialIDValue() {
        SerialIDType aObj = getSerialID();
        return (aObj == null)?null:aObj.getValue();
    }

}
