
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.AltitudeMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.CoordinateSystemCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.LatitudeDegreesMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.LatitudeDirectionCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.LatitudeMinutesMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.LongitudeDegreesMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.LongitudeDirectionCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.LongitudeMinutesMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for LocationCoordinateType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="LocationCoordinateType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CoordinateSystemCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}LatitudeDegreesMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}LatitudeMinutesMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}LatitudeDirectionCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}LongitudeDegreesMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}LongitudeMinutesMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}LongitudeDirectionCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}AltitudeMeasure" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "LocationCoordinateType", propOrder = {
    "ublExtensions",
    "coordinateSystemCode",
    "latitudeDegreesMeasure",
    "latitudeMinutesMeasure",
    "latitudeDirectionCode",
    "longitudeDegreesMeasure",
    "longitudeMinutesMeasure",
    "longitudeDirectionCode",
    "altitudeMeasure"
})
@CodingStyleguideUnaware
public class LocationCoordinateType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "CoordinateSystemCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private CoordinateSystemCodeType coordinateSystemCode;
    @XmlElement(name = "LatitudeDegreesMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private LatitudeDegreesMeasureType latitudeDegreesMeasure;
    @XmlElement(name = "LatitudeMinutesMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private LatitudeMinutesMeasureType latitudeMinutesMeasure;
    @XmlElement(name = "LatitudeDirectionCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private LatitudeDirectionCodeType latitudeDirectionCode;
    @XmlElement(name = "LongitudeDegreesMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private LongitudeDegreesMeasureType longitudeDegreesMeasure;
    @XmlElement(name = "LongitudeMinutesMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private LongitudeMinutesMeasureType longitudeMinutesMeasure;
    @XmlElement(name = "LongitudeDirectionCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private LongitudeDirectionCodeType longitudeDirectionCode;
    @XmlElement(name = "AltitudeMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private AltitudeMeasureType altitudeMeasure;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public LocationCoordinateType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the coordinateSystemCode property.
     * 
     * @return
     *     possible object is
     *     {@link CoordinateSystemCodeType }
     *     
     */
    @Nullable
    public CoordinateSystemCodeType getCoordinateSystemCode() {
        return coordinateSystemCode;
    }

    /**
     * Sets the value of the coordinateSystemCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CoordinateSystemCodeType }
     *     
     */
    public void setCoordinateSystemCode(
        @Nullable
        CoordinateSystemCodeType value) {
        this.coordinateSystemCode = value;
    }

    /**
     * Gets the value of the latitudeDegreesMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link LatitudeDegreesMeasureType }
     *     
     */
    @Nullable
    public LatitudeDegreesMeasureType getLatitudeDegreesMeasure() {
        return latitudeDegreesMeasure;
    }

    /**
     * Sets the value of the latitudeDegreesMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link LatitudeDegreesMeasureType }
     *     
     */
    public void setLatitudeDegreesMeasure(
        @Nullable
        LatitudeDegreesMeasureType value) {
        this.latitudeDegreesMeasure = value;
    }

    /**
     * Gets the value of the latitudeMinutesMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link LatitudeMinutesMeasureType }
     *     
     */
    @Nullable
    public LatitudeMinutesMeasureType getLatitudeMinutesMeasure() {
        return latitudeMinutesMeasure;
    }

    /**
     * Sets the value of the latitudeMinutesMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link LatitudeMinutesMeasureType }
     *     
     */
    public void setLatitudeMinutesMeasure(
        @Nullable
        LatitudeMinutesMeasureType value) {
        this.latitudeMinutesMeasure = value;
    }

    /**
     * Gets the value of the latitudeDirectionCode property.
     * 
     * @return
     *     possible object is
     *     {@link LatitudeDirectionCodeType }
     *     
     */
    @Nullable
    public LatitudeDirectionCodeType getLatitudeDirectionCode() {
        return latitudeDirectionCode;
    }

    /**
     * Sets the value of the latitudeDirectionCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link LatitudeDirectionCodeType }
     *     
     */
    public void setLatitudeDirectionCode(
        @Nullable
        LatitudeDirectionCodeType value) {
        this.latitudeDirectionCode = value;
    }

    /**
     * Gets the value of the longitudeDegreesMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link LongitudeDegreesMeasureType }
     *     
     */
    @Nullable
    public LongitudeDegreesMeasureType getLongitudeDegreesMeasure() {
        return longitudeDegreesMeasure;
    }

    /**
     * Sets the value of the longitudeDegreesMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link LongitudeDegreesMeasureType }
     *     
     */
    public void setLongitudeDegreesMeasure(
        @Nullable
        LongitudeDegreesMeasureType value) {
        this.longitudeDegreesMeasure = value;
    }

    /**
     * Gets the value of the longitudeMinutesMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link LongitudeMinutesMeasureType }
     *     
     */
    @Nullable
    public LongitudeMinutesMeasureType getLongitudeMinutesMeasure() {
        return longitudeMinutesMeasure;
    }

    /**
     * Sets the value of the longitudeMinutesMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link LongitudeMinutesMeasureType }
     *     
     */
    public void setLongitudeMinutesMeasure(
        @Nullable
        LongitudeMinutesMeasureType value) {
        this.longitudeMinutesMeasure = value;
    }

    /**
     * Gets the value of the longitudeDirectionCode property.
     * 
     * @return
     *     possible object is
     *     {@link LongitudeDirectionCodeType }
     *     
     */
    @Nullable
    public LongitudeDirectionCodeType getLongitudeDirectionCode() {
        return longitudeDirectionCode;
    }

    /**
     * Sets the value of the longitudeDirectionCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link LongitudeDirectionCodeType }
     *     
     */
    public void setLongitudeDirectionCode(
        @Nullable
        LongitudeDirectionCodeType value) {
        this.longitudeDirectionCode = value;
    }

    /**
     * Gets the value of the altitudeMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link AltitudeMeasureType }
     *     
     */
    @Nullable
    public AltitudeMeasureType getAltitudeMeasure() {
        return altitudeMeasure;
    }

    /**
     * Sets the value of the altitudeMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link AltitudeMeasureType }
     *     
     */
    public void setAltitudeMeasure(
        @Nullable
        AltitudeMeasureType value) {
        this.altitudeMeasure = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final LocationCoordinateType rhs = ((LocationCoordinateType) o);
        if (!EqualsHelper.equals(altitudeMeasure, rhs.altitudeMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(coordinateSystemCode, rhs.coordinateSystemCode)) {
            return false;
        }
        if (!EqualsHelper.equals(latitudeDegreesMeasure, rhs.latitudeDegreesMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(latitudeDirectionCode, rhs.latitudeDirectionCode)) {
            return false;
        }
        if (!EqualsHelper.equals(latitudeMinutesMeasure, rhs.latitudeMinutesMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(longitudeDegreesMeasure, rhs.longitudeDegreesMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(longitudeDirectionCode, rhs.longitudeDirectionCode)) {
            return false;
        }
        if (!EqualsHelper.equals(longitudeMinutesMeasure, rhs.longitudeMinutesMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(altitudeMeasure).append(coordinateSystemCode).append(latitudeDegreesMeasure).append(latitudeDirectionCode).append(latitudeMinutesMeasure).append(longitudeDegreesMeasure).append(longitudeDirectionCode).append(longitudeMinutesMeasure).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("altitudeMeasure", altitudeMeasure).append("coordinateSystemCode", coordinateSystemCode).append("latitudeDegreesMeasure", latitudeDegreesMeasure).append("latitudeDirectionCode", latitudeDirectionCode).append("latitudeMinutesMeasure", latitudeMinutesMeasure).append("longitudeDegreesMeasure", longitudeDegreesMeasure).append("longitudeDirectionCode", longitudeDirectionCode).append("longitudeMinutesMeasure", longitudeMinutesMeasure).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        LocationCoordinateType ret) {
        ret.altitudeMeasure = ((altitudeMeasure == null)?null:altitudeMeasure.clone());
        ret.coordinateSystemCode = ((coordinateSystemCode == null)?null:coordinateSystemCode.clone());
        ret.latitudeDegreesMeasure = ((latitudeDegreesMeasure == null)?null:latitudeDegreesMeasure.clone());
        ret.latitudeDirectionCode = ((latitudeDirectionCode == null)?null:latitudeDirectionCode.clone());
        ret.latitudeMinutesMeasure = ((latitudeMinutesMeasure == null)?null:latitudeMinutesMeasure.clone());
        ret.longitudeDegreesMeasure = ((longitudeDegreesMeasure == null)?null:longitudeDegreesMeasure.clone());
        ret.longitudeDirectionCode = ((longitudeDirectionCode == null)?null:longitudeDirectionCode.clone());
        ret.longitudeMinutesMeasure = ((longitudeMinutesMeasure == null)?null:longitudeMinutesMeasure.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public LocationCoordinateType clone() {
        LocationCoordinateType ret = new LocationCoordinateType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CoordinateSystemCodeType and never <code>null</code>
     */
    @Nonnull
    public CoordinateSystemCodeType setCoordinateSystemCode(
        @Nullable
        final String valueParam) {
        CoordinateSystemCodeType aObj = getCoordinateSystemCode();
        if (aObj == null) {
            aObj = new CoordinateSystemCodeType(valueParam);
            setCoordinateSystemCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type LatitudeDegreesMeasureType and never <code>null</code>
     */
    @Nonnull
    public LatitudeDegreesMeasureType setLatitudeDegreesMeasure(
        @Nullable
        final BigDecimal valueParam) {
        LatitudeDegreesMeasureType aObj = getLatitudeDegreesMeasure();
        if (aObj == null) {
            aObj = new LatitudeDegreesMeasureType(valueParam);
            setLatitudeDegreesMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type LatitudeMinutesMeasureType and never <code>null</code>
     */
    @Nonnull
    public LatitudeMinutesMeasureType setLatitudeMinutesMeasure(
        @Nullable
        final BigDecimal valueParam) {
        LatitudeMinutesMeasureType aObj = getLatitudeMinutesMeasure();
        if (aObj == null) {
            aObj = new LatitudeMinutesMeasureType(valueParam);
            setLatitudeMinutesMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type LatitudeDirectionCodeType and never <code>null</code>
     */
    @Nonnull
    public LatitudeDirectionCodeType setLatitudeDirectionCode(
        @Nullable
        final String valueParam) {
        LatitudeDirectionCodeType aObj = getLatitudeDirectionCode();
        if (aObj == null) {
            aObj = new LatitudeDirectionCodeType(valueParam);
            setLatitudeDirectionCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type LongitudeDegreesMeasureType and never <code>null</code>
     */
    @Nonnull
    public LongitudeDegreesMeasureType setLongitudeDegreesMeasure(
        @Nullable
        final BigDecimal valueParam) {
        LongitudeDegreesMeasureType aObj = getLongitudeDegreesMeasure();
        if (aObj == null) {
            aObj = new LongitudeDegreesMeasureType(valueParam);
            setLongitudeDegreesMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type LongitudeMinutesMeasureType and never <code>null</code>
     */
    @Nonnull
    public LongitudeMinutesMeasureType setLongitudeMinutesMeasure(
        @Nullable
        final BigDecimal valueParam) {
        LongitudeMinutesMeasureType aObj = getLongitudeMinutesMeasure();
        if (aObj == null) {
            aObj = new LongitudeMinutesMeasureType(valueParam);
            setLongitudeMinutesMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type LongitudeDirectionCodeType and never <code>null</code>
     */
    @Nonnull
    public LongitudeDirectionCodeType setLongitudeDirectionCode(
        @Nullable
        final String valueParam) {
        LongitudeDirectionCodeType aObj = getLongitudeDirectionCode();
        if (aObj == null) {
            aObj = new LongitudeDirectionCodeType(valueParam);
            setLongitudeDirectionCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type AltitudeMeasureType and never <code>null</code>
     */
    @Nonnull
    public AltitudeMeasureType setAltitudeMeasure(
        @Nullable
        final BigDecimal valueParam) {
        AltitudeMeasureType aObj = getAltitudeMeasure();
        if (aObj == null) {
            aObj = new AltitudeMeasureType(valueParam);
            setAltitudeMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained CoordinateSystemCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CoordinateSystemCodeType object or <code>null</code>
     */
    @Nullable
    public String getCoordinateSystemCodeValue() {
        CoordinateSystemCodeType aObj = getCoordinateSystemCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained LatitudeDegreesMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained LatitudeDegreesMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getLatitudeDegreesMeasureValue() {
        LatitudeDegreesMeasureType aObj = getLatitudeDegreesMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained LatitudeMinutesMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained LatitudeMinutesMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getLatitudeMinutesMeasureValue() {
        LatitudeMinutesMeasureType aObj = getLatitudeMinutesMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained LatitudeDirectionCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained LatitudeDirectionCodeType object or <code>null</code>
     */
    @Nullable
    public String getLatitudeDirectionCodeValue() {
        LatitudeDirectionCodeType aObj = getLatitudeDirectionCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained LongitudeDegreesMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained LongitudeDegreesMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getLongitudeDegreesMeasureValue() {
        LongitudeDegreesMeasureType aObj = getLongitudeDegreesMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained LongitudeMinutesMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained LongitudeMinutesMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getLongitudeMinutesMeasureValue() {
        LongitudeMinutesMeasureType aObj = getLongitudeMinutesMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained LongitudeDirectionCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained LongitudeDirectionCodeType object or <code>null</code>
     */
    @Nullable
    public String getLongitudeDirectionCodeValue() {
        LongitudeDirectionCodeType aObj = getLongitudeDirectionCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained AltitudeMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained AltitudeMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getAltitudeMeasureValue() {
        AltitudeMeasureType aObj = getAltitudeMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

}
