
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.GroupingLotsType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.MaximumLotsAwardedNumericType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.MaximumLotsSubmittedNumericType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for LotDistributionType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="LotDistributionType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MaximumLotsAwardedNumeric" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MaximumLotsSubmittedNumeric" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}GroupingLots" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}LotsGroup" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "LotDistributionType", propOrder = {
    "ublExtensions",
    "maximumLotsAwardedNumeric",
    "maximumLotsSubmittedNumeric",
    "groupingLots",
    "lotsGroup"
})
@CodingStyleguideUnaware
public class LotDistributionType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "MaximumLotsAwardedNumeric", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MaximumLotsAwardedNumericType maximumLotsAwardedNumeric;
    @XmlElement(name = "MaximumLotsSubmittedNumeric", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MaximumLotsSubmittedNumericType maximumLotsSubmittedNumeric;
    @XmlElement(name = "GroupingLots", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<GroupingLotsType> groupingLots;
    @XmlElement(name = "LotsGroup")
    private List<LotsGroupType> lotsGroup;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public LotDistributionType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the maximumLotsAwardedNumeric property.
     * 
     * @return
     *     possible object is
     *     {@link MaximumLotsAwardedNumericType }
     *     
     */
    @Nullable
    public MaximumLotsAwardedNumericType getMaximumLotsAwardedNumeric() {
        return maximumLotsAwardedNumeric;
    }

    /**
     * Sets the value of the maximumLotsAwardedNumeric property.
     * 
     * @param value
     *     allowed object is
     *     {@link MaximumLotsAwardedNumericType }
     *     
     */
    public void setMaximumLotsAwardedNumeric(
        @Nullable
        MaximumLotsAwardedNumericType value) {
        this.maximumLotsAwardedNumeric = value;
    }

    /**
     * Gets the value of the maximumLotsSubmittedNumeric property.
     * 
     * @return
     *     possible object is
     *     {@link MaximumLotsSubmittedNumericType }
     *     
     */
    @Nullable
    public MaximumLotsSubmittedNumericType getMaximumLotsSubmittedNumeric() {
        return maximumLotsSubmittedNumeric;
    }

    /**
     * Sets the value of the maximumLotsSubmittedNumeric property.
     * 
     * @param value
     *     allowed object is
     *     {@link MaximumLotsSubmittedNumericType }
     *     
     */
    public void setMaximumLotsSubmittedNumeric(
        @Nullable
        MaximumLotsSubmittedNumericType value) {
        this.maximumLotsSubmittedNumeric = value;
    }

    /**
     * Gets the value of the groupingLots property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the groupingLots property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getGroupingLots().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link GroupingLotsType }
     * </p>
     * 
     * 
     * @return
     *     The value of the groupingLots property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<GroupingLotsType> getGroupingLots() {
        if (groupingLots == null) {
            groupingLots = new ArrayList<>();
        }
        return this.groupingLots;
    }

    /**
     * Gets the value of the lotsGroup property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the lotsGroup property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getLotsGroup().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LotsGroupType }
     * </p>
     * 
     * 
     * @return
     *     The value of the lotsGroup property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<LotsGroupType> getLotsGroup() {
        if (lotsGroup == null) {
            lotsGroup = new ArrayList<>();
        }
        return this.lotsGroup;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final LotDistributionType rhs = ((LotDistributionType) o);
        if (!EqualsHelper.equalsCollection(groupingLots, rhs.groupingLots)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(lotsGroup, rhs.lotsGroup)) {
            return false;
        }
        if (!EqualsHelper.equals(maximumLotsAwardedNumeric, rhs.maximumLotsAwardedNumeric)) {
            return false;
        }
        if (!EqualsHelper.equals(maximumLotsSubmittedNumeric, rhs.maximumLotsSubmittedNumeric)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(groupingLots).append(lotsGroup).append(maximumLotsAwardedNumeric).append(maximumLotsSubmittedNumeric).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("groupingLots", groupingLots).append("lotsGroup", lotsGroup).append("maximumLotsAwardedNumeric", maximumLotsAwardedNumeric).append("maximumLotsSubmittedNumeric", maximumLotsSubmittedNumeric).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setGroupingLots(
        @Nullable
        final List<GroupingLotsType> aList) {
        groupingLots = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setLotsGroup(
        @Nullable
        final List<LotsGroupType> aList) {
        lotsGroup = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasGroupingLotsEntries() {
        return (!getGroupingLots().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoGroupingLotsEntries() {
        return getGroupingLots().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getGroupingLotsCount() {
        return getGroupingLots().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public GroupingLotsType getGroupingLotsAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getGroupingLots().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addGroupingLots(
        @Nonnull
        final GroupingLotsType elem) {
        getGroupingLots().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasLotsGroupEntries() {
        return (!getLotsGroup().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoLotsGroupEntries() {
        return getLotsGroup().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getLotsGroupCount() {
        return getLotsGroup().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public LotsGroupType getLotsGroupAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getLotsGroup().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addLotsGroup(
        @Nonnull
        final LotsGroupType elem) {
        getLotsGroup().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        LotDistributionType ret) {
        if (groupingLots == null) {
            ret.groupingLots = null;
        } else {
            List<GroupingLotsType> retGroupingLots = new ArrayList<>();
            for (GroupingLotsType aItem: getGroupingLots()) {
                retGroupingLots.add(((aItem == null)?null:aItem.clone()));
            }
            ret.groupingLots = retGroupingLots;
        }
        if (lotsGroup == null) {
            ret.lotsGroup = null;
        } else {
            List<LotsGroupType> retLotsGroup = new ArrayList<>();
            for (LotsGroupType aItem: getLotsGroup()) {
                retLotsGroup.add(((aItem == null)?null:aItem.clone()));
            }
            ret.lotsGroup = retLotsGroup;
        }
        ret.maximumLotsAwardedNumeric = ((maximumLotsAwardedNumeric == null)?null:maximumLotsAwardedNumeric.clone());
        ret.maximumLotsSubmittedNumeric = ((maximumLotsSubmittedNumeric == null)?null:maximumLotsSubmittedNumeric.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public LotDistributionType clone() {
        LotDistributionType ret = new LotDistributionType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MaximumLotsAwardedNumericType and never <code>null</code>
     */
    @Nonnull
    public MaximumLotsAwardedNumericType setMaximumLotsAwardedNumeric(
        @Nullable
        final BigDecimal valueParam) {
        MaximumLotsAwardedNumericType aObj = getMaximumLotsAwardedNumeric();
        if (aObj == null) {
            aObj = new MaximumLotsAwardedNumericType(valueParam);
            setMaximumLotsAwardedNumeric(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MaximumLotsSubmittedNumericType and never <code>null</code>
     */
    @Nonnull
    public MaximumLotsSubmittedNumericType setMaximumLotsSubmittedNumeric(
        @Nullable
        final BigDecimal valueParam) {
        MaximumLotsSubmittedNumericType aObj = getMaximumLotsSubmittedNumeric();
        if (aObj == null) {
            aObj = new MaximumLotsSubmittedNumericType(valueParam);
            setMaximumLotsSubmittedNumeric(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained MaximumLotsAwardedNumericType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MaximumLotsAwardedNumericType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getMaximumLotsAwardedNumericValue() {
        MaximumLotsAwardedNumericType aObj = getMaximumLotsAwardedNumeric();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MaximumLotsSubmittedNumericType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MaximumLotsSubmittedNumericType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getMaximumLotsSubmittedNumericValue() {
        MaximumLotsSubmittedNumericType aObj = getMaximumLotsSubmittedNumeric();
        return (aObj == null)?null:aObj.getValue();
    }

}
