
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ExpiryDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.LotNumberIDType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for LotIdentificationType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="LotIdentificationType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}LotNumberID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ExpiryDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}AdditionalItemProperty" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "LotIdentificationType", propOrder = {
    "ublExtensions",
    "lotNumberID",
    "expiryDate",
    "additionalItemProperty"
})
@CodingStyleguideUnaware
public class LotIdentificationType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "LotNumberID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private LotNumberIDType lotNumberID;
    @XmlElement(name = "ExpiryDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ExpiryDateType expiryDate;
    @XmlElement(name = "AdditionalItemProperty")
    private List<ItemPropertyType> additionalItemProperty;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public LotIdentificationType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the lotNumberID property.
     * 
     * @return
     *     possible object is
     *     {@link LotNumberIDType }
     *     
     */
    @Nullable
    public LotNumberIDType getLotNumberID() {
        return lotNumberID;
    }

    /**
     * Sets the value of the lotNumberID property.
     * 
     * @param value
     *     allowed object is
     *     {@link LotNumberIDType }
     *     
     */
    public void setLotNumberID(
        @Nullable
        LotNumberIDType value) {
        this.lotNumberID = value;
    }

    /**
     * Gets the value of the expiryDate property.
     * 
     * @return
     *     possible object is
     *     {@link ExpiryDateType }
     *     
     */
    @Nullable
    public ExpiryDateType getExpiryDate() {
        return expiryDate;
    }

    /**
     * Sets the value of the expiryDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExpiryDateType }
     *     
     */
    public void setExpiryDate(
        @Nullable
        ExpiryDateType value) {
        this.expiryDate = value;
    }

    /**
     * Gets the value of the additionalItemProperty property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the additionalItemProperty property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getAdditionalItemProperty().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ItemPropertyType }
     * </p>
     * 
     * 
     * @return
     *     The value of the additionalItemProperty property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ItemPropertyType> getAdditionalItemProperty() {
        if (additionalItemProperty == null) {
            additionalItemProperty = new ArrayList<>();
        }
        return this.additionalItemProperty;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final LotIdentificationType rhs = ((LotIdentificationType) o);
        if (!EqualsHelper.equalsCollection(additionalItemProperty, rhs.additionalItemProperty)) {
            return false;
        }
        if (!EqualsHelper.equals(expiryDate, rhs.expiryDate)) {
            return false;
        }
        if (!EqualsHelper.equals(lotNumberID, rhs.lotNumberID)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(additionalItemProperty).append(expiryDate).append(lotNumberID).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("additionalItemProperty", additionalItemProperty).append("expiryDate", expiryDate).append("lotNumberID", lotNumberID).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAdditionalItemProperty(
        @Nullable
        final List<ItemPropertyType> aList) {
        additionalItemProperty = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAdditionalItemPropertyEntries() {
        return (!getAdditionalItemProperty().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAdditionalItemPropertyEntries() {
        return getAdditionalItemProperty().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAdditionalItemPropertyCount() {
        return getAdditionalItemProperty().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ItemPropertyType getAdditionalItemPropertyAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAdditionalItemProperty().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAdditionalItemProperty(
        @Nonnull
        final ItemPropertyType elem) {
        getAdditionalItemProperty().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        LotIdentificationType ret) {
        if (additionalItemProperty == null) {
            ret.additionalItemProperty = null;
        } else {
            List<ItemPropertyType> retAdditionalItemProperty = new ArrayList<>();
            for (ItemPropertyType aItem: getAdditionalItemProperty()) {
                retAdditionalItemProperty.add(((aItem == null)?null:aItem.clone()));
            }
            ret.additionalItemProperty = retAdditionalItemProperty;
        }
        ret.expiryDate = ((expiryDate == null)?null:expiryDate.clone());
        ret.lotNumberID = ((lotNumberID == null)?null:lotNumberID.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public LotIdentificationType clone() {
        LotIdentificationType ret = new LotIdentificationType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type LotNumberIDType and never <code>null</code>
     */
    @Nonnull
    public LotNumberIDType setLotNumberID(
        @Nullable
        final String valueParam) {
        LotNumberIDType aObj = getLotNumberID();
        if (aObj == null) {
            aObj = new LotNumberIDType(valueParam);
            setLotNumberID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ExpiryDateType and never <code>null</code>
     */
    @Nonnull
    public ExpiryDateType setExpiryDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        ExpiryDateType aObj = getExpiryDate();
        if (aObj == null) {
            aObj = new ExpiryDateType(valueParam);
            setExpiryDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ExpiryDateType and never <code>null</code>
     */
    @Nonnull
    public ExpiryDateType setExpiryDate(
        @Nullable
        final LocalDate valueParam) {
        ExpiryDateType aObj = getExpiryDate();
        if (aObj == null) {
            aObj = new ExpiryDateType(valueParam);
            setExpiryDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained LotNumberIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained LotNumberIDType object or <code>null</code>
     */
    @Nullable
    public String getLotNumberIDValue() {
        LotNumberIDType aObj = getLotNumberID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ExpiryDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ExpiryDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getExpiryDateValue() {
        ExpiryDateType aObj = getExpiryDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ExpiryDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ExpiryDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getExpiryDateValueLocal() {
        ExpiryDateType aObj = getExpiryDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

}
