
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.FumigatedCargoTransportIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.InfectiousDiseaseCaseOnBoardIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.LastDrinkingWaterAnalysisDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.MedicalPractitionerConsultedIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.MoreIllThanExpectedIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ReinspectionRequiredIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.SanitaryMeasuresAppliedIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.SickAnimalDescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.SickAnimalOnBoardIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.StowawayDescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.StowawaysFoundOnBoardIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TotalDeadPersonQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TotalIllPersonQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ValidSanitationCertificateOnBoardIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for MaritimeHealthDeclarationType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="MaritimeHealthDeclarationType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}InfectiousDiseaseCaseOnBoardIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MoreIllThanExpectedIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MedicalPractitionerConsultedIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}StowawaysFoundOnBoardIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}SickAnimalOnBoardIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}FumigatedCargoTransportIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}SanitaryMeasuresAppliedIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ValidSanitationCertificateOnBoardIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ReinspectionRequiredIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TotalDeadPersonQuantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TotalIllPersonQuantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}SickAnimalDescription" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}StowawayDescription" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}LastDrinkingWaterAnalysisDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}WHOAffectedAreaVisit" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}PersonnelHealthIncident" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}SanitaryMeasure" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}PlaceOfReportLocation" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}MedicalCertificate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ShipSanitationControlCertificate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ShipSanitationControlExemptionDocumentReference" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "MaritimeHealthDeclarationType", propOrder = {
    "ublExtensions",
    "id",
    "infectiousDiseaseCaseOnBoardIndicator",
    "moreIllThanExpectedIndicator",
    "medicalPractitionerConsultedIndicator",
    "stowawaysFoundOnBoardIndicator",
    "sickAnimalOnBoardIndicator",
    "fumigatedCargoTransportIndicator",
    "sanitaryMeasuresAppliedIndicator",
    "validSanitationCertificateOnBoardIndicator",
    "reinspectionRequiredIndicator",
    "totalDeadPersonQuantity",
    "totalIllPersonQuantity",
    "sickAnimalDescription",
    "stowawayDescription",
    "lastDrinkingWaterAnalysisDate",
    "whoAffectedAreaVisit",
    "personnelHealthIncident",
    "sanitaryMeasure",
    "placeOfReportLocation",
    "medicalCertificate",
    "shipSanitationControlCertificate",
    "shipSanitationControlExemptionDocumentReference"
})
@CodingStyleguideUnaware
public class MaritimeHealthDeclarationType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IDType id;
    @XmlElement(name = "InfectiousDiseaseCaseOnBoardIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private InfectiousDiseaseCaseOnBoardIndicatorType infectiousDiseaseCaseOnBoardIndicator;
    @XmlElement(name = "MoreIllThanExpectedIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MoreIllThanExpectedIndicatorType moreIllThanExpectedIndicator;
    @XmlElement(name = "MedicalPractitionerConsultedIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MedicalPractitionerConsultedIndicatorType medicalPractitionerConsultedIndicator;
    @XmlElement(name = "StowawaysFoundOnBoardIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private StowawaysFoundOnBoardIndicatorType stowawaysFoundOnBoardIndicator;
    @XmlElement(name = "SickAnimalOnBoardIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private SickAnimalOnBoardIndicatorType sickAnimalOnBoardIndicator;
    @XmlElement(name = "FumigatedCargoTransportIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private FumigatedCargoTransportIndicatorType fumigatedCargoTransportIndicator;
    @XmlElement(name = "SanitaryMeasuresAppliedIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private SanitaryMeasuresAppliedIndicatorType sanitaryMeasuresAppliedIndicator;
    @XmlElement(name = "ValidSanitationCertificateOnBoardIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ValidSanitationCertificateOnBoardIndicatorType validSanitationCertificateOnBoardIndicator;
    @XmlElement(name = "ReinspectionRequiredIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ReinspectionRequiredIndicatorType reinspectionRequiredIndicator;
    @XmlElement(name = "TotalDeadPersonQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TotalDeadPersonQuantityType totalDeadPersonQuantity;
    @XmlElement(name = "TotalIllPersonQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TotalIllPersonQuantityType totalIllPersonQuantity;
    @XmlElement(name = "SickAnimalDescription", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<SickAnimalDescriptionType> sickAnimalDescription;
    @XmlElement(name = "StowawayDescription", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<StowawayDescriptionType> stowawayDescription;
    @XmlElement(name = "LastDrinkingWaterAnalysisDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private LastDrinkingWaterAnalysisDateType lastDrinkingWaterAnalysisDate;
    @XmlElement(name = "WHOAffectedAreaVisit")
    private List<WHOAffectedAreaVisitType> whoAffectedAreaVisit;
    @XmlElement(name = "PersonnelHealthIncident")
    private List<PersonnelHealthIncidentType> personnelHealthIncident;
    @XmlElement(name = "SanitaryMeasure")
    private List<SanitaryMeasureType> sanitaryMeasure;
    @XmlElement(name = "PlaceOfReportLocation")
    private LocationType placeOfReportLocation;
    @XmlElement(name = "MedicalCertificate")
    private CertificateType medicalCertificate;
    @XmlElement(name = "ShipSanitationControlCertificate")
    private CertificateType shipSanitationControlCertificate;
    @XmlElement(name = "ShipSanitationControlExemptionDocumentReference")
    private List<DocumentReferenceType> shipSanitationControlExemptionDocumentReference;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public MaritimeHealthDeclarationType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the infectiousDiseaseCaseOnBoardIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link InfectiousDiseaseCaseOnBoardIndicatorType }
     *     
     */
    @Nullable
    public InfectiousDiseaseCaseOnBoardIndicatorType getInfectiousDiseaseCaseOnBoardIndicator() {
        return infectiousDiseaseCaseOnBoardIndicator;
    }

    /**
     * Sets the value of the infectiousDiseaseCaseOnBoardIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link InfectiousDiseaseCaseOnBoardIndicatorType }
     *     
     */
    public void setInfectiousDiseaseCaseOnBoardIndicator(
        @Nullable
        InfectiousDiseaseCaseOnBoardIndicatorType value) {
        this.infectiousDiseaseCaseOnBoardIndicator = value;
    }

    /**
     * Gets the value of the moreIllThanExpectedIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link MoreIllThanExpectedIndicatorType }
     *     
     */
    @Nullable
    public MoreIllThanExpectedIndicatorType getMoreIllThanExpectedIndicator() {
        return moreIllThanExpectedIndicator;
    }

    /**
     * Sets the value of the moreIllThanExpectedIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link MoreIllThanExpectedIndicatorType }
     *     
     */
    public void setMoreIllThanExpectedIndicator(
        @Nullable
        MoreIllThanExpectedIndicatorType value) {
        this.moreIllThanExpectedIndicator = value;
    }

    /**
     * Gets the value of the medicalPractitionerConsultedIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link MedicalPractitionerConsultedIndicatorType }
     *     
     */
    @Nullable
    public MedicalPractitionerConsultedIndicatorType getMedicalPractitionerConsultedIndicator() {
        return medicalPractitionerConsultedIndicator;
    }

    /**
     * Sets the value of the medicalPractitionerConsultedIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link MedicalPractitionerConsultedIndicatorType }
     *     
     */
    public void setMedicalPractitionerConsultedIndicator(
        @Nullable
        MedicalPractitionerConsultedIndicatorType value) {
        this.medicalPractitionerConsultedIndicator = value;
    }

    /**
     * Gets the value of the stowawaysFoundOnBoardIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link StowawaysFoundOnBoardIndicatorType }
     *     
     */
    @Nullable
    public StowawaysFoundOnBoardIndicatorType getStowawaysFoundOnBoardIndicator() {
        return stowawaysFoundOnBoardIndicator;
    }

    /**
     * Sets the value of the stowawaysFoundOnBoardIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link StowawaysFoundOnBoardIndicatorType }
     *     
     */
    public void setStowawaysFoundOnBoardIndicator(
        @Nullable
        StowawaysFoundOnBoardIndicatorType value) {
        this.stowawaysFoundOnBoardIndicator = value;
    }

    /**
     * Gets the value of the sickAnimalOnBoardIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link SickAnimalOnBoardIndicatorType }
     *     
     */
    @Nullable
    public SickAnimalOnBoardIndicatorType getSickAnimalOnBoardIndicator() {
        return sickAnimalOnBoardIndicator;
    }

    /**
     * Sets the value of the sickAnimalOnBoardIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link SickAnimalOnBoardIndicatorType }
     *     
     */
    public void setSickAnimalOnBoardIndicator(
        @Nullable
        SickAnimalOnBoardIndicatorType value) {
        this.sickAnimalOnBoardIndicator = value;
    }

    /**
     * Gets the value of the fumigatedCargoTransportIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link FumigatedCargoTransportIndicatorType }
     *     
     */
    @Nullable
    public FumigatedCargoTransportIndicatorType getFumigatedCargoTransportIndicator() {
        return fumigatedCargoTransportIndicator;
    }

    /**
     * Sets the value of the fumigatedCargoTransportIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link FumigatedCargoTransportIndicatorType }
     *     
     */
    public void setFumigatedCargoTransportIndicator(
        @Nullable
        FumigatedCargoTransportIndicatorType value) {
        this.fumigatedCargoTransportIndicator = value;
    }

    /**
     * Gets the value of the sanitaryMeasuresAppliedIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link SanitaryMeasuresAppliedIndicatorType }
     *     
     */
    @Nullable
    public SanitaryMeasuresAppliedIndicatorType getSanitaryMeasuresAppliedIndicator() {
        return sanitaryMeasuresAppliedIndicator;
    }

    /**
     * Sets the value of the sanitaryMeasuresAppliedIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link SanitaryMeasuresAppliedIndicatorType }
     *     
     */
    public void setSanitaryMeasuresAppliedIndicator(
        @Nullable
        SanitaryMeasuresAppliedIndicatorType value) {
        this.sanitaryMeasuresAppliedIndicator = value;
    }

    /**
     * Gets the value of the validSanitationCertificateOnBoardIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link ValidSanitationCertificateOnBoardIndicatorType }
     *     
     */
    @Nullable
    public ValidSanitationCertificateOnBoardIndicatorType getValidSanitationCertificateOnBoardIndicator() {
        return validSanitationCertificateOnBoardIndicator;
    }

    /**
     * Sets the value of the validSanitationCertificateOnBoardIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link ValidSanitationCertificateOnBoardIndicatorType }
     *     
     */
    public void setValidSanitationCertificateOnBoardIndicator(
        @Nullable
        ValidSanitationCertificateOnBoardIndicatorType value) {
        this.validSanitationCertificateOnBoardIndicator = value;
    }

    /**
     * Gets the value of the reinspectionRequiredIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link ReinspectionRequiredIndicatorType }
     *     
     */
    @Nullable
    public ReinspectionRequiredIndicatorType getReinspectionRequiredIndicator() {
        return reinspectionRequiredIndicator;
    }

    /**
     * Sets the value of the reinspectionRequiredIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReinspectionRequiredIndicatorType }
     *     
     */
    public void setReinspectionRequiredIndicator(
        @Nullable
        ReinspectionRequiredIndicatorType value) {
        this.reinspectionRequiredIndicator = value;
    }

    /**
     * Gets the value of the totalDeadPersonQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link TotalDeadPersonQuantityType }
     *     
     */
    @Nullable
    public TotalDeadPersonQuantityType getTotalDeadPersonQuantity() {
        return totalDeadPersonQuantity;
    }

    /**
     * Sets the value of the totalDeadPersonQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link TotalDeadPersonQuantityType }
     *     
     */
    public void setTotalDeadPersonQuantity(
        @Nullable
        TotalDeadPersonQuantityType value) {
        this.totalDeadPersonQuantity = value;
    }

    /**
     * Gets the value of the totalIllPersonQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link TotalIllPersonQuantityType }
     *     
     */
    @Nullable
    public TotalIllPersonQuantityType getTotalIllPersonQuantity() {
        return totalIllPersonQuantity;
    }

    /**
     * Sets the value of the totalIllPersonQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link TotalIllPersonQuantityType }
     *     
     */
    public void setTotalIllPersonQuantity(
        @Nullable
        TotalIllPersonQuantityType value) {
        this.totalIllPersonQuantity = value;
    }

    /**
     * Gets the value of the sickAnimalDescription property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the sickAnimalDescription property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getSickAnimalDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SickAnimalDescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the sickAnimalDescription property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<SickAnimalDescriptionType> getSickAnimalDescription() {
        if (sickAnimalDescription == null) {
            sickAnimalDescription = new ArrayList<>();
        }
        return this.sickAnimalDescription;
    }

    /**
     * Gets the value of the stowawayDescription property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the stowawayDescription property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getStowawayDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link StowawayDescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the stowawayDescription property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<StowawayDescriptionType> getStowawayDescription() {
        if (stowawayDescription == null) {
            stowawayDescription = new ArrayList<>();
        }
        return this.stowawayDescription;
    }

    /**
     * Gets the value of the lastDrinkingWaterAnalysisDate property.
     * 
     * @return
     *     possible object is
     *     {@link LastDrinkingWaterAnalysisDateType }
     *     
     */
    @Nullable
    public LastDrinkingWaterAnalysisDateType getLastDrinkingWaterAnalysisDate() {
        return lastDrinkingWaterAnalysisDate;
    }

    /**
     * Sets the value of the lastDrinkingWaterAnalysisDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link LastDrinkingWaterAnalysisDateType }
     *     
     */
    public void setLastDrinkingWaterAnalysisDate(
        @Nullable
        LastDrinkingWaterAnalysisDateType value) {
        this.lastDrinkingWaterAnalysisDate = value;
    }

    /**
     * Gets the value of the whoAffectedAreaVisit property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the whoAffectedAreaVisit property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getWHOAffectedAreaVisit().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link WHOAffectedAreaVisitType }
     * </p>
     * 
     * 
     * @return
     *     The value of the whoAffectedAreaVisit property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<WHOAffectedAreaVisitType> getWHOAffectedAreaVisit() {
        if (whoAffectedAreaVisit == null) {
            whoAffectedAreaVisit = new ArrayList<>();
        }
        return this.whoAffectedAreaVisit;
    }

    /**
     * Gets the value of the personnelHealthIncident property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the personnelHealthIncident property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPersonnelHealthIncident().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PersonnelHealthIncidentType }
     * </p>
     * 
     * 
     * @return
     *     The value of the personnelHealthIncident property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PersonnelHealthIncidentType> getPersonnelHealthIncident() {
        if (personnelHealthIncident == null) {
            personnelHealthIncident = new ArrayList<>();
        }
        return this.personnelHealthIncident;
    }

    /**
     * Gets the value of the sanitaryMeasure property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the sanitaryMeasure property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getSanitaryMeasure().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SanitaryMeasureType }
     * </p>
     * 
     * 
     * @return
     *     The value of the sanitaryMeasure property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<SanitaryMeasureType> getSanitaryMeasure() {
        if (sanitaryMeasure == null) {
            sanitaryMeasure = new ArrayList<>();
        }
        return this.sanitaryMeasure;
    }

    /**
     * Gets the value of the placeOfReportLocation property.
     * 
     * @return
     *     possible object is
     *     {@link LocationType }
     *     
     */
    @Nullable
    public LocationType getPlaceOfReportLocation() {
        return placeOfReportLocation;
    }

    /**
     * Sets the value of the placeOfReportLocation property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocationType }
     *     
     */
    public void setPlaceOfReportLocation(
        @Nullable
        LocationType value) {
        this.placeOfReportLocation = value;
    }

    /**
     * Gets the value of the medicalCertificate property.
     * 
     * @return
     *     possible object is
     *     {@link CertificateType }
     *     
     */
    @Nullable
    public CertificateType getMedicalCertificate() {
        return medicalCertificate;
    }

    /**
     * Sets the value of the medicalCertificate property.
     * 
     * @param value
     *     allowed object is
     *     {@link CertificateType }
     *     
     */
    public void setMedicalCertificate(
        @Nullable
        CertificateType value) {
        this.medicalCertificate = value;
    }

    /**
     * Gets the value of the shipSanitationControlCertificate property.
     * 
     * @return
     *     possible object is
     *     {@link CertificateType }
     *     
     */
    @Nullable
    public CertificateType getShipSanitationControlCertificate() {
        return shipSanitationControlCertificate;
    }

    /**
     * Sets the value of the shipSanitationControlCertificate property.
     * 
     * @param value
     *     allowed object is
     *     {@link CertificateType }
     *     
     */
    public void setShipSanitationControlCertificate(
        @Nullable
        CertificateType value) {
        this.shipSanitationControlCertificate = value;
    }

    /**
     * Gets the value of the shipSanitationControlExemptionDocumentReference property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the shipSanitationControlExemptionDocumentReference property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getShipSanitationControlExemptionDocumentReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentReferenceType }
     * </p>
     * 
     * 
     * @return
     *     The value of the shipSanitationControlExemptionDocumentReference property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentReferenceType> getShipSanitationControlExemptionDocumentReference() {
        if (shipSanitationControlExemptionDocumentReference == null) {
            shipSanitationControlExemptionDocumentReference = new ArrayList<>();
        }
        return this.shipSanitationControlExemptionDocumentReference;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final MaritimeHealthDeclarationType rhs = ((MaritimeHealthDeclarationType) o);
        if (!EqualsHelper.equals(fumigatedCargoTransportIndicator, rhs.fumigatedCargoTransportIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(infectiousDiseaseCaseOnBoardIndicator, rhs.infectiousDiseaseCaseOnBoardIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(lastDrinkingWaterAnalysisDate, rhs.lastDrinkingWaterAnalysisDate)) {
            return false;
        }
        if (!EqualsHelper.equals(medicalCertificate, rhs.medicalCertificate)) {
            return false;
        }
        if (!EqualsHelper.equals(medicalPractitionerConsultedIndicator, rhs.medicalPractitionerConsultedIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(moreIllThanExpectedIndicator, rhs.moreIllThanExpectedIndicator)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(personnelHealthIncident, rhs.personnelHealthIncident)) {
            return false;
        }
        if (!EqualsHelper.equals(placeOfReportLocation, rhs.placeOfReportLocation)) {
            return false;
        }
        if (!EqualsHelper.equals(reinspectionRequiredIndicator, rhs.reinspectionRequiredIndicator)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(sanitaryMeasure, rhs.sanitaryMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(sanitaryMeasuresAppliedIndicator, rhs.sanitaryMeasuresAppliedIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(shipSanitationControlCertificate, rhs.shipSanitationControlCertificate)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(shipSanitationControlExemptionDocumentReference, rhs.shipSanitationControlExemptionDocumentReference)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(sickAnimalDescription, rhs.sickAnimalDescription)) {
            return false;
        }
        if (!EqualsHelper.equals(sickAnimalOnBoardIndicator, rhs.sickAnimalOnBoardIndicator)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(stowawayDescription, rhs.stowawayDescription)) {
            return false;
        }
        if (!EqualsHelper.equals(stowawaysFoundOnBoardIndicator, rhs.stowawaysFoundOnBoardIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(totalDeadPersonQuantity, rhs.totalDeadPersonQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(totalIllPersonQuantity, rhs.totalIllPersonQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        if (!EqualsHelper.equals(validSanitationCertificateOnBoardIndicator, rhs.validSanitationCertificateOnBoardIndicator)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(whoAffectedAreaVisit, rhs.whoAffectedAreaVisit)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(fumigatedCargoTransportIndicator).append(id).append(infectiousDiseaseCaseOnBoardIndicator).append(lastDrinkingWaterAnalysisDate).append(medicalCertificate).append(medicalPractitionerConsultedIndicator).append(moreIllThanExpectedIndicator).append(personnelHealthIncident).append(placeOfReportLocation).append(reinspectionRequiredIndicator).append(sanitaryMeasure).append(sanitaryMeasuresAppliedIndicator).append(shipSanitationControlCertificate).append(shipSanitationControlExemptionDocumentReference).append(sickAnimalDescription).append(sickAnimalOnBoardIndicator).append(stowawayDescription).append(stowawaysFoundOnBoardIndicator).append(totalDeadPersonQuantity).append(totalIllPersonQuantity).append(ublExtensions).append(validSanitationCertificateOnBoardIndicator).append(whoAffectedAreaVisit).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("fumigatedCargoTransportIndicator", fumigatedCargoTransportIndicator).append("id", id).append("infectiousDiseaseCaseOnBoardIndicator", infectiousDiseaseCaseOnBoardIndicator).append("lastDrinkingWaterAnalysisDate", lastDrinkingWaterAnalysisDate).append("medicalCertificate", medicalCertificate).append("medicalPractitionerConsultedIndicator", medicalPractitionerConsultedIndicator).append("moreIllThanExpectedIndicator", moreIllThanExpectedIndicator).append("personnelHealthIncident", personnelHealthIncident).append("placeOfReportLocation", placeOfReportLocation).append("reinspectionRequiredIndicator", reinspectionRequiredIndicator).append("sanitaryMeasure", sanitaryMeasure).append("sanitaryMeasuresAppliedIndicator", sanitaryMeasuresAppliedIndicator).append("shipSanitationControlCertificate", shipSanitationControlCertificate).append("shipSanitationControlExemptionDocumentReference", shipSanitationControlExemptionDocumentReference).append("sickAnimalDescription", sickAnimalDescription).append("sickAnimalOnBoardIndicator", sickAnimalOnBoardIndicator).append("stowawayDescription", stowawayDescription).append("stowawaysFoundOnBoardIndicator", stowawaysFoundOnBoardIndicator).append("totalDeadPersonQuantity", totalDeadPersonQuantity).append("totalIllPersonQuantity", totalIllPersonQuantity).append("ublExtensions", ublExtensions).append("validSanitationCertificateOnBoardIndicator", validSanitationCertificateOnBoardIndicator).append("whoAffectedAreaVisit", whoAffectedAreaVisit).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSickAnimalDescription(
        @Nullable
        final List<SickAnimalDescriptionType> aList) {
        sickAnimalDescription = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setStowawayDescription(
        @Nullable
        final List<StowawayDescriptionType> aList) {
        stowawayDescription = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setWHOAffectedAreaVisit(
        @Nullable
        final List<WHOAffectedAreaVisitType> aList) {
        whoAffectedAreaVisit = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPersonnelHealthIncident(
        @Nullable
        final List<PersonnelHealthIncidentType> aList) {
        personnelHealthIncident = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSanitaryMeasure(
        @Nullable
        final List<SanitaryMeasureType> aList) {
        sanitaryMeasure = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setShipSanitationControlExemptionDocumentReference(
        @Nullable
        final List<DocumentReferenceType> aList) {
        shipSanitationControlExemptionDocumentReference = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSickAnimalDescriptionEntries() {
        return (!getSickAnimalDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSickAnimalDescriptionEntries() {
        return getSickAnimalDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSickAnimalDescriptionCount() {
        return getSickAnimalDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public SickAnimalDescriptionType getSickAnimalDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSickAnimalDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSickAnimalDescription(
        @Nonnull
        final SickAnimalDescriptionType elem) {
        getSickAnimalDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasStowawayDescriptionEntries() {
        return (!getStowawayDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoStowawayDescriptionEntries() {
        return getStowawayDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getStowawayDescriptionCount() {
        return getStowawayDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public StowawayDescriptionType getStowawayDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getStowawayDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addStowawayDescription(
        @Nonnull
        final StowawayDescriptionType elem) {
        getStowawayDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasWHOAffectedAreaVisitEntries() {
        return (!getWHOAffectedAreaVisit().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoWHOAffectedAreaVisitEntries() {
        return getWHOAffectedAreaVisit().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getWHOAffectedAreaVisitCount() {
        return getWHOAffectedAreaVisit().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public WHOAffectedAreaVisitType getWHOAffectedAreaVisitAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getWHOAffectedAreaVisit().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addWHOAffectedAreaVisit(
        @Nonnull
        final WHOAffectedAreaVisitType elem) {
        getWHOAffectedAreaVisit().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPersonnelHealthIncidentEntries() {
        return (!getPersonnelHealthIncident().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPersonnelHealthIncidentEntries() {
        return getPersonnelHealthIncident().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPersonnelHealthIncidentCount() {
        return getPersonnelHealthIncident().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PersonnelHealthIncidentType getPersonnelHealthIncidentAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPersonnelHealthIncident().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPersonnelHealthIncident(
        @Nonnull
        final PersonnelHealthIncidentType elem) {
        getPersonnelHealthIncident().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSanitaryMeasureEntries() {
        return (!getSanitaryMeasure().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSanitaryMeasureEntries() {
        return getSanitaryMeasure().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSanitaryMeasureCount() {
        return getSanitaryMeasure().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public SanitaryMeasureType getSanitaryMeasureAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSanitaryMeasure().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSanitaryMeasure(
        @Nonnull
        final SanitaryMeasureType elem) {
        getSanitaryMeasure().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasShipSanitationControlExemptionDocumentReferenceEntries() {
        return (!getShipSanitationControlExemptionDocumentReference().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoShipSanitationControlExemptionDocumentReferenceEntries() {
        return getShipSanitationControlExemptionDocumentReference().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getShipSanitationControlExemptionDocumentReferenceCount() {
        return getShipSanitationControlExemptionDocumentReference().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentReferenceType getShipSanitationControlExemptionDocumentReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getShipSanitationControlExemptionDocumentReference().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addShipSanitationControlExemptionDocumentReference(
        @Nonnull
        final DocumentReferenceType elem) {
        getShipSanitationControlExemptionDocumentReference().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        MaritimeHealthDeclarationType ret) {
        ret.fumigatedCargoTransportIndicator = ((fumigatedCargoTransportIndicator == null)?null:fumigatedCargoTransportIndicator.clone());
        ret.id = ((id == null)?null:id.clone());
        ret.infectiousDiseaseCaseOnBoardIndicator = ((infectiousDiseaseCaseOnBoardIndicator == null)?null:infectiousDiseaseCaseOnBoardIndicator.clone());
        ret.lastDrinkingWaterAnalysisDate = ((lastDrinkingWaterAnalysisDate == null)?null:lastDrinkingWaterAnalysisDate.clone());
        ret.medicalCertificate = ((medicalCertificate == null)?null:medicalCertificate.clone());
        ret.medicalPractitionerConsultedIndicator = ((medicalPractitionerConsultedIndicator == null)?null:medicalPractitionerConsultedIndicator.clone());
        ret.moreIllThanExpectedIndicator = ((moreIllThanExpectedIndicator == null)?null:moreIllThanExpectedIndicator.clone());
        if (personnelHealthIncident == null) {
            ret.personnelHealthIncident = null;
        } else {
            List<PersonnelHealthIncidentType> retPersonnelHealthIncident = new ArrayList<>();
            for (PersonnelHealthIncidentType aItem: getPersonnelHealthIncident()) {
                retPersonnelHealthIncident.add(((aItem == null)?null:aItem.clone()));
            }
            ret.personnelHealthIncident = retPersonnelHealthIncident;
        }
        ret.placeOfReportLocation = ((placeOfReportLocation == null)?null:placeOfReportLocation.clone());
        ret.reinspectionRequiredIndicator = ((reinspectionRequiredIndicator == null)?null:reinspectionRequiredIndicator.clone());
        if (sanitaryMeasure == null) {
            ret.sanitaryMeasure = null;
        } else {
            List<SanitaryMeasureType> retSanitaryMeasure = new ArrayList<>();
            for (SanitaryMeasureType aItem: getSanitaryMeasure()) {
                retSanitaryMeasure.add(((aItem == null)?null:aItem.clone()));
            }
            ret.sanitaryMeasure = retSanitaryMeasure;
        }
        ret.sanitaryMeasuresAppliedIndicator = ((sanitaryMeasuresAppliedIndicator == null)?null:sanitaryMeasuresAppliedIndicator.clone());
        ret.shipSanitationControlCertificate = ((shipSanitationControlCertificate == null)?null:shipSanitationControlCertificate.clone());
        if (shipSanitationControlExemptionDocumentReference == null) {
            ret.shipSanitationControlExemptionDocumentReference = null;
        } else {
            List<DocumentReferenceType> retShipSanitationControlExemptionDocumentReference = new ArrayList<>();
            for (DocumentReferenceType aItem: getShipSanitationControlExemptionDocumentReference()) {
                retShipSanitationControlExemptionDocumentReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.shipSanitationControlExemptionDocumentReference = retShipSanitationControlExemptionDocumentReference;
        }
        if (sickAnimalDescription == null) {
            ret.sickAnimalDescription = null;
        } else {
            List<SickAnimalDescriptionType> retSickAnimalDescription = new ArrayList<>();
            for (SickAnimalDescriptionType aItem: getSickAnimalDescription()) {
                retSickAnimalDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.sickAnimalDescription = retSickAnimalDescription;
        }
        ret.sickAnimalOnBoardIndicator = ((sickAnimalOnBoardIndicator == null)?null:sickAnimalOnBoardIndicator.clone());
        if (stowawayDescription == null) {
            ret.stowawayDescription = null;
        } else {
            List<StowawayDescriptionType> retStowawayDescription = new ArrayList<>();
            for (StowawayDescriptionType aItem: getStowawayDescription()) {
                retStowawayDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.stowawayDescription = retStowawayDescription;
        }
        ret.stowawaysFoundOnBoardIndicator = ((stowawaysFoundOnBoardIndicator == null)?null:stowawaysFoundOnBoardIndicator.clone());
        ret.totalDeadPersonQuantity = ((totalDeadPersonQuantity == null)?null:totalDeadPersonQuantity.clone());
        ret.totalIllPersonQuantity = ((totalIllPersonQuantity == null)?null:totalIllPersonQuantity.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
        ret.validSanitationCertificateOnBoardIndicator = ((validSanitationCertificateOnBoardIndicator == null)?null:validSanitationCertificateOnBoardIndicator.clone());
        if (whoAffectedAreaVisit == null) {
            ret.whoAffectedAreaVisit = null;
        } else {
            List<WHOAffectedAreaVisitType> retWHOAffectedAreaVisit = new ArrayList<>();
            for (WHOAffectedAreaVisitType aItem: getWHOAffectedAreaVisit()) {
                retWHOAffectedAreaVisit.add(((aItem == null)?null:aItem.clone()));
            }
            ret.whoAffectedAreaVisit = retWHOAffectedAreaVisit;
        }
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public MaritimeHealthDeclarationType clone() {
        MaritimeHealthDeclarationType ret = new MaritimeHealthDeclarationType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type InfectiousDiseaseCaseOnBoardIndicatorType and never <code>null</code>
     */
    @Nonnull
    public InfectiousDiseaseCaseOnBoardIndicatorType setInfectiousDiseaseCaseOnBoardIndicator(final boolean valueParam) {
        InfectiousDiseaseCaseOnBoardIndicatorType aObj = getInfectiousDiseaseCaseOnBoardIndicator();
        if (aObj == null) {
            aObj = new InfectiousDiseaseCaseOnBoardIndicatorType(valueParam);
            setInfectiousDiseaseCaseOnBoardIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type MoreIllThanExpectedIndicatorType and never <code>null</code>
     */
    @Nonnull
    public MoreIllThanExpectedIndicatorType setMoreIllThanExpectedIndicator(final boolean valueParam) {
        MoreIllThanExpectedIndicatorType aObj = getMoreIllThanExpectedIndicator();
        if (aObj == null) {
            aObj = new MoreIllThanExpectedIndicatorType(valueParam);
            setMoreIllThanExpectedIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type MedicalPractitionerConsultedIndicatorType and never <code>null</code>
     */
    @Nonnull
    public MedicalPractitionerConsultedIndicatorType setMedicalPractitionerConsultedIndicator(final boolean valueParam) {
        MedicalPractitionerConsultedIndicatorType aObj = getMedicalPractitionerConsultedIndicator();
        if (aObj == null) {
            aObj = new MedicalPractitionerConsultedIndicatorType(valueParam);
            setMedicalPractitionerConsultedIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type StowawaysFoundOnBoardIndicatorType and never <code>null</code>
     */
    @Nonnull
    public StowawaysFoundOnBoardIndicatorType setStowawaysFoundOnBoardIndicator(final boolean valueParam) {
        StowawaysFoundOnBoardIndicatorType aObj = getStowawaysFoundOnBoardIndicator();
        if (aObj == null) {
            aObj = new StowawaysFoundOnBoardIndicatorType(valueParam);
            setStowawaysFoundOnBoardIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type SickAnimalOnBoardIndicatorType and never <code>null</code>
     */
    @Nonnull
    public SickAnimalOnBoardIndicatorType setSickAnimalOnBoardIndicator(final boolean valueParam) {
        SickAnimalOnBoardIndicatorType aObj = getSickAnimalOnBoardIndicator();
        if (aObj == null) {
            aObj = new SickAnimalOnBoardIndicatorType(valueParam);
            setSickAnimalOnBoardIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type FumigatedCargoTransportIndicatorType and never <code>null</code>
     */
    @Nonnull
    public FumigatedCargoTransportIndicatorType setFumigatedCargoTransportIndicator(final boolean valueParam) {
        FumigatedCargoTransportIndicatorType aObj = getFumigatedCargoTransportIndicator();
        if (aObj == null) {
            aObj = new FumigatedCargoTransportIndicatorType(valueParam);
            setFumigatedCargoTransportIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type SanitaryMeasuresAppliedIndicatorType and never <code>null</code>
     */
    @Nonnull
    public SanitaryMeasuresAppliedIndicatorType setSanitaryMeasuresAppliedIndicator(final boolean valueParam) {
        SanitaryMeasuresAppliedIndicatorType aObj = getSanitaryMeasuresAppliedIndicator();
        if (aObj == null) {
            aObj = new SanitaryMeasuresAppliedIndicatorType(valueParam);
            setSanitaryMeasuresAppliedIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type ValidSanitationCertificateOnBoardIndicatorType and never <code>null</code>
     */
    @Nonnull
    public ValidSanitationCertificateOnBoardIndicatorType setValidSanitationCertificateOnBoardIndicator(final boolean valueParam) {
        ValidSanitationCertificateOnBoardIndicatorType aObj = getValidSanitationCertificateOnBoardIndicator();
        if (aObj == null) {
            aObj = new ValidSanitationCertificateOnBoardIndicatorType(valueParam);
            setValidSanitationCertificateOnBoardIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type ReinspectionRequiredIndicatorType and never <code>null</code>
     */
    @Nonnull
    public ReinspectionRequiredIndicatorType setReinspectionRequiredIndicator(final boolean valueParam) {
        ReinspectionRequiredIndicatorType aObj = getReinspectionRequiredIndicator();
        if (aObj == null) {
            aObj = new ReinspectionRequiredIndicatorType(valueParam);
            setReinspectionRequiredIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TotalDeadPersonQuantityType and never <code>null</code>
     */
    @Nonnull
    public TotalDeadPersonQuantityType setTotalDeadPersonQuantity(
        @Nullable
        final BigDecimal valueParam) {
        TotalDeadPersonQuantityType aObj = getTotalDeadPersonQuantity();
        if (aObj == null) {
            aObj = new TotalDeadPersonQuantityType(valueParam);
            setTotalDeadPersonQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TotalIllPersonQuantityType and never <code>null</code>
     */
    @Nonnull
    public TotalIllPersonQuantityType setTotalIllPersonQuantity(
        @Nullable
        final BigDecimal valueParam) {
        TotalIllPersonQuantityType aObj = getTotalIllPersonQuantity();
        if (aObj == null) {
            aObj = new TotalIllPersonQuantityType(valueParam);
            setTotalIllPersonQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type LastDrinkingWaterAnalysisDateType and never <code>null</code>
     */
    @Nonnull
    public LastDrinkingWaterAnalysisDateType setLastDrinkingWaterAnalysisDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        LastDrinkingWaterAnalysisDateType aObj = getLastDrinkingWaterAnalysisDate();
        if (aObj == null) {
            aObj = new LastDrinkingWaterAnalysisDateType(valueParam);
            setLastDrinkingWaterAnalysisDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type LastDrinkingWaterAnalysisDateType and never <code>null</code>
     */
    @Nonnull
    public LastDrinkingWaterAnalysisDateType setLastDrinkingWaterAnalysisDate(
        @Nullable
        final LocalDate valueParam) {
        LastDrinkingWaterAnalysisDateType aObj = getLastDrinkingWaterAnalysisDate();
        if (aObj == null) {
            aObj = new LastDrinkingWaterAnalysisDateType(valueParam);
            setLastDrinkingWaterAnalysisDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained InfectiousDiseaseCaseOnBoardIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained InfectiousDiseaseCaseOnBoardIndicatorType object or the passed nullValue
     */
    public boolean isInfectiousDiseaseCaseOnBoardIndicatorValue(final boolean nullValue) {
        InfectiousDiseaseCaseOnBoardIndicatorType aObj = getInfectiousDiseaseCaseOnBoardIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained MoreIllThanExpectedIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained MoreIllThanExpectedIndicatorType object or the passed nullValue
     */
    public boolean isMoreIllThanExpectedIndicatorValue(final boolean nullValue) {
        MoreIllThanExpectedIndicatorType aObj = getMoreIllThanExpectedIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained MedicalPractitionerConsultedIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained MedicalPractitionerConsultedIndicatorType object or the passed nullValue
     */
    public boolean isMedicalPractitionerConsultedIndicatorValue(final boolean nullValue) {
        MedicalPractitionerConsultedIndicatorType aObj = getMedicalPractitionerConsultedIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained StowawaysFoundOnBoardIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained StowawaysFoundOnBoardIndicatorType object or the passed nullValue
     */
    public boolean isStowawaysFoundOnBoardIndicatorValue(final boolean nullValue) {
        StowawaysFoundOnBoardIndicatorType aObj = getStowawaysFoundOnBoardIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained SickAnimalOnBoardIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained SickAnimalOnBoardIndicatorType object or the passed nullValue
     */
    public boolean isSickAnimalOnBoardIndicatorValue(final boolean nullValue) {
        SickAnimalOnBoardIndicatorType aObj = getSickAnimalOnBoardIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained FumigatedCargoTransportIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained FumigatedCargoTransportIndicatorType object or the passed nullValue
     */
    public boolean isFumigatedCargoTransportIndicatorValue(final boolean nullValue) {
        FumigatedCargoTransportIndicatorType aObj = getFumigatedCargoTransportIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained SanitaryMeasuresAppliedIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained SanitaryMeasuresAppliedIndicatorType object or the passed nullValue
     */
    public boolean isSanitaryMeasuresAppliedIndicatorValue(final boolean nullValue) {
        SanitaryMeasuresAppliedIndicatorType aObj = getSanitaryMeasuresAppliedIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained ValidSanitationCertificateOnBoardIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained ValidSanitationCertificateOnBoardIndicatorType object or the passed nullValue
     */
    public boolean isValidSanitationCertificateOnBoardIndicatorValue(final boolean nullValue) {
        ValidSanitationCertificateOnBoardIndicatorType aObj = getValidSanitationCertificateOnBoardIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained ReinspectionRequiredIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained ReinspectionRequiredIndicatorType object or the passed nullValue
     */
    public boolean isReinspectionRequiredIndicatorValue(final boolean nullValue) {
        ReinspectionRequiredIndicatorType aObj = getReinspectionRequiredIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained TotalDeadPersonQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TotalDeadPersonQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getTotalDeadPersonQuantityValue() {
        TotalDeadPersonQuantityType aObj = getTotalDeadPersonQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TotalIllPersonQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TotalIllPersonQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getTotalIllPersonQuantityValue() {
        TotalIllPersonQuantityType aObj = getTotalIllPersonQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained LastDrinkingWaterAnalysisDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained LastDrinkingWaterAnalysisDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getLastDrinkingWaterAnalysisDateValue() {
        LastDrinkingWaterAnalysisDateType aObj = getLastDrinkingWaterAnalysisDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained LastDrinkingWaterAnalysisDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained LastDrinkingWaterAnalysisDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getLastDrinkingWaterAnalysisDateValueLocal() {
        LastDrinkingWaterAnalysisDateType aObj = getLastDrinkingWaterAnalysisDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

}
