
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.AntennaLocusType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.GrossTonnageMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.INFShipClassCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.MMSIRegistrationIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.NetTonnageMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.RadioCallSignIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.SegregatedBallastMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ShipConfigurationCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ShipsRequirementsType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.VesselIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.VesselNameType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for MaritimeTransportType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="MaritimeTransportType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}VesselID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}VesselName" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}RadioCallSignID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MMSIRegistrationID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ShipsRequirements" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}GrossTonnageMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}NetTonnageMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}SegregatedBallastMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ShipConfigurationCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}INFShipClassCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}AntennaLocus" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}RegistryCertificateDocumentReference" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}RegistryPortLocation" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}VesselDynamics" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "MaritimeTransportType", propOrder = {
    "ublExtensions",
    "vesselID",
    "vesselName",
    "radioCallSignID",
    "mmsiRegistrationID",
    "shipsRequirements",
    "grossTonnageMeasure",
    "netTonnageMeasure",
    "segregatedBallastMeasure",
    "shipConfigurationCode",
    "infShipClassCode",
    "antennaLocus",
    "registryCertificateDocumentReference",
    "registryPortLocation",
    "vesselDynamics"
})
@CodingStyleguideUnaware
public class MaritimeTransportType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "VesselID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private VesselIDType vesselID;
    @XmlElement(name = "VesselName", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private VesselNameType vesselName;
    @XmlElement(name = "RadioCallSignID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private RadioCallSignIDType radioCallSignID;
    @XmlElement(name = "MMSIRegistrationID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MMSIRegistrationIDType mmsiRegistrationID;
    @XmlElement(name = "ShipsRequirements", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<ShipsRequirementsType> shipsRequirements;
    @XmlElement(name = "GrossTonnageMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private GrossTonnageMeasureType grossTonnageMeasure;
    @XmlElement(name = "NetTonnageMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private NetTonnageMeasureType netTonnageMeasure;
    @XmlElement(name = "SegregatedBallastMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private SegregatedBallastMeasureType segregatedBallastMeasure;
    @XmlElement(name = "ShipConfigurationCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ShipConfigurationCodeType shipConfigurationCode;
    @XmlElement(name = "INFShipClassCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private INFShipClassCodeType infShipClassCode;
    @XmlElement(name = "AntennaLocus", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private AntennaLocusType antennaLocus;
    @XmlElement(name = "RegistryCertificateDocumentReference")
    private DocumentReferenceType registryCertificateDocumentReference;
    @XmlElement(name = "RegistryPortLocation")
    private LocationType registryPortLocation;
    @XmlElement(name = "VesselDynamics")
    private VesselDynamicsType vesselDynamics;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public MaritimeTransportType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the vesselID property.
     * 
     * @return
     *     possible object is
     *     {@link VesselIDType }
     *     
     */
    @Nullable
    public VesselIDType getVesselID() {
        return vesselID;
    }

    /**
     * Sets the value of the vesselID property.
     * 
     * @param value
     *     allowed object is
     *     {@link VesselIDType }
     *     
     */
    public void setVesselID(
        @Nullable
        VesselIDType value) {
        this.vesselID = value;
    }

    /**
     * Gets the value of the vesselName property.
     * 
     * @return
     *     possible object is
     *     {@link VesselNameType }
     *     
     */
    @Nullable
    public VesselNameType getVesselName() {
        return vesselName;
    }

    /**
     * Sets the value of the vesselName property.
     * 
     * @param value
     *     allowed object is
     *     {@link VesselNameType }
     *     
     */
    public void setVesselName(
        @Nullable
        VesselNameType value) {
        this.vesselName = value;
    }

    /**
     * Gets the value of the radioCallSignID property.
     * 
     * @return
     *     possible object is
     *     {@link RadioCallSignIDType }
     *     
     */
    @Nullable
    public RadioCallSignIDType getRadioCallSignID() {
        return radioCallSignID;
    }

    /**
     * Sets the value of the radioCallSignID property.
     * 
     * @param value
     *     allowed object is
     *     {@link RadioCallSignIDType }
     *     
     */
    public void setRadioCallSignID(
        @Nullable
        RadioCallSignIDType value) {
        this.radioCallSignID = value;
    }

    /**
     * Gets the value of the mmsiRegistrationID property.
     * 
     * @return
     *     possible object is
     *     {@link MMSIRegistrationIDType }
     *     
     */
    @Nullable
    public MMSIRegistrationIDType getMMSIRegistrationID() {
        return mmsiRegistrationID;
    }

    /**
     * Sets the value of the mmsiRegistrationID property.
     * 
     * @param value
     *     allowed object is
     *     {@link MMSIRegistrationIDType }
     *     
     */
    public void setMMSIRegistrationID(
        @Nullable
        MMSIRegistrationIDType value) {
        this.mmsiRegistrationID = value;
    }

    /**
     * Gets the value of the shipsRequirements property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the shipsRequirements property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getShipsRequirements().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ShipsRequirementsType }
     * </p>
     * 
     * 
     * @return
     *     The value of the shipsRequirements property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ShipsRequirementsType> getShipsRequirements() {
        if (shipsRequirements == null) {
            shipsRequirements = new ArrayList<>();
        }
        return this.shipsRequirements;
    }

    /**
     * Gets the value of the grossTonnageMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link GrossTonnageMeasureType }
     *     
     */
    @Nullable
    public GrossTonnageMeasureType getGrossTonnageMeasure() {
        return grossTonnageMeasure;
    }

    /**
     * Sets the value of the grossTonnageMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link GrossTonnageMeasureType }
     *     
     */
    public void setGrossTonnageMeasure(
        @Nullable
        GrossTonnageMeasureType value) {
        this.grossTonnageMeasure = value;
    }

    /**
     * Gets the value of the netTonnageMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link NetTonnageMeasureType }
     *     
     */
    @Nullable
    public NetTonnageMeasureType getNetTonnageMeasure() {
        return netTonnageMeasure;
    }

    /**
     * Sets the value of the netTonnageMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link NetTonnageMeasureType }
     *     
     */
    public void setNetTonnageMeasure(
        @Nullable
        NetTonnageMeasureType value) {
        this.netTonnageMeasure = value;
    }

    /**
     * Gets the value of the segregatedBallastMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link SegregatedBallastMeasureType }
     *     
     */
    @Nullable
    public SegregatedBallastMeasureType getSegregatedBallastMeasure() {
        return segregatedBallastMeasure;
    }

    /**
     * Sets the value of the segregatedBallastMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link SegregatedBallastMeasureType }
     *     
     */
    public void setSegregatedBallastMeasure(
        @Nullable
        SegregatedBallastMeasureType value) {
        this.segregatedBallastMeasure = value;
    }

    /**
     * Gets the value of the shipConfigurationCode property.
     * 
     * @return
     *     possible object is
     *     {@link ShipConfigurationCodeType }
     *     
     */
    @Nullable
    public ShipConfigurationCodeType getShipConfigurationCode() {
        return shipConfigurationCode;
    }

    /**
     * Sets the value of the shipConfigurationCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link ShipConfigurationCodeType }
     *     
     */
    public void setShipConfigurationCode(
        @Nullable
        ShipConfigurationCodeType value) {
        this.shipConfigurationCode = value;
    }

    /**
     * Gets the value of the infShipClassCode property.
     * 
     * @return
     *     possible object is
     *     {@link INFShipClassCodeType }
     *     
     */
    @Nullable
    public INFShipClassCodeType getINFShipClassCode() {
        return infShipClassCode;
    }

    /**
     * Sets the value of the infShipClassCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link INFShipClassCodeType }
     *     
     */
    public void setINFShipClassCode(
        @Nullable
        INFShipClassCodeType value) {
        this.infShipClassCode = value;
    }

    /**
     * Gets the value of the antennaLocus property.
     * 
     * @return
     *     possible object is
     *     {@link AntennaLocusType }
     *     
     */
    @Nullable
    public AntennaLocusType getAntennaLocus() {
        return antennaLocus;
    }

    /**
     * Sets the value of the antennaLocus property.
     * 
     * @param value
     *     allowed object is
     *     {@link AntennaLocusType }
     *     
     */
    public void setAntennaLocus(
        @Nullable
        AntennaLocusType value) {
        this.antennaLocus = value;
    }

    /**
     * Gets the value of the registryCertificateDocumentReference property.
     * 
     * @return
     *     possible object is
     *     {@link DocumentReferenceType }
     *     
     */
    @Nullable
    public DocumentReferenceType getRegistryCertificateDocumentReference() {
        return registryCertificateDocumentReference;
    }

    /**
     * Sets the value of the registryCertificateDocumentReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link DocumentReferenceType }
     *     
     */
    public void setRegistryCertificateDocumentReference(
        @Nullable
        DocumentReferenceType value) {
        this.registryCertificateDocumentReference = value;
    }

    /**
     * Gets the value of the registryPortLocation property.
     * 
     * @return
     *     possible object is
     *     {@link LocationType }
     *     
     */
    @Nullable
    public LocationType getRegistryPortLocation() {
        return registryPortLocation;
    }

    /**
     * Sets the value of the registryPortLocation property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocationType }
     *     
     */
    public void setRegistryPortLocation(
        @Nullable
        LocationType value) {
        this.registryPortLocation = value;
    }

    /**
     * Gets the value of the vesselDynamics property.
     * 
     * @return
     *     possible object is
     *     {@link VesselDynamicsType }
     *     
     */
    @Nullable
    public VesselDynamicsType getVesselDynamics() {
        return vesselDynamics;
    }

    /**
     * Sets the value of the vesselDynamics property.
     * 
     * @param value
     *     allowed object is
     *     {@link VesselDynamicsType }
     *     
     */
    public void setVesselDynamics(
        @Nullable
        VesselDynamicsType value) {
        this.vesselDynamics = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final MaritimeTransportType rhs = ((MaritimeTransportType) o);
        if (!EqualsHelper.equals(antennaLocus, rhs.antennaLocus)) {
            return false;
        }
        if (!EqualsHelper.equals(grossTonnageMeasure, rhs.grossTonnageMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(infShipClassCode, rhs.infShipClassCode)) {
            return false;
        }
        if (!EqualsHelper.equals(mmsiRegistrationID, rhs.mmsiRegistrationID)) {
            return false;
        }
        if (!EqualsHelper.equals(netTonnageMeasure, rhs.netTonnageMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(radioCallSignID, rhs.radioCallSignID)) {
            return false;
        }
        if (!EqualsHelper.equals(registryCertificateDocumentReference, rhs.registryCertificateDocumentReference)) {
            return false;
        }
        if (!EqualsHelper.equals(registryPortLocation, rhs.registryPortLocation)) {
            return false;
        }
        if (!EqualsHelper.equals(segregatedBallastMeasure, rhs.segregatedBallastMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(shipConfigurationCode, rhs.shipConfigurationCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(shipsRequirements, rhs.shipsRequirements)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        if (!EqualsHelper.equals(vesselDynamics, rhs.vesselDynamics)) {
            return false;
        }
        if (!EqualsHelper.equals(vesselID, rhs.vesselID)) {
            return false;
        }
        if (!EqualsHelper.equals(vesselName, rhs.vesselName)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(antennaLocus).append(grossTonnageMeasure).append(infShipClassCode).append(mmsiRegistrationID).append(netTonnageMeasure).append(radioCallSignID).append(registryCertificateDocumentReference).append(registryPortLocation).append(segregatedBallastMeasure).append(shipConfigurationCode).append(shipsRequirements).append(ublExtensions).append(vesselDynamics).append(vesselID).append(vesselName).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("antennaLocus", antennaLocus).append("grossTonnageMeasure", grossTonnageMeasure).append("infShipClassCode", infShipClassCode).append("mmsiRegistrationID", mmsiRegistrationID).append("netTonnageMeasure", netTonnageMeasure).append("radioCallSignID", radioCallSignID).append("registryCertificateDocumentReference", registryCertificateDocumentReference).append("registryPortLocation", registryPortLocation).append("segregatedBallastMeasure", segregatedBallastMeasure).append("shipConfigurationCode", shipConfigurationCode).append("shipsRequirements", shipsRequirements).append("ublExtensions", ublExtensions).append("vesselDynamics", vesselDynamics).append("vesselID", vesselID).append("vesselName", vesselName).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setShipsRequirements(
        @Nullable
        final List<ShipsRequirementsType> aList) {
        shipsRequirements = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasShipsRequirementsEntries() {
        return (!getShipsRequirements().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoShipsRequirementsEntries() {
        return getShipsRequirements().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getShipsRequirementsCount() {
        return getShipsRequirements().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ShipsRequirementsType getShipsRequirementsAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getShipsRequirements().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addShipsRequirements(
        @Nonnull
        final ShipsRequirementsType elem) {
        getShipsRequirements().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        MaritimeTransportType ret) {
        ret.antennaLocus = ((antennaLocus == null)?null:antennaLocus.clone());
        ret.grossTonnageMeasure = ((grossTonnageMeasure == null)?null:grossTonnageMeasure.clone());
        ret.infShipClassCode = ((infShipClassCode == null)?null:infShipClassCode.clone());
        ret.mmsiRegistrationID = ((mmsiRegistrationID == null)?null:mmsiRegistrationID.clone());
        ret.netTonnageMeasure = ((netTonnageMeasure == null)?null:netTonnageMeasure.clone());
        ret.radioCallSignID = ((radioCallSignID == null)?null:radioCallSignID.clone());
        ret.registryCertificateDocumentReference = ((registryCertificateDocumentReference == null)?null:registryCertificateDocumentReference.clone());
        ret.registryPortLocation = ((registryPortLocation == null)?null:registryPortLocation.clone());
        ret.segregatedBallastMeasure = ((segregatedBallastMeasure == null)?null:segregatedBallastMeasure.clone());
        ret.shipConfigurationCode = ((shipConfigurationCode == null)?null:shipConfigurationCode.clone());
        if (shipsRequirements == null) {
            ret.shipsRequirements = null;
        } else {
            List<ShipsRequirementsType> retShipsRequirements = new ArrayList<>();
            for (ShipsRequirementsType aItem: getShipsRequirements()) {
                retShipsRequirements.add(((aItem == null)?null:aItem.clone()));
            }
            ret.shipsRequirements = retShipsRequirements;
        }
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
        ret.vesselDynamics = ((vesselDynamics == null)?null:vesselDynamics.clone());
        ret.vesselID = ((vesselID == null)?null:vesselID.clone());
        ret.vesselName = ((vesselName == null)?null:vesselName.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public MaritimeTransportType clone() {
        MaritimeTransportType ret = new MaritimeTransportType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type VesselIDType and never <code>null</code>
     */
    @Nonnull
    public VesselIDType setVesselID(
        @Nullable
        final String valueParam) {
        VesselIDType aObj = getVesselID();
        if (aObj == null) {
            aObj = new VesselIDType(valueParam);
            setVesselID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type VesselNameType and never <code>null</code>
     */
    @Nonnull
    public VesselNameType setVesselName(
        @Nullable
        final String valueParam) {
        VesselNameType aObj = getVesselName();
        if (aObj == null) {
            aObj = new VesselNameType(valueParam);
            setVesselName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type RadioCallSignIDType and never <code>null</code>
     */
    @Nonnull
    public RadioCallSignIDType setRadioCallSignID(
        @Nullable
        final String valueParam) {
        RadioCallSignIDType aObj = getRadioCallSignID();
        if (aObj == null) {
            aObj = new RadioCallSignIDType(valueParam);
            setRadioCallSignID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MMSIRegistrationIDType and never <code>null</code>
     */
    @Nonnull
    public MMSIRegistrationIDType setMMSIRegistrationID(
        @Nullable
        final String valueParam) {
        MMSIRegistrationIDType aObj = getMMSIRegistrationID();
        if (aObj == null) {
            aObj = new MMSIRegistrationIDType(valueParam);
            setMMSIRegistrationID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type GrossTonnageMeasureType and never <code>null</code>
     */
    @Nonnull
    public GrossTonnageMeasureType setGrossTonnageMeasure(
        @Nullable
        final BigDecimal valueParam) {
        GrossTonnageMeasureType aObj = getGrossTonnageMeasure();
        if (aObj == null) {
            aObj = new GrossTonnageMeasureType(valueParam);
            setGrossTonnageMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NetTonnageMeasureType and never <code>null</code>
     */
    @Nonnull
    public NetTonnageMeasureType setNetTonnageMeasure(
        @Nullable
        final BigDecimal valueParam) {
        NetTonnageMeasureType aObj = getNetTonnageMeasure();
        if (aObj == null) {
            aObj = new NetTonnageMeasureType(valueParam);
            setNetTonnageMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SegregatedBallastMeasureType and never <code>null</code>
     */
    @Nonnull
    public SegregatedBallastMeasureType setSegregatedBallastMeasure(
        @Nullable
        final BigDecimal valueParam) {
        SegregatedBallastMeasureType aObj = getSegregatedBallastMeasure();
        if (aObj == null) {
            aObj = new SegregatedBallastMeasureType(valueParam);
            setSegregatedBallastMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ShipConfigurationCodeType and never <code>null</code>
     */
    @Nonnull
    public ShipConfigurationCodeType setShipConfigurationCode(
        @Nullable
        final String valueParam) {
        ShipConfigurationCodeType aObj = getShipConfigurationCode();
        if (aObj == null) {
            aObj = new ShipConfigurationCodeType(valueParam);
            setShipConfigurationCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type INFShipClassCodeType and never <code>null</code>
     */
    @Nonnull
    public INFShipClassCodeType setINFShipClassCode(
        @Nullable
        final String valueParam) {
        INFShipClassCodeType aObj = getINFShipClassCode();
        if (aObj == null) {
            aObj = new INFShipClassCodeType(valueParam);
            setINFShipClassCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type AntennaLocusType and never <code>null</code>
     */
    @Nonnull
    public AntennaLocusType setAntennaLocus(
        @Nullable
        final String valueParam) {
        AntennaLocusType aObj = getAntennaLocus();
        if (aObj == null) {
            aObj = new AntennaLocusType(valueParam);
            setAntennaLocus(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained VesselIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained VesselIDType object or <code>null</code>
     */
    @Nullable
    public String getVesselIDValue() {
        VesselIDType aObj = getVesselID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained VesselNameType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained VesselNameType object or <code>null</code>
     */
    @Nullable
    public String getVesselNameValue() {
        VesselNameType aObj = getVesselName();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained RadioCallSignIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained RadioCallSignIDType object or <code>null</code>
     */
    @Nullable
    public String getRadioCallSignIDValue() {
        RadioCallSignIDType aObj = getRadioCallSignID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MMSIRegistrationIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MMSIRegistrationIDType object or <code>null</code>
     */
    @Nullable
    public String getMMSIRegistrationIDValue() {
        MMSIRegistrationIDType aObj = getMMSIRegistrationID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained GrossTonnageMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained GrossTonnageMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getGrossTonnageMeasureValue() {
        GrossTonnageMeasureType aObj = getGrossTonnageMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained NetTonnageMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NetTonnageMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getNetTonnageMeasureValue() {
        NetTonnageMeasureType aObj = getNetTonnageMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained SegregatedBallastMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SegregatedBallastMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getSegregatedBallastMeasureValue() {
        SegregatedBallastMeasureType aObj = getSegregatedBallastMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ShipConfigurationCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ShipConfigurationCodeType object or <code>null</code>
     */
    @Nullable
    public String getShipConfigurationCodeValue() {
        ShipConfigurationCodeType aObj = getShipConfigurationCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained INFShipClassCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained INFShipClassCodeType object or <code>null</code>
     */
    @Nullable
    public String getINFShipClassCodeValue() {
        INFShipClassCodeType aObj = getINFShipClassCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained AntennaLocusType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained AntennaLocusType object or <code>null</code>
     */
    @Nullable
    public String getAntennaLocusValue() {
        AntennaLocusType aObj = getAntennaLocus();
        return (aObj == null)?null:aObj.getValue();
    }

}
