
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.EndpointURIType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.EnvelopeTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ProtocolIDType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for MessageDeliveryType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="MessageDeliveryType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ProtocolID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}EnvelopeTypeCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}EndpointURI" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "MessageDeliveryType", propOrder = {
    "ublExtensions",
    "protocolID",
    "envelopeTypeCode",
    "endpointURI"
})
@CodingStyleguideUnaware
public class MessageDeliveryType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ProtocolID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ProtocolIDType protocolID;
    @XmlElement(name = "EnvelopeTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private EnvelopeTypeCodeType envelopeTypeCode;
    @XmlElement(name = "EndpointURI", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private EndpointURIType endpointURI;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public MessageDeliveryType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the protocolID property.
     * 
     * @return
     *     possible object is
     *     {@link ProtocolIDType }
     *     
     */
    @Nullable
    public ProtocolIDType getProtocolID() {
        return protocolID;
    }

    /**
     * Sets the value of the protocolID property.
     * 
     * @param value
     *     allowed object is
     *     {@link ProtocolIDType }
     *     
     */
    public void setProtocolID(
        @Nullable
        ProtocolIDType value) {
        this.protocolID = value;
    }

    /**
     * Gets the value of the envelopeTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link EnvelopeTypeCodeType }
     *     
     */
    @Nullable
    public EnvelopeTypeCodeType getEnvelopeTypeCode() {
        return envelopeTypeCode;
    }

    /**
     * Sets the value of the envelopeTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link EnvelopeTypeCodeType }
     *     
     */
    public void setEnvelopeTypeCode(
        @Nullable
        EnvelopeTypeCodeType value) {
        this.envelopeTypeCode = value;
    }

    /**
     * Gets the value of the endpointURI property.
     * 
     * @return
     *     possible object is
     *     {@link EndpointURIType }
     *     
     */
    @Nullable
    public EndpointURIType getEndpointURI() {
        return endpointURI;
    }

    /**
     * Sets the value of the endpointURI property.
     * 
     * @param value
     *     allowed object is
     *     {@link EndpointURIType }
     *     
     */
    public void setEndpointURI(
        @Nullable
        EndpointURIType value) {
        this.endpointURI = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final MessageDeliveryType rhs = ((MessageDeliveryType) o);
        if (!EqualsHelper.equals(endpointURI, rhs.endpointURI)) {
            return false;
        }
        if (!EqualsHelper.equals(envelopeTypeCode, rhs.envelopeTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(protocolID, rhs.protocolID)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(endpointURI).append(envelopeTypeCode).append(protocolID).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("endpointURI", endpointURI).append("envelopeTypeCode", envelopeTypeCode).append("protocolID", protocolID).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        MessageDeliveryType ret) {
        ret.endpointURI = ((endpointURI == null)?null:endpointURI.clone());
        ret.envelopeTypeCode = ((envelopeTypeCode == null)?null:envelopeTypeCode.clone());
        ret.protocolID = ((protocolID == null)?null:protocolID.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public MessageDeliveryType clone() {
        MessageDeliveryType ret = new MessageDeliveryType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ProtocolIDType and never <code>null</code>
     */
    @Nonnull
    public ProtocolIDType setProtocolID(
        @Nullable
        final String valueParam) {
        ProtocolIDType aObj = getProtocolID();
        if (aObj == null) {
            aObj = new ProtocolIDType(valueParam);
            setProtocolID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type EnvelopeTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public EnvelopeTypeCodeType setEnvelopeTypeCode(
        @Nullable
        final String valueParam) {
        EnvelopeTypeCodeType aObj = getEnvelopeTypeCode();
        if (aObj == null) {
            aObj = new EnvelopeTypeCodeType(valueParam);
            setEnvelopeTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type EndpointURIType and never <code>null</code>
     */
    @Nonnull
    public EndpointURIType setEndpointURI(
        @Nullable
        final String valueParam) {
        EndpointURIType aObj = getEndpointURI();
        if (aObj == null) {
            aObj = new EndpointURIType(valueParam);
            setEndpointURI(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained ProtocolIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ProtocolIDType object or <code>null</code>
     */
    @Nullable
    public String getProtocolIDValue() {
        ProtocolIDType aObj = getProtocolID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained EnvelopeTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained EnvelopeTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getEnvelopeTypeCodeValue() {
        EnvelopeTypeCodeType aObj = getEnvelopeTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained EndpointURIType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained EndpointURIType object or <code>null</code>
     */
    @Nullable
    public String getEndpointURIValue() {
        EndpointURIType aObj = getEndpointURI();
        return (aObj == null)?null:aObj.getValue();
    }

}
