
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.AllowanceTotalAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.AllowanceTotalTaxInclusiveAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ChargeTotalAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ChargeTotalTaxInclusiveAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.LineExtensionAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.PayableAlternativeAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.PayableAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.PayableRoundingAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.PrepaidAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TaxExclusiveAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TaxInclusiveAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.WithholdingTaxTotalAmountType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for MonetaryTotalType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="MonetaryTotalType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}LineExtensionAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TaxExclusiveAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TaxInclusiveAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}AllowanceTotalAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}AllowanceTotalTaxInclusiveAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ChargeTotalAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ChargeTotalTaxInclusiveAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}WithholdingTaxTotalAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PrepaidAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PayableRoundingAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PayableAmount"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PayableAlternativeAmount" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "MonetaryTotalType", propOrder = {
    "ublExtensions",
    "lineExtensionAmount",
    "taxExclusiveAmount",
    "taxInclusiveAmount",
    "allowanceTotalAmount",
    "allowanceTotalTaxInclusiveAmount",
    "chargeTotalAmount",
    "chargeTotalTaxInclusiveAmount",
    "withholdingTaxTotalAmount",
    "prepaidAmount",
    "payableRoundingAmount",
    "payableAmount",
    "payableAlternativeAmount"
})
@CodingStyleguideUnaware
public class MonetaryTotalType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "LineExtensionAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private LineExtensionAmountType lineExtensionAmount;
    @XmlElement(name = "TaxExclusiveAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TaxExclusiveAmountType taxExclusiveAmount;
    @XmlElement(name = "TaxInclusiveAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TaxInclusiveAmountType taxInclusiveAmount;
    @XmlElement(name = "AllowanceTotalAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private AllowanceTotalAmountType allowanceTotalAmount;
    @XmlElement(name = "AllowanceTotalTaxInclusiveAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private AllowanceTotalTaxInclusiveAmountType allowanceTotalTaxInclusiveAmount;
    @XmlElement(name = "ChargeTotalAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ChargeTotalAmountType chargeTotalAmount;
    @XmlElement(name = "ChargeTotalTaxInclusiveAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ChargeTotalTaxInclusiveAmountType chargeTotalTaxInclusiveAmount;
    @XmlElement(name = "WithholdingTaxTotalAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private WithholdingTaxTotalAmountType withholdingTaxTotalAmount;
    @XmlElement(name = "PrepaidAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PrepaidAmountType prepaidAmount;
    @XmlElement(name = "PayableRoundingAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PayableRoundingAmountType payableRoundingAmount;
    @XmlElement(name = "PayableAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private PayableAmountType payableAmount;
    @XmlElement(name = "PayableAlternativeAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PayableAlternativeAmountType payableAlternativeAmount;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public MonetaryTotalType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the lineExtensionAmount property.
     * 
     * @return
     *     possible object is
     *     {@link LineExtensionAmountType }
     *     
     */
    @Nullable
    public LineExtensionAmountType getLineExtensionAmount() {
        return lineExtensionAmount;
    }

    /**
     * Sets the value of the lineExtensionAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link LineExtensionAmountType }
     *     
     */
    public void setLineExtensionAmount(
        @Nullable
        LineExtensionAmountType value) {
        this.lineExtensionAmount = value;
    }

    /**
     * Gets the value of the taxExclusiveAmount property.
     * 
     * @return
     *     possible object is
     *     {@link TaxExclusiveAmountType }
     *     
     */
    @Nullable
    public TaxExclusiveAmountType getTaxExclusiveAmount() {
        return taxExclusiveAmount;
    }

    /**
     * Sets the value of the taxExclusiveAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link TaxExclusiveAmountType }
     *     
     */
    public void setTaxExclusiveAmount(
        @Nullable
        TaxExclusiveAmountType value) {
        this.taxExclusiveAmount = value;
    }

    /**
     * Gets the value of the taxInclusiveAmount property.
     * 
     * @return
     *     possible object is
     *     {@link TaxInclusiveAmountType }
     *     
     */
    @Nullable
    public TaxInclusiveAmountType getTaxInclusiveAmount() {
        return taxInclusiveAmount;
    }

    /**
     * Sets the value of the taxInclusiveAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link TaxInclusiveAmountType }
     *     
     */
    public void setTaxInclusiveAmount(
        @Nullable
        TaxInclusiveAmountType value) {
        this.taxInclusiveAmount = value;
    }

    /**
     * Gets the value of the allowanceTotalAmount property.
     * 
     * @return
     *     possible object is
     *     {@link AllowanceTotalAmountType }
     *     
     */
    @Nullable
    public AllowanceTotalAmountType getAllowanceTotalAmount() {
        return allowanceTotalAmount;
    }

    /**
     * Sets the value of the allowanceTotalAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link AllowanceTotalAmountType }
     *     
     */
    public void setAllowanceTotalAmount(
        @Nullable
        AllowanceTotalAmountType value) {
        this.allowanceTotalAmount = value;
    }

    /**
     * Gets the value of the allowanceTotalTaxInclusiveAmount property.
     * 
     * @return
     *     possible object is
     *     {@link AllowanceTotalTaxInclusiveAmountType }
     *     
     */
    @Nullable
    public AllowanceTotalTaxInclusiveAmountType getAllowanceTotalTaxInclusiveAmount() {
        return allowanceTotalTaxInclusiveAmount;
    }

    /**
     * Sets the value of the allowanceTotalTaxInclusiveAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link AllowanceTotalTaxInclusiveAmountType }
     *     
     */
    public void setAllowanceTotalTaxInclusiveAmount(
        @Nullable
        AllowanceTotalTaxInclusiveAmountType value) {
        this.allowanceTotalTaxInclusiveAmount = value;
    }

    /**
     * Gets the value of the chargeTotalAmount property.
     * 
     * @return
     *     possible object is
     *     {@link ChargeTotalAmountType }
     *     
     */
    @Nullable
    public ChargeTotalAmountType getChargeTotalAmount() {
        return chargeTotalAmount;
    }

    /**
     * Sets the value of the chargeTotalAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link ChargeTotalAmountType }
     *     
     */
    public void setChargeTotalAmount(
        @Nullable
        ChargeTotalAmountType value) {
        this.chargeTotalAmount = value;
    }

    /**
     * Gets the value of the chargeTotalTaxInclusiveAmount property.
     * 
     * @return
     *     possible object is
     *     {@link ChargeTotalTaxInclusiveAmountType }
     *     
     */
    @Nullable
    public ChargeTotalTaxInclusiveAmountType getChargeTotalTaxInclusiveAmount() {
        return chargeTotalTaxInclusiveAmount;
    }

    /**
     * Sets the value of the chargeTotalTaxInclusiveAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link ChargeTotalTaxInclusiveAmountType }
     *     
     */
    public void setChargeTotalTaxInclusiveAmount(
        @Nullable
        ChargeTotalTaxInclusiveAmountType value) {
        this.chargeTotalTaxInclusiveAmount = value;
    }

    /**
     * Gets the value of the withholdingTaxTotalAmount property.
     * 
     * @return
     *     possible object is
     *     {@link WithholdingTaxTotalAmountType }
     *     
     */
    @Nullable
    public WithholdingTaxTotalAmountType getWithholdingTaxTotalAmount() {
        return withholdingTaxTotalAmount;
    }

    /**
     * Sets the value of the withholdingTaxTotalAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link WithholdingTaxTotalAmountType }
     *     
     */
    public void setWithholdingTaxTotalAmount(
        @Nullable
        WithholdingTaxTotalAmountType value) {
        this.withholdingTaxTotalAmount = value;
    }

    /**
     * Gets the value of the prepaidAmount property.
     * 
     * @return
     *     possible object is
     *     {@link PrepaidAmountType }
     *     
     */
    @Nullable
    public PrepaidAmountType getPrepaidAmount() {
        return prepaidAmount;
    }

    /**
     * Sets the value of the prepaidAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link PrepaidAmountType }
     *     
     */
    public void setPrepaidAmount(
        @Nullable
        PrepaidAmountType value) {
        this.prepaidAmount = value;
    }

    /**
     * Gets the value of the payableRoundingAmount property.
     * 
     * @return
     *     possible object is
     *     {@link PayableRoundingAmountType }
     *     
     */
    @Nullable
    public PayableRoundingAmountType getPayableRoundingAmount() {
        return payableRoundingAmount;
    }

    /**
     * Sets the value of the payableRoundingAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link PayableRoundingAmountType }
     *     
     */
    public void setPayableRoundingAmount(
        @Nullable
        PayableRoundingAmountType value) {
        this.payableRoundingAmount = value;
    }

    /**
     * Gets the value of the payableAmount property.
     * 
     * @return
     *     possible object is
     *     {@link PayableAmountType }
     *     
     */
    @Nullable
    public PayableAmountType getPayableAmount() {
        return payableAmount;
    }

    /**
     * Sets the value of the payableAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link PayableAmountType }
     *     
     */
    public void setPayableAmount(
        @Nullable
        PayableAmountType value) {
        this.payableAmount = value;
    }

    /**
     * Gets the value of the payableAlternativeAmount property.
     * 
     * @return
     *     possible object is
     *     {@link PayableAlternativeAmountType }
     *     
     */
    @Nullable
    public PayableAlternativeAmountType getPayableAlternativeAmount() {
        return payableAlternativeAmount;
    }

    /**
     * Sets the value of the payableAlternativeAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link PayableAlternativeAmountType }
     *     
     */
    public void setPayableAlternativeAmount(
        @Nullable
        PayableAlternativeAmountType value) {
        this.payableAlternativeAmount = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final MonetaryTotalType rhs = ((MonetaryTotalType) o);
        if (!EqualsHelper.equals(allowanceTotalAmount, rhs.allowanceTotalAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(allowanceTotalTaxInclusiveAmount, rhs.allowanceTotalTaxInclusiveAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(chargeTotalAmount, rhs.chargeTotalAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(chargeTotalTaxInclusiveAmount, rhs.chargeTotalTaxInclusiveAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(lineExtensionAmount, rhs.lineExtensionAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(payableAlternativeAmount, rhs.payableAlternativeAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(payableAmount, rhs.payableAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(payableRoundingAmount, rhs.payableRoundingAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(prepaidAmount, rhs.prepaidAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(taxExclusiveAmount, rhs.taxExclusiveAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(taxInclusiveAmount, rhs.taxInclusiveAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        if (!EqualsHelper.equals(withholdingTaxTotalAmount, rhs.withholdingTaxTotalAmount)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(allowanceTotalAmount).append(allowanceTotalTaxInclusiveAmount).append(chargeTotalAmount).append(chargeTotalTaxInclusiveAmount).append(lineExtensionAmount).append(payableAlternativeAmount).append(payableAmount).append(payableRoundingAmount).append(prepaidAmount).append(taxExclusiveAmount).append(taxInclusiveAmount).append(ublExtensions).append(withholdingTaxTotalAmount).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("allowanceTotalAmount", allowanceTotalAmount).append("allowanceTotalTaxInclusiveAmount", allowanceTotalTaxInclusiveAmount).append("chargeTotalAmount", chargeTotalAmount).append("chargeTotalTaxInclusiveAmount", chargeTotalTaxInclusiveAmount).append("lineExtensionAmount", lineExtensionAmount).append("payableAlternativeAmount", payableAlternativeAmount).append("payableAmount", payableAmount).append("payableRoundingAmount", payableRoundingAmount).append("prepaidAmount", prepaidAmount).append("taxExclusiveAmount", taxExclusiveAmount).append("taxInclusiveAmount", taxInclusiveAmount).append("ublExtensions", ublExtensions).append("withholdingTaxTotalAmount", withholdingTaxTotalAmount).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        MonetaryTotalType ret) {
        ret.allowanceTotalAmount = ((allowanceTotalAmount == null)?null:allowanceTotalAmount.clone());
        ret.allowanceTotalTaxInclusiveAmount = ((allowanceTotalTaxInclusiveAmount == null)?null:allowanceTotalTaxInclusiveAmount.clone());
        ret.chargeTotalAmount = ((chargeTotalAmount == null)?null:chargeTotalAmount.clone());
        ret.chargeTotalTaxInclusiveAmount = ((chargeTotalTaxInclusiveAmount == null)?null:chargeTotalTaxInclusiveAmount.clone());
        ret.lineExtensionAmount = ((lineExtensionAmount == null)?null:lineExtensionAmount.clone());
        ret.payableAlternativeAmount = ((payableAlternativeAmount == null)?null:payableAlternativeAmount.clone());
        ret.payableAmount = ((payableAmount == null)?null:payableAmount.clone());
        ret.payableRoundingAmount = ((payableRoundingAmount == null)?null:payableRoundingAmount.clone());
        ret.prepaidAmount = ((prepaidAmount == null)?null:prepaidAmount.clone());
        ret.taxExclusiveAmount = ((taxExclusiveAmount == null)?null:taxExclusiveAmount.clone());
        ret.taxInclusiveAmount = ((taxInclusiveAmount == null)?null:taxInclusiveAmount.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
        ret.withholdingTaxTotalAmount = ((withholdingTaxTotalAmount == null)?null:withholdingTaxTotalAmount.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public MonetaryTotalType clone() {
        MonetaryTotalType ret = new MonetaryTotalType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type LineExtensionAmountType and never <code>null</code>
     */
    @Nonnull
    public LineExtensionAmountType setLineExtensionAmount(
        @Nullable
        final BigDecimal valueParam) {
        LineExtensionAmountType aObj = getLineExtensionAmount();
        if (aObj == null) {
            aObj = new LineExtensionAmountType(valueParam);
            setLineExtensionAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TaxExclusiveAmountType and never <code>null</code>
     */
    @Nonnull
    public TaxExclusiveAmountType setTaxExclusiveAmount(
        @Nullable
        final BigDecimal valueParam) {
        TaxExclusiveAmountType aObj = getTaxExclusiveAmount();
        if (aObj == null) {
            aObj = new TaxExclusiveAmountType(valueParam);
            setTaxExclusiveAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TaxInclusiveAmountType and never <code>null</code>
     */
    @Nonnull
    public TaxInclusiveAmountType setTaxInclusiveAmount(
        @Nullable
        final BigDecimal valueParam) {
        TaxInclusiveAmountType aObj = getTaxInclusiveAmount();
        if (aObj == null) {
            aObj = new TaxInclusiveAmountType(valueParam);
            setTaxInclusiveAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type AllowanceTotalAmountType and never <code>null</code>
     */
    @Nonnull
    public AllowanceTotalAmountType setAllowanceTotalAmount(
        @Nullable
        final BigDecimal valueParam) {
        AllowanceTotalAmountType aObj = getAllowanceTotalAmount();
        if (aObj == null) {
            aObj = new AllowanceTotalAmountType(valueParam);
            setAllowanceTotalAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type AllowanceTotalTaxInclusiveAmountType and never <code>null</code>
     */
    @Nonnull
    public AllowanceTotalTaxInclusiveAmountType setAllowanceTotalTaxInclusiveAmount(
        @Nullable
        final BigDecimal valueParam) {
        AllowanceTotalTaxInclusiveAmountType aObj = getAllowanceTotalTaxInclusiveAmount();
        if (aObj == null) {
            aObj = new AllowanceTotalTaxInclusiveAmountType(valueParam);
            setAllowanceTotalTaxInclusiveAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ChargeTotalAmountType and never <code>null</code>
     */
    @Nonnull
    public ChargeTotalAmountType setChargeTotalAmount(
        @Nullable
        final BigDecimal valueParam) {
        ChargeTotalAmountType aObj = getChargeTotalAmount();
        if (aObj == null) {
            aObj = new ChargeTotalAmountType(valueParam);
            setChargeTotalAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ChargeTotalTaxInclusiveAmountType and never <code>null</code>
     */
    @Nonnull
    public ChargeTotalTaxInclusiveAmountType setChargeTotalTaxInclusiveAmount(
        @Nullable
        final BigDecimal valueParam) {
        ChargeTotalTaxInclusiveAmountType aObj = getChargeTotalTaxInclusiveAmount();
        if (aObj == null) {
            aObj = new ChargeTotalTaxInclusiveAmountType(valueParam);
            setChargeTotalTaxInclusiveAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type WithholdingTaxTotalAmountType and never <code>null</code>
     */
    @Nonnull
    public WithholdingTaxTotalAmountType setWithholdingTaxTotalAmount(
        @Nullable
        final BigDecimal valueParam) {
        WithholdingTaxTotalAmountType aObj = getWithholdingTaxTotalAmount();
        if (aObj == null) {
            aObj = new WithholdingTaxTotalAmountType(valueParam);
            setWithholdingTaxTotalAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PrepaidAmountType and never <code>null</code>
     */
    @Nonnull
    public PrepaidAmountType setPrepaidAmount(
        @Nullable
        final BigDecimal valueParam) {
        PrepaidAmountType aObj = getPrepaidAmount();
        if (aObj == null) {
            aObj = new PrepaidAmountType(valueParam);
            setPrepaidAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PayableRoundingAmountType and never <code>null</code>
     */
    @Nonnull
    public PayableRoundingAmountType setPayableRoundingAmount(
        @Nullable
        final BigDecimal valueParam) {
        PayableRoundingAmountType aObj = getPayableRoundingAmount();
        if (aObj == null) {
            aObj = new PayableRoundingAmountType(valueParam);
            setPayableRoundingAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PayableAmountType and never <code>null</code>
     */
    @Nonnull
    public PayableAmountType setPayableAmount(
        @Nullable
        final BigDecimal valueParam) {
        PayableAmountType aObj = getPayableAmount();
        if (aObj == null) {
            aObj = new PayableAmountType(valueParam);
            setPayableAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PayableAlternativeAmountType and never <code>null</code>
     */
    @Nonnull
    public PayableAlternativeAmountType setPayableAlternativeAmount(
        @Nullable
        final BigDecimal valueParam) {
        PayableAlternativeAmountType aObj = getPayableAlternativeAmount();
        if (aObj == null) {
            aObj = new PayableAlternativeAmountType(valueParam);
            setPayableAlternativeAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained LineExtensionAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained LineExtensionAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getLineExtensionAmountValue() {
        LineExtensionAmountType aObj = getLineExtensionAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TaxExclusiveAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TaxExclusiveAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getTaxExclusiveAmountValue() {
        TaxExclusiveAmountType aObj = getTaxExclusiveAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TaxInclusiveAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TaxInclusiveAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getTaxInclusiveAmountValue() {
        TaxInclusiveAmountType aObj = getTaxInclusiveAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained AllowanceTotalAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained AllowanceTotalAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getAllowanceTotalAmountValue() {
        AllowanceTotalAmountType aObj = getAllowanceTotalAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained AllowanceTotalTaxInclusiveAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained AllowanceTotalTaxInclusiveAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getAllowanceTotalTaxInclusiveAmountValue() {
        AllowanceTotalTaxInclusiveAmountType aObj = getAllowanceTotalTaxInclusiveAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ChargeTotalAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ChargeTotalAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getChargeTotalAmountValue() {
        ChargeTotalAmountType aObj = getChargeTotalAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ChargeTotalTaxInclusiveAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ChargeTotalTaxInclusiveAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getChargeTotalTaxInclusiveAmountValue() {
        ChargeTotalTaxInclusiveAmountType aObj = getChargeTotalTaxInclusiveAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained WithholdingTaxTotalAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained WithholdingTaxTotalAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getWithholdingTaxTotalAmountValue() {
        WithholdingTaxTotalAmountType aObj = getWithholdingTaxTotalAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PrepaidAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PrepaidAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getPrepaidAmountValue() {
        PrepaidAmountType aObj = getPrepaidAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PayableRoundingAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PayableRoundingAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getPayableRoundingAmountValue() {
        PayableRoundingAmountType aObj = getPayableRoundingAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PayableAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PayableAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getPayableAmountValue() {
        PayableAmountType aObj = getPayableAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PayableAlternativeAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PayableAlternativeAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getPayableAlternativeAmountValue() {
        PayableAlternativeAmountType aObj = getPayableAlternativeAmount();
        return (aObj == null)?null:aObj.getValue();
    }

}
