
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.InitiatingPartyIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.PrivatePartyIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.PublicPartyIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ServiceProviderPartyIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for ParticipantPartyType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ParticipantPartyType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}InitiatingPartyIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PrivatePartyIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PublicPartyIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ServiceProviderPartyIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Party"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}LegalContact" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}TechnicalContact" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}SupportContact" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}CommercialContact" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ParticipantPartyType", propOrder = {
    "ublExtensions",
    "initiatingPartyIndicator",
    "privatePartyIndicator",
    "publicPartyIndicator",
    "serviceProviderPartyIndicator",
    "party",
    "legalContact",
    "technicalContact",
    "supportContact",
    "commercialContact"
})
@CodingStyleguideUnaware
public class ParticipantPartyType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "InitiatingPartyIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private InitiatingPartyIndicatorType initiatingPartyIndicator;
    @XmlElement(name = "PrivatePartyIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PrivatePartyIndicatorType privatePartyIndicator;
    @XmlElement(name = "PublicPartyIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PublicPartyIndicatorType publicPartyIndicator;
    @XmlElement(name = "ServiceProviderPartyIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ServiceProviderPartyIndicatorType serviceProviderPartyIndicator;
    @XmlElement(name = "Party", required = true)
    private PartyType party;
    @XmlElement(name = "LegalContact")
    private ContactType legalContact;
    @XmlElement(name = "TechnicalContact")
    private ContactType technicalContact;
    @XmlElement(name = "SupportContact")
    private ContactType supportContact;
    @XmlElement(name = "CommercialContact")
    private ContactType commercialContact;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public ParticipantPartyType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the initiatingPartyIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link InitiatingPartyIndicatorType }
     *     
     */
    @Nullable
    public InitiatingPartyIndicatorType getInitiatingPartyIndicator() {
        return initiatingPartyIndicator;
    }

    /**
     * Sets the value of the initiatingPartyIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link InitiatingPartyIndicatorType }
     *     
     */
    public void setInitiatingPartyIndicator(
        @Nullable
        InitiatingPartyIndicatorType value) {
        this.initiatingPartyIndicator = value;
    }

    /**
     * Gets the value of the privatePartyIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link PrivatePartyIndicatorType }
     *     
     */
    @Nullable
    public PrivatePartyIndicatorType getPrivatePartyIndicator() {
        return privatePartyIndicator;
    }

    /**
     * Sets the value of the privatePartyIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link PrivatePartyIndicatorType }
     *     
     */
    public void setPrivatePartyIndicator(
        @Nullable
        PrivatePartyIndicatorType value) {
        this.privatePartyIndicator = value;
    }

    /**
     * Gets the value of the publicPartyIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link PublicPartyIndicatorType }
     *     
     */
    @Nullable
    public PublicPartyIndicatorType getPublicPartyIndicator() {
        return publicPartyIndicator;
    }

    /**
     * Sets the value of the publicPartyIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link PublicPartyIndicatorType }
     *     
     */
    public void setPublicPartyIndicator(
        @Nullable
        PublicPartyIndicatorType value) {
        this.publicPartyIndicator = value;
    }

    /**
     * Gets the value of the serviceProviderPartyIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link ServiceProviderPartyIndicatorType }
     *     
     */
    @Nullable
    public ServiceProviderPartyIndicatorType getServiceProviderPartyIndicator() {
        return serviceProviderPartyIndicator;
    }

    /**
     * Sets the value of the serviceProviderPartyIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link ServiceProviderPartyIndicatorType }
     *     
     */
    public void setServiceProviderPartyIndicator(
        @Nullable
        ServiceProviderPartyIndicatorType value) {
        this.serviceProviderPartyIndicator = value;
    }

    /**
     * Gets the value of the party property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getParty() {
        return party;
    }

    /**
     * Sets the value of the party property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setParty(
        @Nullable
        PartyType value) {
        this.party = value;
    }

    /**
     * Gets the value of the legalContact property.
     * 
     * @return
     *     possible object is
     *     {@link ContactType }
     *     
     */
    @Nullable
    public ContactType getLegalContact() {
        return legalContact;
    }

    /**
     * Sets the value of the legalContact property.
     * 
     * @param value
     *     allowed object is
     *     {@link ContactType }
     *     
     */
    public void setLegalContact(
        @Nullable
        ContactType value) {
        this.legalContact = value;
    }

    /**
     * Gets the value of the technicalContact property.
     * 
     * @return
     *     possible object is
     *     {@link ContactType }
     *     
     */
    @Nullable
    public ContactType getTechnicalContact() {
        return technicalContact;
    }

    /**
     * Sets the value of the technicalContact property.
     * 
     * @param value
     *     allowed object is
     *     {@link ContactType }
     *     
     */
    public void setTechnicalContact(
        @Nullable
        ContactType value) {
        this.technicalContact = value;
    }

    /**
     * Gets the value of the supportContact property.
     * 
     * @return
     *     possible object is
     *     {@link ContactType }
     *     
     */
    @Nullable
    public ContactType getSupportContact() {
        return supportContact;
    }

    /**
     * Sets the value of the supportContact property.
     * 
     * @param value
     *     allowed object is
     *     {@link ContactType }
     *     
     */
    public void setSupportContact(
        @Nullable
        ContactType value) {
        this.supportContact = value;
    }

    /**
     * Gets the value of the commercialContact property.
     * 
     * @return
     *     possible object is
     *     {@link ContactType }
     *     
     */
    @Nullable
    public ContactType getCommercialContact() {
        return commercialContact;
    }

    /**
     * Sets the value of the commercialContact property.
     * 
     * @param value
     *     allowed object is
     *     {@link ContactType }
     *     
     */
    public void setCommercialContact(
        @Nullable
        ContactType value) {
        this.commercialContact = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final ParticipantPartyType rhs = ((ParticipantPartyType) o);
        if (!EqualsHelper.equals(commercialContact, rhs.commercialContact)) {
            return false;
        }
        if (!EqualsHelper.equals(initiatingPartyIndicator, rhs.initiatingPartyIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(legalContact, rhs.legalContact)) {
            return false;
        }
        if (!EqualsHelper.equals(party, rhs.party)) {
            return false;
        }
        if (!EqualsHelper.equals(privatePartyIndicator, rhs.privatePartyIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(publicPartyIndicator, rhs.publicPartyIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(serviceProviderPartyIndicator, rhs.serviceProviderPartyIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(supportContact, rhs.supportContact)) {
            return false;
        }
        if (!EqualsHelper.equals(technicalContact, rhs.technicalContact)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(commercialContact).append(initiatingPartyIndicator).append(legalContact).append(party).append(privatePartyIndicator).append(publicPartyIndicator).append(serviceProviderPartyIndicator).append(supportContact).append(technicalContact).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("commercialContact", commercialContact).append("initiatingPartyIndicator", initiatingPartyIndicator).append("legalContact", legalContact).append("party", party).append("privatePartyIndicator", privatePartyIndicator).append("publicPartyIndicator", publicPartyIndicator).append("serviceProviderPartyIndicator", serviceProviderPartyIndicator).append("supportContact", supportContact).append("technicalContact", technicalContact).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        ParticipantPartyType ret) {
        ret.commercialContact = ((commercialContact == null)?null:commercialContact.clone());
        ret.initiatingPartyIndicator = ((initiatingPartyIndicator == null)?null:initiatingPartyIndicator.clone());
        ret.legalContact = ((legalContact == null)?null:legalContact.clone());
        ret.party = ((party == null)?null:party.clone());
        ret.privatePartyIndicator = ((privatePartyIndicator == null)?null:privatePartyIndicator.clone());
        ret.publicPartyIndicator = ((publicPartyIndicator == null)?null:publicPartyIndicator.clone());
        ret.serviceProviderPartyIndicator = ((serviceProviderPartyIndicator == null)?null:serviceProviderPartyIndicator.clone());
        ret.supportContact = ((supportContact == null)?null:supportContact.clone());
        ret.technicalContact = ((technicalContact == null)?null:technicalContact.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ParticipantPartyType clone() {
        ParticipantPartyType ret = new ParticipantPartyType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type InitiatingPartyIndicatorType and never <code>null</code>
     */
    @Nonnull
    public InitiatingPartyIndicatorType setInitiatingPartyIndicator(final boolean valueParam) {
        InitiatingPartyIndicatorType aObj = getInitiatingPartyIndicator();
        if (aObj == null) {
            aObj = new InitiatingPartyIndicatorType(valueParam);
            setInitiatingPartyIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type PrivatePartyIndicatorType and never <code>null</code>
     */
    @Nonnull
    public PrivatePartyIndicatorType setPrivatePartyIndicator(final boolean valueParam) {
        PrivatePartyIndicatorType aObj = getPrivatePartyIndicator();
        if (aObj == null) {
            aObj = new PrivatePartyIndicatorType(valueParam);
            setPrivatePartyIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type PublicPartyIndicatorType and never <code>null</code>
     */
    @Nonnull
    public PublicPartyIndicatorType setPublicPartyIndicator(final boolean valueParam) {
        PublicPartyIndicatorType aObj = getPublicPartyIndicator();
        if (aObj == null) {
            aObj = new PublicPartyIndicatorType(valueParam);
            setPublicPartyIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type ServiceProviderPartyIndicatorType and never <code>null</code>
     */
    @Nonnull
    public ServiceProviderPartyIndicatorType setServiceProviderPartyIndicator(final boolean valueParam) {
        ServiceProviderPartyIndicatorType aObj = getServiceProviderPartyIndicator();
        if (aObj == null) {
            aObj = new ServiceProviderPartyIndicatorType(valueParam);
            setServiceProviderPartyIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained InitiatingPartyIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained InitiatingPartyIndicatorType object or the passed nullValue
     */
    public boolean isInitiatingPartyIndicatorValue(final boolean nullValue) {
        InitiatingPartyIndicatorType aObj = getInitiatingPartyIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained PrivatePartyIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained PrivatePartyIndicatorType object or the passed nullValue
     */
    public boolean isPrivatePartyIndicatorValue(final boolean nullValue) {
        PrivatePartyIndicatorType aObj = getPrivatePartyIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained PublicPartyIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained PublicPartyIndicatorType object or the passed nullValue
     */
    public boolean isPublicPartyIndicatorValue(final boolean nullValue) {
        PublicPartyIndicatorType aObj = getPublicPartyIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained ServiceProviderPartyIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained ServiceProviderPartyIndicatorType object or the passed nullValue
     */
    public boolean isServiceProviderPartyIndicatorValue(final boolean nullValue) {
        ServiceProviderPartyIndicatorType aObj = getServiceProviderPartyIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

}
